<?php if (!defined('ABSPATH')) {
    exit; // exit if accessed directly
}

/**
 * Fontawesome icons from FontAwesome :)
 *
 * @param $icons - taken from filter - vc_map param field settings['source']
 *     provided icons (default empty array). If array categorized it will
 *     auto-enable category dropdown
 *
 * @return array - of icons for iconpicker, can be categorized, or not.
 * @since 4.4
 */
function ut_iconpicker_type_fontawesome( $icons ) {
    // Categorized icons ( you can also output simple array ( key=> value ), where key = icon class, value = icon readable name ).
    /**
     * @version 4.7
     */
    $fontawesome_icons = array(
        'Accessibility' => array(
            array( 'fa-brands fa-accessible-icon' => 'Accessible Icon (accessibility,handicap,person,wheelchair,wheelchair-alt)' ),
            array( 'fa-solid fa-hands-asl-interpreting' => 'American Sign Language Interpreting (asl,deaf,finger,hand,interpret,speak)' ),
            array( 'fa-solid fa-assistive-listening-systems' => 'Assistive Listening Systems (amplify,audio,deaf,ear,headset,hearing,sound)' ),
            array( 'fa-solid fa-audio-description' => 'Audio Description (blind,narration,video,visual)' ),
            array( 'fa-solid fa-blind' => 'Blind (cane,disability,person,sight)' ),
            array( 'fa-solid fa-braille' => 'Braille (alphabet,blind,dots,raised,vision)' ),
            array( 'fa-solid fa-closed-captioning' => 'Closed Captioning (cc,deaf,hearing,subtitle,subtitling,text,video)' ),
            array( 'fa-regular fa-closed-captioning' => 'Closed Captioning (cc,deaf,hearing,subtitle,subtitling,text,video)' ),
            array( 'fa-solid fa-deaf' => 'Deaf (ear,hearing,sign language)' ),
            array( 'fa-solid fa-low-vision' => 'Low Vision (blind,eye,sight)' ),
            array( 'fa-solid fa-phone-volume' => 'Phone Volume (call,earphone,number,sound,support,telephone,voice,volume-control-phone)' ),
            array( 'fa-solid fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-regular fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-solid fa-sign-language' => 'Sign Language (Translate,asl,deaf,hands)' ),
            array( 'fa-solid fa-tty' => 'TTY (communication,deaf,telephone,teletypewriter,text)' ),
            array( 'fa-solid fa-universal-access' => 'Universal Access (accessibility,hearing,person,seeing,visual impairment)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
        ),
        'Alert' => array(
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-exclamation' => 'exclamation (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-circle' => 'Exclamation Circle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-triangle' => 'Exclamation Triangle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-radiation' => 'Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-radiation-alt' => 'Alternate Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
        ),
        'Animals' => array(
            array( 'fa-solid fa-cat' => 'Cat (feline,halloween,holiday,kitten,kitty,meow,pet)' ),
            array( 'fa-solid fa-crow' => 'Crow (bird,bullfrog,fauna,halloween,holiday,toad)' ),
            array( 'fa-solid fa-dog' => 'Dog (animal,canine,fauna,mammal,pet,pooch,puppy,woof)' ),
            array( 'fa-solid fa-dove' => 'Dove (bird,fauna,flying,peace,war)' ),
            array( 'fa-solid fa-dragon' => 'Dragon (Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)' ),
            array( 'fa-solid fa-feather' => 'Feather (bird,light,plucked,quill,write)' ),
            array( 'fa-solid fa-feather-alt' => 'Alternate Feather (bird,light,plucked,quill,write)' ),
            array( 'fa-solid fa-fish' => 'Fish (fauna,gold,seafood,swimming)' ),
            array( 'fa-solid fa-frog' => 'Frog (amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)' ),
            array( 'fa-solid fa-hippo' => 'Hippo (animal,fauna,hippopotamus,hungry,mammal)' ),
            array( 'fa-solid fa-horse' => 'Horse (equus,fauna,mammmal,mare,neigh,pony)' ),
            array( 'fa-solid fa-horse-head' => 'Horse Head (equus,fauna,mammmal,mare,neigh,pony)' ),
            array( 'fa-solid fa-kiwi-bird' => 'Kiwi Bird (bird,fauna,new zealand)' ),
            array( 'fa-solid fa-otter' => 'Otter (animal,badger,fauna,fur,mammal,marten)' ),
            array( 'fa-solid fa-paw' => 'Paw (animal,cat,dog,pet,print)' ),
            array( 'fa-solid fa-spider' => 'Spider (arachnid,bug,charlotte,crawl,eight,halloween)' ),
        ),
        'Arrows' => array(
            array( 'fa-solid fa-angle-double-down' => 'Angle Double Down (arrows,caret,download,expand)' ),
            array( 'fa-solid fa-angle-double-left' => 'Angle Double Left (arrows,back,caret,laquo,previous,quote)' ),
            array( 'fa-solid fa-angle-double-right' => 'Angle Double Right (arrows,caret,forward,more,next,quote,raquo)' ),
            array( 'fa-solid fa-angle-double-up' => 'Angle Double Up (arrows,caret,collapse,upload)' ),
            array( 'fa-solid fa-angle-down' => 'angle-down (arrow,caret,download,expand)' ),
            array( 'fa-solid fa-angle-left' => 'angle-left (arrow,back,caret,less,previous)' ),
            array( 'fa-solid fa-angle-right' => 'angle-right (arrow,care,forward,more,next)' ),
            array( 'fa-solid fa-angle-up' => 'angle-up (arrow,caret,collapse,upload)' ),
            array( 'fa-solid fa-arrow-alt-circle-down' => 'Alternate Arrow Circle Down (arrow-circle-o-down,download)' ),
            array( 'fa-regular fa-arrow-alt-circle-down' => 'Alternate Arrow Circle Down (arrow-circle-o-down,download)' ),
            array( 'fa-solid fa-arrow-alt-circle-left' => 'Alternate Arrow Circle Left (arrow-circle-o-left,back,previous)' ),
            array( 'fa-regular fa-arrow-alt-circle-left' => 'Alternate Arrow Circle Left (arrow-circle-o-left,back,previous)' ),
            array( 'fa-solid fa-arrow-alt-circle-right' => 'Alternate Arrow Circle Right (arrow-circle-o-right,forward,next)' ),
            array( 'fa-regular fa-arrow-alt-circle-right' => 'Alternate Arrow Circle Right (arrow-circle-o-right,forward,next)' ),
            array( 'fa-solid fa-arrow-alt-circle-up' => 'Alternate Arrow Circle Up (arrow-circle-o-up)' ),
            array( 'fa-regular fa-arrow-alt-circle-up' => 'Alternate Arrow Circle Up (arrow-circle-o-up)' ),
            array( 'fa-solid fa-arrow-circle-down' => 'Arrow Circle Down (download)' ),
            array( 'fa-solid fa-arrow-circle-left' => 'Arrow Circle Left (back,previous)' ),
            array( 'fa-solid fa-arrow-circle-right' => 'Arrow Circle Right (forward,next)' ),
            array( 'fa-solid fa-arrow-circle-up' => 'Arrow Circle Up (upload)' ),
            array( 'fa-solid fa-arrow-down' => 'arrow-down (download)' ),
            array( 'fa-solid fa-arrow-left' => 'arrow-left (back,previous)' ),
            array( 'fa-solid fa-arrow-right' => 'arrow-right (forward,next)' ),
            array( 'fa-solid fa-arrow-up' => 'arrow-up (forward,upload)' ),
            array( 'fa-solid fa-arrows-alt' => 'Alternate Arrows (arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)' ),
            array( 'fa-solid fa-arrows-alt-h' => 'Alternate Arrows Horizontal (arrows-h,expand,horizontal,landscape,resize,wide)' ),
            array( 'fa-solid fa-arrows-alt-v' => 'Alternate Arrows Vertical (arrows-v,expand,portrait,resize,tall,vertical)' ),
            array( 'fa-solid fa-caret-down' => 'Caret Down (arrow,dropdown,expand,menu,more,triangle)' ),
            array( 'fa-solid fa-caret-left' => 'Caret Left (arrow,back,previous,triangle)' ),
            array( 'fa-solid fa-caret-right' => 'Caret Right (arrow,forward,next,triangle)' ),
            array( 'fa-solid fa-caret-square-down' => 'Caret Square Down (arrow,caret-square-o-down,dropdown,expand,menu,more,triangle)' ),
            array( 'fa-regular fa-caret-square-down' => 'Caret Square Down (arrow,caret-square-o-down,dropdown,expand,menu,more,triangle)' ),
            array( 'fa-solid fa-caret-square-left' => 'Caret Square Left (arrow,back,caret-square-o-left,previous,triangle)' ),
            array( 'fa-regular fa-caret-square-left' => 'Caret Square Left (arrow,back,caret-square-o-left,previous,triangle)' ),
            array( 'fa-solid fa-caret-square-right' => 'Caret Square Right (arrow,caret-square-o-right,forward,next,triangle)' ),
            array( 'fa-regular fa-caret-square-right' => 'Caret Square Right (arrow,caret-square-o-right,forward,next,triangle)' ),
            array( 'fa-solid fa-caret-square-up' => 'Caret Square Up (arrow,caret-square-o-up,collapse,triangle,upload)' ),
            array( 'fa-regular fa-caret-square-up' => 'Caret Square Up (arrow,caret-square-o-up,collapse,triangle,upload)' ),
            array( 'fa-solid fa-caret-up' => 'Caret Up (arrow,collapse,triangle)' ),
            array( 'fa-solid fa-cart-arrow-down' => 'Shopping Cart Arrow Down (download,save,shopping)' ),
            array( 'fa-solid fa-chart-line' => 'Line Chart (activity,analytics,chart,dashboard,gain,graph,increase,line)' ),
            array( 'fa-solid fa-chevron-circle-down' => 'Chevron Circle Down (arrow,download,dropdown,menu,more)' ),
            array( 'fa-solid fa-chevron-circle-left' => 'Chevron Circle Left (arrow,back,previous)' ),
            array( 'fa-solid fa-chevron-circle-right' => 'Chevron Circle Right (arrow,forward,next)' ),
            array( 'fa-solid fa-chevron-circle-up' => 'Chevron Circle Up (arrow,collapse,upload)' ),
            array( 'fa-solid fa-chevron-down' => 'chevron-down (arrow,download,expand)' ),
            array( 'fa-solid fa-chevron-left' => 'chevron-left (arrow,back,bracket,previous)' ),
            array( 'fa-solid fa-chevron-right' => 'chevron-right (arrow,bracket,forward,next)' ),
            array( 'fa-solid fa-chevron-up' => 'chevron-up (arrow,collapse,upload)' ),
            array( 'fa-solid fa-cloud-download-alt' => 'Alternate Cloud Download (download,export,save)' ),
            array( 'fa-solid fa-cloud-upload-alt' => 'Alternate Cloud Upload (cloud-upload,import,save,upload)' ),
            array( 'fa-solid fa-compress-arrows-alt' => 'Alternate Compress Arrows (collapse,fullscreen,minimize,move,resize,shrink,smaller)' ),
            array( 'fa-solid fa-download' => 'Download (export,hard drive,save,transfer)' ),
            array( 'fa-solid fa-exchange-alt' => 'Alternate Exchange (arrow,arrows,exchange,reciprocate,return,swap,transfer)' ),
            array( 'fa-solid fa-expand-arrows-alt' => 'Alternate Expand Arrows (arrows-alt,bigger,enlarge,move,resize)' ),
            array( 'fa-solid fa-external-link-alt' => 'Alternate External Link (external-link,new,open,share)' ),
            array( 'fa-solid fa-external-link-square-alt' => 'Alternate External Link Square (external-link-square,new,open,share)' ),
            array( 'fa-solid fa-hand-point-down' => 'Hand Pointing Down (finger,hand-o-down,point)' ),
            array( 'fa-regular fa-hand-point-down' => 'Hand Pointing Down (finger,hand-o-down,point)' ),
            array( 'fa-solid fa-hand-point-left' => 'Hand Pointing Left (back,finger,hand-o-left,left,point,previous)' ),
            array( 'fa-regular fa-hand-point-left' => 'Hand Pointing Left (back,finger,hand-o-left,left,point,previous)' ),
            array( 'fa-solid fa-hand-point-right' => 'Hand Pointing Right (finger,forward,hand-o-right,next,point,right)' ),
            array( 'fa-regular fa-hand-point-right' => 'Hand Pointing Right (finger,forward,hand-o-right,next,point,right)' ),
            array( 'fa-solid fa-hand-point-up' => 'Hand Pointing Up (finger,hand-o-up,point)' ),
            array( 'fa-regular fa-hand-point-up' => 'Hand Pointing Up (finger,hand-o-up,point)' ),
            array( 'fa-solid fa-hand-pointer' => 'Pointer (Hand) (arrow,cursor,select)' ),
            array( 'fa-regular fa-hand-pointer' => 'Pointer (Hand) (arrow,cursor,select)' ),
            array( 'fa-solid fa-history' => 'History (Rewind,clock,reverse,time,time machine)' ),
            array( 'fa-solid fa-level-down-alt' => 'Alternate Level Down (arrow,level-down)' ),
            array( 'fa-solid fa-level-up-alt' => 'Alternate Level Up (arrow,level-up)' ),
            array( 'fa-solid fa-location-arrow' => 'location-arrow (address,compass,coordinate,direction,gps,map,navigation,place)' ),
            array( 'fa-solid fa-long-arrow-alt-down' => 'Alternate Long Arrow Down (download,long-arrow-down)' ),
            array( 'fa-solid fa-long-arrow-alt-left' => 'Alternate Long Arrow Left (back,long-arrow-left,previous)' ),
            array( 'fa-solid fa-long-arrow-alt-right' => 'Alternate Long Arrow Right (forward,long-arrow-right,next)' ),
            array( 'fa-solid fa-long-arrow-alt-up' => 'Alternate Long Arrow Up (long-arrow-up,upload)' ),
            array( 'fa-solid fa-mouse-pointer' => 'Mouse Pointer (arrow,cursor,select)' ),
            array( 'fa-solid fa-play' => 'play (audio,music,playing,sound,start,video)' ),
            array( 'fa-solid fa-random' => 'random (arrows,shuffle,sort,swap,switch,transfer)' ),
            array( 'fa-solid fa-recycle' => 'Recycle (Waste,compost,garbage,reuse,trash)' ),
            array( 'fa-solid fa-redo' => 'Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-redo-alt' => 'Alternate Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-reply' => 'Reply (mail,message,respond)' ),
            array( 'fa-solid fa-reply-all' => 'reply-all (mail,message,respond)' ),
            array( 'fa-solid fa-retweet' => 'Retweet (refresh,reload,share,swap)' ),
            array( 'fa-solid fa-share' => 'Share (forward,save,send,social)' ),
            array( 'fa-solid fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-regular fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-solid fa-sign-in-alt' => 'Alternate Sign In (arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)' ),
            array( 'fa-solid fa-sign-out-alt' => 'Alternate Sign Out (arrow,exit,leave,log out,logout,sign-out)' ),
            array( 'fa-solid fa-sort' => 'Sort (filter,order)' ),
            array( 'fa-solid fa-sort-alpha-down' => 'Sort Alphabetical Down (alphabetical,arrange,filter,order,sort-alpha-asc)' ),
            array( 'fa-solid fa-sort-alpha-down-alt' => 'Alternate Sort Alphabetical Down (alphabetical,arrange,filter,order,sort-alpha-asc)' ),
            array( 'fa-solid fa-sort-alpha-up' => 'Sort Alphabetical Up (alphabetical,arrange,filter,order,sort-alpha-desc)' ),
            array( 'fa-solid fa-sort-alpha-up-alt' => 'Alternate Sort Alphabetical Up (alphabetical,arrange,filter,order,sort-alpha-desc)' ),
            array( 'fa-solid fa-sort-amount-down' => 'Sort Amount Down (arrange,filter,number,order,sort-amount-asc)' ),
            array( 'fa-solid fa-sort-amount-down-alt' => 'Alternate Sort Amount Down (arrange,filter,order,sort-amount-asc)' ),
            array( 'fa-solid fa-sort-amount-up' => 'Sort Amount Up (arrange,filter,order,sort-amount-desc)' ),
            array( 'fa-solid fa-sort-amount-up-alt' => 'Alternate Sort Amount Up (arrange,filter,order,sort-amount-desc)' ),
            array( 'fa-solid fa-sort-down' => 'Sort Down (Descending) (arrow,descending,filter,order,sort-desc)' ),
            array( 'fa-solid fa-sort-numeric-down' => 'Sort Numeric Down (arrange,filter,numbers,order,sort-numeric-asc)' ),
            array( 'fa-solid fa-sort-numeric-down-alt' => 'Alternate Sort Numeric Down (arrange,filter,numbers,order,sort-numeric-asc)' ),
            array( 'fa-solid fa-sort-numeric-up' => 'Sort Numeric Up (arrange,filter,numbers,order,sort-numeric-desc)' ),
            array( 'fa-solid fa-sort-numeric-up-alt' => 'Alternate Sort Numeric Up (arrange,filter,numbers,order,sort-numeric-desc)' ),
            array( 'fa-solid fa-sort-up' => 'Sort Up (Ascending) (arrow,ascending,filter,order,sort-asc)' ),
            array( 'fa-solid fa-sync' => 'Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-sync-alt' => 'Alternate Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-text-height' => 'text-height (edit,font,format,text,type)' ),
            array( 'fa-solid fa-text-width' => 'Text Width (edit,font,format,text,type)' ),
            array( 'fa-solid fa-undo' => 'Undo (back,control z,exchange,oops,return,rotate,swap)' ),
            array( 'fa-solid fa-undo-alt' => 'Alternate Undo (back,control z,exchange,oops,return,swap)' ),
            array( 'fa-solid fa-upload' => 'Upload (hard drive,import,publish)' ),
        ),
        'Audio & Video' => array(
            array( 'fa-solid fa-audio-description' => 'Audio Description (blind,narration,video,visual)' ),
            array( 'fa-solid fa-backward' => 'backward (previous,rewind)' ),
            array( 'fa-solid fa-broadcast-tower' => 'Broadcast Tower (airwaves,antenna,radio,reception,waves)' ),
            array( 'fa-solid fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-regular fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-solid fa-closed-captioning' => 'Closed Captioning (cc,deaf,hearing,subtitle,subtitling,text,video)' ),
            array( 'fa-regular fa-closed-captioning' => 'Closed Captioning (cc,deaf,hearing,subtitle,subtitling,text,video)' ),
            array( 'fa-solid fa-compress' => 'Compress (collapse,fullscreen,minimize,move,resize,shrink,smaller)' ),
            array( 'fa-solid fa-compress-arrows-alt' => 'Alternate Compress Arrows (collapse,fullscreen,minimize,move,resize,shrink,smaller)' ),
            array( 'fa-solid fa-eject' => 'eject (abort,cancel,cd,discharge)' ),
            array( 'fa-solid fa-expand' => 'Expand (arrow,bigger,enlarge,resize)' ),
            array( 'fa-solid fa-expand-arrows-alt' => 'Alternate Expand Arrows (arrows-alt,bigger,enlarge,move,resize)' ),
            array( 'fa-solid fa-fast-backward' => 'fast-backward (beginning,first,previous,rewind,start)' ),
            array( 'fa-solid fa-fast-forward' => 'fast-forward (end,last,next)' ),
            array( 'fa-solid fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-regular fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-solid fa-file-video' => 'Video File (document,m4v,movie,mp4,play)' ),
            array( 'fa-regular fa-file-video' => 'Video File (document,m4v,movie,mp4,play)' ),
            array( 'fa-solid fa-film' => 'Film (cinema,movie,strip,video)' ),
            array( 'fa-solid fa-forward' => 'forward (forward,next,skip)' ),
            array( 'fa-solid fa-headphones' => 'headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt-slash' => 'Alternate Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-music' => 'Music (lyrics,melody,note,sing,sound)' ),
            array( 'fa-solid fa-pause' => 'pause (hold,wait)' ),
            array( 'fa-solid fa-pause-circle' => 'Pause Circle (hold,wait)' ),
            array( 'fa-regular fa-pause-circle' => 'Pause Circle (hold,wait)' ),
            array( 'fa-solid fa-phone-volume' => 'Phone Volume (call,earphone,number,sound,support,telephone,voice,volume-control-phone)' ),
            array( 'fa-solid fa-photo-video' => 'Photo Video (av,film,image,library,media)' ),
            array( 'fa-solid fa-play' => 'play (audio,music,playing,sound,start,video)' ),
            array( 'fa-solid fa-play-circle' => 'Play Circle (audio,music,playing,sound,start,video)' ),
            array( 'fa-regular fa-play-circle' => 'Play Circle (audio,music,playing,sound,start,video)' ),
            array( 'fa-solid fa-podcast' => 'Podcast (audio,broadcast,music,sound)' ),
            array( 'fa-solid fa-random' => 'random (arrows,shuffle,sort,swap,switch,transfer)' ),
            array( 'fa-solid fa-redo' => 'Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-redo-alt' => 'Alternate Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-rss' => 'rss (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-rss-square' => 'RSS Square (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-step-backward' => 'step-backward (beginning,first,previous,rewind,start)' ),
            array( 'fa-solid fa-step-forward' => 'step-forward (end,last,next)' ),
            array( 'fa-solid fa-stop' => 'stop (block,box,square)' ),
            array( 'fa-solid fa-stop-circle' => 'Stop Circle (block,box,circle,square)' ),
            array( 'fa-regular fa-stop-circle' => 'Stop Circle (block,box,circle,square)' ),
            array( 'fa-solid fa-sync' => 'Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-sync-alt' => 'Alternate Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
            array( 'fa-solid fa-undo' => 'Undo (back,control z,exchange,oops,return,rotate,swap)' ),
            array( 'fa-solid fa-undo-alt' => 'Alternate Undo (back,control z,exchange,oops,return,swap)' ),
            array( 'fa-solid fa-video' => 'Video (camera,film,movie,record,video-camera)' ),
            array( 'fa-solid fa-volume-down' => 'Volume Down (audio,lower,music,quieter,sound,speaker)' ),
            array( 'fa-solid fa-volume-mute' => 'Volume Mute (audio,music,quiet,sound,speaker)' ),
            array( 'fa-solid fa-volume-off' => 'Volume Off (audio,ban,music,mute,quiet,silent,sound)' ),
            array( 'fa-solid fa-volume-up' => 'Volume Up (audio,higher,louder,music,sound,speaker)' ),
            array( 'fa-brands fa-youtube' => 'YouTube (film,video,youtube-play,youtube-square)' ),
        ),
        'Automotive' => array(
            array( 'fa-solid fa-spray-can-sparkles' => 'Air Freshener (car,deodorize,fresh,pine,scent)' ),
            array( 'fa-solid fa-ambulance' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-bus' => 'Bus (public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-bus-alt' => 'Bus Alt (mta,public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car' => 'Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car-alt' => 'Alternate Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car-battery' => 'Car Battery (auto,electric,mechanic,power)' ),
            array( 'fa-solid fa-car-crash' => 'Car Crash (accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)' ),
            array( 'fa-solid fa-car-side' => 'Car Side (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-charging-station' => 'Charging Station (electric,ev,tesla,vehicle)' ),
            array( 'fa-solid fa-gas-pump' => 'Gas Pump (car,fuel,gasoline,petrol)' ),
            array( 'fa-solid fa-motorcycle' => 'Motorcycle (bike,machine,transportation,vehicle)' ),
            array( 'fa-solid fa-oil-can' => 'Oil Can (auto,crude,gasoline,grease,lubricate,petroleum)' ),
            array( 'fa-solid fa-shuttle-van' => 'Shuttle Van (airport,machine,public-transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-tachometer-alt' => 'Alternate Tachometer (dashboard,fast,odometer,speed,speedometer)' ),
            array( 'fa-solid fa-taxi' => 'Taxi (cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-truck-monster' => 'Truck Monster (offroad,vehicle,wheel)' ),
            array( 'fa-solid fa-truck-pickup' => 'Truck Side (cargo,vehicle)' ),
        ),
        'Autumn' => array(
            array( 'fa-solid fa-apple-alt' => 'Fruit Apple (fall,fruit,fuji,macintosh,orchard,seasonal,vegan)' ),
            array( 'fa-solid fa-campground' => 'Campground (camping,fall,outdoors,teepee,tent,tipi)' ),
            array( 'fa-solid fa-cloud-sun' => 'Cloud with Sun (clear,day,daytime,fall,outdoors,overcast,partly cloudy)' ),
            array( 'fa-solid fa-drumstick-bite' => 'Drumstick with Bite Taken Out (bone,chicken,leg,meat,poultry,turkey)' ),
            array( 'fa-solid fa-football-ball' => 'Football Ball (ball,fall,nfl,pigskin,seasonal)' ),
            array( 'fa-solid fa-hiking' => 'Hiking (activity,backpack,fall,fitness,outdoors,person,seasonal,walking)' ),
            array( 'fa-solid fa-mountain' => 'Mountain (glacier,hiking,hill,landscape,travel,view)' ),
            array( 'fa-solid fa-tractor' => 'Tractor (agriculture,farm,vehicle)' ),
            array( 'fa-solid fa-tree' => 'Tree (bark,fall,flora,forest,nature,plant,seasonal)' ),
            array( 'fa-solid fa-wind' => 'Wind (air,blow,breeze,fall,seasonal,weather)' ),
            array( 'fa-solid fa-wine-bottle' => 'Wine Bottle (alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)' ),
        ),
        'Beverage' => array(
            array( 'fa-solid fa-beer' => 'beer (alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)' ),
            array( 'fa-solid fa-blender' => 'Blender (cocktail,milkshake,mixer,puree,smoothie)' ),
            array( 'fa-solid fa-cocktail' => 'Cocktail (alcohol,beverage,drink,gin,glass,margarita,martini,vodka)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-flask' => 'Flask (beaker,experimental,labs,science)' ),
            array( 'fa-solid fa-glass-cheers' => 'Glass Cheers (alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)' ),
            array( 'fa-solid fa-glass-martini' => 'Martini Glass (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-glass-martini-alt' => 'Alternate Glass Martini (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-glass-whiskey' => 'Glass Whiskey (alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)' ),
            array( 'fa-solid fa-mug-hot' => 'Mug Hot (caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)' ),
            array( 'fa-solid fa-wine-bottle' => 'Wine Bottle (alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)' ),
            array( 'fa-solid fa-wine-glass' => 'Wine Glass (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
            array( 'fa-solid fa-wine-glass-alt' => 'Alternate Wine Glas (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
        ),
        'Brands' => array(
            array( 'fa-brands fa-creative-commons' => 'Creative Commons' ),
            array( 'fa-brands fa-twitter-square' => 'Twitter Square (social network,tweet)' ),
            array( 'fa-brands fa-facebook-square' => 'Facebook Square (social network)' ),
            array( 'fa-brands fa-linkedin' => 'LinkedIn (linkedin-square)' ),
            array( 'fa-brands fa-github-square' => 'GitHub Square (octocat)' ),
            array( 'fa-brands fa-twitter' => 'Twitter (social network,tweet)' ),
            array( 'fa-brands fa-facebook-f' => 'Facebook F (facebook)' ),
            array( 'fa-brands fa-github' => 'GitHub (octocat)' ),
            array( 'fa-brands fa-pinterest' => 'Pinterest' ),
            array( 'fa-brands fa-pinterest-square' => 'Pinterest Square' ),
            array( 'fa-brands fa-google-plus-square' => 'Google Plus Square (social network)' ),
            array( 'fa-brands fa-google-plus-g' => 'Google Plus G (google-plus,social network)' ),
            array( 'fa-brands fa-linkedin-in' => 'LinkedIn In (linkedin)' ),
            array( 'fa-brands fa-github-alt' => 'Alternate GitHub (octocat)' ),
            array( 'fa-brands fa-maxcdn' => 'MaxCDN' ),
            array( 'fa-brands fa-html5' => 'HTML 5 Logo' ),
            array( 'fa-brands fa-css3' => 'CSS 3 Logo (code)' ),
            array( 'fa-brands fa-youtube-square' => 'YouTube Square' ),
            array( 'fa-brands fa-xing' => 'Xing' ),
            array( 'fa-brands fa-xing-square' => 'Xing Square' ),
            array( 'fa-brands fa-dropbox' => 'Dropbox' ),
            array( 'fa-brands fa-stack-overflow' => 'Stack Overflow' ),
            array( 'fa-brands fa-instagram' => 'Instagram' ),
            array( 'fa-brands fa-flickr' => 'Flickr' ),
            array( 'fa-brands fa-adn' => 'App.net' ),
            array( 'fa-brands fa-bitbucket' => 'Bitbucket (atlassian,bitbucket-square,git)' ),
            array( 'fa-brands fa-tumblr' => 'Tumblr' ),
            array( 'fa-brands fa-tumblr-square' => 'Tumblr Square' ),
            array( 'fa-brands fa-apple' => 'Apple (fruit,ios,mac,operating system,os,osx)' ),
            array( 'fa-brands fa-windows' => 'Windows (microsoft,operating system,os)' ),
            array( 'fa-brands fa-android' => 'Android (robot)' ),
            array( 'fa-brands fa-linux' => 'Linux (tux)' ),
            array( 'fa-brands fa-dribbble' => 'Dribbble' ),
            array( 'fa-brands fa-skype' => 'Skype' ),
            array( 'fa-brands fa-foursquare' => 'Foursquare' ),
            array( 'fa-brands fa-trello' => 'Trello (atlassian)' ),
            array( 'fa-brands fa-gratipay' => 'Gratipay (Gittip) (favorite,heart,like,love)' ),
            array( 'fa-brands fa-vk' => 'VK' ),
            array( 'fa-brands fa-weibo' => 'Weibo' ),
            array( 'fa-brands fa-renren' => 'Renren' ),
            array( 'fa-brands fa-pagelines' => 'Pagelines (eco,flora,leaf,leaves,nature,plant,tree)' ),
            array( 'fa-brands fa-stack-exchange' => 'Stack Exchange' ),
            array( 'fa-brands fa-vimeo-square' => 'Vimeo Square' ),
            array( 'fa-brands fa-slack' => 'Slack Logo (anchor,hash,hashtag)' ),
            array( 'fa-brands fa-wordpress' => 'WordPress Logo' ),
            array( 'fa-brands fa-openid' => 'OpenID' ),
            array( 'fa-brands fa-yahoo' => 'Yahoo Logo' ),
            array( 'fa-brands fa-google' => 'Google Logo' ),
            array( 'fa-brands fa-reddit' => 'reddit Logo' ),
            array( 'fa-brands fa-reddit-square' => 'reddit Square' ),
            array( 'fa-brands fa-stumbleupon-circle' => 'StumbleUpon Circle' ),
            array( 'fa-brands fa-stumbleupon' => 'StumbleUpon Logo' ),
            array( 'fa-brands fa-delicious' => 'Delicious' ),
            array( 'fa-brands fa-digg' => 'Digg Logo' ),
            array( 'fa-brands fa-pied-piper-pp' => 'Pied Piper PP Logo (Old)' ),
            array( 'fa-brands fa-pied-piper-alt' => 'Alternate Pied Piper Logo' ),
            array( 'fa-brands fa-drupal' => 'Drupal Logo' ),
            array( 'fa-brands fa-joomla' => 'Joomla Logo' ),
            array( 'fa-brands fa-behance' => 'Behance' ),
            array( 'fa-brands fa-behance-square' => 'Behance Square' ),
            array( 'fa-brands fa-deviantart' => 'deviantART' ),
            array( 'fa-brands fa-vine' => 'Vine' ),
            array( 'fa-brands fa-codepen' => 'Codepen' ),
            array( 'fa-brands fa-jsfiddle' => 'jsFiddle' ),
            array( 'fa-brands fa-rebel' => 'Rebel Alliance' ),
            array( 'fa-brands fa-empire' => 'Galactic Empire' ),
            array( 'fa-brands fa-git-square' => 'Git Square' ),
            array( 'fa-brands fa-git' => 'Git' ),
            array( 'fa-brands fa-hacker-news' => 'Hacker News' ),
            array( 'fa-brands fa-tencent-weibo' => 'Tencent Weibo' ),
            array( 'fa-brands fa-qq' => 'QQ' ),
            array( 'fa-brands fa-weixin' => 'Weixin (WeChat)' ),
            array( 'fa-brands fa-slideshare' => 'Slideshare' ),
            array( 'fa-brands fa-yelp' => 'Yelp' ),
            array( 'fa-brands fa-lastfm' => 'last.fm' ),
            array( 'fa-brands fa-lastfm-square' => 'last.fm Square' ),
            array( 'fa-brands fa-ioxhost' => 'ioxhost' ),
            array( 'fa-brands fa-angellist' => 'AngelList' ),
            array( 'fa-brands fa-font-awesome' => 'Font Awesome (meanpath)' ),
            array( 'fa-brands fa-buysellads' => 'BuySellAds' ),
            array( 'fa-brands fa-connectdevelop' => 'Connect Develop' ),
            array( 'fa-brands fa-dashcube' => 'DashCube' ),
            array( 'fa-brands fa-forumbee' => 'Forumbee' ),
            array( 'fa-brands fa-leanpub' => 'Leanpub' ),
            array( 'fa-brands fa-sellsy' => 'Sellsy' ),
            array( 'fa-brands fa-shirtsinbulk' => 'Shirts in Bulk' ),
            array( 'fa-brands fa-simplybuilt' => 'SimplyBuilt' ),
            array( 'fa-brands fa-skyatlas' => 'skyatlas' ),
            array( 'fa-brands fa-facebook' => 'Facebook (facebook-official,social network)' ),
            array( 'fa-brands fa-pinterest-p' => 'Pinterest P' ),
            array( 'fa-brands fa-whatsapp' => 'What\'s App' ),
            array( 'fa-brands fa-viacoin' => 'Viacoin' ),
            array( 'fa-brands fa-medium' => 'Medium' ),
            array( 'fa-brands fa-y-combinator' => 'Y Combinator' ),
            array( 'fa-brands fa-optin-monster' => 'Optin Monster' ),
            array( 'fa-brands fa-opencart' => 'OpenCart' ),
            array( 'fa-brands fa-expeditedssl' => 'ExpeditedSSL' ),
            array( 'fa-brands fa-tripadvisor' => 'TripAdvisor' ),
            array( 'fa-brands fa-odnoklassniki' => 'Odnoklassniki' ),
            array( 'fa-brands fa-odnoklassniki-square' => 'Odnoklassniki Square' ),
            array( 'fa-brands fa-get-pocket' => 'Get Pocket' ),
            array( 'fa-brands fa-wikipedia-w' => 'Wikipedia W' ),
            array( 'fa-brands fa-safari' => 'Safari (browser)' ),
            array( 'fa-brands fa-chrome' => 'Chrome (browser)' ),
            array( 'fa-brands fa-firefox' => 'Firefox (browser)' ),
            array( 'fa-brands fa-opera' => 'Opera' ),
            array( 'fa-brands fa-internet-explorer' => 'Internet-explorer (browser,ie)' ),
            array( 'fa-brands fa-contao' => 'Contao' ),
            array( 'fa-brands fa-500px' => '500px' ),
            array( 'fa-brands fa-amazon' => 'Amazon' ),
            array( 'fa-brands fa-houzz' => 'Houzz' ),
            array( 'fa-brands fa-vimeo-v' => 'Vimeo (vimeo)' ),
            array( 'fa-brands fa-black-tie' => 'Font Awesome Black Tie' ),
            array( 'fa-brands fa-fonticons' => 'Fonticons' ),
            array( 'fa-brands fa-reddit-alien' => 'reddit Alien' ),
            array( 'fa-brands fa-edge' => 'Edge Browser (browser,ie)' ),
            array( 'fa-brands fa-codiepie' => 'Codie Pie' ),
            array( 'fa-brands fa-modx' => 'MODX' ),
            array( 'fa-brands fa-fort-awesome' => 'Fort Awesome (castle)' ),
            array( 'fa-brands fa-usb' => 'USB' ),
            array( 'fa-brands fa-product-hunt' => 'Product Hunt' ),
            array( 'fa-brands fa-mixcloud' => 'Mixcloud' ),
            array( 'fa-brands fa-scribd' => 'Scribd' ),
            array( 'fa-brands fa-gitlab' => 'GitLab (Axosoft)' ),
            array( 'fa-brands fa-wpbeginner' => 'WPBeginner' ),
            array( 'fa-brands fa-wpforms' => 'WPForms' ),
            array( 'fa-brands fa-envira' => 'Envira Gallery (leaf)' ),
            array( 'fa-brands fa-glide' => 'Glide' ),
            array( 'fa-brands fa-glide-g' => 'Glide G' ),
            array( 'fa-brands fa-viadeo' => 'Video' ),
            array( 'fa-brands fa-viadeo-square' => 'Video Square' ),
            array( 'fa-brands fa-snapchat' => 'Snapchat' ),
            array( 'fa-brands fa-snapchat-ghost' => 'Snapchat Ghost' ),
            array( 'fa-brands fa-snapchat-square' => 'Snapchat Square' ),
            array( 'fa-brands fa-pied-piper' => 'Pied Piper Logo' ),
            array( 'fa-brands fa-first-order' => 'First Order' ),
            array( 'fa-brands fa-yoast' => 'Yoast' ),
            array( 'fa-brands fa-themeisle' => 'ThemeIsle' ),
            array( 'fa-brands fa-google-plus' => 'Google Plus (google-plus-circle,google-plus-official)' ),
            array( 'fa-brands fa-linode' => 'Linode' ),
            array( 'fa-brands fa-quora' => 'Quora' ),
            array( 'fa-brands fa-free-code-camp' => 'Free Code Camp' ),
            array( 'fa-brands fa-telegram' => 'Telegram' ),
            array( 'fa-brands fa-bandcamp' => 'Bandcamp' ),
            array( 'fa-brands fa-grav' => 'Grav' ),
            array( 'fa-brands fa-etsy' => 'Etsy' ),
            array( 'fa-brands fa-imdb' => 'IMDB' ),
            array( 'fa-brands fa-ravelry' => 'Ravelry' ),
            array( 'fa-brands fa-sellcast' => 'Sellcast (eercast)' ),
            array( 'fa-brands fa-superpowers' => 'Superpowers' ),
            array( 'fa-brands fa-wpexplorer' => 'WPExplorer' ),
            array( 'fa-brands fa-meetup' => 'Meetup' ),
            array( 'fa-brands fa-tiktok' => 'Tiktok' ),
            array( 'fa-brands fa-bluesky' => 'Bluesky' ),
            array( 'fa-brands fa-jxl' => 'JXL' ),
            array( 'fa-brands fa-square-upwork' => 'Upwork' ),
            array( 'fa-brands fa-square-web-awesome' => 'Web Awesome' ),
            array( 'fa-brands fa-square-web-awesome-stroke' => 'Web Awesome' ),
            array( 'fa-brands fa-square-web-awesome-stroke' => 'Web Awesome' ),
            array( 'fa-brands fa-brave' => 'Brave' ),
            array( 'fa-brands fa-brave-reverse' => 'Brave' ),
            array( 'fa-brands fa-square-x-twitter' => 'Twitter (X)' ),
            array( 'fa-brands fa-x-twitter' => 'Twitter (X)' ),
            array( 'fa-brands fa-square-threads' => 'Threads' ),
            array( 'fa-brands fa-threads' => 'Threads' ),
        ),
        'Buildings' => array(
            array( 'fa-solid fa-archway' => 'Archway (arc,monument,road,street,tunnel)' ),
            array( 'fa-solid fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-regular fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-solid fa-campground' => 'Campground (camping,fall,outdoors,teepee,tent,tipi)' ),
            array( 'fa-solid fa-church' => 'Church (building,cathedral,chapel,community,religion)' ),
            array( 'fa-solid fa-city' => 'City (buildings,busy,skyscrapers,urban,windows)' ),
            array( 'fa-solid fa-clinic-medical' => 'Medical Clinic (doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)' ),
            array( 'fa-solid fa-dungeon' => 'Dungeon (Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)' ),
            array( 'fa-solid fa-gopuram' => 'Gopuram (building,entrance,hinduism,temple,tower)' ),
            array( 'fa-solid fa-home' => 'home (abode,building,house,main)' ),
            array( 'fa-solid fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-regular fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-hospital-alt' => 'Alternate Hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-hotel' => 'Hotel (building,inn,lodging,motel,resort,travel)' ),
            array( 'fa-solid fa-house-damage' => 'Damaged House (building,devastation,disaster,home,insurance)' ),
            array( 'fa-solid fa-igloo' => 'Igloo (dome,dwelling,eskimo,home,house,ice,snow)' ),
            array( 'fa-solid fa-industry' => 'Industry (building,factory,industrial,manufacturing,mill,warehouse)' ),
            array( 'fa-solid fa-kaaba' => 'Kaaba (building,cube,islam,muslim)' ),
            array( 'fa-solid fa-landmark' => 'Landmark (building,historic,memorable,monument,politics)' ),
            array( 'fa-solid fa-monument' => 'Monument (building,historic,landmark,memorable)' ),
            array( 'fa-solid fa-mosque' => 'Mosque (building,islam,landmark,muslim)' ),
            array( 'fa-solid fa-place-of-worship' => 'Place of Worship (building,church,holy,mosque,synagogue)' ),
            array( 'fa-solid fa-school' => 'School (building,education,learn,student,teacher)' ),
            array( 'fa-solid fa-store' => 'Store (building,buy,purchase,shopping)' ),
            array( 'fa-solid fa-store-alt' => 'Alternate Store (building,buy,purchase,shopping)' ),
            array( 'fa-solid fa-synagogue' => 'Synagogue (building,jewish,judaism,religion,star of david,temple)' ),
            array( 'fa-solid fa-torii-gate' => 'Torii Gate (building,shintoism)' ),
            array( 'fa-solid fa-university' => 'University (bank,building,college,higher education - students,institution)' ),
            array( 'fa-solid fa-vihara' => 'Vihara (buddhism,buddhist,building,monastery)' ),
            array( 'fa-solid fa-warehouse' => 'Warehouse (building,capacity,garage,inventory,storage)' ),
        ),
        'Business' => array(
            array( 'fa-solid fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-regular fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-solid fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-regular fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-balance-scale' => 'Balance Scale (balanced,justice,legal,measure,weight)' ),
            array( 'fa-solid fa-balance-scale-left' => 'Balance Scale (Left-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-balance-scale-right' => 'Balance Scale (Right-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-birthday-cake' => 'Birthday Cake (anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)' ),
            array( 'fa-solid fa-book' => 'book (diary,documentation,journal,library,read)' ),
            array( 'fa-solid fa-briefcase' => 'Briefcase (bag,business,luggage,office,work)' ),
            array( 'fa-solid fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-regular fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-bullseye' => 'Bullseye (archery,goal,objective,target)' ),
            array( 'fa-solid fa-business-time' => 'Business Time (alarm,briefcase,business socks,clock,flight of the conchords,reminder,wednesday)' ),
            array( 'fa-solid fa-calculator' => 'Calculator (abacus,addition,arithmetic,counting,math,multiplication,subtraction)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-certificate' => 'certificate (badge,star,verified)' ),
            array( 'fa-solid fa-chart-area' => 'Area Chart (analytics,area,chart,graph)' ),
            array( 'fa-solid fa-chart-bar' => 'Bar Chart (analytics,bar,chart,graph)' ),
            array( 'fa-regular fa-chart-bar' => 'Bar Chart (analytics,bar,chart,graph)' ),
            array( 'fa-solid fa-chart-line' => 'Line Chart (activity,analytics,chart,dashboard,gain,graph,increase,line)' ),
            array( 'fa-solid fa-chart-pie' => 'Pie Chart (analytics,chart,diagram,graph,pie)' ),
            array( 'fa-solid fa-city' => 'City (buildings,busy,skyscrapers,urban,windows)' ),
            array( 'fa-solid fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-regular fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-columns' => 'Columns (browser,dashboard,organize,panes,split)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-copyright' => 'Copyright (brand,mark,register,trademark)' ),
            array( 'fa-regular fa-copyright' => 'Copyright (brand,mark,register,trademark)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-regular fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-square' => 'Envelope Square (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-fax' => 'Fax (business,communicate,copy,facsimile,send)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-minus' => 'Folder Minus (archive,delete,directory,document,file,negative,remove)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-folder-plus' => 'Folder Plus (add,archive,create,directory,document,file,new,positive)' ),
            array( 'fa-solid fa-glasses' => 'Glasses (hipster,nerd,reading,sight,spectacles,vision)' ),
            array( 'fa-solid fa-globe' => 'Globe (all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-highlighter' => 'Highlighter (edit,marker,sharpie,update,write)' ),
            array( 'fa-solid fa-industry' => 'Industry (building,factory,industrial,manufacturing,mill,warehouse)' ),
            array( 'fa-solid fa-landmark' => 'Landmark (building,historic,memorable,monument,politics)' ),
            array( 'fa-solid fa-marker' => 'Marker (design,edit,sharpie,update,write)' ),
            array( 'fa-solid fa-paperclip' => 'Paperclip (attach,attachment,connect,link)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-fancy' => 'Pen Fancy (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pen-nib' => 'Pen Nib (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pen-square' => 'Pen Square (edit,pencil-square,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-percent' => 'Percent (discount,fraction,proportion,rate,ratio)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-slash' => 'Phone Slash (call,cancel,earphone,mute,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square' => 'Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square-alt' => 'Alternate Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-volume' => 'Phone Volume (call,earphone,number,sound,support,telephone,voice,volume-control-phone)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-project-diagram' => 'Project Diagram (chart,graph,network,pert)' ),
            array( 'fa-solid fa-registered' => 'Registered Trademark (copyright,mark,trademark)' ),
            array( 'fa-regular fa-registered' => 'Registered Trademark (copyright,mark,trademark)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-sitemap' => 'Sitemap (directory,hierarchy,ia,information architecture,organization)' ),
            array( 'fa-solid fa-socks' => 'Socks (business socks,business time,clothing,feet,flight of the conchords,wednesday)' ),
            array( 'fa-solid fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-regular fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-solid fa-stream' => 'Stream (flow,list,timeline)' ),
            array( 'fa-solid fa-table' => 'table (data,excel,spreadsheet)' ),
            array( 'fa-solid fa-tag' => 'tag (discount,label,price,shopping)' ),
            array( 'fa-solid fa-tags' => 'tags (discount,label,price,shopping)' ),
            array( 'fa-solid fa-tasks' => 'Tasks (checklist,downloading,downloads,loading,progress,project management,settings,to do)' ),
            array( 'fa-solid fa-thumbtack' => 'Thumbtack (coordinates,location,marker,pin,thumb-tack)' ),
            array( 'fa-solid fa-trademark' => 'Trademark (copyright,register,symbol)' ),
            array( 'fa-solid fa-wallet' => 'Wallet (billfold,cash,currency,money)' ),
        ),
        'Camping' => array(
            array( 'fa-solid fa-binoculars' => 'Binoculars (glasses,magnify,scenic,spyglass,view)' ),
            array( 'fa-solid fa-campground' => 'Campground (camping,fall,outdoors,teepee,tent,tipi)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-fire' => 'fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-first-aid' => 'First Aid (emergency,emt,health,medical,rescue)' ),
            array( 'fa-solid fa-frog' => 'Frog (amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)' ),
            array( 'fa-solid fa-hiking' => 'Hiking (activity,backpack,fall,fitness,outdoors,person,seasonal,walking)' ),
            array( 'fa-solid fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-regular fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marked' => 'Map Marked (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marked-alt' => 'Alternate Map Marked (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-signs' => 'Map Signs (directions,directory,map,signage,wayfinding)' ),
            array( 'fa-solid fa-mountain' => 'Mountain (glacier,hiking,hill,landscape,travel,view)' ),
            array( 'fa-solid fa-route' => 'Route (directions,navigation,travel)' ),
            array( 'fa-solid fa-toilet-paper' => 'Toilet Paper (bathroom,halloween,holiday,lavatory,prank,restroom,roll)' ),
            array( 'fa-solid fa-tree' => 'Tree (bark,fall,flora,forest,nature,plant,seasonal)' ),
        ),
        'Charity' => array(
            array( 'fa-solid fa-dollar-sign' => 'Dollar Sign ($,cost,dollar-sign,money,price,usd)' ),
            array( 'fa-solid fa-donate' => 'Donate (contribute,generosity,gift,give)' ),
            array( 'fa-solid fa-dove' => 'Dove (bird,fauna,flying,peace,war)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-globe' => 'Globe (all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-hand-holding-heart' => 'Hand Holding Heart (carry,charity,gift,lift,package)' ),
            array( 'fa-solid fa-hand-holding-usd' => 'Hand Holding US Dollar ($,carry,dollar sign,donation,giving,lift,money,price)' ),
            array( 'fa-solid fa-hands-helping' => 'Helping Hands (aid,assistance,handshake,partnership,volunteering)' ),
            array( 'fa-solid fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-regular fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-leaf' => 'leaf (eco,flora,nature,plant,vegan)' ),
            array( 'fa-solid fa-parachute-box' => 'Parachute Box (aid,assistance,rescue,supplies)' ),
            array( 'fa-solid fa-piggy-bank' => 'Piggy Bank (bank,save,savings)' ),
            array( 'fa-solid fa-ribbon' => 'Ribbon (badge,cause,lapel,pin)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
        ),
        'Chat' => array(
            array( 'fa-solid fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-dots' => 'Comment Dots (bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)' ),
            array( 'fa-regular fa-comment-dots' => 'Comment Dots (bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-medical' => 'Alternate Medical Chat (advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-slash' => 'Comment Slash (bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)' ),
            array( 'fa-solid fa-comments' => 'comments (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comments' => 'comments (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-regular fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-solid fa-icons' => 'Icons (bolt,emoji,heart,image,music,photo,symbols)' ),
            array( 'fa-solid fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-slash' => 'Phone Slash (call,cancel,earphone,mute,number,support,telephone,voice)' ),
            array( 'fa-solid fa-poo' => 'Poo (crap,poop,shit,smile,turd)' ),
            array( 'fa-solid fa-quote-left' => 'quote-left (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-quote-right' => 'quote-right (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-regular fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-solid fa-sms' => 'SMS (chat,conversation,message,mobile,notification,phone,sms,texting)' ),
            array( 'fa-solid fa-video' => 'Video (camera,film,movie,record,video-camera)' ),
            array( 'fa-solid fa-video-slash' => 'Video Slash (add,create,film,new,positive,record,video)' ),
        ),
        'Chess' => array(
            array( 'fa-solid fa-chess' => 'Chess (board,castle,checkmate,game,king,rook,strategy,tournament)' ),
            array( 'fa-solid fa-chess-bishop' => 'Chess Bishop (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-board' => 'Chess Board (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-king' => 'Chess King (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-knight' => 'Chess Knight (board,checkmate,game,horse,strategy)' ),
            array( 'fa-solid fa-chess-pawn' => 'Chess Pawn (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-queen' => 'Chess Queen (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-rook' => 'Chess Rook (board,castle,checkmate,game,strategy)' ),
            array( 'fa-solid fa-square-full' => 'Square Full (block,box,shape)' ),
        ),
        'Childhood' => array(
            array( 'fa-solid fa-apple-alt' => 'Fruit Apple (fall,fruit,fuji,macintosh,orchard,seasonal,vegan)' ),
            array( 'fa-solid fa-baby' => 'Baby (child,diaper,doll,human,infant,kid,offspring,person,sprout)' ),
            array( 'fa-solid fa-baby-carriage' => 'Baby Carriage (buggy,carrier,infant,push,stroller,transportation,walk,wheels)' ),
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-biking' => 'Biking (bicycle,bike,cycle,cycling,ride,wheel)' ),
            array( 'fa-solid fa-birthday-cake' => 'Birthday Cake (anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)' ),
            array( 'fa-solid fa-cookie' => 'Cookie (baked good,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-cookie-bite' => 'Cookie Bite (baked good,bitten,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-gamepad' => 'Gamepad (arcade,controller,d-pad,joystick,video,video game)' ),
            array( 'fa-solid fa-ice-cream' => 'Ice Cream (chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)' ),
            array( 'fa-solid fa-mitten' => 'Mitten (clothing,cold,glove,hands,knitted,seasonal,warmth)' ),
            array( 'fa-solid fa-robot' => 'Robot (android,automate,computer,cyborg)' ),
            array( 'fa-solid fa-school' => 'School (building,education,learn,student,teacher)' ),
            array( 'fa-solid fa-shapes' => 'Shapes (blocks,build,circle,square,triangle)' ),
            array( 'fa-solid fa-snowman' => 'Snowman (decoration,frost,frosty,holiday)' ),
        ),
        'Clothing' => array(
            array( 'fa-solid fa-graduation-cap' => 'Graduation Cap (ceremony,college,graduate,learning,school,student)' ),
            array( 'fa-solid fa-hat-cowboy' => 'Cowboy Hat (buckaroo,horse,jackeroo,john b.,old west,pardner,ranch,rancher,rodeo,western,wrangler)' ),
            array( 'fa-solid fa-hat-cowboy-side' => 'Cowboy Hat Side (buckaroo,horse,jackeroo,john b.,old west,pardner,ranch,rancher,rodeo,western,wrangler)' ),
            array( 'fa-solid fa-hat-wizard' => 'Wizard\'s Hat (Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)' ),
            array( 'fa-solid fa-mitten' => 'Mitten (clothing,cold,glove,hands,knitted,seasonal,warmth)' ),
            array( 'fa-solid fa-shoe-prints' => 'Shoe Prints (feet,footprints,steps,walk)' ),
            array( 'fa-solid fa-socks' => 'Socks (business socks,business time,clothing,feet,flight of the conchords,wednesday)' ),
            array( 'fa-solid fa-tshirt' => 'T-Shirt (clothing,fashion,garment,shirt)' ),
            array( 'fa-solid fa-user-tie' => 'User Tie (avatar,business,clothing,formal,professional,suit)' ),
        ),
        'Code' => array(
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-barcode' => 'barcode (info,laser,price,scan,upc)' ),
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-bug' => 'Bug (beetle,error,insect,report)' ),
            array( 'fa-solid fa-code' => 'Code (brackets,code,development,html)' ),
            array( 'fa-solid fa-code-branch' => 'Code Branch (branch,code-fork,fork,git,github,rebase,svn,vcs,version)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-file-code' => 'Code File (css,development,document,html)' ),
            array( 'fa-regular fa-file-code' => 'Code File (css,development,document,html)' ),
            array( 'fa-solid fa-filter' => 'Filter (funnel,options,separate,sort)' ),
            array( 'fa-solid fa-fire-extinguisher' => 'fire-extinguisher (burn,caliente,fire fighter,flame,heat,hot,rescue)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-regular fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-solid fa-laptop-code' => 'Laptop Code (computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)' ),
            array( 'fa-solid fa-microchip' => 'Microchip (cpu,hardware,processor,technology)' ),
            array( 'fa-solid fa-project-diagram' => 'Project Diagram (chart,graph,network,pert)' ),
            array( 'fa-solid fa-qrcode' => 'qrcode (barcode,info,information,scan)' ),
            array( 'fa-solid fa-shield-alt' => 'Alternate Shield (achievement,award,block,defend,security,winner)' ),
            array( 'fa-solid fa-sitemap' => 'Sitemap (directory,hierarchy,ia,information architecture,organization)' ),
            array( 'fa-solid fa-stream' => 'Stream (flow,list,timeline)' ),
            array( 'fa-solid fa-terminal' => 'Terminal (code,command,console,development,prompt)' ),
            array( 'fa-solid fa-user-secret' => 'User Secret (clothing,coat,hat,incognito,person,privacy,spy,whisper)' ),
            array( 'fa-solid fa-window-close' => 'Window Close (browser,cancel,computer,development)' ),
            array( 'fa-regular fa-window-close' => 'Window Close (browser,cancel,computer,development)' ),
            array( 'fa-solid fa-window-maximize' => 'Window Maximize (browser,computer,development,expand)' ),
            array( 'fa-regular fa-window-maximize' => 'Window Maximize (browser,computer,development,expand)' ),
            array( 'fa-solid fa-window-minimize' => 'Window Minimize (browser,collapse,computer,development)' ),
            array( 'fa-regular fa-window-minimize' => 'Window Minimize (browser,collapse,computer,development)' ),
            array( 'fa-solid fa-window-restore' => 'Window Restore (browser,computer,development)' ),
            array( 'fa-regular fa-window-restore' => 'Window Restore (browser,computer,development)' ),
        ),
        'Communication' => array(
            array( 'fa-solid fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-regular fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-solid fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-regular fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-solid fa-american-sign-language-interpreting' => 'American Sign Language Interpreting (asl,deaf,finger,hand,interpret,speak)' ),
            array( 'fa-solid fa-assistive-listening-systems' => 'Assistive Listening Systems (amplify,audio,deaf,ear,headset,hearing,sound)' ),
            array( 'fa-solid fa-at' => 'At (address,author,e-mail,email,handle)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-brands fa-bluetooth' => 'Bluetooth' ),
            array( 'fa-brands fa-bluetooth-b' => 'Bluetooth' ),
            array( 'fa-solid fa-broadcast-tower' => 'Broadcast Tower (airwaves,antenna,radio,reception,waves)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-chalkboard' => 'Chalkboard (blackboard,learning,school,teaching,whiteboard,writing)' ),
            array( 'fa-solid fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comments' => 'comments (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comments' => 'comments (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-square' => 'Envelope Square (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-fax' => 'Fax (business,communicate,copy,facsimile,send)' ),
            array( 'fa-solid fa-inbox' => 'inbox (archive,desk,email,mail,message)' ),
            array( 'fa-solid fa-language' => 'Language (dialect,idiom,localize,speech,translate,vernacular)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt-slash' => 'Alternate Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-mobile' => 'Mobile Phone (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-mobile-alt' => 'Alternate Mobile (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-regular fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-slash' => 'Phone Slash (call,cancel,earphone,mute,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square' => 'Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square-alt' => 'Alternate Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-volume' => 'Phone Volume (call,earphone,number,sound,support,telephone,voice,volume-control-phone)' ),
            array( 'fa-solid fa-rss' => 'rss (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-rss-square' => 'RSS Square (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-tty' => 'TTY (communication,deaf,telephone,teletypewriter,text)' ),
            array( 'fa-solid fa-voicemail' => 'Voicemail (answer,inbox,message,phone)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
        ),
        'Computers' => array(
            array( 'fa-solid fa-database' => 'Database (computer,development,directory,memory,storage)' ),
            array( 'fa-solid fa-desktop' => 'Desktop (computer,cpu,demo,desktop,device,imac,machine,monitor,pc,screen)' ),
            array( 'fa-solid fa-download' => 'Download (export,hard drive,save,transfer)' ),
            array( 'fa-solid fa-ethernet' => 'Ethernet (cable,cat 5,cat 6,connection,hardware,internet,network,wired)' ),
            array( 'fa-solid fa-hdd' => 'HDD (cpu,hard drive,harddrive,machine,save,storage)' ),
            array( 'fa-regular fa-hdd' => 'HDD (cpu,hard drive,harddrive,machine,save,storage)' ),
            array( 'fa-solid fa-headphones' => 'headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-regular fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-solid fa-laptop' => 'Laptop (computer,cpu,dell,demo,device,mac,macbook,machine,pc)' ),
            array( 'fa-solid fa-memory' => 'Memory (DIMM,RAM,hardware,storage,technology)' ),
            array( 'fa-solid fa-microchip' => 'Microchip (cpu,hardware,processor,technology)' ),
            array( 'fa-solid fa-mobile' => 'Mobile Phone (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-mobile-alt' => 'Alternate Mobile (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-mouse' => 'Mouse (click,computer,cursor,input,peripheral)' ),
            array( 'fa-solid fa-plug' => 'Plug (connect,electric,online,power)' ),
            array( 'fa-solid fa-power-off' => 'Power Off (cancel,computer,on,reboot,restart)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-satellite' => 'Satellite (communications,hardware,orbit,space)' ),
            array( 'fa-solid fa-satellite-dish' => 'Satellite Dish (SETI,communications,hardware,receiver,saucer,signal)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-sd-card' => 'Sd Card (image,memory,photo,save)' ),
            array( 'fa-solid fa-server' => 'Server (computer,cpu,database,hardware,network)' ),
            array( 'fa-solid fa-sim-card' => 'SIM Card (hard drive,hardware,portable,storage,technology,tiny)' ),
            array( 'fa-solid fa-stream' => 'Stream (flow,list,timeline)' ),
            array( 'fa-solid fa-tablet' => 'tablet (apple,device,ipad,kindle,screen)' ),
            array( 'fa-solid fa-tablet-alt' => 'Alternate Tablet (apple,device,ipad,kindle,screen)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
            array( 'fa-solid fa-upload' => 'Upload (hard drive,import,publish)' ),
        ),
        'Construction' => array(
            array( 'fa-solid fa-brush' => 'Brush (art,bristles,color,handle,paint)' ),
            array( 'fa-solid fa-drafting-compass' => 'Drafting Compass (design,map,mechanical drawing,plot,plotting)' ),
            array( 'fa-solid fa-dumpster' => 'Dumpster (alley,bin,commercial,trash,waste)' ),
            array( 'fa-solid fa-hammer' => 'Hammer (admin,fix,repair,settings,tool)' ),
            array( 'fa-solid fa-hard-hat' => 'Hard Hat (construction,hardhat,helmet,safety)' ),
            array( 'fa-solid fa-paint-roller' => 'Paint Roller (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-pencil-ruler' => 'Pencil Ruler (design,draft,draw,pencil)' ),
            array( 'fa-solid fa-ruler' => 'Ruler (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-combined' => 'Ruler Combined (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-horizontal' => 'Ruler Horizontal (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-vertical' => 'Ruler Vertical (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-screwdriver' => 'Screwdriver (admin,fix,mechanic,repair,settings,tool)' ),
            array( 'fa-solid fa-toolbox' => 'Toolbox (admin,container,fix,repair,settings,tools)' ),
            array( 'fa-solid fa-tools' => 'Tools (admin,fix,repair,screwdriver,settings,tools,wrench)' ),
            array( 'fa-solid fa-truck-pickup' => 'Truck Side (cargo,vehicle)' ),
            array( 'fa-solid fa-wrench' => 'Wrench (construction,fix,mechanic,plumbing,settings,spanner,tool,update)' ),
        ),
        'Currency' => array(
            array( 'fa-brands fa-bitcoin' => 'Bitcoin' ),
            array( 'fa-brands fa-btc' => 'BTC' ),
            array( 'fa-solid fa-dollar-sign' => 'Dollar Sign ($,cost,dollar-sign,money,price,usd)' ),
            array( 'fa-brands fa-ethereum' => 'Ethereum' ),
            array( 'fa-solid fa-euro-sign' => 'Euro Sign (currency,dollar,exchange,money)' ),
            array( 'fa-brands fa-gg' => 'GG Currency' ),
            array( 'fa-brands fa-gg-circle' => 'GG Currency Circle' ),
            array( 'fa-solid fa-hryvnia' => 'Hryvnia (currency,money,ukraine,ukrainian)' ),
            array( 'fa-solid fa-lira-sign' => 'Turkish Lira Sign (currency,money,try,turkish)' ),
            array( 'fa-solid fa-money-bill' => 'Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-regular fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-wave' => 'Wavy Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-wave-alt' => 'Alternate Wavy Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check' => 'Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check-alt' => 'Alternate Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-pound-sign' => 'Pound Sign (currency,gbp,money)' ),
            array( 'fa-solid fa-ruble-sign' => 'Ruble Sign (currency,money,rub)' ),
            array( 'fa-solid fa-rupee-sign' => 'Indian Rupee Sign (currency,indian,inr,money)' ),
            array( 'fa-solid fa-shekel-sign' => 'Shekel Sign (currency,ils,money)' ),
            array( 'fa-solid fa-tenge' => 'Tenge (currency,kazakhstan,money,price)' ),
            array( 'fa-solid fa-won-sign' => 'Won Sign (currency,krw,money)' ),
            array( 'fa-solid fa-yen-sign' => 'Yen Sign (currency,jpy,money)' ),
        ),
        'Date & Time' => array(
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-regular fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-solid fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-regular fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-solid fa-clock' => 'Clock (date,late,schedule,time,timer,timestamp,watch)' ),
            array( 'fa-regular fa-clock' => 'Clock (date,late,schedule,time,timer,timestamp,watch)' ),
            array( 'fa-solid fa-hourglass' => 'Hourglass (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-regular fa-hourglass' => 'Hourglass (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-solid fa-hourglass-end' => 'Hourglass End (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-solid fa-hourglass-half' => 'Hourglass Half (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-solid fa-hourglass-start' => 'Hourglass Start (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-solid fa-stopwatch' => 'Stopwatch (clock,reminder,time)' ),
        ),
        'Design' => array(
            array( 'fa-solid fa-circle-half-stroke' => 'adjust (contrast,dark,light,saturation)' ),
            array( 'fa-solid fa-bezier-curve' => 'Bezier Curve (curves,illustrator,lines,path,vector)' ),
            array( 'fa-solid fa-brush' => 'Brush (art,bristles,color,handle,paint)' ),
            array( 'fa-solid fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-regular fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-crop' => 'crop (design,frame,mask,resize,shrink)' ),
            array( 'fa-solid fa-crop-alt' => 'Alternate Crop (design,frame,mask,resize,shrink)' ),
            array( 'fa-solid fa-crosshairs' => 'Crosshairs (aim,bullseye,gpd,picker,position)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-drafting-compass' => 'Drafting Compass (design,map,mechanical drawing,plot,plotting)' ),
            array( 'fa-solid fa-draw-polygon' => 'Draw Polygon (anchors,lines,object,render,shape)' ),
            array( 'fa-solid fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-regular fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-dropper' => 'Eye Dropper (beaker,clone,color,copy,eyedropper,pipette)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-fill' => 'Fill (bucket,color,paint,paint bucket)' ),
            array( 'fa-solid fa-fill-drip' => 'Fill Drip (bucket,color,drop,paint,paint bucket,spill)' ),
            array( 'fa-solid fa-highlighter' => 'Highlighter (edit,marker,sharpie,update,write)' ),
            array( 'fa-solid fa-icons' => 'Icons (bolt,emoji,heart,image,music,photo,symbols)' ),
            array( 'fa-solid fa-layer-group' => 'Layer Group (arrange,develop,layers,map,stack)' ),
            array( 'fa-solid fa-magic' => 'magic (autocomplete,automatic,mage,magic,spell,wand,witch,wizard)' ),
            array( 'fa-solid fa-marker' => 'Marker (design,edit,sharpie,update,write)' ),
            array( 'fa-solid fa-object-group' => 'Object Group (combine,copy,design,merge,select)' ),
            array( 'fa-regular fa-object-group' => 'Object Group (combine,copy,design,merge,select)' ),
            array( 'fa-solid fa-object-ungroup' => 'Object Ungroup (copy,design,merge,select,separate)' ),
            array( 'fa-regular fa-object-ungroup' => 'Object Ungroup (copy,design,merge,select,separate)' ),
            array( 'fa-solid fa-paint-brush' => 'Paint Brush (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-paint-roller' => 'Paint Roller (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-palette' => 'Palette (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-fancy' => 'Pen Fancy (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pen-nib' => 'Pen Nib (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-pencil-ruler' => 'Pencil Ruler (design,draft,draw,pencil)' ),
            array( 'fa-solid fa-ruler-combined' => 'Ruler Combined (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-horizontal' => 'Ruler Horizontal (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-vertical' => 'Ruler Vertical (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-splotch' => 'Splotch (Ink,blob,blotch,glob,stain)' ),
            array( 'fa-solid fa-spray-can' => 'Spray Can (Paint,aerosol,design,graffiti,tag)' ),
            array( 'fa-solid fa-stamp' => 'Stamp (art,certificate,imprint,rubber,seal)' ),
            array( 'fa-solid fa-swatchbook' => 'Swatchbook (Pantone,color,design,hue,palette)' ),
            array( 'fa-solid fa-tint' => 'tint (color,drop,droplet,raindrop,waterdrop)' ),
            array( 'fa-solid fa-tint-slash' => 'Tint Slash (color,drop,droplet,raindrop,waterdrop)' ),
            array( 'fa-solid fa-vector-square' => 'Vector Square (anchors,lines,object,render,shape)' ),
        ),
        'Editors' => array(
            array( 'fa-solid fa-align-center' => 'align-center (format,middle,paragraph,text)' ),
            array( 'fa-solid fa-align-justify' => 'align-justify (format,paragraph,text)' ),
            array( 'fa-solid fa-align-left' => 'align-left (format,paragraph,text)' ),
            array( 'fa-solid fa-align-right' => 'align-right (format,paragraph,text)' ),
            array( 'fa-solid fa-bold' => 'bold (emphasis,format,text)' ),
            array( 'fa-solid fa-border-all' => 'Border All (cell,grid,outline,stroke,table)' ),
            array( 'fa-solid fa-border-none' => 'Border None (cell,grid,outline,stroke,table)' ),
            array( 'fa-solid fa-border-style' => 'Border Style' ),
            array( 'fa-solid fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-regular fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-solid fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-regular fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-solid fa-columns' => 'Columns (browser,dashboard,organize,panes,split)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-regular fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-font' => 'font (alphabet,glyph,text,type,typeface)' ),
            array( 'fa-solid fa-glasses' => 'Glasses (hipster,nerd,reading,sight,spectacles,vision)' ),
            array( 'fa-solid fa-heading' => 'heading (format,header,text,title)' ),
            array( 'fa-solid fa-highlighter' => 'Highlighter (edit,marker,sharpie,update,write)' ),
            array( 'fa-solid fa-i-cursor' => 'I Beam Cursor (editing,i-beam,type,writing)' ),
            array( 'fa-solid fa-icons' => 'Icons (bolt,emoji,heart,image,music,photo,symbols)' ),
            array( 'fa-solid fa-indent' => 'Indent (align,justify,paragraph,tab)' ),
            array( 'fa-solid fa-italic' => 'italic (edit,emphasis,font,format,text,type)' ),
            array( 'fa-solid fa-link' => 'Link (attach,attachment,chain,connect)' ),
            array( 'fa-solid fa-list' => 'List (checklist,completed,done,finished,ol,todo,ul)' ),
            array( 'fa-solid fa-list-alt' => 'Alternate List (checklist,completed,done,finished,ol,todo,ul)' ),
            array( 'fa-regular fa-list-alt' => 'Alternate List (checklist,completed,done,finished,ol,todo,ul)' ),
            array( 'fa-solid fa-list-ol' => 'list-ol (checklist,completed,done,finished,numbers,ol,todo,ul)' ),
            array( 'fa-solid fa-list-ul' => 'list-ul (checklist,completed,done,finished,ol,todo,ul)' ),
            array( 'fa-solid fa-marker' => 'Marker (design,edit,sharpie,update,write)' ),
            array( 'fa-solid fa-outdent' => 'Outdent (align,justify,paragraph,tab)' ),
            array( 'fa-solid fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-regular fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-solid fa-paperclip' => 'Paperclip (attach,attachment,connect,link)' ),
            array( 'fa-solid fa-paragraph' => 'paragraph (edit,format,text,writing)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-fancy' => 'Pen Fancy (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pen-nib' => 'Pen Nib (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-quote-left' => 'quote-left (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-quote-right' => 'quote-right (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-redo' => 'Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-redo-alt' => 'Alternate Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-remove-format' => 'Remove Format (cancel,font,format,remove,style,text)' ),
            array( 'fa-solid fa-reply' => 'Reply (mail,message,respond)' ),
            array( 'fa-solid fa-reply-all' => 'reply-all (mail,message,respond)' ),
            array( 'fa-solid fa-screwdriver' => 'Screwdriver (admin,fix,mechanic,repair,settings,tool)' ),
            array( 'fa-solid fa-share' => 'Share (forward,save,send,social)' ),
            array( 'fa-solid fa-spell-check' => 'Spell Check (dictionary,edit,editor,grammar,text)' ),
            array( 'fa-solid fa-strikethrough' => 'Strikethrough (cancel,edit,font,format,text,type)' ),
            array( 'fa-solid fa-subscript' => 'subscript (edit,font,format,text,type)' ),
            array( 'fa-solid fa-superscript' => 'superscript (edit,exponential,font,format,text,type)' ),
            array( 'fa-solid fa-sync' => 'Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-sync-alt' => 'Alternate Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-table' => 'table (data,excel,spreadsheet)' ),
            array( 'fa-solid fa-tasks' => 'Tasks (checklist,downloading,downloads,loading,progress,project management,settings,to do)' ),
            array( 'fa-solid fa-text-height' => 'text-height (edit,font,format,text,type)' ),
            array( 'fa-solid fa-text-width' => 'Text Width (edit,font,format,text,type)' ),
            array( 'fa-solid fa-th' => 'th (blocks,boxes,grid,squares)' ),
            array( 'fa-solid fa-th-large' => 'th-large (blocks,boxes,grid,squares)' ),
            array( 'fa-solid fa-th-list' => 'th-list (checklist,completed,done,finished,ol,todo,ul)' ),
            array( 'fa-solid fa-tools' => 'Tools (admin,fix,repair,screwdriver,settings,tools,wrench)' ),
            array( 'fa-solid fa-trash' => 'Trash (delete,garbage,hide,remove)' ),
            array( 'fa-solid fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-regular fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-solid fa-trash-restore' => 'Trash Restore (back,control z,oops,undo)' ),
            array( 'fa-solid fa-trash-restore-alt' => 'Alternative Trash Restore (back,control z,oops,undo)' ),
            array( 'fa-solid fa-underline' => 'Underline (edit,emphasis,format,text,writing)' ),
            array( 'fa-solid fa-undo' => 'Undo (back,control z,exchange,oops,return,rotate,swap)' ),
            array( 'fa-solid fa-undo-alt' => 'Alternate Undo (back,control z,exchange,oops,return,swap)' ),
            array( 'fa-solid fa-unlink' => 'unlink (attachment,chain,chain-broken,remove)' ),
            array( 'fa-solid fa-wrench' => 'Wrench (construction,fix,mechanic,plumbing,settings,spanner,tool,update)' ),
        ),
        'Education' => array(
            array( 'fa-solid fa-apple-alt' => 'Fruit Apple (fall,fruit,fuji,macintosh,orchard,seasonal,vegan)' ),
            array( 'fa-solid fa-atom' => 'Atom (atheism,chemistry,ion,nuclear,science)' ),
            array( 'fa-solid fa-award' => 'Award (honor,praise,prize,recognition,ribbon,trophy)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-book-open' => 'Book Open (flyer,library,notebook,open book,pamphlet,reading)' ),
            array( 'fa-solid fa-book-reader' => 'Book Reader (flyer,library,notebook,open book,pamphlet,reading)' ),
            array( 'fa-solid fa-chalkboard' => 'Chalkboard (blackboard,learning,school,teaching,whiteboard,writing)' ),
            array( 'fa-solid fa-chalkboard-teacher' => 'Chalkboard Teacher (blackboard,instructor,learning,professor,school,whiteboard,writing)' ),
            array( 'fa-solid fa-graduation-cap' => 'Graduation Cap (ceremony,college,graduate,learning,school,student)' ),
            array( 'fa-solid fa-laptop-code' => 'Laptop Code (computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)' ),
            array( 'fa-solid fa-microscope' => 'Microscope (electron,lens,optics,science,shrink)' ),
            array( 'fa-solid fa-music' => 'Music (lyrics,melody,note,sing,sound)' ),
            array( 'fa-solid fa-school' => 'School (building,education,learn,student,teacher)' ),
            array( 'fa-solid fa-shapes' => 'Shapes (blocks,build,circle,square,triangle)' ),
            array( 'fa-solid fa-theater-masks' => 'Theater Masks (comedy,perform,theatre,tragedy)' ),
            array( 'fa-solid fa-user-graduate' => 'User Graduate (cap,clothing,commencement,gown,graduation,person,student)' ),
        ),
        'Emoji' => array(
            array( 'fa-solid fa-angry' => 'Angry Face (disapprove,emoticon,face,mad,upset)' ),
            array( 'fa-regular fa-angry' => 'Angry Face (disapprove,emoticon,face,mad,upset)' ),
            array( 'fa-solid fa-dizzy' => 'Dizzy Face (dazed,dead,disapprove,emoticon,face)' ),
            array( 'fa-regular fa-dizzy' => 'Dizzy Face (dazed,dead,disapprove,emoticon,face)' ),
            array( 'fa-solid fa-flushed' => 'Flushed Face (embarrassed,emoticon,face)' ),
            array( 'fa-regular fa-flushed' => 'Flushed Face (embarrassed,emoticon,face)' ),
            array( 'fa-solid fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-regular fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-solid fa-frown-open' => 'Frowning Face With Open Mouth (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-regular fa-frown-open' => 'Frowning Face With Open Mouth (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-solid fa-grimace' => 'Grimacing Face (cringe,emoticon,face,teeth)' ),
            array( 'fa-regular fa-grimace' => 'Grimacing Face (cringe,emoticon,face,teeth)' ),
            array( 'fa-solid fa-grin' => 'Grinning Face (emoticon,face,laugh,smile)' ),
            array( 'fa-regular fa-grin' => 'Grinning Face (emoticon,face,laugh,smile)' ),
            array( 'fa-solid fa-grin-alt' => 'Alternate Grinning Face (emoticon,face,laugh,smile)' ),
            array( 'fa-regular fa-grin-alt' => 'Alternate Grinning Face (emoticon,face,laugh,smile)' ),
            array( 'fa-solid fa-grin-beam' => 'Grinning Face With Smiling Eyes (emoticon,face,laugh,smile)' ),
            array( 'fa-regular fa-grin-beam' => 'Grinning Face With Smiling Eyes (emoticon,face,laugh,smile)' ),
            array( 'fa-solid fa-grin-beam-sweat' => 'Grinning Face With Sweat (embarass,emoticon,face,smile)' ),
            array( 'fa-regular fa-grin-beam-sweat' => 'Grinning Face With Sweat (embarass,emoticon,face,smile)' ),
            array( 'fa-solid fa-grin-hearts' => 'Smiling Face With Heart-Eyes (emoticon,face,love,smile)' ),
            array( 'fa-regular fa-grin-hearts' => 'Smiling Face With Heart-Eyes (emoticon,face,love,smile)' ),
            array( 'fa-solid fa-grin-squint' => 'Grinning Squinting Face (emoticon,face,laugh,smile)' ),
            array( 'fa-regular fa-grin-squint' => 'Grinning Squinting Face (emoticon,face,laugh,smile)' ),
            array( 'fa-solid fa-grin-squint-tears' => 'Rolling on the Floor Laughing (emoticon,face,happy,smile)' ),
            array( 'fa-regular fa-grin-squint-tears' => 'Rolling on the Floor Laughing (emoticon,face,happy,smile)' ),
            array( 'fa-solid fa-grin-stars' => 'Star-Struck (emoticon,face,star-struck)' ),
            array( 'fa-regular fa-grin-stars' => 'Star-Struck (emoticon,face,star-struck)' ),
            array( 'fa-solid fa-grin-tears' => 'Face With Tears of Joy (LOL,emoticon,face)' ),
            array( 'fa-regular fa-grin-tears' => 'Face With Tears of Joy (LOL,emoticon,face)' ),
            array( 'fa-solid fa-grin-tongue' => 'Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-regular fa-grin-tongue' => 'Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-solid fa-grin-tongue-squint' => 'Squinting Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-regular fa-grin-tongue-squint' => 'Squinting Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-solid fa-grin-tongue-wink' => 'Winking Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-regular fa-grin-tongue-wink' => 'Winking Face With Tongue (LOL,emoticon,face)' ),
            array( 'fa-solid fa-grin-wink' => 'Grinning Winking Face (emoticon,face,flirt,laugh,smile)' ),
            array( 'fa-regular fa-grin-wink' => 'Grinning Winking Face (emoticon,face,flirt,laugh,smile)' ),
            array( 'fa-solid fa-kiss' => 'Kissing Face (beso,emoticon,face,love,smooch)' ),
            array( 'fa-regular fa-kiss' => 'Kissing Face (beso,emoticon,face,love,smooch)' ),
            array( 'fa-solid fa-kiss-beam' => 'Kissing Face With Smiling Eyes (beso,emoticon,face,love,smooch)' ),
            array( 'fa-regular fa-kiss-beam' => 'Kissing Face With Smiling Eyes (beso,emoticon,face,love,smooch)' ),
            array( 'fa-solid fa-kiss-wink-heart' => 'Face Blowing a Kiss (beso,emoticon,face,love,smooch)' ),
            array( 'fa-regular fa-kiss-wink-heart' => 'Face Blowing a Kiss (beso,emoticon,face,love,smooch)' ),
            array( 'fa-solid fa-laugh' => 'Grinning Face With Big Eyes (LOL,emoticon,face,laugh,smile)' ),
            array( 'fa-regular fa-laugh' => 'Grinning Face With Big Eyes (LOL,emoticon,face,laugh,smile)' ),
            array( 'fa-solid fa-laugh-beam' => 'Laugh Face with Beaming Eyes (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-regular fa-laugh-beam' => 'Laugh Face with Beaming Eyes (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-solid fa-laugh-squint' => 'Laughing Squinting Face (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-regular fa-laugh-squint' => 'Laughing Squinting Face (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-solid fa-laugh-wink' => 'Laughing Winking Face (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-regular fa-laugh-wink' => 'Laughing Winking Face (LOL,emoticon,face,happy,smile)' ),
            array( 'fa-solid fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-meh-blank' => 'Face Without Mouth (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh-blank' => 'Face Without Mouth (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-meh-rolling-eyes' => 'Face With Rolling Eyes (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh-rolling-eyes' => 'Face With Rolling Eyes (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-sad-cry' => 'Crying Face (emoticon,face,tear,tears)' ),
            array( 'fa-regular fa-sad-cry' => 'Crying Face (emoticon,face,tear,tears)' ),
            array( 'fa-solid fa-sad-tear' => 'Loudly Crying Face (emoticon,face,tear,tears)' ),
            array( 'fa-regular fa-sad-tear' => 'Loudly Crying Face (emoticon,face,tear,tears)' ),
            array( 'fa-solid fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-regular fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-solid fa-smile-beam' => 'Beaming Face With Smiling Eyes (emoticon,face,happy,positive)' ),
            array( 'fa-regular fa-smile-beam' => 'Beaming Face With Smiling Eyes (emoticon,face,happy,positive)' ),
            array( 'fa-solid fa-smile-wink' => 'Winking Face (emoticon,face,happy,hint,joke)' ),
            array( 'fa-regular fa-smile-wink' => 'Winking Face (emoticon,face,happy,hint,joke)' ),
            array( 'fa-solid fa-surprise' => 'Hushed Face (emoticon,face,shocked)' ),
            array( 'fa-regular fa-surprise' => 'Hushed Face (emoticon,face,shocked)' ),
            array( 'fa-solid fa-tired' => 'Tired Face (angry,emoticon,face,grumpy,upset)' ),
            array( 'fa-regular fa-tired' => 'Tired Face (angry,emoticon,face,grumpy,upset)' ),
        ),
        'Energy' => array(
            array( 'fa-solid fa-atom' => 'Atom (atheism,chemistry,ion,nuclear,science)' ),
            array( 'fa-solid fa-battery-empty' => 'Battery Empty (charge,dead,power,status)' ),
            array( 'fa-solid fa-battery-full' => 'Battery Full (charge,power,status)' ),
            array( 'fa-solid fa-battery-half' => 'Battery 1/2 Full (charge,power,status)' ),
            array( 'fa-solid fa-battery-quarter' => 'Battery 1/4 Full (charge,low,power,status)' ),
            array( 'fa-solid fa-battery-three-quarters' => 'Battery 3/4 Full (charge,power,status)' ),
            array( 'fa-solid fa-broadcast-tower' => 'Broadcast Tower (airwaves,antenna,radio,reception,waves)' ),
            array( 'fa-solid fa-burn' => 'Burn (caliente,energy,fire,flame,gas,heat,hot)' ),
            array( 'fa-solid fa-charging-station' => 'Charging Station (electric,ev,tesla,vehicle)' ),
            array( 'fa-solid fa-fire' => 'fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-gas-pump' => 'Gas Pump (car,fuel,gasoline,petrol)' ),
            array( 'fa-solid fa-industry' => 'Industry (building,factory,industrial,manufacturing,mill,warehouse)' ),
            array( 'fa-solid fa-leaf' => 'leaf (eco,flora,nature,plant,vegan)' ),
            array( 'fa-solid fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-regular fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-solid fa-plug' => 'Plug (connect,electric,online,power)' ),
            array( 'fa-solid fa-poop' => 'Poop (crap,poop,shit,smile,turd)' ),
            array( 'fa-solid fa-power-off' => 'Power Off (cancel,computer,on,reboot,restart)' ),
            array( 'fa-solid fa-radiation' => 'Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-radiation-alt' => 'Alternate Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
            array( 'fa-solid fa-solar-panel' => 'Solar Panel (clean,eco-friendly,energy,green,sun)' ),
            array( 'fa-solid fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-regular fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-solid fa-water' => 'Water (lake,liquid,ocean,sea,swim,wet)' ),
            array( 'fa-solid fa-wind' => 'Wind (air,blow,breeze,fall,seasonal,weather)' ),
        ),
        'Files' => array(
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-regular fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-file-archive' => 'Archive File (.zip,bundle,compress,compression,download,zip)' ),
            array( 'fa-regular fa-file-archive' => 'Archive File (.zip,bundle,compress,compression,download,zip)' ),
            array( 'fa-solid fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-regular fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-solid fa-file-code' => 'Code File (css,development,document,html)' ),
            array( 'fa-regular fa-file-code' => 'Code File (css,development,document,html)' ),
            array( 'fa-solid fa-file-excel' => 'Excel File (csv,document,numbers,spreadsheets,table)' ),
            array( 'fa-regular fa-file-excel' => 'Excel File (csv,document,numbers,spreadsheets,table)' ),
            array( 'fa-solid fa-file-image' => 'Image File (document,image,jpg,photo,png)' ),
            array( 'fa-regular fa-file-image' => 'Image File (document,image,jpg,photo,png)' ),
            array( 'fa-solid fa-file-pdf' => 'PDF File (acrobat,document,preview,save)' ),
            array( 'fa-regular fa-file-pdf' => 'PDF File (acrobat,document,preview,save)' ),
            array( 'fa-solid fa-file-powerpoint' => 'Powerpoint File (display,document,keynote,presentation)' ),
            array( 'fa-regular fa-file-powerpoint' => 'Powerpoint File (display,document,keynote,presentation)' ),
            array( 'fa-solid fa-file-video' => 'Video File (document,m4v,movie,mp4,play)' ),
            array( 'fa-regular fa-file-video' => 'Video File (document,m4v,movie,mp4,play)' ),
            array( 'fa-solid fa-file-word' => 'Word File (document,edit,page,text,writing)' ),
            array( 'fa-regular fa-file-word' => 'Word File (document,edit,page,text,writing)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-photo-video' => 'Photo Video (av,film,image,library,media)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-regular fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
        ),
        'Finance' => array(
            array( 'fa-solid fa-balance-scale' => 'Balance Scale (balanced,justice,legal,measure,weight)' ),
            array( 'fa-solid fa-balance-scale-left' => 'Balance Scale (Left-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-balance-scale-right' => 'Balance Scale (Right-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-book' => 'book (diary,documentation,journal,library,read)' ),
            array( 'fa-solid fa-cash-register' => 'Cash Register (buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)' ),
            array( 'fa-solid fa-chart-line' => 'Line Chart (activity,analytics,chart,dashboard,gain,graph,increase,line)' ),
            array( 'fa-solid fa-chart-pie' => 'Pie Chart (analytics,chart,diagram,graph,pie)' ),
            array( 'fa-solid fa-coins' => 'Coins (currency,dime,financial,gold,money,penny)' ),
            array( 'fa-solid fa-comment-dollar' => 'Comment Dollar (bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)' ),
            array( 'fa-solid fa-comments-dollar' => 'Comments Dollar (bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)' ),
            array( 'fa-solid fa-credit-card' => 'Credit Card (buy,checkout,credit-card-alt,debit,money,payment,purchase)' ),
            array( 'fa-regular fa-credit-card' => 'Credit Card (buy,checkout,credit-card-alt,debit,money,payment,purchase)' ),
            array( 'fa-solid fa-donate' => 'Donate (contribute,generosity,gift,give)' ),
            array( 'fa-solid fa-file-invoice' => 'File Invoice (account,bill,charge,document,payment,receipt)' ),
            array( 'fa-solid fa-file-invoice-dollar' => 'File Invoice with US Dollar ($,account,bill,charge,document,dollar-sign,money,payment,receipt,usd)' ),
            array( 'fa-solid fa-hand-holding-usd' => 'Hand Holding US Dollar ($,carry,dollar sign,donation,giving,lift,money,price)' ),
            array( 'fa-solid fa-landmark' => 'Landmark (building,historic,memorable,monument,politics)' ),
            array( 'fa-solid fa-money-bill' => 'Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-regular fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-wave' => 'Wavy Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-wave-alt' => 'Alternate Wavy Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check' => 'Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check-alt' => 'Alternate Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-percentage' => 'Percentage (discount,fraction,proportion,rate,ratio)' ),
            array( 'fa-solid fa-piggy-bank' => 'Piggy Bank (bank,save,savings)' ),
            array( 'fa-solid fa-receipt' => 'Receipt (check,invoice,money,pay,table)' ),
            array( 'fa-solid fa-stamp' => 'Stamp (art,certificate,imprint,rubber,seal)' ),
            array( 'fa-solid fa-wallet' => 'Wallet (billfold,cash,currency,money)' ),
        ),
        'Fitness' => array(
            array( 'fa-solid fa-bicycle' => 'Bicycle (bike,gears,pedal,transportation,vehicle)' ),
            array( 'fa-solid fa-biking' => 'Biking (bicycle,bike,cycle,cycling,ride,wheel)' ),
            array( 'fa-solid fa-burn' => 'Burn (caliente,energy,fire,flame,gas,heat,hot)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heartbeat' => 'Heartbeat (ekg,electrocardiogram,health,lifeline,vital signs)' ),
            array( 'fa-solid fa-hiking' => 'Hiking (activity,backpack,fall,fitness,outdoors,person,seasonal,walking)' ),
            array( 'fa-solid fa-running' => 'Running (exercise,health,jog,person,run,sport,sprint)' ),
            array( 'fa-solid fa-shoe-prints' => 'Shoe Prints (feet,footprints,steps,walk)' ),
            array( 'fa-solid fa-skating' => 'Skating (activity,figure skating,fitness,ice,person,winter)' ),
            array( 'fa-solid fa-skiing' => 'Skiing (activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)' ),
            array( 'fa-solid fa-skiing-nordic' => 'Skiing Nordic (activity,cross country,fitness,outdoors,person,seasonal)' ),
            array( 'fa-solid fa-snowboarding' => 'Snowboarding (activity,fitness,olympics,outdoors,person)' ),
            array( 'fa-solid fa-spa' => 'Spa (flora,massage,mindfulness,plant,wellness)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-walking' => 'Walking (exercise,health,pedometer,person,steps)' ),
        ),
        'Food' => array(
            array( 'fa-solid fa-apple-alt' => 'Fruit Apple (fall,fruit,fuji,macintosh,orchard,seasonal,vegan)' ),
            array( 'fa-solid fa-bacon' => 'Bacon (blt,breakfast,ham,lard,meat,pancetta,pork,rasher)' ),
            array( 'fa-solid fa-bone' => 'Bone (calcium,dog,skeletal,skeleton,tibia)' ),
            array( 'fa-solid fa-bread-slice' => 'Bread Slice (bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)' ),
            array( 'fa-solid fa-candy-cane' => 'Candy Cane (candy,christmas,holiday,mint,peppermint,striped,xmas)' ),
            array( 'fa-solid fa-carrot' => 'Carrot (bugs bunny,orange,vegan,vegetable)' ),
            array( 'fa-solid fa-cheese' => 'Cheese (cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)' ),
            array( 'fa-solid fa-cloud-meatball' => 'Cloud with (a chance of) Meatball (FLDSMDFR,food,spaghetti,storm)' ),
            array( 'fa-solid fa-cookie' => 'Cookie (baked good,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-drumstick-bite' => 'Drumstick with Bite Taken Out (bone,chicken,leg,meat,poultry,turkey)' ),
            array( 'fa-solid fa-egg' => 'Egg (breakfast,chicken,easter,shell,yolk)' ),
            array( 'fa-solid fa-fish' => 'Fish (fauna,gold,seafood,swimming)' ),
            array( 'fa-solid fa-hamburger' => 'Hamburger (bacon,beef,burger,burger king,cheeseburger,fast food,grill,ground beef,mcdonalds,sandwich)' ),
            array( 'fa-solid fa-hotdog' => 'Hot Dog (bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)' ),
            array( 'fa-solid fa-ice-cream' => 'Ice Cream (chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)' ),
            array( 'fa-solid fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-regular fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-solid fa-pepper-hot' => 'Hot Pepper (buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)' ),
            array( 'fa-solid fa-pizza-slice' => 'Pizza Slice (cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
            array( 'fa-solid fa-stroopwafel' => 'Stroopwafel (caramel,cookie,dessert,sweets,waffle)' ),
        ),
        'Fruits & Vegetables' => array(
            array( 'fa-solid fa-apple-alt' => 'Fruit Apple (fall,fruit,fuji,macintosh,orchard,seasonal,vegan)' ),
            array( 'fa-solid fa-carrot' => 'Carrot (bugs bunny,orange,vegan,vegetable)' ),
            array( 'fa-solid fa-leaf' => 'leaf (eco,flora,nature,plant,vegan)' ),
            array( 'fa-solid fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-regular fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-solid fa-pepper-hot' => 'Hot Pepper (buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
        ),
        'Games' => array(
            array( 'fa-solid fa-chess' => 'Chess (board,castle,checkmate,game,king,rook,strategy,tournament)' ),
            array( 'fa-solid fa-chess-bishop' => 'Chess Bishop (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-board' => 'Chess Board (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-king' => 'Chess King (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-knight' => 'Chess Knight (board,checkmate,game,horse,strategy)' ),
            array( 'fa-solid fa-chess-pawn' => 'Chess Pawn (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-queen' => 'Chess Queen (board,checkmate,game,strategy)' ),
            array( 'fa-solid fa-chess-rook' => 'Chess Rook (board,castle,checkmate,game,strategy)' ),
            array( 'fa-solid fa-dice' => 'Dice (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-d20' => 'Dice D20 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-d6' => 'Dice D6 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-five' => 'Dice Five (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-four' => 'Dice Four (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-one' => 'Dice One (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-six' => 'Dice Six (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-three' => 'Dice Three (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-two' => 'Dice Two (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-gamepad' => 'Gamepad (arcade,controller,d-pad,joystick,video,video game)' ),
            array( 'fa-solid fa-ghost' => 'Ghost (apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)' ),
            array( 'fa-solid fa-headset' => 'Headset (audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-brands fa-playstation' => 'PlayStation' ),
            array( 'fa-solid fa-puzzle-piece' => 'Puzzle Piece (add-on,addon,game,section)' ),
            array( 'fa-brands fa-steam' => 'Steam' ),
            array( 'fa-brands fa-steam-square' => 'Steam Square' ),
            array( 'fa-brands fa-steam-symbol' => 'Steam Symbol' ),
            array( 'fa-brands fa-twitch' => 'Twitch' ),
            array( 'fa-brands fa-xbox' => 'Xbox' ),
        ),
        'Genders' => array(
            array( 'fa-solid fa-genderless' => 'Genderless (androgynous,asexual,sexless)' ),
            array( 'fa-solid fa-mars' => 'Mars (male)' ),
            array( 'fa-solid fa-mars-double' => 'Mars Double' ),
            array( 'fa-solid fa-mars-stroke' => 'Mars Stroke' ),
            array( 'fa-solid fa-mars-stroke-h' => 'Mars Stroke Horizontal' ),
            array( 'fa-solid fa-mars-stroke-v' => 'Mars Stroke Vertical' ),
            array( 'fa-solid fa-mercury' => 'Mercury (transgender)' ),
            array( 'fa-solid fa-neuter' => 'Neuter' ),
            array( 'fa-solid fa-transgender' => 'Transgender (intersex)' ),
            array( 'fa-solid fa-transgender-alt' => 'Alternate Transgender (intersex)' ),
            array( 'fa-solid fa-venus' => 'Venus (female)' ),
            array( 'fa-solid fa-venus-double' => 'Venus Double (female)' ),
            array( 'fa-solid fa-venus-mars' => 'Venus Mars (Gender)' ),
        ),
        'Halloween' => array(
            array( 'fa-solid fa-book-dead' => 'Book of the Dead (Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)' ),
            array( 'fa-solid fa-broom' => 'Broom (clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)' ),
            array( 'fa-solid fa-cat' => 'Cat (feline,halloween,holiday,kitten,kitty,meow,pet)' ),
            array( 'fa-solid fa-cloud-moon' => 'Cloud with Moon (crescent,evening,lunar,night,partly cloudy,sky)' ),
            array( 'fa-solid fa-crow' => 'Crow (bird,bullfrog,fauna,halloween,holiday,toad)' ),
            array( 'fa-solid fa-ghost' => 'Ghost (apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)' ),
            array( 'fa-solid fa-hat-wizard' => 'Wizard\'s Hat (Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)' ),
            array( 'fa-solid fa-mask' => 'Mask (carnivale,costume,disguise,halloween,secret,super hero)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-solid fa-spider' => 'Spider (arachnid,bug,charlotte,crawl,eight,halloween)' ),
            array( 'fa-solid fa-toilet-paper' => 'Toilet Paper (bathroom,halloween,holiday,lavatory,prank,restroom,roll)' ),
        ),
        'Hands' => array(
            array( 'fa-solid fa-hand-dots' => 'Allergies (allergy,freckles,hand,hives,pox,skin,spots)' ),
            array( 'fa-solid fa-fist-raised' => 'Raised Fist (Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)' ),
            array( 'fa-solid fa-hand-holding' => 'Hand Holding (carry,lift)' ),
            array( 'fa-solid fa-hand-holding-heart' => 'Hand Holding Heart (carry,charity,gift,lift,package)' ),
            array( 'fa-solid fa-hand-holding-usd' => 'Hand Holding US Dollar ($,carry,dollar sign,donation,giving,lift,money,price)' ),
            array( 'fa-solid fa-hand-lizard' => 'Lizard (Hand) (game,roshambo)' ),
            array( 'fa-regular fa-hand-lizard' => 'Lizard (Hand) (game,roshambo)' ),
            array( 'fa-solid fa-hand-middle-finger' => 'Hand with Middle Finger Raised (flip the bird,gesture,hate,rude)' ),
            array( 'fa-solid fa-hand-paper' => 'Paper (Hand) (game,halt,roshambo,stop)' ),
            array( 'fa-regular fa-hand-paper' => 'Paper (Hand) (game,halt,roshambo,stop)' ),
            array( 'fa-solid fa-hand-peace' => 'Peace (Hand) (rest,truce)' ),
            array( 'fa-regular fa-hand-peace' => 'Peace (Hand) (rest,truce)' ),
            array( 'fa-solid fa-hand-point-down' => 'Hand Pointing Down (finger,hand-o-down,point)' ),
            array( 'fa-regular fa-hand-point-down' => 'Hand Pointing Down (finger,hand-o-down,point)' ),
            array( 'fa-solid fa-hand-point-left' => 'Hand Pointing Left (back,finger,hand-o-left,left,point,previous)' ),
            array( 'fa-regular fa-hand-point-left' => 'Hand Pointing Left (back,finger,hand-o-left,left,point,previous)' ),
            array( 'fa-solid fa-hand-point-right' => 'Hand Pointing Right (finger,forward,hand-o-right,next,point,right)' ),
            array( 'fa-regular fa-hand-point-right' => 'Hand Pointing Right (finger,forward,hand-o-right,next,point,right)' ),
            array( 'fa-solid fa-hand-point-up' => 'Hand Pointing Up (finger,hand-o-up,point)' ),
            array( 'fa-regular fa-hand-point-up' => 'Hand Pointing Up (finger,hand-o-up,point)' ),
            array( 'fa-solid fa-hand-pointer' => 'Pointer (Hand) (arrow,cursor,select)' ),
            array( 'fa-regular fa-hand-pointer' => 'Pointer (Hand) (arrow,cursor,select)' ),
            array( 'fa-solid fa-hand-rock' => 'Rock (Hand) (fist,game,roshambo)' ),
            array( 'fa-regular fa-hand-rock' => 'Rock (Hand) (fist,game,roshambo)' ),
            array( 'fa-solid fa-hand-scissors' => 'Scissors (Hand) (cut,game,roshambo)' ),
            array( 'fa-regular fa-hand-scissors' => 'Scissors (Hand) (cut,game,roshambo)' ),
            array( 'fa-solid fa-hand-spock' => 'Spock (Hand) (live long,prosper,salute,star trek,vulcan)' ),
            array( 'fa-regular fa-hand-spock' => 'Spock (Hand) (live long,prosper,salute,star trek,vulcan)' ),
            array( 'fa-solid fa-hands' => 'Hands (carry,hold,lift)' ),
            array( 'fa-solid fa-hands-helping' => 'Helping Hands (aid,assistance,handshake,partnership,volunteering)' ),
            array( 'fa-solid fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-regular fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-solid fa-praying-hands' => 'Praying Hands (kneel,preach,religion,worship)' ),
            array( 'fa-solid fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-regular fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-solid fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-regular fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
        ),
        'Health' => array(
            array( 'fa-brands fa-accessible-icon' => 'Accessible Icon (accessibility,handicap,person,wheelchair,wheelchair-alt)' ),
            array( 'fa-solid fa-truck-medical' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-h-square' => 'H Square (directions,emergency,hospital,hotel,map)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heartbeat' => 'Heartbeat (ekg,electrocardiogram,health,lifeline,vital signs)' ),
            array( 'fa-solid fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-regular fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-medkit' => 'medkit (first aid,firstaid,health,help,support)' ),
            array( 'fa-solid fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-regular fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-prescription' => 'Prescription (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-stethoscope' => 'Stethoscope (diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)' ),
            array( 'fa-solid fa-user-md' => 'Doctor (job,medical,nurse,occupation,physician,profile,surgeon)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
        ),
        'Holiday' => array(
            array( 'fa-solid fa-candy-cane' => 'Candy Cane (candy,christmas,holiday,mint,peppermint,striped,xmas)' ),
            array( 'fa-solid fa-carrot' => 'Carrot (bugs bunny,orange,vegan,vegetable)' ),
            array( 'fa-solid fa-cookie-bite' => 'Cookie Bite (baked good,bitten,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-gifts' => 'Gifts (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-glass-cheers' => 'Glass Cheers (alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)' ),
            array( 'fa-solid fa-holly-berry' => 'Holly Berry (catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)' ),
            array( 'fa-solid fa-mug-hot' => 'Mug Hot (caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)' ),
            array( 'fa-solid fa-sleigh' => 'Sleigh (christmas,claus,fly,holiday,santa,sled,snow,xmas)' ),
            array( 'fa-solid fa-snowman' => 'Snowman (decoration,frost,frosty,holiday)' ),
        ),
        'Hotel' => array(
            array( 'fa-solid fa-baby-carriage' => 'Baby Carriage (buggy,carrier,infant,push,stroller,transportation,walk,wheels)' ),
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-briefcase' => 'Briefcase (bag,business,luggage,office,work)' ),
            array( 'fa-solid fa-car' => 'Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-cocktail' => 'Cocktail (alcohol,beverage,drink,gin,glass,margarita,martini,vodka)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-concierge-bell' => 'Concierge Bell (attention,hotel,receptionist,service,support)' ),
            array( 'fa-solid fa-dice' => 'Dice (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-five' => 'Dice Five (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-door-closed' => 'Door Closed (enter,exit,locked)' ),
            array( 'fa-solid fa-door-open' => 'Door Open (enter,exit,welcome)' ),
            array( 'fa-solid fa-dumbbell' => 'Dumbbell (exercise,gym,strength,weight,weight-lifting)' ),
            array( 'fa-solid fa-glass-martini' => 'Martini Glass (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-glass-martini-alt' => 'Alternate Glass Martini (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-hot-tub' => 'Hot Tub (bath,jacuzzi,massage,sauna,spa)' ),
            array( 'fa-solid fa-hotel' => 'Hotel (building,inn,lodging,motel,resort,travel)' ),
            array( 'fa-solid fa-infinity' => 'Infinity (eternity,forever,math)' ),
            array( 'fa-solid fa-key' => 'key (lock,password,private,secret,unlock)' ),
            array( 'fa-solid fa-luggage-cart' => 'Luggage Cart (bag,baggage,suitcase,travel)' ),
            array( 'fa-solid fa-shower' => 'Shower (bath,clean,faucet,water)' ),
            array( 'fa-solid fa-shuttle-van' => 'Shuttle Van (airport,machine,public-transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-smoking' => 'Smoking (cancer,cigarette,nicotine,smoking status,tobacco)' ),
            array( 'fa-solid fa-smoking-ban' => 'Smoking Ban (ban,cancel,no smoking,non-smoking)' ),
            array( 'fa-solid fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-regular fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-solid fa-spa' => 'Spa (flora,massage,mindfulness,plant,wellness)' ),
            array( 'fa-solid fa-suitcase' => 'Suitcase (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-suitcase-rolling' => 'Suitcase Rolling (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-swimming-pool' => 'Swimming Pool (ladder,recreation,swim,water)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
            array( 'fa-solid fa-umbrella-beach' => 'Umbrella Beach (protection,recreation,sand,shade,summer,sun)' ),
            array( 'fa-solid fa-utensils' => 'Utensils (cutlery,dining,dinner,eat,food,fork,knife,restaurant)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
        ),
        'Household' => array(
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-blender' => 'Blender (cocktail,milkshake,mixer,puree,smoothie)' ),
            array( 'fa-solid fa-chair' => 'Chair (furniture,seat,sit)' ),
            array( 'fa-solid fa-couch' => 'Couch (chair,cushion,furniture,relax,sofa)' ),
            array( 'fa-solid fa-door-closed' => 'Door Closed (enter,exit,locked)' ),
            array( 'fa-solid fa-door-open' => 'Door Open (enter,exit,welcome)' ),
            array( 'fa-solid fa-dungeon' => 'Dungeon (Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)' ),
            array( 'fa-solid fa-fan' => 'Fan (ac,air conditioning,blade,blower,cool,hot)' ),
            array( 'fa-solid fa-shower' => 'Shower (bath,clean,faucet,water)' ),
            array( 'fa-solid fa-toilet-paper' => 'Toilet Paper (bathroom,halloween,holiday,lavatory,prank,restroom,roll)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
        ),
        'Images' => array(
            array( 'fa-solid fa-adjust' => 'adjust (contrast,dark,light,saturation)' ),
            array( 'fa-solid fa-bolt' => 'Lightning Bolt (electricity,lightning,weather,zap)' ),
            array( 'fa-solid fa-camera' => 'camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-camera-retro' => 'Retro Camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-chalkboard' => 'Chalkboard (blackboard,learning,school,teaching,whiteboard,writing)' ),
            array( 'fa-solid fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-regular fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-solid fa-compress' => 'Compress (collapse,fullscreen,minimize,move,resize,shrink,smaller)' ),
            array( 'fa-solid fa-compress-arrows-alt' => 'Alternate Compress Arrows (collapse,fullscreen,minimize,move,resize,shrink,smaller)' ),
            array( 'fa-solid fa-expand' => 'Expand (arrow,bigger,enlarge,resize)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-dropper' => 'Eye Dropper (beaker,clone,color,copy,eyedropper,pipette)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-file-image' => 'Image File (document,image,jpg,photo,png)' ),
            array( 'fa-regular fa-file-image' => 'Image File (document,image,jpg,photo,png)' ),
            array( 'fa-solid fa-film' => 'Film (cinema,movie,strip,video)' ),
            array( 'fa-solid fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-regular fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-solid fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-regular fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-photo-video' => 'Photo Video (av,film,image,library,media)' ),
            array( 'fa-solid fa-portrait' => 'Portrait (id,image,photo,picture,selfie)' ),
            array( 'fa-solid fa-sliders-h' => 'Horizontal Sliders (adjust,settings,sliders,toggle)' ),
            array( 'fa-solid fa-tint' => 'tint (color,drop,droplet,raindrop,waterdrop)' ),
        ),
        'Interfaces' => array(
            array( 'fa-solid fa-award' => 'Award (honor,praise,prize,recognition,ribbon,trophy)' ),
            array( 'fa-solid fa-ban' => 'ban (abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)' ),
            array( 'fa-solid fa-barcode' => 'barcode (info,laser,price,scan,upc)' ),
            array( 'fa-solid fa-bars' => 'Bars (checklist,drag,hamburger,list,menu,nav,navigation,ol,reorder,settings,todo,ul)' ),
            array( 'fa-solid fa-beer' => 'beer (alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-blog' => 'Blog (journal,log,online,personal,post,web 2.0,wordpress,writing)' ),
            array( 'fa-solid fa-bug' => 'Bug (beetle,error,insect,report)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-bullseye' => 'Bullseye (archery,goal,objective,target)' ),
            array( 'fa-solid fa-calculator' => 'Calculator (abacus,addition,arithmetic,counting,math,multiplication,subtraction)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-regular fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-solid fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-regular fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-solid fa-certificate' => 'certificate (badge,star,verified)' ),
            array( 'fa-solid fa-check' => 'Check (accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-check-circle' => 'Check Circle (accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-regular fa-check-circle' => 'Check Circle (accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-check-double' => 'Double Check (accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)' ),
            array( 'fa-solid fa-check-square' => 'Check Square (accept,agree,checkmark,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-regular fa-check-square' => 'Check Square (accept,agree,checkmark,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-regular fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-solid fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-regular fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-solid fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-regular fa-clone' => 'Clone (arrange,copy,duplicate,paste)' ),
            array( 'fa-solid fa-cloud' => 'Cloud (atmosphere,fog,overcast,save,upload,weather)' ),
            array( 'fa-solid fa-cloud-download-alt' => 'Alternate Cloud Download (download,export,save)' ),
            array( 'fa-solid fa-cloud-upload-alt' => 'Alternate Cloud Upload (cloud-upload,import,save,upload)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-cog' => 'cog (gear,mechanical,settings,sprocket,wheel)' ),
            array( 'fa-solid fa-cogs' => 'cogs (gears,mechanical,settings,sprocket,wheel)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-database' => 'Database (computer,development,directory,memory,storage)' ),
            array( 'fa-solid fa-dot-circle' => 'Dot Circle (bullseye,notification,target)' ),
            array( 'fa-regular fa-dot-circle' => 'Dot Circle (bullseye,notification,target)' ),
            array( 'fa-solid fa-download' => 'Download (export,hard drive,save,transfer)' ),
            array( 'fa-solid fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-regular fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-solid fa-ellipsis-h' => 'Horizontal Ellipsis (dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)' ),
            array( 'fa-solid fa-ellipsis-v' => 'Vertical Ellipsis (dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-exclamation' => 'exclamation (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-circle' => 'Exclamation Circle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-triangle' => 'Exclamation Triangle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-external-link-alt' => 'Alternate External Link (external-link,new,open,share)' ),
            array( 'fa-solid fa-external-link-square-alt' => 'Alternate External Link Square (external-link-square,new,open,share)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-file-download' => 'File Download (document,export,save)' ),
            array( 'fa-solid fa-file-export' => 'File Export (download,save)' ),
            array( 'fa-solid fa-file-import' => 'File Import (copy,document,send,upload)' ),
            array( 'fa-solid fa-file-upload' => 'File Upload (document,import,page,save)' ),
            array( 'fa-solid fa-filter' => 'Filter (funnel,options,separate,sort)' ),
            array( 'fa-solid fa-fingerprint' => 'Fingerprint (human,id,identification,lock,smudge,touch,unique,unlock)' ),
            array( 'fa-solid fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-regular fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-solid fa-flag-checkered' => 'flag-checkered (notice,notification,notify,pole,racing,report,symbol)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-regular fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-solid fa-glasses' => 'Glasses (hipster,nerd,reading,sight,spectacles,vision)' ),
            array( 'fa-solid fa-grip-horizontal' => 'Grip Horizontal (affordance,drag,drop,grab,handle)' ),
            array( 'fa-solid fa-grip-lines' => 'Grip Lines (affordance,drag,drop,grab,handle)' ),
            array( 'fa-solid fa-grip-lines-vertical' => 'Grip Lines Vertical (affordance,drag,drop,grab,handle)' ),
            array( 'fa-solid fa-grip-vertical' => 'Grip Vertical (affordance,drag,drop,grab,handle)' ),
            array( 'fa-solid fa-hashtag' => 'Hashtag (Twitter,instagram,pound,social media,tag)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-history' => 'History (Rewind,clock,reverse,time,time machine)' ),
            array( 'fa-solid fa-home' => 'home (abode,building,house,main)' ),
            array( 'fa-solid fa-i-cursor' => 'I Beam Cursor (editing,i-beam,type,writing)' ),
            array( 'fa-solid fa-info' => 'Info (details,help,information,more,support)' ),
            array( 'fa-solid fa-info-circle' => 'Info Circle (details,help,information,more,support)' ),
            array( 'fa-solid fa-language' => 'Language (dialect,idiom,localize,speech,translate,vernacular)' ),
            array( 'fa-solid fa-magic' => 'magic (autocomplete,automatic,mage,magic,spell,wand,witch,wizard)' ),
            array( 'fa-solid fa-marker' => 'Marker (design,edit,sharpie,update,write)' ),
            array( 'fa-solid fa-medal' => 'Medal (award,ribbon,star,trophy)' ),
            array( 'fa-solid fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-minus' => 'minus (collapse,delete,hide,minify,negative,remove,trash)' ),
            array( 'fa-solid fa-minus-circle' => 'Minus Circle (delete,hide,negative,remove,shape,trash)' ),
            array( 'fa-solid fa-minus-square' => 'Minus Square (collapse,delete,hide,minify,negative,remove,shape,trash)' ),
            array( 'fa-regular fa-minus-square' => 'Minus Square (collapse,delete,hide,minify,negative,remove,shape,trash)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-fancy' => 'Pen Fancy (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-plus' => 'plus (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-plus-circle' => 'Plus Circle (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-regular fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-poo' => 'Poo (crap,poop,shit,smile,turd)' ),
            array( 'fa-solid fa-qrcode' => 'qrcode (barcode,info,information,scan)' ),
            array( 'fa-solid fa-question' => 'Question (help,information,support,unknown)' ),
            array( 'fa-solid fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-regular fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-solid fa-quote-left' => 'quote-left (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-quote-right' => 'quote-right (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-redo' => 'Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-redo-alt' => 'Alternate Redo (forward,refresh,reload,repeat)' ),
            array( 'fa-solid fa-reply' => 'Reply (mail,message,respond)' ),
            array( 'fa-solid fa-reply-all' => 'reply-all (mail,message,respond)' ),
            array( 'fa-solid fa-rss' => 'rss (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-rss-square' => 'RSS Square (blog,feed,journal,news,writing)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-screwdriver' => 'Screwdriver (admin,fix,mechanic,repair,settings,tool)' ),
            array( 'fa-solid fa-search' => 'Search (bigger,enlarge,find,magnify,preview,zoom)' ),
            array( 'fa-solid fa-search-minus' => 'Search Minus (minify,negative,smaller,zoom,zoom out)' ),
            array( 'fa-solid fa-search-plus' => 'Search Plus (bigger,enlarge,magnify,positive,zoom,zoom in)' ),
            array( 'fa-solid fa-share' => 'Share (forward,save,send,social)' ),
            array( 'fa-solid fa-share-alt' => 'Alternate Share (forward,save,send,social)' ),
            array( 'fa-solid fa-share-alt-square' => 'Alternate Share Square (forward,save,send,social)' ),
            array( 'fa-solid fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-regular fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-solid fa-shield-alt' => 'Alternate Shield (achievement,award,block,defend,security,winner)' ),
            array( 'fa-solid fa-sign-in-alt' => 'Alternate Sign In (arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)' ),
            array( 'fa-solid fa-sign-out-alt' => 'Alternate Sign Out (arrow,exit,leave,log out,logout,sign-out)' ),
            array( 'fa-solid fa-signal' => 'signal (bars,graph,online,reception,status)' ),
            array( 'fa-solid fa-sitemap' => 'Sitemap (directory,hierarchy,ia,information architecture,organization)' ),
            array( 'fa-solid fa-sliders-h' => 'Horizontal Sliders (adjust,settings,sliders,toggle)' ),
            array( 'fa-solid fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-regular fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-solid fa-sort' => 'Sort (filter,order)' ),
            array( 'fa-solid fa-sort-alpha-down' => 'Sort Alphabetical Down (alphabetical,arrange,filter,order,sort-alpha-asc)' ),
            array( 'fa-solid fa-sort-alpha-down-alt' => 'Alternate Sort Alphabetical Down (alphabetical,arrange,filter,order,sort-alpha-asc)' ),
            array( 'fa-solid fa-sort-alpha-up' => 'Sort Alphabetical Up (alphabetical,arrange,filter,order,sort-alpha-desc)' ),
            array( 'fa-solid fa-sort-alpha-up-alt' => 'Alternate Sort Alphabetical Up (alphabetical,arrange,filter,order,sort-alpha-desc)' ),
            array( 'fa-solid fa-sort-amount-down' => 'Sort Amount Down (arrange,filter,number,order,sort-amount-asc)' ),
            array( 'fa-solid fa-sort-amount-down-alt' => 'Alternate Sort Amount Down (arrange,filter,order,sort-amount-asc)' ),
            array( 'fa-solid fa-sort-amount-up' => 'Sort Amount Up (arrange,filter,order,sort-amount-desc)' ),
            array( 'fa-solid fa-sort-amount-up-alt' => 'Alternate Sort Amount Up (arrange,filter,order,sort-amount-desc)' ),
            array( 'fa-solid fa-sort-down' => 'Sort Down (Descending) (arrow,descending,filter,order,sort-desc)' ),
            array( 'fa-solid fa-sort-numeric-down' => 'Sort Numeric Down (arrange,filter,numbers,order,sort-numeric-asc)' ),
            array( 'fa-solid fa-sort-numeric-down-alt' => 'Alternate Sort Numeric Down (arrange,filter,numbers,order,sort-numeric-asc)' ),
            array( 'fa-solid fa-sort-numeric-up' => 'Sort Numeric Up (arrange,filter,numbers,order,sort-numeric-desc)' ),
            array( 'fa-solid fa-sort-numeric-up-alt' => 'Alternate Sort Numeric Up (arrange,filter,numbers,order,sort-numeric-desc)' ),
            array( 'fa-solid fa-sort-up' => 'Sort Up (Ascending) (arrow,ascending,filter,order,sort-asc)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-solid fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-regular fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-solid fa-sync' => 'Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-sync-alt' => 'Alternate Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-regular fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-solid fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-regular fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-solid fa-times' => 'Times (close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)' ),
            array( 'fa-solid fa-times-circle' => 'Times Circle (close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)' ),
            array( 'fa-regular fa-times-circle' => 'Times Circle (close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)' ),
            array( 'fa-solid fa-toggle-off' => 'Toggle Off (switch)' ),
            array( 'fa-solid fa-toggle-on' => 'Toggle On (switch)' ),
            array( 'fa-solid fa-tools' => 'Tools (admin,fix,repair,screwdriver,settings,tools,wrench)' ),
            array( 'fa-solid fa-trash' => 'Trash (delete,garbage,hide,remove)' ),
            array( 'fa-solid fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-regular fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-solid fa-trash-restore' => 'Trash Restore (back,control z,oops,undo)' ),
            array( 'fa-solid fa-trash-restore-alt' => 'Alternative Trash Restore (back,control z,oops,undo)' ),
            array( 'fa-solid fa-trophy' => 'trophy (achievement,award,cup,game,winner)' ),
            array( 'fa-solid fa-undo' => 'Undo (back,control z,exchange,oops,return,rotate,swap)' ),
            array( 'fa-solid fa-undo-alt' => 'Alternate Undo (back,control z,exchange,oops,return,swap)' ),
            array( 'fa-solid fa-upload' => 'Upload (hard drive,import,publish)' ),
            array( 'fa-solid fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-alt' => 'Alternate User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-volume-down' => 'Volume Down (audio,lower,music,quieter,sound,speaker)' ),
            array( 'fa-solid fa-volume-mute' => 'Volume Mute (audio,music,quiet,sound,speaker)' ),
            array( 'fa-solid fa-volume-off' => 'Volume Off (audio,ban,music,mute,quiet,silent,sound)' ),
            array( 'fa-solid fa-volume-up' => 'Volume Up (audio,higher,louder,music,sound,speaker)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
            array( 'fa-solid fa-wrench' => 'Wrench (construction,fix,mechanic,plumbing,settings,spanner,tool,update)' ),
        ),
        'Logistics' => array(
            array( 'fa-solid fa-box' => 'Box (archive,container,package,storage)' ),
            array( 'fa-solid fa-boxes' => 'Boxes (archives,inventory,storage,warehouse)' ),
            array( 'fa-solid fa-clipboard-check' => 'Clipboard with Check (accept,agree,confirm,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-clipboard-list' => 'Clipboard List (checklist,completed,done,finished,intinerary,ol,schedule,tick,todo,ul)' ),
            array( 'fa-solid fa-dolly' => 'Dolly (carry,shipping,transport)' ),
            array( 'fa-solid fa-dolly-flatbed' => 'Dolly Flatbed (carry,inventory,shipping,transport)' ),
            array( 'fa-solid fa-hard-hat' => 'Hard Hat (construction,hardhat,helmet,safety)' ),
            array( 'fa-solid fa-pallet' => 'Pallet (archive,box,inventory,shipping,warehouse)' ),
            array( 'fa-solid fa-shipping-fast' => 'Shipping Fast (express,fedex,mail,overnight,package,ups)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-warehouse' => 'Warehouse (building,capacity,garage,inventory,storage)' ),
        ),
        'Maps' => array(
            array( 'fa-solid fa-ambulance' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-anchor' => 'Anchor (berth,boat,dock,embed,link,maritime,moor,secure)' ),
            array( 'fa-solid fa-balance-scale' => 'Balance Scale (balanced,justice,legal,measure,weight)' ),
            array( 'fa-solid fa-balance-scale-left' => 'Balance Scale (Left-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-balance-scale-right' => 'Balance Scale (Right-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-beer' => 'beer (alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-bicycle' => 'Bicycle (bike,gears,pedal,transportation,vehicle)' ),
            array( 'fa-solid fa-binoculars' => 'Binoculars (glasses,magnify,scenic,spyglass,view)' ),
            array( 'fa-solid fa-birthday-cake' => 'Birthday Cake (anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)' ),
            array( 'fa-solid fa-blind' => 'Blind (cane,disability,person,sight)' ),
            array( 'fa-solid fa-bomb' => 'Bomb (error,explode,fuse,grenade,warning)' ),
            array( 'fa-solid fa-book' => 'book (diary,documentation,journal,library,read)' ),
            array( 'fa-solid fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-regular fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-solid fa-briefcase' => 'Briefcase (bag,business,luggage,office,work)' ),
            array( 'fa-solid fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-regular fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-solid fa-car' => 'Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-crosshairs' => 'Crosshairs (aim,bullseye,gpd,picker,position)' ),
            array( 'fa-solid fa-directions' => 'Directions (map,navigation,sign,turn)' ),
            array( 'fa-solid fa-dollar-sign' => 'Dollar Sign ($,cost,dollar-sign,money,price,usd)' ),
            array( 'fa-solid fa-draw-polygon' => 'Draw Polygon (anchors,lines,object,render,shape)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-fighter-jet' => 'fighter-jet (airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)' ),
            array( 'fa-solid fa-fire' => 'fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-extinguisher' => 'fire-extinguisher (burn,caliente,fire fighter,flame,heat,hot,rescue)' ),
            array( 'fa-solid fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-regular fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-solid fa-flag-checkered' => 'flag-checkered (notice,notification,notify,pole,racing,report,symbol)' ),
            array( 'fa-solid fa-flask' => 'Flask (beaker,experimental,labs,science)' ),
            array( 'fa-solid fa-gamepad' => 'Gamepad (arcade,controller,d-pad,joystick,video,video game)' ),
            array( 'fa-solid fa-gavel' => 'Gavel (hammer,judge,law,lawyer,opinion)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-glass-martini' => 'Martini Glass (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-globe' => 'Globe (all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-graduation-cap' => 'Graduation Cap (ceremony,college,graduate,learning,school,student)' ),
            array( 'fa-solid fa-h-square' => 'H Square (directions,emergency,hospital,hotel,map)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heartbeat' => 'Heartbeat (ekg,electrocardiogram,health,lifeline,vital signs)' ),
            array( 'fa-solid fa-helicopter' => 'Helicopter (airwolf,apache,chopper,flight,fly,travel)' ),
            array( 'fa-solid fa-home' => 'home (abode,building,house,main)' ),
            array( 'fa-solid fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-regular fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-industry' => 'Industry (building,factory,industrial,manufacturing,mill,warehouse)' ),
            array( 'fa-solid fa-info' => 'Info (details,help,information,more,support)' ),
            array( 'fa-solid fa-info-circle' => 'Info Circle (details,help,information,more,support)' ),
            array( 'fa-solid fa-key' => 'key (lock,password,private,secret,unlock)' ),
            array( 'fa-solid fa-landmark' => 'Landmark (building,historic,memorable,monument,politics)' ),
            array( 'fa-solid fa-layer-group' => 'Layer Group (arrange,develop,layers,map,stack)' ),
            array( 'fa-solid fa-leaf' => 'leaf (eco,flora,nature,plant,vegan)' ),
            array( 'fa-solid fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-regular fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-solid fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-regular fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-solid fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-regular fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-solid fa-location-arrow' => 'location-arrow (address,compass,coordinate,direction,gps,map,navigation,place)' ),
            array( 'fa-solid fa-low-vision' => 'Low Vision (blind,eye,sight)' ),
            array( 'fa-solid fa-magnet' => 'magnet (Attract,lodestone,tool)' ),
            array( 'fa-solid fa-male' => 'Male (human,man,person,profile,user)' ),
            array( 'fa-solid fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-regular fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker' => 'map-marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker-alt' => 'Alternate Map Marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-pin' => 'Map Pin (address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)' ),
            array( 'fa-solid fa-map-signs' => 'Map Signs (directions,directory,map,signage,wayfinding)' ),
            array( 'fa-solid fa-medkit' => 'medkit (first aid,firstaid,health,help,support)' ),
            array( 'fa-solid fa-money-bill' => 'Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-regular fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-motorcycle' => 'Motorcycle (bike,machine,transportation,vehicle)' ),
            array( 'fa-solid fa-music' => 'Music (lyrics,melody,note,sing,sound)' ),
            array( 'fa-solid fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-regular fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-solid fa-parking' => 'Parking (auto,car,garage,meter)' ),
            array( 'fa-solid fa-paw' => 'Paw (animal,cat,dog,pet,print)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square' => 'Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-square-alt' => 'Alternate Phone Square (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-volume' => 'Phone Volume (call,earphone,number,sound,support,telephone,voice,volume-control-phone)' ),
            array( 'fa-solid fa-plane' => 'plane (airplane,destination,fly,location,mode,travel,trip)' ),
            array( 'fa-solid fa-plug' => 'Plug (connect,electric,online,power)' ),
            array( 'fa-solid fa-plus' => 'plus (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-regular fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-recycle' => 'Recycle (Waste,compost,garbage,reuse,trash)' ),
            array( 'fa-solid fa-restroom' => 'Restroom (bathroom,john,loo,potty,washroom,waste,wc)' ),
            array( 'fa-solid fa-road' => 'road (highway,map,pavement,route,street,travel)' ),
            array( 'fa-solid fa-rocket' => 'rocket (aircraft,app,jet,launch,nasa,space)' ),
            array( 'fa-solid fa-route' => 'Route (directions,navigation,travel)' ),
            array( 'fa-solid fa-search' => 'Search (bigger,enlarge,find,magnify,preview,zoom)' ),
            array( 'fa-solid fa-search-minus' => 'Search Minus (minify,negative,smaller,zoom,zoom out)' ),
            array( 'fa-solid fa-search-plus' => 'Search Plus (bigger,enlarge,magnify,positive,zoom,zoom in)' ),
            array( 'fa-solid fa-ship' => 'Ship (boat,sea,water)' ),
            array( 'fa-solid fa-shoe-prints' => 'Shoe Prints (feet,footprints,steps,walk)' ),
            array( 'fa-solid fa-shopping-bag' => 'Shopping Bag (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-basket' => 'Shopping Basket (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shower' => 'Shower (bath,clean,faucet,water)' ),
            array( 'fa-solid fa-snowplow' => 'Snowplow (clean up,cold,road,storm,winter)' ),
            array( 'fa-solid fa-street-view' => 'Street View (directions,location,map,navigation)' ),
            array( 'fa-solid fa-subway' => 'Subway (machine,railway,train,transportation,vehicle)' ),
            array( 'fa-solid fa-suitcase' => 'Suitcase (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-tag' => 'tag (discount,label,price,shopping)' ),
            array( 'fa-solid fa-tags' => 'tags (discount,label,price,shopping)' ),
            array( 'fa-solid fa-taxi' => 'Taxi (cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)' ),
            array( 'fa-solid fa-thumbtack' => 'Thumbtack (coordinates,location,marker,pin,thumb-tack)' ),
            array( 'fa-solid fa-ticket-alt' => 'Alternate Ticket (movie,pass,support,ticket)' ),
            array( 'fa-solid fa-tint' => 'tint (color,drop,droplet,raindrop,waterdrop)' ),
            array( 'fa-solid fa-traffic-light' => 'Traffic Light (direction,road,signal,travel)' ),
            array( 'fa-solid fa-train' => 'Train (bullet,commute,locomotive,railway,subway)' ),
            array( 'fa-solid fa-tram' => 'Tram (crossing,machine,mountains,seasonal,transportation)' ),
            array( 'fa-solid fa-tree' => 'Tree (bark,fall,flora,forest,nature,plant,seasonal)' ),
            array( 'fa-solid fa-trophy' => 'trophy (achievement,award,cup,game,winner)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-tty' => 'TTY (communication,deaf,telephone,teletypewriter,text)' ),
            array( 'fa-solid fa-umbrella' => 'Umbrella (protection,rain,storm,wet)' ),
            array( 'fa-solid fa-university' => 'University (bank,building,college,higher education - students,institution)' ),
            array( 'fa-solid fa-utensil-spoon' => 'Utensil Spoon (cutlery,dining,scoop,silverware,spoon)' ),
            array( 'fa-solid fa-utensils' => 'Utensils (cutlery,dining,dinner,eat,food,fork,knife,restaurant)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
            array( 'fa-solid fa-wine-glass' => 'Wine Glass (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
            array( 'fa-solid fa-wrench' => 'Wrench (construction,fix,mechanic,plumbing,settings,spanner,tool,update)' ),
        ),
        'Maritime' => array(
            array( 'fa-solid fa-anchor' => 'Anchor (berth,boat,dock,embed,link,maritime,moor,secure)' ),
            array( 'fa-solid fa-binoculars' => 'Binoculars (glasses,magnify,scenic,spyglass,view)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-dharmachakra' => 'Dharmachakra (buddhism,buddhist,wheel of dharma)' ),
            array( 'fa-solid fa-frog' => 'Frog (amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)' ),
            array( 'fa-solid fa-ship' => 'Ship (boat,sea,water)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-water' => 'Water (lake,liquid,ocean,sea,swim,wet)' ),
            array( 'fa-solid fa-wind' => 'Wind (air,blow,breeze,fall,seasonal,weather)' ),
        ),
        'Marketing' => array(
            array( 'fa-solid fa-ad' => 'Ad (advertisement,media,newspaper,promotion,publicity)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-bullseye' => 'Bullseye (archery,goal,objective,target)' ),
            array( 'fa-solid fa-comment-dollar' => 'Comment Dollar (bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)' ),
            array( 'fa-solid fa-comments-dollar' => 'Comments Dollar (bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)' ),
            array( 'fa-solid fa-envelope-open-text' => 'Envelope Open-text (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-funnel-dollar' => 'Funnel Dollar (filter,money,options,separate,sort)' ),
            array( 'fa-solid fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-regular fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-solid fa-mail-bulk' => 'Mail Bulk (archive,envelope,letter,post office,postal,postcard,send,stamp,usps)' ),
            array( 'fa-solid fa-poll' => 'Poll (results,survey,trend,vote,voting)' ),
            array( 'fa-solid fa-poll-h' => 'Poll H (results,survey,trend,vote,voting)' ),
            array( 'fa-solid fa-search-dollar' => 'Search Dollar (bigger,enlarge,find,magnify,money,preview,zoom)' ),
            array( 'fa-solid fa-search-location' => 'Search Location (bigger,enlarge,find,magnify,preview,zoom)' ),
        ),
        'Mathematics' => array(
            array( 'fa-solid fa-calculator' => 'Calculator (abacus,addition,arithmetic,counting,math,multiplication,subtraction)' ),
            array( 'fa-solid fa-divide' => 'Divide (arithmetic,calculus,division,math)' ),
            array( 'fa-solid fa-equals' => 'Equals (arithmetic,even,match,math)' ),
            array( 'fa-solid fa-greater-than' => 'Greater Than (arithmetic,compare,math)' ),
            array( 'fa-solid fa-greater-than-equal' => 'Greater Than Equal To (arithmetic,compare,math)' ),
            array( 'fa-solid fa-infinity' => 'Infinity (eternity,forever,math)' ),
            array( 'fa-solid fa-less-than' => 'Less Than (arithmetic,compare,math)' ),
            array( 'fa-solid fa-less-than-equal' => 'Less Than Equal To (arithmetic,compare,math)' ),
            array( 'fa-solid fa-minus' => 'minus (collapse,delete,hide,minify,negative,remove,trash)' ),
            array( 'fa-solid fa-not-equal' => 'Not Equal (arithmetic,compare,math)' ),
            array( 'fa-solid fa-percentage' => 'Percentage (discount,fraction,proportion,rate,ratio)' ),
            array( 'fa-solid fa-plus' => 'plus (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-square-root-alt' => 'Alternate Square Root (arithmetic,calculus,division,math)' ),
            array( 'fa-solid fa-subscript' => 'subscript (edit,font,format,text,type)' ),
            array( 'fa-solid fa-superscript' => 'superscript (edit,exponential,font,format,text,type)' ),
            array( 'fa-solid fa-times' => 'Times (close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)' ),
            array( 'fa-solid fa-wave-square' => 'Square Wave (frequency,pulse,signal)' ),
        ),
        'Medical' => array(
            array( 'fa-solid fa-allergies' => 'Allergies (allergy,freckles,hand,hives,pox,skin,spots)' ),
            array( 'fa-solid fa-ambulance' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-band-aid' => 'Band-Aid (bandage,boo boo,first aid,ouch)' ),
            array( 'fa-solid fa-biohazard' => 'Biohazard (danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)' ),
            array( 'fa-solid fa-bone' => 'Bone (calcium,dog,skeletal,skeleton,tibia)' ),
            array( 'fa-solid fa-bong' => 'Bong (aparatus,cannabis,marijuana,pipe,smoke,smoking)' ),
            array( 'fa-solid fa-book-medical' => 'Medical Book (diary,documentation,health,history,journal,library,read,record)' ),
            array( 'fa-solid fa-brain' => 'Brain (cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)' ),
            array( 'fa-solid fa-briefcase-medical' => 'Medical Briefcase (doctor,emt,first aid,health)' ),
            array( 'fa-solid fa-burn' => 'Burn (caliente,energy,fire,flame,gas,heat,hot)' ),
            array( 'fa-solid fa-cannabis' => 'Cannabis (bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)' ),
            array( 'fa-solid fa-capsules' => 'Capsules (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-clinic-medical' => 'Medical Clinic (doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)' ),
            array( 'fa-solid fa-comment-medical' => 'Alternate Medical Chat (advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)' ),
            array( 'fa-solid fa-crutch' => 'Crutch (cane,injury,mobility,wheelchair)' ),
            array( 'fa-solid fa-diagnoses' => 'Diagnoses (analyze,detect,diagnosis,examine,medicine)' ),
            array( 'fa-solid fa-dna' => 'DNA (double helix,genetic,helix,molecule,protein)' ),
            array( 'fa-solid fa-file-medical' => 'Medical File (document,health,history,prescription,record)' ),
            array( 'fa-solid fa-file-medical-alt' => 'Alternate Medical File (document,health,history,prescription,record)' ),
            array( 'fa-solid fa-file-prescription' => 'File Prescription (document,drugs,medical,medicine,rx)' ),
            array( 'fa-solid fa-first-aid' => 'First Aid (emergency,emt,health,medical,rescue)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heartbeat' => 'Heartbeat (ekg,electrocardiogram,health,lifeline,vital signs)' ),
            array( 'fa-solid fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-regular fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-hospital-alt' => 'Alternate Hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-hospital-symbol' => 'Hospital Symbol (clinic,emergency,map)' ),
            array( 'fa-solid fa-id-card-alt' => 'Alternate Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-joint' => 'Joint (blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)' ),
            array( 'fa-solid fa-laptop-medical' => 'Laptop Medical (computer,device,ehr,electronic health records,history)' ),
            array( 'fa-solid fa-microscope' => 'Microscope (electron,lens,optics,science,shrink)' ),
            array( 'fa-solid fa-mortar-pestle' => 'Mortar Pestle (crush,culinary,grind,medical,mix,pharmacy,prescription,spices)' ),
            array( 'fa-solid fa-notes-medical' => 'Medical Notes (clipboard,doctor,ehr,health,history,records)' ),
            array( 'fa-solid fa-pager' => 'Pager (beeper,cellphone,communication)' ),
            array( 'fa-solid fa-pills' => 'Pills (drugs,medicine,prescription,tablets)' ),
            array( 'fa-solid fa-plus' => 'plus (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-poop' => 'Poop (crap,poop,shit,smile,turd)' ),
            array( 'fa-solid fa-prescription' => 'Prescription (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-prescription-bottle' => 'Prescription Bottle (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-prescription-bottle-alt' => 'Alternate Prescription Bottle (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-procedures' => 'Procedures (EKG,bed,electrocardiogram,health,hospital,life,patient,vital)' ),
            array( 'fa-solid fa-radiation' => 'Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-radiation-alt' => 'Alternate Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-smoking' => 'Smoking (cancer,cigarette,nicotine,smoking status,tobacco)' ),
            array( 'fa-solid fa-smoking-ban' => 'Smoking Ban (ban,cancel,no smoking,non-smoking)' ),
            array( 'fa-solid fa-star-of-life' => 'Star of Life (doctor,emt,first aid,health,medical)' ),
            array( 'fa-solid fa-stethoscope' => 'Stethoscope (diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)' ),
            array( 'fa-solid fa-syringe' => 'Syringe (doctor,immunizations,medical,needle)' ),
            array( 'fa-solid fa-tablets' => 'Tablets (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-teeth' => 'Teeth (bite,dental,dentist,gums,mouth,smile,tooth)' ),
            array( 'fa-solid fa-teeth-open' => 'Teeth Open (dental,dentist,gums bite,mouth,smile,tooth)' ),
            array( 'fa-solid fa-thermometer' => 'Thermometer (mercury,status,temperature)' ),
            array( 'fa-solid fa-tooth' => 'Tooth (bicuspid,dental,dentist,molar,mouth,teeth)' ),
            array( 'fa-solid fa-user-md' => 'Doctor (job,medical,nurse,occupation,physician,profile,surgeon)' ),
            array( 'fa-solid fa-user-nurse' => 'Nurse (doctor,midwife,practitioner,surgeon)' ),
            array( 'fa-solid fa-vial' => 'Vial (experiment,lab,sample,science,test,test tube)' ),
            array( 'fa-solid fa-vials' => 'Vials (experiment,lab,sample,science,test,test tube)' ),
            array( 'fa-solid fa-weight' => 'Weight (health,measurement,scale,weight)' ),
            array( 'fa-solid fa-x-ray' => 'X-Ray (health,medical,radiological images,radiology,skeleton)' ),
        ),
        'Moving' => array(
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-box-open' => 'Box Open (archive,container,package,storage,unpack)' ),
            array( 'fa-solid fa-couch' => 'Couch (chair,cushion,furniture,relax,sofa)' ),
            array( 'fa-solid fa-dolly' => 'Dolly (carry,shipping,transport)' ),
            array( 'fa-solid fa-people-carry' => 'People Carry (box,carry,fragile,help,movers,package)' ),
            array( 'fa-solid fa-route' => 'Route (directions,navigation,travel)' ),
            array( 'fa-solid fa-sign' => 'Sign (directions,real estate,signage,wayfinding)' ),
            array( 'fa-solid fa-suitcase' => 'Suitcase (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-tape' => 'Tape (design,package,sticky)' ),
            array( 'fa-solid fa-truck-loading' => 'Truck Loading (box,cargo,delivery,inventory,moving,rental,vehicle)' ),
            array( 'fa-solid fa-truck-moving' => 'Truck Moving (cargo,inventory,rental,vehicle)' ),
            array( 'fa-solid fa-wine-glass' => 'Wine Glass (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
        ),
        'Music' => array(
            array( 'fa-solid fa-drum' => 'Drum (instrument,music,percussion,snare,sound)' ),
            array( 'fa-solid fa-drum-steelpan' => 'Drum Steelpan (calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)' ),
            array( 'fa-solid fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-regular fa-file-audio' => 'Audio File (document,mp3,music,page,play,sound)' ),
            array( 'fa-solid fa-guitar' => 'Guitar (acoustic,instrument,music,rock,rock and roll,song,strings)' ),
            array( 'fa-solid fa-headphones' => 'headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-headphones-alt' => 'Alternate Headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt-slash' => 'Alternate Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-music' => 'Music (lyrics,melody,note,sing,sound)' ),
            array( 'fa-brands fa-napster' => 'Napster' ),
            array( 'fa-solid fa-play' => 'play (audio,music,playing,sound,start,video)' ),
            array( 'fa-solid fa-record-vinyl' => 'Record Vinyl (LP,album,analog,music,phonograph,sound)' ),
            array( 'fa-solid fa-sliders-h' => 'Horizontal Sliders (adjust,settings,sliders,toggle)' ),
            array( 'fa-brands fa-soundcloud' => 'SoundCloud' ),
            array( 'fa-brands fa-spotify' => 'Spotify' ),
            array( 'fa-solid fa-volume-down' => 'Volume Down (audio,lower,music,quieter,sound,speaker)' ),
            array( 'fa-solid fa-volume-mute' => 'Volume Mute (audio,music,quiet,sound,speaker)' ),
            array( 'fa-solid fa-volume-off' => 'Volume Off (audio,ban,music,mute,quiet,silent,sound)' ),
            array( 'fa-solid fa-volume-up' => 'Volume Up (audio,higher,louder,music,sound,speaker)' ),
        ),
        'Objects' => array(
            array( 'fa-solid fa-ambulance' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-anchor' => 'Anchor (berth,boat,dock,embed,link,maritime,moor,secure)' ),
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-award' => 'Award (honor,praise,prize,recognition,ribbon,trophy)' ),
            array( 'fa-solid fa-baby-carriage' => 'Baby Carriage (buggy,carrier,infant,push,stroller,transportation,walk,wheels)' ),
            array( 'fa-solid fa-balance-scale' => 'Balance Scale (balanced,justice,legal,measure,weight)' ),
            array( 'fa-solid fa-balance-scale-left' => 'Balance Scale (Left-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-balance-scale-right' => 'Balance Scale (Right-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-bath' => 'Bath (clean,shower,tub,wash)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-beer' => 'beer (alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bicycle' => 'Bicycle (bike,gears,pedal,transportation,vehicle)' ),
            array( 'fa-solid fa-binoculars' => 'Binoculars (glasses,magnify,scenic,spyglass,view)' ),
            array( 'fa-solid fa-birthday-cake' => 'Birthday Cake (anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)' ),
            array( 'fa-solid fa-blender' => 'Blender (cocktail,milkshake,mixer,puree,smoothie)' ),
            array( 'fa-solid fa-bomb' => 'Bomb (error,explode,fuse,grenade,warning)' ),
            array( 'fa-solid fa-book' => 'book (diary,documentation,journal,library,read)' ),
            array( 'fa-solid fa-book-dead' => 'Book of the Dead (Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)' ),
            array( 'fa-solid fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-regular fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-solid fa-briefcase' => 'Briefcase (bag,business,luggage,office,work)' ),
            array( 'fa-solid fa-broadcast-tower' => 'Broadcast Tower (airwaves,antenna,radio,reception,waves)' ),
            array( 'fa-solid fa-bug' => 'Bug (beetle,error,insect,report)' ),
            array( 'fa-solid fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-regular fa-building' => 'Building (apartment,business,city,company,office,work)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-bullseye' => 'Bullseye (archery,goal,objective,target)' ),
            array( 'fa-solid fa-bus' => 'Bus (public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-calculator' => 'Calculator (abacus,addition,arithmetic,counting,math,multiplication,subtraction)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-camera' => 'camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-camera-retro' => 'Retro Camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-candy-cane' => 'Candy Cane (candy,christmas,holiday,mint,peppermint,striped,xmas)' ),
            array( 'fa-solid fa-car' => 'Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-carrot' => 'Carrot (bugs bunny,orange,vegan,vegetable)' ),
            array( 'fa-solid fa-church' => 'Church (building,cathedral,chapel,community,religion)' ),
            array( 'fa-solid fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-regular fa-clipboard' => 'Clipboard (copy,notes,paste,record)' ),
            array( 'fa-solid fa-cloud' => 'Cloud (atmosphere,fog,overcast,save,upload,weather)' ),
            array( 'fa-solid fa-coffee' => 'Coffee (beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)' ),
            array( 'fa-solid fa-cog' => 'cog (gear,mechanical,settings,sprocket,wheel)' ),
            array( 'fa-solid fa-cogs' => 'cogs (gears,mechanical,settings,sprocket,wheel)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-cookie' => 'Cookie (baked good,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-cookie-bite' => 'Cookie Bite (baked good,bitten,chips,chocolate,eat,snack,sweet,treat)' ),
            array( 'fa-solid fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-regular fa-copy' => 'Copy (clone,duplicate,file,files-o,paper,paste)' ),
            array( 'fa-solid fa-cube' => 'Cube (3d,block,dice,package,square,tesseract)' ),
            array( 'fa-solid fa-cubes' => 'Cubes (3d,block,dice,package,pyramid,square,stack,tesseract)' ),
            array( 'fa-solid fa-cut' => 'Cut (clip,scissors,snip)' ),
            array( 'fa-solid fa-dice' => 'Dice (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-d20' => 'Dice D20 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-d6' => 'Dice D6 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-five' => 'Dice Five (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-four' => 'Dice Four (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-one' => 'Dice One (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-six' => 'Dice Six (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-three' => 'Dice Three (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-two' => 'Dice Two (chance,gambling,game,roll)' ),
            array( 'fa-solid fa-digital-tachograph' => 'Digital Tachograph (data,distance,speed,tachometer)' ),
            array( 'fa-solid fa-door-closed' => 'Door Closed (enter,exit,locked)' ),
            array( 'fa-solid fa-door-open' => 'Door Open (enter,exit,welcome)' ),
            array( 'fa-solid fa-drum' => 'Drum (instrument,music,percussion,snare,sound)' ),
            array( 'fa-solid fa-drum-steelpan' => 'Drum Steelpan (calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-dropper' => 'Eye Dropper (beaker,clone,color,copy,eyedropper,pipette)' ),
            array( 'fa-solid fa-fax' => 'Fax (business,communicate,copy,facsimile,send)' ),
            array( 'fa-solid fa-feather' => 'Feather (bird,light,plucked,quill,write)' ),
            array( 'fa-solid fa-feather-alt' => 'Alternate Feather (bird,light,plucked,quill,write)' ),
            array( 'fa-solid fa-fighter-jet' => 'fighter-jet (airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-file-prescription' => 'File Prescription (document,drugs,medical,medicine,rx)' ),
            array( 'fa-solid fa-film' => 'Film (cinema,movie,strip,video)' ),
            array( 'fa-solid fa-fire' => 'fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-extinguisher' => 'fire-extinguisher (burn,caliente,fire fighter,flame,heat,hot,rescue)' ),
            array( 'fa-solid fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-regular fa-flag' => 'flag (country,notice,notification,notify,pole,report,symbol)' ),
            array( 'fa-solid fa-flag-checkered' => 'flag-checkered (notice,notification,notify,pole,racing,report,symbol)' ),
            array( 'fa-solid fa-flask' => 'Flask (beaker,experimental,labs,science)' ),
            array( 'fa-solid fa-futbol' => 'Futbol (ball,football,mls,soccer)' ),
            array( 'fa-regular fa-futbol' => 'Futbol (ball,football,mls,soccer)' ),
            array( 'fa-solid fa-gamepad' => 'Gamepad (arcade,controller,d-pad,joystick,video,video game)' ),
            array( 'fa-solid fa-gavel' => 'Gavel (hammer,judge,law,lawyer,opinion)' ),
            array( 'fa-solid fa-gem' => 'Gem (diamond,jewelry,sapphire,stone,treasure)' ),
            array( 'fa-regular fa-gem' => 'Gem (diamond,jewelry,sapphire,stone,treasure)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-gifts' => 'Gifts (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-glass-cheers' => 'Glass Cheers (alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)' ),
            array( 'fa-solid fa-glass-martini' => 'Martini Glass (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-glass-whiskey' => 'Glass Whiskey (alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)' ),
            array( 'fa-solid fa-glasses' => 'Glasses (hipster,nerd,reading,sight,spectacles,vision)' ),
            array( 'fa-solid fa-globe' => 'Globe (all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-graduation-cap' => 'Graduation Cap (ceremony,college,graduate,learning,school,student)' ),
            array( 'fa-solid fa-guitar' => 'Guitar (acoustic,instrument,music,rock,rock and roll,song,strings)' ),
            array( 'fa-solid fa-hat-wizard' => 'Wizard\'s Hat (Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)' ),
            array( 'fa-solid fa-hdd' => 'HDD (cpu,hard drive,harddrive,machine,save,storage)' ),
            array( 'fa-regular fa-hdd' => 'HDD (cpu,hard drive,harddrive,machine,save,storage)' ),
            array( 'fa-solid fa-headphones' => 'headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-headphones-alt' => 'Alternate Headphones (audio,listen,music,sound,speaker)' ),
            array( 'fa-solid fa-headset' => 'Headset (audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heart-broken' => 'Heart Broken (breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)' ),
            array( 'fa-solid fa-helicopter' => 'Helicopter (airwolf,apache,chopper,flight,fly,travel)' ),
            array( 'fa-solid fa-highlighter' => 'Highlighter (edit,marker,sharpie,update,write)' ),
            array( 'fa-solid fa-holly-berry' => 'Holly Berry (catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)' ),
            array( 'fa-solid fa-home' => 'home (abode,building,house,main)' ),
            array( 'fa-solid fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-regular fa-hospital' => 'hospital (building,emergency room,medical center)' ),
            array( 'fa-solid fa-hourglass' => 'Hourglass (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-regular fa-hourglass' => 'Hourglass (hour,minute,sand,stopwatch,time)' ),
            array( 'fa-solid fa-igloo' => 'Igloo (dome,dwelling,eskimo,home,house,ice,snow)' ),
            array( 'fa-solid fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-industry' => 'Industry (building,factory,industrial,manufacturing,mill,warehouse)' ),
            array( 'fa-solid fa-key' => 'key (lock,password,private,secret,unlock)' ),
            array( 'fa-solid fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-regular fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-solid fa-laptop' => 'Laptop (computer,cpu,dell,demo,device,mac,macbook,machine,pc)' ),
            array( 'fa-solid fa-leaf' => 'leaf (eco,flora,nature,plant,vegan)' ),
            array( 'fa-solid fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-regular fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-solid fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-regular fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-solid fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-regular fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-solid fa-lock' => 'lock (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-lock-open' => 'Lock Open (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-magic' => 'magic (autocomplete,automatic,mage,magic,spell,wand,witch,wizard)' ),
            array( 'fa-solid fa-magnet' => 'magnet (Attract,lodestone,tool)' ),
            array( 'fa-solid fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-regular fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker' => 'map-marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker-alt' => 'Alternate Map Marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-pin' => 'Map Pin (address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)' ),
            array( 'fa-solid fa-map-signs' => 'Map Signs (directions,directory,map,signage,wayfinding)' ),
            array( 'fa-solid fa-marker' => 'Marker (design,edit,sharpie,update,write)' ),
            array( 'fa-solid fa-medal' => 'Medal (award,ribbon,star,trophy)' ),
            array( 'fa-solid fa-medkit' => 'medkit (first aid,firstaid,health,help,support)' ),
            array( 'fa-solid fa-memory' => 'Memory (DIMM,RAM,hardware,storage,technology)' ),
            array( 'fa-solid fa-microchip' => 'Microchip (cpu,hardware,processor,technology)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-mitten' => 'Mitten (clothing,cold,glove,hands,knitted,seasonal,warmth)' ),
            array( 'fa-solid fa-mobile' => 'Mobile Phone (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-mobile-alt' => 'Alternate Mobile (apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)' ),
            array( 'fa-solid fa-money-bill' => 'Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-regular fa-money-bill-alt' => 'Alternate Money Bill (buy,cash,checkout,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check' => 'Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check-alt' => 'Alternate Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-regular fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-solid fa-motorcycle' => 'Motorcycle (bike,machine,transportation,vehicle)' ),
            array( 'fa-solid fa-mug-hot' => 'Mug Hot (caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)' ),
            array( 'fa-solid fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-regular fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-solid fa-paint-brush' => 'Paint Brush (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-regular fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-solid fa-paperclip' => 'Paperclip (attach,attachment,connect,link)' ),
            array( 'fa-solid fa-paste' => 'Paste (clipboard,copy,document,paper)' ),
            array( 'fa-solid fa-paw' => 'Paw (animal,cat,dog,pet,print)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-fancy' => 'Pen Fancy (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pen-nib' => 'Pen Nib (design,edit,fountain pen,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-plane' => 'plane (airplane,destination,fly,location,mode,travel,trip)' ),
            array( 'fa-solid fa-plug' => 'Plug (connect,electric,online,power)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-puzzle-piece' => 'Puzzle Piece (add-on,addon,game,section)' ),
            array( 'fa-solid fa-ring' => 'Ring (Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)' ),
            array( 'fa-solid fa-road' => 'road (highway,map,pavement,route,street,travel)' ),
            array( 'fa-solid fa-rocket' => 'rocket (aircraft,app,jet,launch,nasa,space)' ),
            array( 'fa-solid fa-ruler-combined' => 'Ruler Combined (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-horizontal' => 'Ruler Horizontal (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-ruler-vertical' => 'Ruler Vertical (design,draft,length,measure,planning)' ),
            array( 'fa-solid fa-satellite' => 'Satellite (communications,hardware,orbit,space)' ),
            array( 'fa-solid fa-satellite-dish' => 'Satellite Dish (SETI,communications,hardware,receiver,saucer,signal)' ),
            array( 'fa-solid fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-regular fa-save' => 'Save (disk,download,floppy,floppy-o)' ),
            array( 'fa-solid fa-school' => 'School (building,education,learn,student,teacher)' ),
            array( 'fa-solid fa-screwdriver' => 'Screwdriver (admin,fix,mechanic,repair,settings,tool)' ),
            array( 'fa-solid fa-scroll' => 'Scroll (Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)' ),
            array( 'fa-solid fa-sd-card' => 'Sd Card (image,memory,photo,save)' ),
            array( 'fa-solid fa-search' => 'Search (bigger,enlarge,find,magnify,preview,zoom)' ),
            array( 'fa-solid fa-shield-alt' => 'Alternate Shield (achievement,award,block,defend,security,winner)' ),
            array( 'fa-solid fa-shopping-bag' => 'Shopping Bag (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-basket' => 'Shopping Basket (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shower' => 'Shower (bath,clean,faucet,water)' ),
            array( 'fa-solid fa-sim-card' => 'SIM Card (hard drive,hardware,portable,storage,technology,tiny)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-solid fa-sleigh' => 'Sleigh (christmas,claus,fly,holiday,santa,sled,snow,xmas)' ),
            array( 'fa-solid fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-regular fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-solid fa-snowplow' => 'Snowplow (clean up,cold,road,storm,winter)' ),
            array( 'fa-solid fa-space-shuttle' => 'Space Shuttle (astronaut,machine,nasa,rocket,transportation)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-solid fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-regular fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-solid fa-stopwatch' => 'Stopwatch (clock,reminder,time)' ),
            array( 'fa-solid fa-stroopwafel' => 'Stroopwafel (caramel,cookie,dessert,sweets,waffle)' ),
            array( 'fa-solid fa-subway' => 'Subway (machine,railway,train,transportation,vehicle)' ),
            array( 'fa-solid fa-suitcase' => 'Suitcase (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-regular fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-solid fa-tablet' => 'tablet (apple,device,ipad,kindle,screen)' ),
            array( 'fa-solid fa-tablet-alt' => 'Alternate Tablet (apple,device,ipad,kindle,screen)' ),
            array( 'fa-solid fa-tachometer-alt' => 'Alternate Tachometer (dashboard,fast,odometer,speed,speedometer)' ),
            array( 'fa-solid fa-tag' => 'tag (discount,label,price,shopping)' ),
            array( 'fa-solid fa-tags' => 'tags (discount,label,price,shopping)' ),
            array( 'fa-solid fa-taxi' => 'Taxi (cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)' ),
            array( 'fa-solid fa-thumbtack' => 'Thumbtack (coordinates,location,marker,pin,thumb-tack)' ),
            array( 'fa-solid fa-ticket-alt' => 'Alternate Ticket (movie,pass,support,ticket)' ),
            array( 'fa-solid fa-toilet' => 'Toilet (bathroom,flush,john,loo,pee,plumbing,poop,porcelain,potty,restroom,throne,washroom,waste,wc)' ),
            array( 'fa-solid fa-toolbox' => 'Toolbox (admin,container,fix,repair,settings,tools)' ),
            array( 'fa-solid fa-tools' => 'Tools (admin,fix,repair,screwdriver,settings,tools,wrench)' ),
            array( 'fa-solid fa-train' => 'Train (bullet,commute,locomotive,railway,subway)' ),
            array( 'fa-solid fa-tram' => 'Tram (crossing,machine,mountains,seasonal,transportation)' ),
            array( 'fa-solid fa-trash' => 'Trash (delete,garbage,hide,remove)' ),
            array( 'fa-solid fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-regular fa-trash-alt' => 'Alternate Trash (delete,garbage,hide,remove,trash-o)' ),
            array( 'fa-solid fa-tree' => 'Tree (bark,fall,flora,forest,nature,plant,seasonal)' ),
            array( 'fa-solid fa-trophy' => 'trophy (achievement,award,cup,game,winner)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
            array( 'fa-solid fa-umbrella' => 'Umbrella (protection,rain,storm,wet)' ),
            array( 'fa-solid fa-university' => 'University (bank,building,college,higher education - students,institution)' ),
            array( 'fa-solid fa-unlock' => 'unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-unlock-alt' => 'Alternate Unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-utensil-spoon' => 'Utensil Spoon (cutlery,dining,scoop,silverware,spoon)' ),
            array( 'fa-solid fa-utensils' => 'Utensils (cutlery,dining,dinner,eat,food,fork,knife,restaurant)' ),
            array( 'fa-solid fa-wallet' => 'Wallet (billfold,cash,currency,money)' ),
            array( 'fa-solid fa-weight' => 'Weight (health,measurement,scale,weight)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
            array( 'fa-solid fa-wine-glass' => 'Wine Glass (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
            array( 'fa-solid fa-wrench' => 'Wrench (construction,fix,mechanic,plumbing,settings,spanner,tool,update)' ),
        ),
        'Payments & Shopping' => array(
            array( 'fa-brands fa-alipay' => 'Alipay' ),
            array( 'fa-brands fa-amazon-pay' => 'Amazon Pay' ),
            array( 'fa-brands fa-apple-pay' => 'Apple Pay' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-brands fa-bitcoin' => 'Bitcoin' ),
            array( 'fa-solid fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-regular fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-brands fa-btc' => 'BTC' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-camera' => 'camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-camera-retro' => 'Retro Camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-cart-arrow-down' => 'Shopping Cart Arrow Down (download,save,shopping)' ),
            array( 'fa-solid fa-cart-plus' => 'Add to Shopping Cart (add,create,new,positive,shopping)' ),
            array( 'fa-brands fa-cc-amazon-pay' => 'Amazon Pay Credit Card' ),
            array( 'fa-brands fa-cc-amex' => 'American Express Credit Card (amex)' ),
            array( 'fa-brands fa-cc-apple-pay' => 'Apple Pay Credit Card' ),
            array( 'fa-brands fa-cc-diners-club' => 'Diner\'s Club Credit Card' ),
            array( 'fa-brands fa-cc-discover' => 'Discover Credit Card' ),
            array( 'fa-brands fa-cc-jcb' => 'JCB Credit Card' ),
            array( 'fa-brands fa-cc-mastercard' => 'MasterCard Credit Card' ),
            array( 'fa-brands fa-cc-paypal' => 'Paypal Credit Card' ),
            array( 'fa-brands fa-cc-stripe' => 'Stripe Credit Card' ),
            array( 'fa-brands fa-cc-visa' => 'Visa Credit Card' ),
            array( 'fa-solid fa-certificate' => 'certificate (badge,star,verified)' ),
            array( 'fa-solid fa-credit-card' => 'Credit Card (buy,checkout,credit-card-alt,debit,money,payment,purchase)' ),
            array( 'fa-regular fa-credit-card' => 'Credit Card (buy,checkout,credit-card-alt,debit,money,payment,purchase)' ),
            array( 'fa-brands fa-ethereum' => 'Ethereum' ),
            array( 'fa-solid fa-gem' => 'Gem (diamond,jewelry,sapphire,stone,treasure)' ),
            array( 'fa-regular fa-gem' => 'Gem (diamond,jewelry,sapphire,stone,treasure)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-brands fa-google-wallet' => 'Google Wallet' ),
            array( 'fa-solid fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-regular fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-key' => 'key (lock,password,private,secret,unlock)' ),
            array( 'fa-solid fa-money-check' => 'Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-solid fa-money-check-alt' => 'Alternate Money Check (bank check,buy,checkout,cheque,money,payment,price,purchase)' ),
            array( 'fa-brands fa-paypal' => 'Paypal' ),
            array( 'fa-solid fa-receipt' => 'Receipt (check,invoice,money,pay,table)' ),
            array( 'fa-solid fa-shopping-bag' => 'Shopping Bag (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-basket' => 'Shopping Basket (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-brands fa-stripe' => 'Stripe' ),
            array( 'fa-brands fa-stripe-s' => 'Stripe S' ),
            array( 'fa-solid fa-tag' => 'tag (discount,label,price,shopping)' ),
            array( 'fa-solid fa-tags' => 'tags (discount,label,price,shopping)' ),
            array( 'fa-solid fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-regular fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-solid fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-regular fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-solid fa-trophy' => 'trophy (achievement,award,cup,game,winner)' ),
        ),
        'Pharmacy' => array(
            array( 'fa-solid fa-band-aid' => 'Band-Aid (bandage,boo boo,first aid,ouch)' ),
            array( 'fa-solid fa-book-medical' => 'Medical Book (diary,documentation,health,history,journal,library,read,record)' ),
            array( 'fa-solid fa-cannabis' => 'Cannabis (bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)' ),
            array( 'fa-solid fa-capsules' => 'Capsules (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-clinic-medical' => 'Medical Clinic (doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)' ),
            array( 'fa-solid fa-eye-dropper' => 'Eye Dropper (beaker,clone,color,copy,eyedropper,pipette)' ),
            array( 'fa-solid fa-file-medical' => 'Medical File (document,health,history,prescription,record)' ),
            array( 'fa-solid fa-file-prescription' => 'File Prescription (document,drugs,medical,medicine,rx)' ),
            array( 'fa-solid fa-first-aid' => 'First Aid (emergency,emt,health,medical,rescue)' ),
            array( 'fa-solid fa-flask' => 'Flask (beaker,experimental,labs,science)' ),
            array( 'fa-solid fa-history' => 'History (Rewind,clock,reverse,time,time machine)' ),
            array( 'fa-solid fa-joint' => 'Joint (blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)' ),
            array( 'fa-solid fa-laptop-medical' => 'Laptop Medical (computer,device,ehr,electronic health records,history)' ),
            array( 'fa-solid fa-mortar-pestle' => 'Mortar Pestle (crush,culinary,grind,medical,mix,pharmacy,prescription,spices)' ),
            array( 'fa-solid fa-notes-medical' => 'Medical Notes (clipboard,doctor,ehr,health,history,records)' ),
            array( 'fa-solid fa-pills' => 'Pills (drugs,medicine,prescription,tablets)' ),
            array( 'fa-solid fa-prescription' => 'Prescription (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-prescription-bottle' => 'Prescription Bottle (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-prescription-bottle-alt' => 'Alternate Prescription Bottle (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-receipt' => 'Receipt (check,invoice,money,pay,table)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-solid fa-syringe' => 'Syringe (doctor,immunizations,medical,needle)' ),
            array( 'fa-solid fa-tablets' => 'Tablets (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-thermometer' => 'Thermometer (mercury,status,temperature)' ),
            array( 'fa-solid fa-vial' => 'Vial (experiment,lab,sample,science,test,test tube)' ),
            array( 'fa-solid fa-vials' => 'Vials (experiment,lab,sample,science,test,test tube)' ),
        ),
        'Political' => array(
            array( 'fa-solid fa-award' => 'Award (honor,praise,prize,recognition,ribbon,trophy)' ),
            array( 'fa-solid fa-balance-scale' => 'Balance Scale (balanced,justice,legal,measure,weight)' ),
            array( 'fa-solid fa-balance-scale-left' => 'Balance Scale (Left-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-balance-scale-right' => 'Balance Scale (Right-Weighted) (justice,legal,measure,unbalanced,weight)' ),
            array( 'fa-solid fa-bullhorn' => 'bullhorn (announcement,broadcast,louder,megaphone,share)' ),
            array( 'fa-solid fa-check-double' => 'Double Check (accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)' ),
            array( 'fa-solid fa-democrat' => 'Democrat (american,democratic party,donkey,election,left,left-wing,liberal,politics,usa)' ),
            array( 'fa-solid fa-donate' => 'Donate (contribute,generosity,gift,give)' ),
            array( 'fa-solid fa-dove' => 'Dove (bird,fauna,flying,peace,war)' ),
            array( 'fa-solid fa-fist-raised' => 'Raised Fist (Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)' ),
            array( 'fa-solid fa-flag-usa' => 'United States of America Flag (betsy ross,country,old glory,stars,stripes,symbol)' ),
            array( 'fa-solid fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-regular fa-handshake' => 'Handshake (agreement,greeting,meeting,partnership)' ),
            array( 'fa-solid fa-person-booth' => 'Person Entering Booth (changing,changing room,election,human,person,vote,voting)' ),
            array( 'fa-solid fa-piggy-bank' => 'Piggy Bank (bank,save,savings)' ),
            array( 'fa-solid fa-republican' => 'Republican (american,conservative,election,elephant,politics,republican party,right,right-wing,usa)' ),
            array( 'fa-solid fa-vote-yea' => 'Vote Yea (accept,cast,election,politics,positive,yes)' ),
        ),
        'Religion' => array(
            array( 'fa-solid fa-ankh' => 'Ankh (amulet,copper,coptic christianity,copts,crux ansata,egypt,venus)' ),
            array( 'fa-solid fa-atom' => 'Atom (atheism,chemistry,ion,nuclear,science)' ),
            array( 'fa-solid fa-bible' => 'Bible (book,catholicism,christianity,god,holy)' ),
            array( 'fa-solid fa-church' => 'Church (building,cathedral,chapel,community,religion)' ),
            array( 'fa-solid fa-cross' => 'Cross (catholicism,christianity,church,jesus)' ),
            array( 'fa-solid fa-dharmachakra' => 'Dharmachakra (buddhism,buddhist,wheel of dharma)' ),
            array( 'fa-solid fa-dove' => 'Dove (bird,fauna,flying,peace,war)' ),
            array( 'fa-solid fa-gopuram' => 'Gopuram (building,entrance,hinduism,temple,tower)' ),
            array( 'fa-solid fa-hamsa' => 'Hamsa (amulet,christianity,islam,jewish,judaism,muslim,protection)' ),
            array( 'fa-solid fa-hanukiah' => 'Hanukiah (candle,hanukkah,jewish,judaism,light)' ),
            array( 'fa-solid fa-haykal' => 'Haykal (bahai,bahá\'í,star)' ),
            array( 'fa-solid fa-jedi' => 'Jedi (crest,force,sith,skywalker,star wars,yoda)' ),
            array( 'fa-solid fa-journal-whills' => 'Journal of the Whills (book,force,jedi,sith,star wars,yoda)' ),
            array( 'fa-solid fa-kaaba' => 'Kaaba (building,cube,islam,muslim)' ),
            array( 'fa-solid fa-khanda' => 'Khanda (chakkar,sikh,sikhism,sword)' ),
            array( 'fa-solid fa-menorah' => 'Menorah (candle,hanukkah,jewish,judaism,light)' ),
            array( 'fa-solid fa-mosque' => 'Mosque (building,islam,landmark,muslim)' ),
            array( 'fa-solid fa-om' => 'Om (buddhism,hinduism,jainism,mantra)' ),
            array( 'fa-solid fa-pastafarianism' => 'Pastafarianism (agnosticism,atheism,flying spaghetti monster,fsm)' ),
            array( 'fa-solid fa-peace' => 'Peace (serenity,tranquility,truce,war)' ),
            array( 'fa-solid fa-place-of-worship' => 'Place of Worship (building,church,holy,mosque,synagogue)' ),
            array( 'fa-solid fa-pray' => 'Pray (kneel,preach,religion,worship)' ),
            array( 'fa-solid fa-praying-hands' => 'Praying Hands (kneel,preach,religion,worship)' ),
            array( 'fa-solid fa-quran' => 'Quran (book,islam,muslim,religion)' ),
            array( 'fa-solid fa-star-and-crescent' => 'Star and Crescent (islam,muslim,religion)' ),
            array( 'fa-solid fa-star-of-david' => 'Star of David (jewish,judaism,religion)' ),
            array( 'fa-solid fa-synagogue' => 'Synagogue (building,jewish,judaism,religion,star of david,temple)' ),
            array( 'fa-solid fa-torah' => 'Torah (book,jewish,judaism,religion,scroll)' ),
            array( 'fa-solid fa-torii-gate' => 'Torii Gate (building,shintoism)' ),
            array( 'fa-solid fa-vihara' => 'Vihara (buddhism,buddhist,building,monastery)' ),
            array( 'fa-solid fa-yin-yang' => 'Yin Yang (daoism,opposites,taoism)' ),
        ),
        'Science' => array(
            array( 'fa-solid fa-atom' => 'Atom (atheism,chemistry,ion,nuclear,science)' ),
            array( 'fa-solid fa-biohazard' => 'Biohazard (danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)' ),
            array( 'fa-solid fa-brain' => 'Brain (cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)' ),
            array( 'fa-solid fa-burn' => 'Burn (caliente,energy,fire,flame,gas,heat,hot)' ),
            array( 'fa-solid fa-capsules' => 'Capsules (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-clipboard-check' => 'Clipboard with Check (accept,agree,confirm,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-dna' => 'DNA (double helix,genetic,helix,molecule,protein)' ),
            array( 'fa-solid fa-eye-dropper' => 'Eye Dropper (beaker,clone,color,copy,eyedropper,pipette)' ),
            array( 'fa-solid fa-filter' => 'Filter (funnel,options,separate,sort)' ),
            array( 'fa-solid fa-fire' => 'fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-fire-alt' => 'Alternate Fire (burn,caliente,flame,heat,hot,popular)' ),
            array( 'fa-solid fa-flask' => 'Flask (beaker,experimental,labs,science)' ),
            array( 'fa-solid fa-frog' => 'Frog (amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)' ),
            array( 'fa-solid fa-magnet' => 'magnet (Attract,lodestone,tool)' ),
            array( 'fa-solid fa-microscope' => 'Microscope (electron,lens,optics,science,shrink)' ),
            array( 'fa-solid fa-mortar-pestle' => 'Mortar Pestle (crush,culinary,grind,medical,mix,pharmacy,prescription,spices)' ),
            array( 'fa-solid fa-pills' => 'Pills (drugs,medicine,prescription,tablets)' ),
            array( 'fa-solid fa-prescription-bottle' => 'Prescription Bottle (drugs,medical,medicine,pharmacy,rx)' ),
            array( 'fa-solid fa-radiation' => 'Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-radiation-alt' => 'Alternate Radiation (danger,dangerous,deadly,hazard,nuclear,radioactive,warning)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-solid fa-syringe' => 'Syringe (doctor,immunizations,medical,needle)' ),
            array( 'fa-solid fa-tablets' => 'Tablets (drugs,medicine,pills,prescription)' ),
            array( 'fa-solid fa-temperature-high' => 'High Temperature (cook,mercury,summer,thermometer,warm)' ),
            array( 'fa-solid fa-temperature-low' => 'Low Temperature (cold,cool,mercury,thermometer,winter)' ),
            array( 'fa-solid fa-vial' => 'Vial (experiment,lab,sample,science,test,test tube)' ),
            array( 'fa-solid fa-vials' => 'Vials (experiment,lab,sample,science,test,test tube)' ),
        ),
        'Science Fiction' => array(
            array( 'fa-brands fa-galactic-republic' => 'Galactic Republic (politics,star wars)' ),
            array( 'fa-brands fa-galactic-senate' => 'Galactic Senate (star wars)' ),
            array( 'fa-solid fa-globe' => 'Globe (all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-jedi' => 'Jedi (crest,force,sith,skywalker,star wars,yoda)' ),
            array( 'fa-brands fa-jedi-order' => 'Jedi Order (star wars)' ),
            array( 'fa-solid fa-journal-whills' => 'Journal of the Whills (book,force,jedi,sith,star wars,yoda)' ),
            array( 'fa-solid fa-meteor' => 'Meteor (armageddon,asteroid,comet,shooting star,space)' ),
            array( 'fa-solid fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-regular fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-brands fa-old-republic' => 'Old Republic (politics,star wars)' ),
            array( 'fa-solid fa-robot' => 'Robot (android,automate,computer,cyborg)' ),
            array( 'fa-solid fa-rocket' => 'rocket (aircraft,app,jet,launch,nasa,space)' ),
            array( 'fa-solid fa-satellite' => 'Satellite (communications,hardware,orbit,space)' ),
            array( 'fa-solid fa-satellite-dish' => 'Satellite Dish (SETI,communications,hardware,receiver,saucer,signal)' ),
            array( 'fa-solid fa-space-shuttle' => 'Space Shuttle (astronaut,machine,nasa,rocket,transportation)' ),
            array( 'fa-solid fa-user-astronaut' => 'User Astronaut (avatar,clothing,cosmonaut,nasa,space,suit)' ),
        ),
        'Security' => array(
            array( 'fa-solid fa-ban' => 'ban (abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)' ),
            array( 'fa-solid fa-bug' => 'Bug (beetle,error,insect,report)' ),
            array( 'fa-solid fa-door-closed' => 'Door Closed (enter,exit,locked)' ),
            array( 'fa-solid fa-door-open' => 'Door Open (enter,exit,welcome)' ),
            array( 'fa-solid fa-dungeon' => 'Dungeon (Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-file-contract' => 'File Contract (agreement,binding,document,legal,signature)' ),
            array( 'fa-solid fa-file-signature' => 'File Signature (John Hancock,contract,document,name)' ),
            array( 'fa-solid fa-fingerprint' => 'Fingerprint (human,id,identification,lock,smudge,touch,unique,unlock)' ),
            array( 'fa-solid fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-regular fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-solid fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-regular fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-id-card-alt' => 'Alternate Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-key' => 'key (lock,password,private,secret,unlock)' ),
            array( 'fa-solid fa-lock' => 'lock (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-lock-open' => 'Lock Open (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-mask' => 'Mask (carnivale,costume,disguise,halloween,secret,super hero)' ),
            array( 'fa-solid fa-passport' => 'Passport (document,id,identification,issued,travel)' ),
            array( 'fa-solid fa-shield-alt' => 'Alternate Shield (achievement,award,block,defend,security,winner)' ),
            array( 'fa-solid fa-unlock' => 'unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-unlock-alt' => 'Alternate Unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-user-lock' => 'User Lock (admin,lock,person,private,unlock)' ),
            array( 'fa-solid fa-user-secret' => 'User Secret (clothing,coat,hat,incognito,person,privacy,spy,whisper)' ),
            array( 'fa-solid fa-user-shield' => 'User Shield (admin,person,private,protect,safe)' ),
        ),
        'Shapes' => array(
            array( 'fa-solid fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-regular fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-certificate' => 'certificate (badge,star,verified)' ),
            array( 'fa-solid fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-regular fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-solid fa-cloud' => 'Cloud (atmosphere,fog,overcast,save,upload,weather)' ),
            array( 'fa-solid fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-heart-broken' => 'Heart Broken (breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)' ),
            array( 'fa-solid fa-map-marker' => 'map-marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-play' => 'play (audio,music,playing,sound,start,video)' ),
            array( 'fa-solid fa-shapes' => 'Shapes (blocks,build,circle,square,triangle)' ),
            array( 'fa-solid fa-square' => 'Square (block,box,shape)' ),
            array( 'fa-regular fa-square' => 'Square (block,box,shape)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
        ),
        'Shopping' => array(
            array( 'fa-solid fa-barcode' => 'barcode (info,laser,price,scan,upc)' ),
            array( 'fa-solid fa-cart-arrow-down' => 'Shopping Cart Arrow Down (download,save,shopping)' ),
            array( 'fa-solid fa-cart-plus' => 'Add to Shopping Cart (add,create,new,positive,shopping)' ),
            array( 'fa-solid fa-cash-register' => 'Cash Register (buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)' ),
            array( 'fa-solid fa-gift' => 'gift (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-gifts' => 'Gifts (christmas,generosity,giving,holiday,party,present,wrapped,xmas)' ),
            array( 'fa-solid fa-person-booth' => 'Person Entering Booth (changing,changing room,election,human,person,vote,voting)' ),
            array( 'fa-solid fa-receipt' => 'Receipt (check,invoice,money,pay,table)' ),
            array( 'fa-solid fa-shipping-fast' => 'Shipping Fast (express,fedex,mail,overnight,package,ups)' ),
            array( 'fa-solid fa-shopping-bag' => 'Shopping Bag (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-basket' => 'Shopping Basket (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-store' => 'Store (building,buy,purchase,shopping)' ),
            array( 'fa-solid fa-store-alt' => 'Alternate Store (building,buy,purchase,shopping)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-tshirt' => 'T-Shirt (clothing,fashion,garment,shirt)' ),
        ),
        'Social' => array(
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-birthday-cake' => 'Birthday Cake (anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)' ),
            array( 'fa-solid fa-camera' => 'camera (image,lens,photo,picture,record,shutter,video)' ),
            array( 'fa-solid fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-hashtag' => 'Hashtag (Twitter,instagram,pound,social media,tag)' ),
            array( 'fa-solid fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-regular fa-heart' => 'Heart (favorite,like,love,relationship,valentine)' ),
            array( 'fa-solid fa-icons' => 'Icons (bolt,emoji,heart,image,music,photo,symbols)' ),
            array( 'fa-solid fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-image' => 'Image (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-regular fa-images' => 'Images (album,landscape,photo,picture)' ),
            array( 'fa-solid fa-map-marker' => 'map-marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker-alt' => 'Alternate Map Marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-photo-video' => 'Photo Video (av,film,image,library,media)' ),
            array( 'fa-solid fa-poll' => 'Poll (results,survey,trend,vote,voting)' ),
            array( 'fa-solid fa-poll-h' => 'Poll H (results,survey,trend,vote,voting)' ),
            array( 'fa-solid fa-retweet' => 'Retweet (refresh,reload,share,swap)' ),
            array( 'fa-solid fa-share' => 'Share (forward,save,send,social)' ),
            array( 'fa-solid fa-share-alt' => 'Alternate Share (forward,save,send,social)' ),
            array( 'fa-solid fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-regular fa-share-square' => 'Share Square (forward,save,send,social)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-solid fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-regular fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-solid fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-regular fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-solid fa-thumbtack' => 'Thumbtack (coordinates,location,marker,pin,thumb-tack)' ),
            array( 'fa-solid fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-friends' => 'User Friends (group,people,person,team,users)' ),
            array( 'fa-solid fa-user-plus' => 'User Plus (add,avatar,positive,sign up,signup,team)' ),
            array( 'fa-solid fa-users' => 'Users (friends,group,people,persons,profiles,team)' ),
            array( 'fa-solid fa-video' => 'Video (camera,film,movie,record,video-camera)' ),
        ),
        'Spinners' => array(
            array( 'fa-solid fa-asterisk' => 'asterisk (annotation,details,reference,star)' ),
            array( 'fa-solid fa-atom' => 'Atom (atheism,chemistry,ion,nuclear,science)' ),
            array( 'fa-solid fa-certificate' => 'certificate (badge,star,verified)' ),
            array( 'fa-solid fa-circle-notch' => 'Circle Notched (circle-o-notch,diameter,dot,ellipse,round,spinner)' ),
            array( 'fa-solid fa-cog' => 'cog (gear,mechanical,settings,sprocket,wheel)' ),
            array( 'fa-solid fa-compact-disc' => 'Compact Disc (album,bluray,cd,disc,dvd,media,movie,music,record,video,vinyl)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-crosshairs' => 'Crosshairs (aim,bullseye,gpd,picker,position)' ),
            array( 'fa-solid fa-dharmachakra' => 'Dharmachakra (buddhism,buddhist,wheel of dharma)' ),
            array( 'fa-solid fa-fan' => 'Fan (ac,air conditioning,blade,blower,cool,hot)' ),
            array( 'fa-solid fa-haykal' => 'Haykal (bahai,bahá\'í,star)' ),
            array( 'fa-solid fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-regular fa-life-ring' => 'Life Ring (coast guard,help,overboard,save,support)' ),
            array( 'fa-solid fa-palette' => 'Palette (acrylic,art,brush,color,fill,paint,pigment,watercolor)' ),
            array( 'fa-solid fa-ring' => 'Ring (Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)' ),
            array( 'fa-solid fa-slash' => 'Slash (cancel,close,mute,off,stop,x)' ),
            array( 'fa-solid fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-regular fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-solid fa-spinner' => 'Spinner (circle,loading,progress)' ),
            array( 'fa-solid fa-stroopwafel' => 'Stroopwafel (caramel,cookie,dessert,sweets,waffle)' ),
            array( 'fa-solid fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-regular fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-solid fa-sync' => 'Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-sync-alt' => 'Alternate Sync (exchange,refresh,reload,rotate,swap)' ),
            array( 'fa-solid fa-yin-yang' => 'Yin Yang (daoism,opposites,taoism)' ),
        ),
        'Sports' => array(
            array( 'fa-solid fa-baseball-ball' => 'Baseball Ball (foul,hardball,league,leather,mlb,softball,sport)' ),
            array( 'fa-solid fa-basketball-ball' => 'Basketball Ball (dribble,dunk,hoop,nba)' ),
            array( 'fa-solid fa-biking' => 'Biking (bicycle,bike,cycle,cycling,ride,wheel)' ),
            array( 'fa-solid fa-bowling-ball' => 'Bowling Ball (alley,candlepin,gutter,lane,strike,tenpin)' ),
            array( 'fa-solid fa-dumbbell' => 'Dumbbell (exercise,gym,strength,weight,weight-lifting)' ),
            array( 'fa-solid fa-football-ball' => 'Football Ball (ball,fall,nfl,pigskin,seasonal)' ),
            array( 'fa-solid fa-futbol' => 'Futbol (ball,football,mls,soccer)' ),
            array( 'fa-regular fa-futbol' => 'Futbol (ball,football,mls,soccer)' ),
            array( 'fa-solid fa-golf-ball' => 'Golf Ball (caddy,eagle,putt,tee)' ),
            array( 'fa-solid fa-hockey-puck' => 'Hockey Puck (ice,nhl,sport)' ),
            array( 'fa-solid fa-quidditch' => 'Quidditch (ball,bludger,broom,golden snitch,harry potter,hogwarts,quaffle,sport,wizard)' ),
            array( 'fa-solid fa-running' => 'Running (exercise,health,jog,person,run,sport,sprint)' ),
            array( 'fa-solid fa-skating' => 'Skating (activity,figure skating,fitness,ice,person,winter)' ),
            array( 'fa-solid fa-skiing' => 'Skiing (activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)' ),
            array( 'fa-solid fa-skiing-nordic' => 'Skiing Nordic (activity,cross country,fitness,outdoors,person,seasonal)' ),
            array( 'fa-solid fa-snowboarding' => 'Snowboarding (activity,fitness,olympics,outdoors,person)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-table-tennis' => 'Table Tennis (ball,paddle,ping pong)' ),
            array( 'fa-solid fa-volleyball-ball' => 'Volleyball Ball (beach,olympics,sport)' ),
        ),
        'Spring' => array(
            array( 'fa-solid fa-allergies' => 'Allergies (allergy,freckles,hand,hives,pox,skin,spots)' ),
            array( 'fa-solid fa-broom' => 'Broom (clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)' ),
            array( 'fa-solid fa-cloud-sun' => 'Cloud with Sun (clear,day,daytime,fall,outdoors,overcast,partly cloudy)' ),
            array( 'fa-solid fa-cloud-sun-rain' => 'Cloud with Sun and Rain (day,overcast,precipitation,storm,summer,sunshower)' ),
            array( 'fa-solid fa-frog' => 'Frog (amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)' ),
            array( 'fa-solid fa-rainbow' => 'Rainbow (gold,leprechaun,prism,rain,sky)' ),
            array( 'fa-solid fa-seedling' => 'Seedling (flora,grow,plant,vegan)' ),
            array( 'fa-solid fa-umbrella' => 'Umbrella (protection,rain,storm,wet)' ),
        ),
        'Status' => array(
            array( 'fa-solid fa-ban' => 'ban (abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)' ),
            array( 'fa-solid fa-battery-empty' => 'Battery Empty (charge,dead,power,status)' ),
            array( 'fa-solid fa-battery-full' => 'Battery Full (charge,power,status)' ),
            array( 'fa-solid fa-battery-half' => 'Battery 1/2 Full (charge,power,status)' ),
            array( 'fa-solid fa-battery-quarter' => 'Battery 1/4 Full (charge,low,power,status)' ),
            array( 'fa-solid fa-battery-three-quarters' => 'Battery 3/4 Full (charge,power,status)' ),
            array( 'fa-solid fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-regular fa-bell' => 'bell (alarm,alert,chime,notification,reminder)' ),
            array( 'fa-solid fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-regular fa-bell-slash' => 'Bell Slash (alert,cancel,disabled,notification,off,reminder)' ),
            array( 'fa-solid fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar' => 'Calendar (calendar-o,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-alt' => 'Alternate Calendar (calendar,date,event,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-regular fa-calendar-check' => 'Calendar Check (accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)' ),
            array( 'fa-solid fa-calendar-day' => 'Calendar with Day Focus (date,detail,event,focus,schedule,single day,time,today,when)' ),
            array( 'fa-solid fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-minus' => 'Calendar Minus (calendar,date,delete,event,negative,remove,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-regular fa-calendar-plus' => 'Calendar Plus (add,calendar,create,date,event,new,positive,schedule,time,when)' ),
            array( 'fa-solid fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-regular fa-calendar-times' => 'Calendar Times (archive,calendar,date,delete,event,remove,schedule,time,when,x)' ),
            array( 'fa-solid fa-calendar-week' => 'Calendar with Week Focus (date,detail,event,focus,schedule,single week,time,today,when)' ),
            array( 'fa-solid fa-cart-arrow-down' => 'Shopping Cart Arrow Down (download,save,shopping)' ),
            array( 'fa-solid fa-cart-plus' => 'Add to Shopping Cart (add,create,new,positive,shopping)' ),
            array( 'fa-solid fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment' => 'comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-regular fa-comment-alt' => 'Alternate Comment (bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)' ),
            array( 'fa-solid fa-comment-slash' => 'Comment Slash (bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)' ),
            array( 'fa-solid fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-regular fa-compass' => 'Compass (directions,directory,location,menu,navigation,safari,travel)' ),
            array( 'fa-solid fa-door-closed' => 'Door Closed (enter,exit,locked)' ),
            array( 'fa-solid fa-door-open' => 'Door Open (enter,exit,welcome)' ),
            array( 'fa-solid fa-exclamation' => 'exclamation (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-circle' => 'Exclamation Circle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-exclamation-triangle' => 'Exclamation Triangle (alert,danger,error,important,notice,notification,notify,problem,warning)' ),
            array( 'fa-solid fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-regular fa-eye' => 'Eye (look,optic,see,seen,show,sight,views,visible)' ),
            array( 'fa-solid fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-regular fa-eye-slash' => 'Eye Slash (blind,hide,show,toggle,unseen,views,visible,visiblity)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-gas-pump' => 'Gas Pump (car,fuel,gasoline,petrol)' ),
            array( 'fa-solid fa-info' => 'Info (details,help,information,more,support)' ),
            array( 'fa-solid fa-info-circle' => 'Info Circle (details,help,information,more,support)' ),
            array( 'fa-solid fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-regular fa-lightbulb' => 'Lightbulb (energy,idea,inspiration,light)' ),
            array( 'fa-solid fa-lock' => 'lock (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-lock-open' => 'Lock Open (admin,lock,open,password,private,protect,security)' ),
            array( 'fa-solid fa-map-marker' => 'map-marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marker-alt' => 'Alternate Map Marker (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt' => 'Alternate Microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-alt-slash' => 'Alternate Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-minus' => 'minus (collapse,delete,hide,minify,negative,remove,trash)' ),
            array( 'fa-solid fa-minus-circle' => 'Minus Circle (delete,hide,negative,remove,shape,trash)' ),
            array( 'fa-solid fa-minus-square' => 'Minus Square (collapse,delete,hide,minify,negative,remove,shape,trash)' ),
            array( 'fa-regular fa-minus-square' => 'Minus Square (collapse,delete,hide,minify,negative,remove,shape,trash)' ),
            array( 'fa-solid fa-parking' => 'Parking (auto,car,garage,meter)' ),
            array( 'fa-solid fa-phone' => 'Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-alt' => 'Alternate Phone (call,earphone,number,support,telephone,voice)' ),
            array( 'fa-solid fa-phone-slash' => 'Phone Slash (call,cancel,earphone,mute,number,support,telephone,voice)' ),
            array( 'fa-solid fa-plus' => 'plus (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-plus-circle' => 'Plus Circle (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-regular fa-plus-square' => 'Plus Square (add,create,expand,new,positive,shape)' ),
            array( 'fa-solid fa-print' => 'print (business,copy,document,office,paper)' ),
            array( 'fa-solid fa-question' => 'Question (help,information,support,unknown)' ),
            array( 'fa-solid fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-regular fa-question-circle' => 'Question Circle (help,information,support,unknown)' ),
            array( 'fa-solid fa-shield-alt' => 'Alternate Shield (achievement,award,block,defend,security,winner)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-sign-in-alt' => 'Alternate Sign In (arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)' ),
            array( 'fa-solid fa-sign-out-alt' => 'Alternate Sign Out (arrow,exit,leave,log out,logout,sign-out)' ),
            array( 'fa-solid fa-signal' => 'signal (bars,graph,online,reception,status)' ),
            array( 'fa-solid fa-smoking-ban' => 'Smoking Ban (ban,cancel,no smoking,non-smoking)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-solid fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-regular fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-solid fa-star-half-alt' => 'Alternate Star Half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-solid fa-stream' => 'Stream (flow,list,timeline)' ),
            array( 'fa-solid fa-thermometer-empty' => 'Thermometer Empty (cold,mercury,status,temperature)' ),
            array( 'fa-solid fa-thermometer-full' => 'Thermometer Full (fever,hot,mercury,status,temperature)' ),
            array( 'fa-solid fa-thermometer-half' => 'Thermometer 1/2 Full (mercury,status,temperature)' ),
            array( 'fa-solid fa-thermometer-quarter' => 'Thermometer 1/4 Full (mercury,status,temperature)' ),
            array( 'fa-solid fa-thermometer-three-quarters' => 'Thermometer 3/4 Full (mercury,status,temperature)' ),
            array( 'fa-solid fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-regular fa-thumbs-down' => 'thumbs-down (disagree,disapprove,dislike,hand,social,thumbs-o-down)' ),
            array( 'fa-solid fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-regular fa-thumbs-up' => 'thumbs-up (agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)' ),
            array( 'fa-solid fa-tint' => 'tint (color,drop,droplet,raindrop,waterdrop)' ),
            array( 'fa-solid fa-tint-slash' => 'Tint Slash (color,drop,droplet,raindrop,waterdrop)' ),
            array( 'fa-solid fa-toggle-off' => 'Toggle Off (switch)' ),
            array( 'fa-solid fa-toggle-on' => 'Toggle On (switch)' ),
            array( 'fa-solid fa-unlock' => 'unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-unlock-alt' => 'Alternate Unlock (admin,lock,password,private,protect)' ),
            array( 'fa-solid fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-alt' => 'Alternate User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-alt-slash' => 'Alternate User Slash (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-slash' => 'User Slash (ban,delete,remove)' ),
            array( 'fa-solid fa-video' => 'Video (camera,film,movie,record,video-camera)' ),
            array( 'fa-solid fa-video-slash' => 'Video Slash (add,create,film,new,positive,record,video)' ),
            array( 'fa-solid fa-volume-down' => 'Volume Down (audio,lower,music,quieter,sound,speaker)' ),
            array( 'fa-solid fa-volume-mute' => 'Volume Mute (audio,music,quiet,sound,speaker)' ),
            array( 'fa-solid fa-volume-off' => 'Volume Off (audio,ban,music,mute,quiet,silent,sound)' ),
            array( 'fa-solid fa-volume-up' => 'Volume Up (audio,higher,louder,music,sound,speaker)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
        ),
        'Summer' => array(
            array( 'fa-solid fa-anchor' => 'Anchor (berth,boat,dock,embed,link,maritime,moor,secure)' ),
            array( 'fa-solid fa-biking' => 'Biking (bicycle,bike,cycle,cycling,ride,wheel)' ),
            array( 'fa-solid fa-fish' => 'Fish (fauna,gold,seafood,swimming)' ),
            array( 'fa-solid fa-hotdog' => 'Hot Dog (bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)' ),
            array( 'fa-solid fa-ice-cream' => 'Ice Cream (chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)' ),
            array( 'fa-solid fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-regular fa-lemon' => 'Lemon (citrus,lemonade,lime,tart)' ),
            array( 'fa-solid fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-regular fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-swimming-pool' => 'Swimming Pool (ladder,recreation,swim,water)' ),
            array( 'fa-solid fa-umbrella-beach' => 'Umbrella Beach (protection,recreation,sand,shade,summer,sun)' ),
            array( 'fa-solid fa-volleyball-ball' => 'Volleyball Ball (beach,olympics,sport)' ),
            array( 'fa-solid fa-water' => 'Water (lake,liquid,ocean,sea,swim,wet)' ),
        ),
        'Tabletop Gaming' => array(
            array( 'fa-brands fa-acquisitions-incorporated' => 'Acquisitions Incorporated (Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)' ),
            array( 'fa-solid fa-book-dead' => 'Book of the Dead (Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)' ),
            array( 'fa-brands fa-critical-role' => 'Critical Role (Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)' ),
            array( 'fa-brands fa-d-and-d' => 'Dungeons & Dragons' ),
            array( 'fa-brands fa-d-and-d-beyond' => 'D&D Beyond (Dungeons & Dragons,d&d,dnd,fantasy,gaming,tabletop)' ),
            array( 'fa-solid fa-dice-d20' => 'Dice D20 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dice-d6' => 'Dice D6 (Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)' ),
            array( 'fa-solid fa-dragon' => 'Dragon (Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)' ),
            array( 'fa-solid fa-dungeon' => 'Dungeon (Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)' ),
            array( 'fa-brands fa-fantasy-flight-games' => 'Fantasy Flight-games (Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)' ),
            array( 'fa-solid fa-fist-raised' => 'Raised Fist (Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)' ),
            array( 'fa-solid fa-hat-wizard' => 'Wizard\'s Hat (Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)' ),
            array( 'fa-brands fa-penny-arcade' => 'Penny Arcade (Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,pax,tabletop)' ),
            array( 'fa-solid fa-ring' => 'Ring (Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)' ),
            array( 'fa-solid fa-scroll' => 'Scroll (Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)' ),
            array( 'fa-solid fa-skull-crossbones' => 'Skull & Crossbones (Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)' ),
            array( 'fa-brands fa-wizards-of-the-coast' => 'Wizards of the Coast (Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)' ),
        ),
        'Toggle' => array(
            array( 'fa-solid fa-bullseye' => 'Bullseye (archery,goal,objective,target)' ),
            array( 'fa-solid fa-check-circle' => 'Check Circle (accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-regular fa-check-circle' => 'Check Circle (accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)' ),
            array( 'fa-solid fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-regular fa-circle' => 'Circle (circle-thin,diameter,dot,ellipse,notification,round)' ),
            array( 'fa-solid fa-dot-circle' => 'Dot Circle (bullseye,notification,target)' ),
            array( 'fa-regular fa-dot-circle' => 'Dot Circle (bullseye,notification,target)' ),
            array( 'fa-solid fa-microphone' => 'microphone (audio,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-microphone-slash' => 'Microphone Slash (audio,disable,mute,podcast,record,sing,sound,voice)' ),
            array( 'fa-solid fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-regular fa-star' => 'Star (achievement,award,favorite,important,night,rating,score)' ),
            array( 'fa-solid fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-regular fa-star-half' => 'star-half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-solid fa-star-half-alt' => 'Alternate Star Half (achievement,award,rating,score,star-half-empty,star-half-full)' ),
            array( 'fa-solid fa-toggle-off' => 'Toggle Off (switch)' ),
            array( 'fa-solid fa-toggle-on' => 'Toggle On (switch)' ),
            array( 'fa-solid fa-wifi' => 'WiFi (connection,hotspot,internet,network,wireless)' ),
        ),
        'Travel' => array(
            array( 'fa-solid fa-archway' => 'Archway (arc,monument,road,street,tunnel)' ),
            array( 'fa-solid fa-atlas' => 'Atlas (book,directions,geography,globe,map,travel,wayfinding)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-bus' => 'Bus (public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-bus-alt' => 'Bus Alt (mta,public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-cocktail' => 'Cocktail (alcohol,beverage,drink,gin,glass,margarita,martini,vodka)' ),
            array( 'fa-solid fa-concierge-bell' => 'Concierge Bell (attention,hotel,receptionist,service,support)' ),
            array( 'fa-solid fa-dumbbell' => 'Dumbbell (exercise,gym,strength,weight,weight-lifting)' ),
            array( 'fa-solid fa-glass-martini' => 'Martini Glass (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-glass-martini-alt' => 'Alternate Glass Martini (alcohol,bar,beverage,drink,liquor)' ),
            array( 'fa-solid fa-globe-africa' => 'Globe with Africa shown (all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-globe-americas' => 'Globe with Americas shown (all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-globe-asia' => 'Globe with Asia shown (all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-globe-europe' => 'Globe with Europe shown (all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)' ),
            array( 'fa-solid fa-hot-tub' => 'Hot Tub (bath,jacuzzi,massage,sauna,spa)' ),
            array( 'fa-solid fa-hotel' => 'Hotel (building,inn,lodging,motel,resort,travel)' ),
            array( 'fa-solid fa-luggage-cart' => 'Luggage Cart (bag,baggage,suitcase,travel)' ),
            array( 'fa-solid fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-regular fa-map' => 'Map (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marked' => 'Map Marked (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-map-marked-alt' => 'Alternate Map Marked (address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)' ),
            array( 'fa-solid fa-monument' => 'Monument (building,historic,landmark,memorable)' ),
            array( 'fa-solid fa-passport' => 'Passport (document,id,identification,issued,travel)' ),
            array( 'fa-solid fa-plane' => 'plane (airplane,destination,fly,location,mode,travel,trip)' ),
            array( 'fa-solid fa-plane-arrival' => 'Plane Arrival (airplane,arriving,destination,fly,land,landing,location,mode,travel,trip)' ),
            array( 'fa-solid fa-plane-departure' => 'Plane Departure (airplane,departing,destination,fly,location,mode,take off,taking off,travel,trip)' ),
            array( 'fa-solid fa-shuttle-van' => 'Shuttle Van (airport,machine,public-transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-spa' => 'Spa (flora,massage,mindfulness,plant,wellness)' ),
            array( 'fa-solid fa-suitcase' => 'Suitcase (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-suitcase-rolling' => 'Suitcase Rolling (baggage,luggage,move,suitcase,travel,trip)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-swimming-pool' => 'Swimming Pool (ladder,recreation,swim,water)' ),
            array( 'fa-solid fa-taxi' => 'Taxi (cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)' ),
            array( 'fa-solid fa-tram' => 'Tram (crossing,machine,mountains,seasonal,transportation)' ),
            array( 'fa-solid fa-tv' => 'Television (computer,display,monitor,television)' ),
            array( 'fa-solid fa-umbrella-beach' => 'Umbrella Beach (protection,recreation,sand,shade,summer,sun)' ),
            array( 'fa-solid fa-wine-glass' => 'Wine Glass (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
            array( 'fa-solid fa-wine-glass-alt' => 'Alternate Wine Glas (alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)' ),
        ),
        'Users & People' => array(
            array( 'fa-brands fa-accessible-icon' => 'Accessible Icon (accessibility,handicap,person,wheelchair,wheelchair-alt)' ),
            array( 'fa-solid fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-regular fa-address-book' => 'Address Book (contact,directory,index,little black book,rolodex)' ),
            array( 'fa-solid fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-regular fa-address-card' => 'Address Card (about,contact,id,identification,postcard,profile)' ),
            array( 'fa-solid fa-baby' => 'Baby (child,diaper,doll,human,infant,kid,offspring,person,sprout)' ),
            array( 'fa-solid fa-bed' => 'Bed (lodging,rest,sleep,travel)' ),
            array( 'fa-solid fa-biking' => 'Biking (bicycle,bike,cycle,cycling,ride,wheel)' ),
            array( 'fa-solid fa-blind' => 'Blind (cane,disability,person,sight)' ),
            array( 'fa-solid fa-chalkboard-teacher' => 'Chalkboard Teacher (blackboard,instructor,learning,professor,school,whiteboard,writing)' ),
            array( 'fa-solid fa-child' => 'Child (boy,girl,kid,toddler,young)' ),
            array( 'fa-solid fa-female' => 'Female (human,person,profile,user,woman)' ),
            array( 'fa-solid fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-regular fa-frown' => 'Frowning Face (disapprove,emoticon,face,rating,sad)' ),
            array( 'fa-solid fa-hiking' => 'Hiking (activity,backpack,fall,fitness,outdoors,person,seasonal,walking)' ),
            array( 'fa-solid fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-regular fa-id-badge' => 'Identification Badge (address,contact,identification,license,profile)' ),
            array( 'fa-solid fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-regular fa-id-card' => 'Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-id-card-alt' => 'Alternate Identification Card (contact,demographics,document,identification,issued,profile)' ),
            array( 'fa-solid fa-male' => 'Male (human,man,person,profile,user)' ),
            array( 'fa-solid fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-regular fa-meh' => 'Neutral Face (emoticon,face,neutral,rating)' ),
            array( 'fa-solid fa-people-carry' => 'People Carry (box,carry,fragile,help,movers,package)' ),
            array( 'fa-solid fa-person-booth' => 'Person Entering Booth (changing,changing room,election,human,person,vote,voting)' ),
            array( 'fa-solid fa-poo' => 'Poo (crap,poop,shit,smile,turd)' ),
            array( 'fa-solid fa-portrait' => 'Portrait (id,image,photo,picture,selfie)' ),
            array( 'fa-solid fa-power-off' => 'Power Off (cancel,computer,on,reboot,restart)' ),
            array( 'fa-solid fa-pray' => 'Pray (kneel,preach,religion,worship)' ),
            array( 'fa-solid fa-restroom' => 'Restroom (bathroom,john,loo,potty,washroom,waste,wc)' ),
            array( 'fa-solid fa-running' => 'Running (exercise,health,jog,person,run,sport,sprint)' ),
            array( 'fa-solid fa-skating' => 'Skating (activity,figure skating,fitness,ice,person,winter)' ),
            array( 'fa-solid fa-skiing' => 'Skiing (activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)' ),
            array( 'fa-solid fa-skiing-nordic' => 'Skiing Nordic (activity,cross country,fitness,outdoors,person,seasonal)' ),
            array( 'fa-solid fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-regular fa-smile' => 'Smiling Face (approve,emoticon,face,happy,rating,satisfied)' ),
            array( 'fa-solid fa-snowboarding' => 'Snowboarding (activity,fitness,olympics,outdoors,person)' ),
            array( 'fa-solid fa-street-view' => 'Street View (directions,location,map,navigation)' ),
            array( 'fa-solid fa-swimmer' => 'Swimmer (athlete,head,man,olympics,person,pool,water)' ),
            array( 'fa-solid fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user' => 'User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-alt' => 'Alternate User (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-alt-slash' => 'Alternate User Slash (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-astronaut' => 'User Astronaut (avatar,clothing,cosmonaut,nasa,space,suit)' ),
            array( 'fa-solid fa-user-check' => 'User Check (accept,check,person,verified)' ),
            array( 'fa-solid fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-regular fa-user-circle' => 'User Circle (account,avatar,head,human,man,person,profile)' ),
            array( 'fa-solid fa-user-clock' => 'User Clock (alert,person,remind,time)' ),
            array( 'fa-solid fa-user-cog' => 'User Cog (admin,cog,person,settings)' ),
            array( 'fa-solid fa-user-edit' => 'User Edit (edit,pen,pencil,person,update,write)' ),
            array( 'fa-solid fa-user-friends' => 'User Friends (group,people,person,team,users)' ),
            array( 'fa-solid fa-user-graduate' => 'User Graduate (cap,clothing,commencement,gown,graduation,person,student)' ),
            array( 'fa-solid fa-user-injured' => 'User Injured (cast,injury,ouch,patient,person,sling)' ),
            array( 'fa-solid fa-user-lock' => 'User Lock (admin,lock,person,private,unlock)' ),
            array( 'fa-solid fa-user-md' => 'Doctor (job,medical,nurse,occupation,physician,profile,surgeon)' ),
            array( 'fa-solid fa-user-minus' => 'User Minus (delete,negative,remove)' ),
            array( 'fa-solid fa-user-ninja' => 'User Ninja (assassin,avatar,dangerous,deadly,sneaky)' ),
            array( 'fa-solid fa-user-nurse' => 'Nurse (doctor,midwife,practitioner,surgeon)' ),
            array( 'fa-solid fa-user-plus' => 'User Plus (add,avatar,positive,sign up,signup,team)' ),
            array( 'fa-solid fa-user-secret' => 'User Secret (clothing,coat,hat,incognito,person,privacy,spy,whisper)' ),
            array( 'fa-solid fa-user-shield' => 'User Shield (admin,person,private,protect,safe)' ),
            array( 'fa-solid fa-user-slash' => 'User Slash (ban,delete,remove)' ),
            array( 'fa-solid fa-user-tag' => 'User Tag (avatar,discount,label,person,role,special)' ),
            array( 'fa-solid fa-user-tie' => 'User Tie (avatar,business,clothing,formal,professional,suit)' ),
            array( 'fa-solid fa-user-times' => 'Remove User (archive,delete,remove,x)' ),
            array( 'fa-solid fa-users' => 'Users (friends,group,people,persons,profiles,team)' ),
            array( 'fa-solid fa-users-cog' => 'Users Cog (admin,cog,group,person,settings,team)' ),
            array( 'fa-solid fa-walking' => 'Walking (exercise,health,pedometer,person,steps)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
        ),
        'Vehicles' => array(
            array( 'fa-brands fa-accessible-icon' => 'Accessible Icon (accessibility,handicap,person,wheelchair,wheelchair-alt)' ),
            array( 'fa-solid fa-ambulance' => 'ambulance (emergency,emt,er,help,hospital,support,vehicle)' ),
            array( 'fa-solid fa-baby-carriage' => 'Baby Carriage (buggy,carrier,infant,push,stroller,transportation,walk,wheels)' ),
            array( 'fa-solid fa-bicycle' => 'Bicycle (bike,gears,pedal,transportation,vehicle)' ),
            array( 'fa-solid fa-bus' => 'Bus (public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-bus-alt' => 'Bus Alt (mta,public transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car' => 'Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car-alt' => 'Alternate Car (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-car-crash' => 'Car Crash (accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)' ),
            array( 'fa-solid fa-car-side' => 'Car Side (auto,automobile,sedan,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-fighter-jet' => 'fighter-jet (airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)' ),
            array( 'fa-solid fa-helicopter' => 'Helicopter (airwolf,apache,chopper,flight,fly,travel)' ),
            array( 'fa-solid fa-horse' => 'Horse (equus,fauna,mammmal,mare,neigh,pony)' ),
            array( 'fa-solid fa-motorcycle' => 'Motorcycle (bike,machine,transportation,vehicle)' ),
            array( 'fa-solid fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-regular fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-solid fa-plane' => 'plane (airplane,destination,fly,location,mode,travel,trip)' ),
            array( 'fa-solid fa-rocket' => 'rocket (aircraft,app,jet,launch,nasa,space)' ),
            array( 'fa-solid fa-ship' => 'Ship (boat,sea,water)' ),
            array( 'fa-solid fa-shopping-cart' => 'shopping-cart (buy,checkout,grocery,payment,purchase)' ),
            array( 'fa-solid fa-shuttle-van' => 'Shuttle Van (airport,machine,public-transportation,transportation,travel,vehicle)' ),
            array( 'fa-solid fa-sleigh' => 'Sleigh (christmas,claus,fly,holiday,santa,sled,snow,xmas)' ),
            array( 'fa-solid fa-snowplow' => 'Snowplow (clean up,cold,road,storm,winter)' ),
            array( 'fa-solid fa-space-shuttle' => 'Space Shuttle (astronaut,machine,nasa,rocket,transportation)' ),
            array( 'fa-solid fa-subway' => 'Subway (machine,railway,train,transportation,vehicle)' ),
            array( 'fa-solid fa-taxi' => 'Taxi (cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)' ),
            array( 'fa-solid fa-tractor' => 'Tractor (agriculture,farm,vehicle)' ),
            array( 'fa-solid fa-train' => 'Train (bullet,commute,locomotive,railway,subway)' ),
            array( 'fa-solid fa-tram' => 'Tram (crossing,machine,mountains,seasonal,transportation)' ),
            array( 'fa-solid fa-truck' => 'truck (cargo,delivery,shipping,vehicle)' ),
            array( 'fa-solid fa-truck-monster' => 'Truck Monster (offroad,vehicle,wheel)' ),
            array( 'fa-solid fa-truck-pickup' => 'Truck Side (cargo,vehicle)' ),
            array( 'fa-solid fa-wheelchair' => 'Wheelchair (accessible,handicap,person)' ),
        ),
        'Weather' => array(
            array( 'fa-solid fa-bolt' => 'Lightning Bolt (electricity,lightning,weather,zap)' ),
            array( 'fa-solid fa-cloud' => 'Cloud (atmosphere,fog,overcast,save,upload,weather)' ),
            array( 'fa-solid fa-cloud-meatball' => 'Cloud with (a chance of) Meatball (FLDSMDFR,food,spaghetti,storm)' ),
            array( 'fa-solid fa-cloud-moon' => 'Cloud with Moon (crescent,evening,lunar,night,partly cloudy,sky)' ),
            array( 'fa-solid fa-cloud-moon-rain' => 'Cloud with Moon and Rain (crescent,evening,lunar,night,partly cloudy,precipitation,rain,sky,storm)' ),
            array( 'fa-solid fa-cloud-rain' => 'Cloud with Rain (precipitation,rain,sky,storm)' ),
            array( 'fa-solid fa-cloud-showers-heavy' => 'Cloud with Heavy Showers (precipitation,rain,sky,storm)' ),
            array( 'fa-solid fa-cloud-sun' => 'Cloud with Sun (clear,day,daytime,fall,outdoors,overcast,partly cloudy)' ),
            array( 'fa-solid fa-cloud-sun-rain' => 'Cloud with Sun and Rain (day,overcast,precipitation,storm,summer,sunshower)' ),
            array( 'fa-solid fa-meteor' => 'Meteor (armageddon,asteroid,comet,shooting star,space)' ),
            array( 'fa-solid fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-regular fa-moon' => 'Moon (contrast,crescent,dark,lunar,night)' ),
            array( 'fa-solid fa-poo-storm' => 'Poo Storm (bolt,cloud,euphemism,lightning,mess,poop,shit,turd)' ),
            array( 'fa-solid fa-rainbow' => 'Rainbow (gold,leprechaun,prism,rain,sky)' ),
            array( 'fa-solid fa-smog' => 'Smog (dragon,fog,haze,pollution,smoke,weather)' ),
            array( 'fa-solid fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-regular fa-snowflake' => 'Snowflake (precipitation,rain,winter)' ),
            array( 'fa-solid fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-regular fa-sun' => 'Sun (brighten,contrast,day,lighter,sol,solar,star,weather)' ),
            array( 'fa-solid fa-temperature-high' => 'High Temperature (cook,mercury,summer,thermometer,warm)' ),
            array( 'fa-solid fa-temperature-low' => 'Low Temperature (cold,cool,mercury,thermometer,winter)' ),
            array( 'fa-solid fa-umbrella' => 'Umbrella (protection,rain,storm,wet)' ),
            array( 'fa-solid fa-water' => 'Water (lake,liquid,ocean,sea,swim,wet)' ),
            array( 'fa-solid fa-wind' => 'Wind (air,blow,breeze,fall,seasonal,weather)' ),
        ),
        'Winter' => array(
            array( 'fa-solid fa-glass-whiskey' => 'Glass Whiskey (alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)' ),
            array( 'fa-solid fa-icicles' => 'Icicles (cold,frozen,hanging,ice,seasonal,sharp)' ),
            array( 'fa-solid fa-igloo' => 'Igloo (dome,dwelling,eskimo,home,house,ice,snow)' ),
            array( 'fa-solid fa-mitten' => 'Mitten (clothing,cold,glove,hands,knitted,seasonal,warmth)' ),
            array( 'fa-solid fa-skating' => 'Skating (activity,figure skating,fitness,ice,person,winter)' ),
            array( 'fa-solid fa-skiing' => 'Skiing (activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)' ),
            array( 'fa-solid fa-skiing-nordic' => 'Skiing Nordic (activity,cross country,fitness,outdoors,person,seasonal)' ),
            array( 'fa-solid fa-snowboarding' => 'Snowboarding (activity,fitness,olympics,outdoors,person)' ),
            array( 'fa-solid fa-snowplow' => 'Snowplow (clean up,cold,road,storm,winter)' ),
            array( 'fa-solid fa-tram' => 'Tram (crossing,machine,mountains,seasonal,transportation)' ),
        ),
        'Writing' => array(
            array( 'fa-solid fa-archive' => 'Archive (box,package,save,storage)' ),
            array( 'fa-solid fa-blog' => 'Blog (journal,log,online,personal,post,web 2.0,wordpress,writing)' ),
            array( 'fa-solid fa-book' => 'book (diary,documentation,journal,library,read)' ),
            array( 'fa-solid fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-regular fa-bookmark' => 'bookmark (favorite,marker,read,remember,save)' ),
            array( 'fa-solid fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-regular fa-edit' => 'Edit (edit,pen,pencil,update,write)' ),
            array( 'fa-solid fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope' => 'Envelope (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-regular fa-envelope-open' => 'Envelope Open (e-mail,email,letter,mail,message,notification,support)' ),
            array( 'fa-solid fa-eraser' => 'eraser (art,delete,remove,rubber)' ),
            array( 'fa-solid fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-regular fa-file' => 'File (document,new,page,pdf,resume)' ),
            array( 'fa-solid fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-regular fa-file-alt' => 'Alternate File (document,file-text,invoice,new,page,pdf)' ),
            array( 'fa-solid fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-regular fa-folder' => 'Folder (archive,directory,document,file)' ),
            array( 'fa-solid fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-regular fa-folder-open' => 'Folder Open (archive,directory,document,empty,file,new)' ),
            array( 'fa-solid fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-regular fa-keyboard' => 'Keyboard (accessory,edit,input,text,type,write)' ),
            array( 'fa-solid fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-regular fa-newspaper' => 'Newspaper (article,editorial,headline,journal,journalism,news,press)' ),
            array( 'fa-solid fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-regular fa-paper-plane' => 'Paper Plane (air,float,fold,mail,paper,send)' ),
            array( 'fa-solid fa-paperclip' => 'Paperclip (attach,attachment,connect,link)' ),
            array( 'fa-solid fa-paragraph' => 'paragraph (edit,format,text,writing)' ),
            array( 'fa-solid fa-pen' => 'Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-alt' => 'Alternate Pen (design,edit,update,write)' ),
            array( 'fa-solid fa-pen-square' => 'Pen Square (edit,pencil-square,update,write)' ),
            array( 'fa-solid fa-pencil-alt' => 'Alternate Pencil (design,edit,pencil,update,write)' ),
            array( 'fa-solid fa-quote-left' => 'quote-left (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-quote-right' => 'quote-right (mention,note,phrase,text,type)' ),
            array( 'fa-solid fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-regular fa-sticky-note' => 'Sticky Note (message,note,paper,reminder,sticker)' ),
            array( 'fa-solid fa-thumbtack' => 'Thumbtack (coordinates,location,marker,pin,thumb-tack)' ),
        ),
        'Other' => array(
            array( 'fa-solid fa-backspace' => 'Backspace (command,delete,erase,keyboard,undo)' ),
            array( 'fa-solid fa-blender-phone' => 'Blender Phone (appliance,cocktail,communication,fantasy,milkshake,mixer,puree,silly,smoothie)' ),
            array( 'fa-solid fa-crown' => 'Crown (award,favorite,king,queen,royal,tiara)' ),
            array( 'fa-solid fa-dumpster-fire' => 'Dumpster Fire (alley,bin,commercial,danger,dangerous,euphemism,flame,heat,hot,trash,waste)' ),
            array( 'fa-solid fa-file-csv' => 'File CSV (document,excel,numbers,spreadsheets,table)' ),
            array( 'fa-solid fa-network-wired' => 'Wired Network (computer,connect,ethernet,internet,intranet)' ),
            array( 'fa-solid fa-signature' => 'Signature (John Hancock,cursive,name,writing)' ),
            array( 'fa-solid fa-skull' => 'Skull (bones,skeleton,x-ray,yorick)' ),
            array( 'fa-solid fa-vr-cardboard' => 'Cardboard VR (3d,augment,google,reality,virtual)' ),
            array( 'fa-solid fa-weight-hanging' => 'Hanging Weight (anvil,heavy,measurement)' ),
        ),
    );

    return array_merge( $icons, $fontawesome_icons );
}
add_filter( 'vc_iconpicker-type-fontawesome', 'ut_iconpicker_type_fontawesome' );

function ut_unset_vc_fontawesome_icons() {
    remove_filter( 'vc_iconpicker-type-fontawesome', 'vc_iconpicker_type_fontawesome' );
}
add_action( 'admin_init', 'ut_unset_vc_fontawesome_icons' );