
/*!
 * PerfectMasonry extension for Isotope
 *
 * Does similar things as the Isotopes "masonry" layoutmode, except that this one will actually go back and plug the holes
 * left by bigger elements, thus making a perfect brick wall. Profit!
 * 
 * Usage:
 * 	$('#grid').isotope({
 * 		layoutMode: 'perfectMasonry',
 *		perfectMasonry: {
 *			layout: 'horizontal',		// Set layout as vertical/horizontal (default: vertical)
 *			columnWidth: 200,			// Set/Prefer columns to x wide (default: width of first tile)
 *			rowHeight: 200,				// Set/Prefer rows to y high (default: height of first tile)
 * 
 *			liquid: true,				// Set layout as liquid (default: false)
 *			cols: 3,					// Force to have x columns (default: null)
 *			rows: 3,					// Force to have y rows (default: null)
 *			minCols: 3,					// Set min col count (default: 1)
 *			minRows: 3,					// Set min row count (default: 1)
 *			maxCols: 5,					// Set max col count (default: 9999)
 *			maxRows: 4					// Set max row count (default: 9999)
 * 		}
 * 	});
 *
 * 
 * @author Mikko Tikkanen, Zonear Ltd. <contact@zonear.com>
 */
(function(e,g){var b="1.2.1";var c=null,a=null,f=null,d=true;e.extend(e.Isotope.prototype,{_perfectMasonryReset:function(){var l=this.options.perfectMasonry.layout!="horizontal",m=this.options.perfectMasonry.liquid==true;if(d){d=false;c=this;a=e(this.element.context);f=a.parent();this.options.perfectMasonry.minCols=this.options.perfectMasonry.minCols||1;this.options.perfectMasonry.minRows=this.options.perfectMasonry.minRows||1;this.options.perfectMasonry.maxCols=this.options.perfectMasonry.maxCols||9999;this.options.perfectMasonry.maxRows=this.options.perfectMasonry.maxRows||9999}if(m&&e._data(window,"events").smartresize){e(window).off("smartresize.isotope");e(window).on("resize.isotope.perfectmasonry",function(){if(!a.hasClass("isotope")){return}a.isotope("reLayout")})}var i=this.perfectMasonry={};this._getSegments();this._getSegments(true);this._perfectMasonryGetSegments();if(m){var j=f.width(),h=f.height();this.options.perfectMasonry.columnWidth=this.options.perfectMasonry.columnWidth||i.columnWidth;this.options.perfectMasonry.rowHeight=this.options.perfectMasonry.rowHeight||i.rowHeight;i.cols=this.options.perfectMasonry.cols||Math.floor(j/this.options.perfectMasonry.columnWidth);i.rows=this.options.perfectMasonry.rows||Math.floor(h/this.options.perfectMasonry.rowHeight);i.cols=Math.min(Math.max(i.cols,this.options.perfectMasonry.minCols),this.options.perfectMasonry.maxCols);i.rows=Math.min(Math.max(i.rows,this.options.perfectMasonry.minRows),this.options.perfectMasonry.maxRows);var k=(l?i.columnWidth/(j/i.cols):i.rowHeight/(h/i.rows));i.columnWidth=Math.floor(i.columnWidth/k);i.rowHeight=Math.floor(i.rowHeight/k)}i.grid=new Array(this.perfectMasonry.cols);i.containerHeight=0;i.containerWidth=0},_perfectMasonryLayout:function(l){var h=this,i=this.perfectMasonry,j=h.options.perfectMasonry.layout!="horizontal",k=h.options.perfectMasonry.liquid==true;i.grid=new Array(i[(j?"cols":"rows")]);l.each(function(){var s=e(this);var p=(k?s.data("colSpan"):Math.ceil(s.outerWidth()/(i.columnWidth+1))),t=(k?s.data("rowSpan"):Math.ceil(s.outerHeight()/(i.rowHeight+1)));if(!p){p=Math.ceil(s.outerWidth(true)/(i.columnWidth+1));t=Math.ceil(s.outerHeight(true)/(i.rowHeight+1));s.data("colSpan",p);s.data("rowSpan",t)}var w=(j?p:t);var r=(j?t:p);var z=Math.max((j?i.cols-p:i.rows-t)+1,1);var A=-1,B=0,v=0;while(++A<10000){i.grid[A]=i.grid[A]||[];for(var u=0;u<z;u++){var q=i.grid[A][u];if(q){continue}var m=true;if(p>1||t>1){for(var o=0;o<w;o++){for(var n=0;n<r;n++){i.grid[A+n]=i.grid[A+n]||[];if(i.grid[A+n][u+o]){m=false;break}}if(!m){break}}}if(!m){continue}for(var o=0;o<w;o++){for(var n=0;n<r;n++){i.grid[A+n][u+o]=true}}var B=A,v=u;if(j){var B=u,v=A}i.containerWidth=Math.max(i.containerWidth,(B+w)*i.columnWidth);i.containerHeight=Math.max(i.containerHeight,(v+r)*i.rowHeight);if(h.options.perfectMasonry.liquid==true){s.css({width:i.columnWidth*p,height:i.rowHeight*t})}h._pushPosition(s,B*i.columnWidth,v*i.rowHeight);return}}h._pushPosition(s,-9999,-9999)})},_perfectMasonryGetContainerSize:function(){return{width:this.perfectMasonry.containerWidth,height:this.perfectMasonry.containerHeight}},_perfectMasonryResizeChanged:function(){var h=this.perfectMasonry;var j=h.cols,i=h.rows;this._perfectMasonryGetSegments();if(this.options.perfectMasonry.layout=="horizontal"&&i!==h.rows){return true}if(j!==h.cols){return true}return false},_perfectMasonryGetSegments:function(){var i=this.perfectMasonry;var k=this.options.perfectMasonry.parent||this.element.parent();var j=k.width();i.cols=Math.floor(j/i.columnWidth)||1;var h=k.height();i.rows=Math.floor(h/i.rowHeight)||1}})})(jQuery);