<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://themify.me/
 * @since      1.0.0
 *
 * @package    Tbp
 * @subpackage Tbp/admin/partials
 */

$themes = self::prepare_themes_for_js();
$message = 'Themes';
// Plupload
if(current_user_can('upload_files') ) {
	wp_enqueue_media();
}
$canInstall=current_user_can( 'manage_options' );
$canEdit=current_user_can( 'edit_theme_options' );
$canSwitch=current_user_can( 'switch_themes' );
$canDelete=current_user_can( 'delete_themes' );
$count = count( $themes );
?>

<div class="wrap">
	
	<h2><?php _e( 'Themes', 'tbp'); ?>
		<span class="title-count theme-count"><?php echo $count; ?></span>
		<?php if($canInstall):?>
		    <div id="placeholder_pointer_add_new_theme" style="display: inline-block;position: relative;">
		    	<button class="page-title-action"><?php _e('Add New', 'tbp') ?></button>
		    </div>
		<?php elseif(defined('DISALLOW_FILE_MODS') && DISALLOW_FILE_MODS):?>
		    <div class="notice notice-warning"><p><?php _e("Can't add themes because 'DISALLOW_FILE_MODS' is defined on your WordPress config file 'wp-config.php'",'tbp')?></p></div>
		<?php endif;?>
		<div id="placeholder_pointer_theme_activated" style="position: relative;display: inline-block;">
			<a class="add-new-h2" href="<?php echo admin_url( 'edit.php?post_type='.Tbp_Templates::SLUG ); ?>"><?php _e('Go to Templates', 'tbp') ?></a>
		</div>
	</h2>

	<div class="theme-browser rendered tbp_theme_browser">
		<div class="tbp_themes">
			<?php
			/*
			 * This PHP is synchronized with the tmpl-theme template below!
			 */

			foreach ( $themes as $theme ) :?>
			<div class="theme tbp_theme<?php if ( $theme['active'] ) echo ' active'; ?>" tabindex="0">
				<div class="tb_more_details" data-id="<?php echo $theme['theme_id']; ?>">
				    <?php if ( ! empty( $theme['screenshot'][0] ) ) { ?>
					    <div class="theme-screenshot">
						<img loading="lazy" decode="async" src="<?php echo $theme['screenshot'][0]; ?>" alt="<?php echo $theme['name']; ?>" />
					    </div>
				    <?php } else { ?>
					    <div class="theme-screenshot blank"></div>
				    <?php } ?>

				    <span class="more-details"><?php _e( 'Theme Details','tbp'); ?></span>
				</div>
				<div class="theme-id-container">
				    <h3 class="theme-name">
					<?php if ( $theme['active'] ):?>
					    <span><?php _e( 'Active:','tbp'); ?></span>
					<?php endif;?>
					<?php echo $theme['name']; ?>
				    </h3>
				    <div class="theme-actions">
				    <?php if($canSwitch ):?>
					<?php if ( $theme['active'] ): ?>
					    <a href="<?php echo $theme['actions']['deactivate']; ?>" class="button button-secondary"><?php _e( 'Deactivate', 'tbp'); ?></a>
					<?php else:?>
					    <a class="button button-secondary" href="<?php echo $theme['actions']['activate']; ?>"><?php _e( 'Activate', 'tbp'); ?></a>
					<?php endif;?>
				    <?php endif;?>
				    <?php if($canEdit):?>
					<a class="button button-primary tbp_lightbox_edit" href="#" data-post-id="<?php echo $theme['theme_id']; ?>"><?php _e( 'Edit', 'tbp'); ?></a>
				    <?php endif?>
				    </div>
				</div>
				<?php if ( $theme['hasUpdate'] ): ?>
					<div class="theme-update"><?php _e( 'Update Available','tbp' ); ?></div>
				<?php endif; ?>
			</div>
			<?php endforeach; ?>
			<?php if($canInstall):?>
			    <div class="theme add-new-theme">
				<a href="#" class="tbp_lightbox_edit">
				<div class="theme-screenshot"><span></span></div>
				<h3 class="theme-name"><?php _e('Add New Theme','tbp')?></h3></a>
			    </div>
			<?php endif;?>
			<br class="clear" />		
		</div>
		<!-- /themes -->
	</div>
	<!-- /theme-browser -->
	<div class="theme-overlay"></div>
	<p class="no-themes"><?php _e( 'No themes found. Try a different search.','tbp' ); ?></p>
</div>

<script id="tmpl-tbp-theme-single" type="text/template">
	<div class="theme-backdrop"></div>
	<div class="theme-wrap">
		<div class="theme-header">
			<button class="left dashicons dashicons-no<# if ( !data.prev ) { #> disabled<#}#>"><span class="screen-reader-text"><?php _e( 'Show previous theme','tbp' ); ?></span></button>
			<button class="right dashicons dashicons-no<# if ( !data.next ) { #> disabled<#}#>"><span class="screen-reader-text"><?php _e( 'Show next theme','tbp' ); ?></span></button>
			<button class="close dashicons dashicons-no"><span class="screen-reader-text"><?php _e( 'Close overlay','tbp' ); ?></span></button>
		</div>
		<div class="theme-about">
			<div class="theme-screenshots">
			<# if ( data.screenshot[0] ) { #>
				<div class="screenshot"><img src="{{ data.screenshot[0] }}" alt="{{data.name }}" /></div>
			<# } else { #>
				<div class="screenshot blank"></div>
			<# } #>
			</div>

			<div class="theme-info">
				<# if ( data.active ) { #>
					<span class="current-label"><?php _e( 'Current Theme','tbp' ); ?></span>
				<# } #>
				<h3 class="theme-name">{{{ data.name }}}<span class="theme-version"><?php printf( __( 'Version: %s','tbp' ), '{{ data.version }}' ); ?></span></h3>
				<h4 class="theme-author"><?php printf( __( 'By %s','tbp' ), '{{{ data.authorAndUri }}}' ); ?></h4>

				<# if ( data.hasUpdate ) { #>
				<div class="theme-update-message">
					<h4 class="theme-update"><?php _e( 'Update Available','tbp' ); ?></h4>
					{{{ data.update }}}
				</div>
				<# } #>
				<p class="theme-description">{{{ data.description }}}</p>
			</div>
		</div>

		<div class="theme-actions">
			<?php if($canSwitch ):?>
			     <# if (!data.active && data.actions.activate ) { #>
				     <a href="{{{ data.actions.activate }}}" class="button button-secondary"><?php _e( 'Activate','tbp'); ?></a>
			     <# } #>
			 <?php endif;?>
			<?php if($canEdit ):?>
			    <a class="button button-primary tbp_lightbox_edit" href="#" data-post-id="{{{ data.theme_id }}}"><?php _e( 'Edit', 'tbp'); ?></a>
			    <# if ( data.actions.export ) { #>
				    <a href="{{{ data.actions.export }}}" data-post-id="{{data.theme_id}}" class="button button-secondary tbp_export"><?php _e( 'Export', 'tbp'); ?></a>
			    <# } #>
			<?php endif;?>
			<?php if($canSwitch ):?>
			    <# if ( data.active ) { #>
				    <a href="{{{ data.actions.deactivate }}}" class="button button-secondary"><?php _e( 'Deactivate', 'tbp'); ?></a>
			    <# } #>
			<?php endif;?>
			<?php if($canDelete):?>
			    <# if ( ! data.active && data.actions['delete'] ) { #>
				    <a href="{{{ data.actions['delete'] }}}" class="button button-secondary delete-theme"><?php _e( 'Delete','tbp'); ?></a>
			    <# } #>
			<?php endif;?>
			<a class="button button-secondary tbp_erase_demo" href="<?php echo add_query_arg( 'tbp_erase_demo', 1 ); ?>"><?php _e( 'Erase Demo', 'tbp'); ?></a>
		</div>
	</div>
</script>
