<?php
/**
 * @package    Themify Builder Pro
 * @link       https://themify.me/
 */
class Tbp_Dynamic_Item_PTBSelectClass extends Tbp_Dynamic_Item {

	public static function is_available():bool {
		return class_exists( 'Themify_Builder_Plugin_Compat_ptb',false );
	}

	public static function get_category():string {
		return 'ptb';
	}

	public static function get_type():array {
		return array( 'custom_css' );
	}

	public static function get_label():string {
		return __( 'PTB (Select)', 'tbp' );
	}

	public static function get_value(array $args = array()):?string {
		$value = '';
		if ( ! empty( $args['field'] ) ) {
			list( $post_type, $field_name ) = explode( ':', $args['field'] );
			$cf_value = get_post_meta( $args['post_id'] ?? get_the_ID(), "ptb_{$field_name}", true );
            if ( ! empty( $cf_value ) ) {
                $value = join( ' ', array_filter( (array) $cf_value ) );
            }
		}

		return $value;
	}

	public static function get_options():array {
		return array(
			array(
				'label' => 'tbp_f',
				'id' => 'field',
				'type' => 'select',
				'dataset' => 'ptb_fields',
                'dataset_args' => [ 'type' => [ 'select' ] ]
			),
		);
	}
}