<?php
/**
 * Auto-loads the required dependencies for this plugin.
 *
 * @link       https://themehigh.com
 * @since      2.9.0
 *
 * @package    woocommerce-checkout-field-editor-pro
 * @subpackage woocommerce-checkout-field-editor-pro/includes
 */
if(!defined('WPINC')){	die; }

if(!class_exists('THWCFE_Autoloader')):

class THWCFE_Autoloader {
	private $include_path = '';

	private $compatibility_classes = array(
			'wcfe_checkout_fields_export_handler',
			'wcfe_wc_api_handler',
			'wcfe_wc_pdf_invoices_packing_slips_handler',
			'wcfe_wc_zapier_handler',
		);
	
	private $class_path = array(
				//'wcfe_settings' => 'classes/class-wcfe-settings.php',
				'wcfe_checkout_fields_utils' => 'classes/fe/class-wcfe-checkout-field-editor-utils.php',
				/*'classes/fe/rules/class-wcfe-condition.php',
				'classes/fe/rules/class-wcfe-condition-set.php',
				'classes/fe/rules/class-wcfe-rule.php',
				'classes/fe/rules/class-wcfe-rule-set.php',
				'classes/fe/class-wcfe-section.php',
				'classes/fe/fields/class-wcfe-field.php',
				'classes/fe/fields/class-wcfe-field-inputtext.php',
				'classes/fe/fields/class-wcfe-field-hidden.php',
				'classes/fe/fields/class-wcfe-field-password.php',
				'classes/fe/fields/class-wcfe-field-textarea.php',				
				'classes/fe/fields/class-wcfe-field-select.php',
				'classes/fe/fields/class-wcfe-field-multiselect.php',
				'classes/fe/fields/class-wcfe-field-radio.php',
				'classes/fe/fields/class-wcfe-field-checkbox.php',
				'classes/fe/fields/class-wcfe-field-checkboxgroup.php',
				'classes/fe/fields/class-wcfe-field-datepicker.php',
				'classes/fe/fields/class-wcfe-field-timepicker.php',
				'classes/fe/fields/class-wcfe-field-file.php',
				'classes/fe/fields/class-wcfe-field-heading.php',
				'classes/fe/fields/class-wcfe-field-label.php',
				'classes/fe/fields/class-wcfe-field-country.php',
				'classes/fe/fields/class-wcfe-field-email.php',
				'classes/fe/fields/class-wcfe-field-state.php',
				'classes/fe/fields/class-wcfe-field-city.php',
				'classes/fe/fields/class-wcfe-field-tel.php',
				'classes/fe/fields/class-wcfe-field-factory.php',
				'classes/fe/utils/class-wcfe-utils-common.php',
				'classes/fe/utils/class-wcfe-utils-field.php',
				'classes/fe/utils/class-wcfe-utils-section.php',
				'classes/fe/utils/class-wcfe-utils-condition.php',*/
				
				//'wcfe_checkout_fields_admin_utils' => 'classes/fe/class-wcfe-checkout-field-editor-utils-admin.php',
				//'classes/includes/class-wcfe-install.php',
				//'wcfe_settings_page' => 'classes/class-wcfe-settings-page.php',
				//'wcfe_license_settings' => 'classes/class-wcfe-license-settings.php',
				//'wcfe_checkout_field_editor_settings' => 'classes/fe/class-wcfe-checkout-field-editor-settings.php',
				//'wcfe_checkout_field_editor_advanced_settings' => 'classes/fe/class-wcfe-checkout-field-editor-settings-advanced.php',
				
				//'' => 'classes/fe/class-wcfe-checkout-field-editor-frontend.php',
			);
	
	/*private $class_path = array(
				'wepo_condition' => 'includes/model/rules/class-wepo-condition.php',
				'wepo_condition_set' => 'includes/model/rules/class-wepo-condition-set.php',
				'wepo_condition_rule' => 'includes/model/rules/class-wepo-rule.php',
				'wepo_condition_rule_set' => 'includes/model/rules/class-wepo-rule-set.php',
				
				'wepo_product_page_section' => 'includes/model/class-wepo-section.php',
				'wepo_product_field' => 'includes/model/fields/class-wepo-field.php',
				'wepo_product_field_inputtext' => 'includes/model/fields/class-wepo-field-inputtext.php',
				'wepo_product_field_hidden' => 'includes/model/fields/class-wepo-field-hidden.php',
				'wepo_product_field_password' => 'includes/model/fields/class-wepo-field-password.php',
				'wepo_product_field_textarea' => 'includes/model/fields/class-wepo-field-textarea.php',				
				'wepo_product_field_select' => 'includes/model/fields/class-wepo-field-select.php',
				'wepo_product_field_multiselect' => 'includes/model/fields/class-wepo-field-multiselect.php',
				'wepo_product_field_radio' => 'includes/model/fields/class-wepo-field-radio.php',
				'wepo_product_field_checkbox' => 'includes/model/fields/class-wepo-field-checkbox.php',
				'wepo_product_field_checkboxgroup' => 'includes/model/fields/class-wepo-field-checkboxgroup.php',
				'wepo_product_field_datepicker' => 'includes/model/fields/class-wepo-field-datepicker.php',
				'wepo_product_field_timepicker' => 'includes/model/fields/class-wepo-field-timepicker.php',
				'wepo_product_field_heading' => 'includes/model/fields/class-wepo-field-heading.php',
				'wepo_product_field_label' => 'includes/model/fields/class-wepo-field-label.php',
		);*/
	
	public function __construct() {
		$this->include_path = untrailingslashit(THWCFE_PATH);
		
		if(function_exists("__autoload")){
			spl_autoload_register("__autoload");
		}
		spl_autoload_register(array($this, 'autoload'));
	}

	/** Include a class file. */
	private function load_file( $path ) {
		if ( $path && is_readable( $path ) ) {
			require_once( $path );
			return true;
		}
		return false;
	}
	
	/** Class name to file name. */
	private function get_file_name_from_class( $class ) {
		return 'class-' . str_replace( '_', '-', $class ) . '.php';
	}
	
	public function autoload( $class ) {
		$class = strtolower( $class );
		$file  = $this->get_file_name_from_class( $class );
		$path  = '';
		$file_path  = '';

		if(isset($this->class_path[$class])){
			$file_path = $this->include_path . '/' . $this->class_path[$class];

		} elseif (in_array($class, $this->compatibility_classes)){
			$path = $this->include_path . '/includes/compatibility/';
			$file_path = $path . $file;

		} else {
			if (strpos($class, 'thwcfe_admin') === 0){
				$path = $this->include_path . '/admin/';

			} elseif (strpos($class, 'thwcfe_public') === 0){
				$path = $this->include_path . '/public/';

			} elseif (strpos($class, 'thwcfe_utils') === 0){
				$path = $this->include_path . '/includes/utils/';

			} elseif (strpos($class, 'wcfe_checkout_field') === 0){
				$path = $this->include_path . '/includes/model/fields/';

			} elseif (strpos($class, 'wcfe_condition') === 0){
				$path = $this->include_path . '/includes/model/rules/';

			} elseif (strpos($class, 'wcfe_checkout_section') === 0){
				$path = $this->include_path . '/includes/model/';

			} elseif (strpos($class, 'thwcfe_block') === 0){
				$path = $this->include_path . '/block/';
			} else{
				$path = $this->include_path . '/includes/';
			}
			$file_path = $path . $file;
		}
		
		if( empty($file_path) || (!$this->load_file($file_path) && strpos($class, 'thwcfe_') === 0) ) {
			$this->load_file( $this->include_path . $file );
		}
	}
}

endif;

new THWCFE_Autoloader();
