<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_Function_PRO')) {
		class WBTM_Function_PRO {
			public function __construct() {
				add_action('wbtm_order_status_change', array($this, 'order_status_changed'), 10, 4);
			}
			public function order_status_changed( $order_status, $post_id, $order_id ) {

				$email_status = WBTM_Global_Function::get_settings( 'wbtm_email_settings', 'pdf_email_status', array('processing','completed') );

				if ( get_post_type( $post_id ) == WBTM_Functions::get_cpt() && sizeof($email_status)>0) {
					if ( in_array( $order_status, $email_status ) ) {
						do_action( 'wbtm_send_mail', $order_id );
					}
				}
			}
			public static function order_item_data($order_id) {
				$args['wbtm_order_id'] = $order_id;
				$guest_query = self::attendee_query($args);
				$attendees = $guest_query->posts;
				$all_data = [];
				foreach ($attendees as $attendee) {
					$ticket_id = $attendee->ID;
					$item_id = WBTM_Global_Function::get_post_info($ticket_id, 'wbtm_item_id');
					if ($item_id) {
						$all_data[$item_id][] = $ticket_id;
					}else{
						$all_data[]=$ticket_id;
					}
				}
				wp_reset_postdata();
				return $all_data;
			}
			public static function attendee_query($filter_args = array(), $show = -1, $page = 1): WP_Query {
				$seat_booked_status = WBTM_Global_Function::get_settings('wbtm_general_settings', 'set_book_status', array('processing', 'completed'));
				
				// Build meta query
				$meta_conditions = array();
				
				// Add conditions for each filter
				if (!empty($filter_args['wbtm_bus_id']) && $filter_args['wbtm_bus_id'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_bus_id',
						'value' => $filter_args['wbtm_bus_id'],
						'compare' => '='
					);
				}
				
				if (!empty($filter_args['wbtm_booking_date']) && $filter_args['wbtm_booking_date'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_booking_date',
						'value' => date('Y-m-d', strtotime($filter_args['wbtm_booking_date'])),
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_start_time']) && $filter_args['wbtm_start_time'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_start_time',
						'value' => date('Y-m-d', strtotime($filter_args['wbtm_start_time'])),
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_boarding_time']) && $filter_args['wbtm_boarding_time'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_boarding_time',
						'value' => date('Y-m-d', strtotime($filter_args['wbtm_boarding_time'])),
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_boarding_point']) && $filter_args['wbtm_boarding_point'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_boarding_point',
						'value' => $filter_args['wbtm_boarding_point'],
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_dropping_point']) && $filter_args['wbtm_dropping_point'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_dropping_point',
						'value' => $filter_args['wbtm_dropping_point'],
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_order_id']) && $filter_args['wbtm_order_id'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_order_id',
						'value' => $filter_args['wbtm_order_id'],
						'compare' => '='
					);
				}
				
				if (!empty($filter_args['wbtm_user_name']) && $filter_args['wbtm_user_name'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_user_name',
						'value' => $filter_args['wbtm_user_name'],
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_user_email']) && $filter_args['wbtm_user_email'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_user_email',
						'value' => $filter_args['wbtm_user_email'],
						'compare' => 'LIKE'
					);
				}
				
				if (!empty($filter_args['wbtm_user_phone']) && $filter_args['wbtm_user_phone'] !== ' ') {
					$meta_conditions[] = array(
						'key' => 'wbtm_user_phone',
						'value' => $filter_args['wbtm_user_phone'],
						'compare' => 'LIKE'
					);
				}
				
				// Add order status condition
				$meta_conditions[] = array(
					'relation' => 'OR',
					array(
						'key' => 'wbtm_order_status',
						'value' => 'partially-paid',
						'compare' => '='
					),
					array(
						'key' => 'wbtm_order_status',
						'value' => $seat_booked_status,
						'compare' => 'IN'
					)
				);
				
				$args = array(
					'post_type' => 'wbtm_bus_booking',
					'posts_per_page' => intval($show),
					'paged' => max(1, intval($page)),
					'meta_query' => array(
						'relation' => 'AND',
						$meta_conditions
					)
				);
				
				return new WP_Query($args);
			}
			public static function get_extra_bag_info($post_id) {
				$ex_bag_infos = WBTM_Global_Function::get_post_info($post_id, 'wbtm_ex_bag_info', []);
				if (sizeof($ex_bag_infos) < 1) {
					$ex_bag_infos = [
						'max_qty' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_extra_max_qty'),
						'price' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_extra_bag_price'),
						'field_label' => esc_html__('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'),
						'active' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_user_extra_bag'),
					];
					delete_post_meta($post_id, 'wbtm_extra_max_qty');
					delete_post_meta($post_id, 'wbtm_extra_bag_price');
					delete_post_meta($post_id, 'wbtm_user_extra_bag');
					update_post_meta($post_id, 'wbtm_ex_bag_info', $ex_bag_infos);
				}
				return $ex_bag_infos;
			}
			public static function get_attendee_info($attendee_id) {
				
				$attendee_data = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_attendee_info', []);
				
				if (is_array($attendee_data) && sizeof($attendee_data) == 0) {
					
					$user_additional = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_additional', []);
					$attendee_infos = WBTM_Attendee_form::default_form();
					if (sizeof($attendee_infos) > 0) {
						foreach ($attendee_infos as $form) {
							$name = array_key_exists('field_id', $form) ? $form['field_id'] : '';
							$attendee_data = WBTM_Global_Function::get_post_info($attendee_id, $name);
							
							if ($attendee_data) {
								$label = array_key_exists('field_label', $form) ? $form['field_label'] : $form['d_label'];
								$user_additional[] = [
									'name' => $label,
									'value' => $attendee_data,
								];
							}
						}
						$extra_bag = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_bag_qty');
						if ($extra_bag > 0) {
							$user_additional[] = [
								'name' => esc_html__('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'),
								'value' => $extra_bag,
							];
						}
					}
					update_post_meta($attendee_id, 'wbtm_attendee_info', $user_additional);
					$attendee_data = $user_additional;
					
				}
				
				return $attendee_data;
			}
		}
		new WBTM_Function_PRO();
	}