<?php
/*
	* @Author 		engr.sumonazma@gmail.com
	* Copyright: 	mage-people.com
	*/
if (!defined('ABSPATH')) {
	die;
} // Cannot access pages directly.
if (!class_exists('WBTM_Passenger_List')) {
	class WBTM_Passenger_List
	{
		public function __construct()
		{
			add_action('admin_menu', array($this, 'passenger_menu'));
			add_action('wbtm_passenger_info_header', array($this, 'wbtm_passenger_info_header'));
			add_action('wbtm_passenger_info_column', array($this, 'wbtm_passenger_info_column'), 10, 2);
			/**********************************/
			add_action('wp_ajax_get_wbtm_passenger_filter_result', array($this, 'get_wbtm_passenger_filter_result'));
			add_action('wp_ajax_nopriv_get_wbtm_passenger_filter_result', array($this, 'get_wbtm_passenger_filter_result'));
			/*********************************************/
			add_action('wp_ajax_wbtm_delete_attendee', array($this, 'wbtm_delete_attendee'));
			add_action('wp_ajax_nopriv_wbtm_delete_attendee', array($this, 'wbtm_delete_attendee'));
			/*********************************************/
		}
		public static function wbtm_passenger_info_header_array($bus_id)
		{
			$passenger_infos = get_post_meta($bus_id, 'wbtm_attendee_info', true);
			$custom_passenger_infos = get_post_meta($bus_id, 'wbtm_custom_attendee_info', true);
			$passenger_infos = is_array($passenger_infos) ? $passenger_infos : array();
			$custom_passenger_infos = is_array($custom_passenger_infos) ? $custom_passenger_infos : array();
			$headers = array();
			foreach ($passenger_infos as $passenger_info) {
				if (is_array($passenger_info) && array_key_exists('field_id', $passenger_info)) {
					$headers[$passenger_info['field_id']] = $passenger_info;
				}
			}
			foreach ($custom_passenger_infos as $passenger_info) {
				if (is_array($passenger_info) && array_key_exists('field_id', $passenger_info)) {
					$headers[$passenger_info['field_id']] = $passenger_info;
				}
			}
			return $headers;
		}
		public static function wbtm_passenger_info_header($bus_id)
		{
			$passenger_infos = self::wbtm_passenger_info_header_array($bus_id);
			if (is_array($passenger_infos)) {
				foreach ($passenger_infos as $key => $passenger_info) {
					unset($field_label);
					$field_label = (is_array($passenger_info) && array_key_exists('field_label', $passenger_info) && empty($passenger_info['field_label'])) ? $passenger_info['d_label'] : $passenger_info['field_label'];
					if (array_key_exists('active', $passenger_info) && $passenger_info['active'] == 1) {
?>
						<th class="textLeft"><?php echo esc_html($field_label); ?></th>
					<?php
					}
				}
			}
		}
		public static function wbtm_passenger_info_column($attendee_id, $bus_id)
		{
			$headers = self::wbtm_passenger_info_header_array($bus_id);
			$passenger_infos = WBTM_Function_PRO::get_attendee_info($attendee_id);
			if (is_array($headers)) {
				foreach ($headers as $key => $header) {
					if (is_array($header) && (array_key_exists('active', $header) && $header['active'] == 1) && array_key_exists($key, $passenger_infos)) {
					?>
						<td class="textCenter"><?php echo esc_html($passenger_infos[$key]['value']); ?></td>
					<?php
					} else if (is_array($header) && (array_key_exists('active', $header) && $header['active'] == 1) && !array_key_exists($key, $passenger_infos)) {
					?>
						<td class="textCenter"></td>
					<?php
					} else if (is_array($header) && (array_key_exists('active', $header) && $header['active'] != 1)) {
					?>
			<?php
					}
				}
			}
		}
		public static function get_passenger_info($passenger_infos, $key)
		{
			if (is_array($passenger_infos) && array_key_exists($key, $passenger_infos) && array_key_exists('value', $passenger_infos[$key])) {
				return $passenger_infos[$key]['value'];
			} else {
				return "";
			}
		}
		public static function extra_service($attendee_id)
		{
			$extra_service = "";
			$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
			if (sizeof($ex_service_infos) > 0) {
				$count = count($ex_service_infos);
				foreach ($ex_service_infos as $key => $ex_service_info) {
					$name = $ex_service_info['name'];
					$price = $ex_service_info['price'];
					$qty = $ex_service_info['qty'];
					if ($key == ($count - 1)) {
						$extra_service .= $name . ' x ' . $qty;
					} else {
						$extra_service .= $name . ' x ' . $qty . " , ";
					}
					$count++;
				}
				return $extra_service;
			} else {
				return "";
			}
		}
		public function passenger_menu()
		{
			$cpt = WBTM_Functions::get_cpt();
			add_submenu_page('edit.php?post_type=' . $cpt, esc_html__('Passenger List', 'addon-bus--ticket-booking-with-seat-pro'), esc_html__('Passenger List', 'addon-bus--ticket-booking-with-seat-pro'), 'manage_options', 'wbtm_passenger_list', array($this, 'passenger_filter'));
		}
		public function passenger_filter()
		{
			?>
			<div class="wrap">
				<div class="wbtm_style wbtm_passenger_filter_area wbtm_admin_page">
					<?php $this->filter_selection(); ?>
					<?php //echo '<pre>';print_r(get_post_types());echo '</pre>'; 
					?>
					<div class="wbtm_filter_result" id="wbtm_passenger_list_result">
						<?php $this->passenger_filter_result(); ?>
					</div>
				</div>
			</div>
			<style>
				div.notice,
				#update-nag,
				.update-nag {
					display: none;
				}
			</style>
		<?php
		}
		public function filter_selection()
		{
			$label = WBTM_Functions::get_name();
		?>
			<div class="_dLayout_pRelative placeholder_area">
				<h4 class="title_on_border"><?php echo esc_html($label) . ' ' . esc_html__('Passenger Filter', 'addon-bus--ticket-booking-with-seat-pro'); ?></h4>
				<div class="wbtm_filter_form inputInline" data-placeholder>
					<div class="mpForm">
						<?php WBTM_Layout_Pro::select_bus(); ?>
						<?php WBTM_Layout_Pro::select_journey_date(); ?>
						<?php WBTM_Layout_Pro::select_order_date(); ?>
						<?php WBTM_Layout_Pro::select_bp_date(); ?>
						<?php WBTM_Layout_Pro::select_bp_point(); ?>
					</div>
					<div class="mpForm _mT_xs">
						<?php WBTM_Layout_Pro::select_order_id(); ?>
						<?php WBTM_Layout_Pro::select_passenger_name(); ?>
						<?php WBTM_Layout_Pro::select_passenger_email(); ?>
						<?php WBTM_Layout_Pro::select_passenger_phone(); ?>
						<div class="inputList">
							<div class="fdColumn justifyBetween fullHeight">
								<span>&nbsp;</span>
								<div class="buttonGroup flexEqual">
									<button class="_themeButton" type="button" id="get_wbtm_passenger_filter_result"><?php esc_html_e('Filter', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
									<button class="_warningButton" id="wbtm_filter_reset" type="button"><?php esc_html_e('Reset', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
		}
		public function passenger_filter_result()
		{
			$post_per_page = isset($_REQUEST['post_per_page']) ? WBTM_Global_Function::data_sanitize($_REQUEST['post_per_page']) : 20;
			$post_per_page = $post_per_page > 0 ? $post_per_page : 20;
			$filter_args = isset($_REQUEST['filter_args']) ? WBTM_Global_Function::data_sanitize($_REQUEST['filter_args']) : [];
			$bus_id = array_key_exists('wbtm_bus_id', $filter_args) ? $filter_args['wbtm_bus_id'] : 0;
			$page = isset($_REQUEST['page']) ? WBTM_Global_Function::data_sanitize($_REQUEST['page']) : 1;
			$all_passengers = WBTM_Function_PRO::attendee_query($filter_args, $post_per_page, $page);
			$total_passenger = $all_passengers->post_count;
		?>
			<div class="_dLayout_pRelative placeholder_area">
				<table class="_mb_layoutFixed passenger-table-header" data-placeholder>
					<thead>
						<tr>
							<th class="textLeft">
								<label class="alignCenter">
									<span class="pR"><?php _e('Passenger Per Page', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
									<input type="number" min="1" class="formControl pagination_input" name="post_per_page" value="<?php echo $post_per_page > 0 ? $post_per_page : 20; ?>" />
								</label>
							</th>
							<th class="textRight">
								<label class="mp_zero">
									<?php _e('Showing ', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<strong class="textTheme"><?php echo esc_html(min($post_per_page, $total_passenger)); ?></strong>
									<?php _e('of total ', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<strong class="textTheme"><?php echo esc_html($all_passengers->found_posts); ?></strong>
									<?php _e(' Passenger.', 'addon-bus--ticket-booking-with-seat-pro'); ?>
								</label>
							</th>
							<?php if ($bus_id > 0) { ?>
								<?php
								$download_url = WBTM_Pro_Pdf::get_pdf_url($filter_args);
								$default_args = array('action' => 'wbtm_download_csv', 'document_type' => 'csv', 'args' => $filter_args);
								$args = wp_parse_args($default_args);
								$build_url = http_build_query($args);
								$download_url_csv = wp_nonce_url(admin_url("admin-ajax.php?" . $build_url), 'wbtm_download_csv');
								?>
								<th>
									<div class="buttonGroup">
										<button class="_themeButton" type="button" title="<?php esc_attr_e('Download Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url); ?>">
											<span class="fas fa-file-pdf _mR_xs"></span>
											<?php esc_html_e('Download Passenger List', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										</button>
										<button type="button" class="_successButton_xs" data-href="<?php echo esc_attr($download_url_csv); ?>">
											<span class="fas fa-file-csv _mR_xs"></span>
											<?php esc_html_e('Download CSV', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										</button>
									</div>
								</th>
							<?php } ?>
						</tr>
					</thead>
				</table>
				<?php $this->passenger_list($all_passengers, $page); ?>
			</div>
			<?php
		}
		public function passenger_list($all_passengers, $page)
		{
			$total_passenger = $all_passengers ? $all_passengers->found_posts : 0;
			$page = $page ?? 1;
			if ($total_passenger > 0) {
				$active_page = (int)$page - 1;
				$active_page = max($active_page, 0);
				$post_per_page = $_REQUEST['post_per_page'] ?? 20;
				$post_per_page = $post_per_page > 0 ? $post_per_page : 20;
				$count = $active_page * $post_per_page + 1;
				$passenger_infos = $all_passengers->posts;
				$attendee_ids = [];
				foreach ($passenger_infos as $passenger) {
					$attendee_ids[] = $passenger->ID;
				}
				self::passenger_table($attendee_ids, $count);
			?>
				<?php
				$parameter = array("show" => $post_per_page, "pagination" => "yes", "pagination-style" => "ajax",);
				do_action('wbtm_pagination_section', $parameter, $total_passenger, $active_page);
				?>
				<input type="hidden" name="mp_total_item" value="<?php echo esc_attr($total_passenger); ?>" />
			<?php
			} else {
				WBTM_Layout::msg(esc_html__('No Record Found.', 'addon-bus--ticket-booking-with-seat-pro'));
			}
		}
		public static function ex_service_price($attendee_id){
			$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
				if (sizeof($ex_service_infos) > 0) {
					$total_ex_service_price = 0;
					foreach ($ex_service_infos as $ex_service_info) {
						$price = $ex_service_info['price'] * $ex_service_info['qty'];
						$total_ex_service_price = $total_ex_service_price + $price;
					}
					return $total_ex_service_price;
				}
		}
		public static function passenger_table($attendee_ids = [], $count = 1)
		{
			if (sizeof($attendee_ids) > 0) {
				$filter_args = isset($_REQUEST['filter_args']) ? WBTM_Global_Function::data_sanitize($_REQUEST['filter_args']) : [];
				$bus_id = array_key_exists('wbtm_bus_id', $filter_args) ? $filter_args['wbtm_bus_id'] : 0;
			?>
				<table class="groupCheckBox passenger-list-table" data-placeholder>
					<thead>
						<tr>
							<th class="_w_50"><?php esc_html_e('SI.', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_50"><?php esc_html_e('Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="textLeft"><?php echo esc_html(WBTM_Functions::get_name()); ?></th>
							<th class="textLeft"><?php esc_html_e('Billing Info', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<?php if ($bus_id > 0) {
								do_action('wbtm_passenger_info_header', $bus_id);
							} ?>
							<th><?php esc_html_e('Ticket', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th><?php echo WBTM_Translations::text_order_date(); ?></th>
							<th><?php echo WBTM_Translations::text_journey_date(); ?></th>
							<th class="_w_100"><?php esc_html_e('Time', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php esc_html_e('From=>To', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php echo WBTM_Translations::text_pickup() . '=>' . WBTM_Translations::text_drop_off(); ?></th>
							<th class="textLeft"><?php esc_html_e('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_125"><?php esc_html_e('Paid Amount', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php esc_html_e('Check in', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_100"><?php esc_html_e('Status', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_125"><?php echo WBTM_Translations::text_action(); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach ($attendee_ids as $attendee_id) {
							$post_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
							$category = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_category');
							$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
							$billing_name = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_name');
							$billing_email = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_email');
							$billing_phone = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_phone');
							$booking_date = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_booking_date');
							$boarding_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_time');
							$bp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_point');
							$dp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_point');
							$pickup_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pickup_point');
							$drop_off_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_drop_off_point');
							$download_url = WBTM_Pro_Pdf::get_pdf_url(array('attendee_id' => $attendee_id));
							$download_url_order = WBTM_Pro_Pdf::get_pdf_url(array('wbtm_order_id' => $order_id));
							$order_status = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_status');
							// Get Paid Amount
							if ($order_status == 'partially-paid') {
								$paid_amount = WBTM_Global_Function::get_post_info($order_id, '_order_total');
								$paid_amount = $paid_amount + self::ex_service_price($attendee_id);
							} else {
								$paid_amount = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
								$paid_amount = $paid_amount + self::ex_service_price($attendee_id);
							}
						?>
							<tr class="passenger-list">
								<td class="textCenter"><?php echo esc_html($count); ?></td>
								<td class="textCenter">#<?php echo esc_html($order_id); ?></td>
								<td>
									<?php echo esc_html(get_the_title($post_id)); ?>
								</td>
								<td>
									<div class="textSuccess">
										<?php if ($billing_name) { ?>
											<i class="fas fa-user-circle"></i>&nbsp;&nbsp;<?php echo esc_html($billing_name); ?>
										<?php }
										if ($billing_phone) { ?>
											<i class="fas fa-phone-alt"></i>&nbsp;&nbsp;<?php echo esc_html($billing_phone); ?>
										<?php }
										if ($billing_email) { ?>
											<i class="fas fa-envelope"></i>&nbsp;&nbsp;<?php echo esc_html($billing_email); ?>
										<?php } ?>
									</div>
								</td>
								<?php if ($bus_id > 0) {
									do_action('wbtm_passenger_info_column', $attendee_id, $bus_id);
								} ?>
								<td class="textCenter"><?php echo WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($booking_date, 'date'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($boarding_time, 'date'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($boarding_time, 'time'); ?></td>
								<td class="textCenter"><?php echo esc_html($bp); ?> <i class="fas fa-long-arrow-alt-right"></i> <?php echo esc_html($dp); ?></td>
								<td><?php echo esc_html($pickup_point) . '=>' . esc_html($drop_off_point); ?></td>
								<td><?php echo esc_html(self::extra_service($attendee_id)); ?></td>
								<td class="textCenter"><?php echo wc_price($paid_amount); ?></td>
								<td><?php do_action('wbtm_qr_ticket_status_text', $attendee_id); ?> </td>
								<td class="textCenter"><span class="label textWhite bgSuccess" style="padding:.2em .6em;"><?php echo esc_html($order_status); ?></span></td>
								<td>
									<div class="buttonGroup">
										<button class="_whiteButton_xs" type="button" title="<?php esc_attr_e('Download Attendee Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url); ?>">
											<span class="fas fa-file-pdf mp_zero"></span>
										</button>
										<button class="_whiteButton_xs " type="button" title="<?php esc_attr_e('Download Order Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url_order); ?>">
											<span class="far fa-file-pdf mp_zero"></span>
										</button>
										<button class="_whiteButton_xs" type="button" data-collapse-target="wbtm_expand_<?php echo esc_attr($attendee_id); ?>" title="<?php esc_attr_e('Open Passenger Details.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-open-icon="fa-eye" data-close-icon="fa-eye-slash">
											<span data-icon class="fas fa-eye mp_zero"></span>
										</button>
										<button class="_themeButton_xs" id="wbtm_delete_attendee" type="button" data-attendee-id="<?php echo esc_attr($attendee_id); ?>" title="<?php echo esc_attr__('Remove Passenger.', 'addon-bus--ticket-booking-with-seat-pro') . ' : ' . esc_attr($attendee_id); ?>">
											<span class="fas fa-trash-alt mp_zero"></span>
										</button>
									</div>
								</td>
							</tr>
							<tr class="passenger-list-details" data-collapse="wbtm_expand_<?php echo $attendee_id; ?>">
								<td></td>
								<td colspan="4"><?php WBTM_Layout_Pro::service_info($attendee_id); ?></td>
								<td colspan="4"> <?php WBTM_Layout_Pro::billing_info($attendee_id); ?> </td>
								<td colspan="4">
									<h4><?php echo WBTM_Translations::text_passenger_info(); ?></h4>
									<?php WBTM_Layout_Pro::seat_info($attendee_id); ?>
								</td>
							</tr>
						<?php
							$count++;
						}
						?>
					</tbody>
				</table>
<?php
			}
		}
		//********************//
		public function get_wbtm_passenger_filter_result()
		{
			$this->passenger_filter_result();
			die();
		}
		public function wbtm_delete_attendee()
		{
			$attendee_id = isset($_REQUEST['attendee_id']) ? WBTM_Global_Function::data_sanitize($_REQUEST['attendee_id']) : '';
			if ($attendee_id) {
				update_post_meta($attendee_id, 'wbtm_order_status', 'canceled');
			}
			die();
		}
	}
	new WBTM_Passenger_List();
}
