<?php
if (!defined('ABSPATH')) {
    die;
} // Cannot access pages directly.
if (!class_exists('WBTM_Pro_Pdf')) {
    class WBTM_Pro_Pdf {
        public function __construct() {
            add_action('woocommerce_thankyou', array($this, 'pdf_button'));
            add_action('wbtm_pdf_button', array($this, 'pdf_button'));

            add_action('wbtm_generate_pdf', array($this, 'generate_pdf'), 10, 3);
            add_filter('wbtm_generate_order_pdf_data', array($this, 'wbtm_generate_order_pdf_data'), 10);

            /***************/
	        add_shortcode('wbtm_download_pdf', array($this, 'download_pdf'));
            /***************/
            add_action('wp_ajax_wbtm_generate_pdf', array($this, 'wbtm_generate_pdf'));
            add_action('wp_ajax_nopriv_wbtm_generate_pdf', array($this, 'wbtm_generate_pdf'));
        }
        public function download_pdf($attribute) {
	        ob_start();
	        $order_id=isset($_GET['order_id']) && $_GET['order_id']?$_GET['order_id']:0;
            if($order_id>0){

                $this->pdf_button($order_id);
            }
	        return ob_get_clean();
        }
        public function pdf_button($order_id) {
            $seat_booked_status = WBTM_Global_Function::get_settings('wbtm_general_settings', 'set_book_status', array('processing', 'completed'));
            $order = wc_get_order($order_id);
            $item_id = current(array_keys($order->get_items()));
            $post_id = wc_get_order_item_meta($item_id, '_wbtm_bus_id');
            if ($post_id && get_post_type($post_id) == WBTM_Functions::get_cpt() && in_array($order->get_status(), $seat_booked_status)) {
                $download_url = self::get_pdf_url(array('wbtm_order_id' => $order_id));
                if ($download_url) {
                    ?>
                    <div class="wbtm_style">
                        <div class="_mB">
                            <?php self::pdf_download_button($download_url); ?>
                        </div>
                    </div>
                    <?php
                }
            }
        }
        public static function pdf_download_button($download_url) {
            ?>
            <button type="button" class="_themeButton" data-href="<?php echo esc_attr($download_url); ?>">
                <span class="fas fa-file-pdf mR_xs"></span>
                <?php esc_html_e('Download Ticket', 'addon-bus--ticket-booking-with-seat-pro'); ?>
            </button>
            <?php
        }
        public function wbtm_generate_pdf() {
            if (empty($_GET['action']) || !check_admin_referer($_GET['action'])) {
                wp_die(__('You do not have sufficient permissions to access this page.', 'addon-bus--ticket-booking-with-seat-pro'));
            }
            $order_id = WBTM_Global_Function::get_submit_info_get_method('wbtm_order_id');
            $attendee_id = WBTM_Global_Function::get_submit_info_get_method('attendee_id');
            $bus_id = WBTM_Global_Function::get_submit_info_get_method('wbtm_bus_id');
            $date = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time');
            $args['attendee_id'] = $attendee_id;
            $args['wbtm_bus_id'] = $bus_id;
            $args['wbtm_booking_date'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date');
            $args['wbtm_booking_date_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_from');
            $args['wbtm_booking_date_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_to');
            $args['wbtm_start_time'] = $date;
            $args['wbtm_start_time_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_from');
            $args['wbtm_start_time_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_to');
            $args['wbtm_boarding_time'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_time');
            $args['wbtm_boarding_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_point');
            $args['wbtm_dropping_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_dropping_point');
            $args['wbtm_order_id'] = $order_id;
            $args['wbtm_user_name'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_name');
            $args['wbtm_user_email'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_email');
            $args['wbtm_user_phone'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_phone');
            header("Content-Type: application/pdf; charset=UTF-8");
            
            if ($attendee_id) {
                $file_name = esc_html__('Attendee_', 'addon-bus--ticket-booking-with-seat-pro') . $attendee_id . '.pdf';
            } elseif ($order_id) {
                $file_name = esc_html__('Order_', 'addon-bus--ticket-booking-with-seat-pro') . $order_id . '.pdf';
            } else {
                $file_name = esc_html__('Passenger_List', 'addon-bus--ticket-booking-with-seat-pro') . '_' . get_the_title() . '_' . $date . '.pdf';
            }
            $this->generate_pdf($args, $file_name);
            exit;
        }

        public function wbtm_generate_order_pdf_data($order_id) 
        {
            $order = wc_get_order($order_id);
            $order_items = $order->get_items();
            $attendee_id = WBTM_Global_Function::get_submit_info_get_method('attendee_id');
            $bus_id = WBTM_Global_Function::get_submit_info_get_method('wbtm_bus_id');
            $date = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time');
            $args['attendee_id'] = $attendee_id;
            $args['wbtm_bus_id'] = $bus_id;
            $args['wbtm_booking_date'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date');
            $args['wbtm_booking_date_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_from');
            $args['wbtm_booking_date_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_to');
            $args['wbtm_start_time'] = $date;
            $args['wbtm_start_time_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_from');
            $args['wbtm_start_time_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_to');
            $args['wbtm_boarding_time'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_time');
            $args['wbtm_boarding_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_point');
            $args['wbtm_dropping_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_dropping_point');
            $args['wbtm_order_id'] = $order_id;
            $args['wbtm_user_name'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_name');
            $args['wbtm_user_email'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_email');
            $args['wbtm_user_phone'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_phone');            
            $file_name = esc_html__('Order_', 'addon-bus--ticket-booking-with-seat-pro') . $order_id . '.pdf';
            $this->generate_pdf($args, $file_name,'mail');
            exit;
        }

        public function generate_pdf($args, $file_name, $mail = '') {
            $html = $this->create_pdf_file($args);
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->allow_charset_conversion = true;  // Set by default to TRUE
            $mpdf->autoScriptToLang = true;
            $mpdf->baseScript = 1;
            $mpdf->autoVietnamese = true;
            $mpdf->autoArabic = true;
            $mpdf->autoLangToFont = true;
            $mpdf->WriteHTML($html);
            if ($mail) {
                $mpdf->Output($file_name, 'F');
            } else {
                $mpdf->Output($file_name, 'D');
            }
        }
        public function create_pdf_file($args = []) {
            $template_dir = WBTM_PLUGIN_DIR_PRO . '/template/WBTM_Pdf.php';
            $template_dir = file_exists($template_dir) ? $template_dir : '';
            ob_start();
            include $template_dir;
            return ob_get_clean();
        }
        //**********************//
        public static function get_pdf_url($args = array()) {
            $default_args = array(
                'action' => 'wbtm_generate_pdf'
            );
            $args = wp_parse_args($args, $default_args);
            $build_url = http_build_query($args);
            $nonce_url = wp_nonce_url(admin_url("admin-ajax.php?" . $build_url), $args['action']);
            return apply_filters('wbtm_filter_pdf_url', $nonce_url);
        }
        public static function pdf_logo() {
            $logo_url = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_logo');
            if (!empty($logo_url)) {

				$logo_url=$logo_url>0?wp_get_attachment_image_url($logo_url,'',true):$logo_url;

                ?>
                <img src="<?php echo esc_attr($logo_url) ?>" alt="logo" width="150"/>
                <?php
            }
        }
    }
    new WBTM_Pro_Pdf();
}
