<?php
	// Template Name: Default Theme
	$attendee_id = $ticket_id ?? 0;
	$total_guest = $total_guest ?? 1;
	$all_attendees = $all_attendees ?? [];
	$pin = '';
	if (sizeof($all_attendees) > 0) {
		$attendee_id = current($all_attendees);
		foreach ($all_attendees as $all_attendee) {
			$pin = $pin ? $pin . '-' . $all_attendee : $all_attendee;
		}
	}
	else {
		$pin = $attendee_id;
	}
	$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
	$pdf_class = 'mp_pdf_item_left';
?>
	<div class='mp_pdf'>
		<div class="mp_pdf_header">
			<div class="mp_pdf_item_left">
				<?php WBTM_Pro_Pdf::pdf_logo(); ?>
				<h5><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_address'); ?> </h5>
				<h6><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_phone',); ?> </h6>
				<h6><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_email',); ?> </h6>
			</div>
			<div class="mp_pdf_item_right">
				<?php do_action('wbtm_qr_display', $pin); ?>
			</div>
		</div>
		<div class="mp_pdf_body">
			<div class="mp_pdf_item_left">
				<?php WBTM_Layout_Pro::service_info($attendee_id); ?>
			</div>
			<div class="mp_pdf_item_right">
				<?php WBTM_Layout_Pro::billing_info($attendee_id); ?>
			</div>
		</div>
		<div class="mp_pdf_body">
		
			<h4><?php echo WBTM_Translations::text_passenger_info(); ?></h4>
			
			<?php if (sizeof($all_attendees) > 0) { ?>
				<?php foreach ($all_attendees as $attendee) { ?>
					<div class="<?php echo esc_attr($pdf_class); ?>">
						<?php $pdf_class = $pdf_class == 'mp_pdf_item_left' ? 'mp_pdf_item_right' : 'mp_pdf_item_left'; ?>
						<?php WBTM_Layout_Pro::seat_info($attendee); ?>
					</div>
				<?php } ?>
			<?php }
			else {
				WBTM_Layout_Pro::seat_info($attendee_id);
			}
			?>
		</div>
		
		<div class="mp_pdf_footer">
			<?php
				$term_title = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_tc_title');
				$term_text = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_tc_text',);
				if ($term_title) {
					?>
					<h4><?php echo esc_html($term_title); ?></h4>
					<?php
				}
				if ($term_text) { ?>
					<span><?php echo html_entity_decode($term_text); ?></span>
				<?php } ?>
		</div>
	</div>
<?php