<?php
	// Template Name: Default Theme
	$attendee_id = $ticket_id ?? 0;
	$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
	if (sizeof($ex_service_infos) > 0) {
		?>
		<div class="page_break"></div>
		<div class='mp_pdf'>
			<div class="mp_pdf_header">
				<div class="mp_pdf_body">
					<?php WBTM_Pro_Pdf::pdf_logo(); ?>
					<h5><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_address'); ?> </h5>
					<h6><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_phone',); ?> </h6>
					<h6><?php echo WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_email',); ?> </h6>
				</div>
			</div>
			<div class="mp_pdf_body">
				<div class="mp_pdf_item_left">
					<?php WBTM_Layout_Pro::service_info($attendee_id); ?>
				</div>
				<div class="mp_pdf_item_right">
					<?php WBTM_Layout_Pro::billing_info($attendee_id); ?>
				</div>
			</div>
			<div class="mp_pdf_body">
				<?php WBTM_Layout_Pro::ex_service_info($attendee_id); ?>
			</div>
			<div class="mp_pdf_footer">
				<?php
					$term_title = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_tc_title');
					$term_text = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_tc_text',);
					if ($term_title) {
						?>
						<h4><?php echo esc_html($term_title); ?></h4>
						<?php
					}
					if ($term_text) { ?>
						<span><?php echo html_entity_decode($term_text); ?></span>
					<?php } ?>
			</div>
		</div>
		<?php
	}