<?php
	// Template Name: Passenger List
	$args = $args ?? [];
//echo '<pre>';print_r($args);echo '</pre>';
	$bus_id          = array_key_exists( 'wbtm_bus_id', $args ) && $args['wbtm_bus_id'] ? $args['wbtm_bus_id'] : 0;
	$j_date          = array_key_exists( 'wbtm_start_time', $args ) && $args['wbtm_start_time'] ? $args['wbtm_start_time'] : 0;
	$all_passengers  = WBTM_Function_PRO::attendee_query( $args );
	$total_guest     = $all_passengers->post_count;
	$passenger_infos = $all_passengers->posts;
	$orders          = [];
	$total_sale      = 0;
	foreach ( $passenger_infos as $passenger ) {
		$attendee_id = $passenger->ID;
		$price       = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_bus_fare' );
		$orders[]    = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_order_id' );
		$total_sale  = $total_sale + max( 0, $price );
	}
	$category = WBTM_Global_Function::get_post_info( $bus_id, 'wbtm_bus_category' );
	/****************************/
	$show_bus_name        = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_bus_name', 'on' );
	$show_bus_id          = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_bus_id', 'on' );
	$show_price           = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_price', 'on' );
	$show_total_passenger = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_total_passenger', 'on' );
	$show_total_order     = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_total_order', 'on' );
	/****************************/
	$show_pin           = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_pin', 'on' );
	$show_order_id      = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_order_id', 'on' );
	$show_seat_name     = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_seat_name', 'on' );
	$show_name          = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_name', 'on' );
	$show_phone         = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_phone', 'on' );
	$show_attendee_info = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_attendee_info', 'off' );
	/*********************************/
	$attendee_infos = WBTM_Global_Function::get_post_info( $bus_id, 'wbtm_attendee_info', [] );
	$custom_infos   = WBTM_Global_Function::get_post_info( $bus_id, 'wbtm_custom_attendee_info', [] );
	// $show_email = WBTM_Global_Function::get_settings('wbtm_passenger_pdf_settings', 'passenger_pdf_email', 'on');
	// $show_address = WBTM_Global_Function::get_settings('wbtm_passenger_pdf_settings', 'passenger_pdf_address', 'on');
	$show_extra_service = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_extra_service', 'on' );
	$show_from_to       = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_from_to', 'on' );
	$show_pick_drop     = WBTM_Global_Function::get_settings( 'wbtm_passenger_pdf_settings', 'passenger_pdf_pickup_drop_off', 'on' );
?>
    <div class='mp_pdf'>
        <div class="mp_pdf_header">
            <div class="mp_pdf_item_left">
				<?php WBTM_Pro_Pdf::pdf_logo(); ?>
                <h5><?php echo WBTM_Global_Function::get_settings( 'wbtm_pdf_settings', 'pdf_address' ); ?> </h5>
                <h6><?php echo WBTM_Global_Function::get_settings( 'wbtm_pdf_settings', 'pdf_phone' ); ?> </h6>
                <h6><?php echo WBTM_Global_Function::get_settings( 'wbtm_pdf_settings', 'pdf_email' ); ?> </h6>
            </div>
            <div class="mp_pdf_item_right">
				<?php if ( $show_bus_name == 'on' ) { ?>
                    <h6 class="text_left"><?php echo esc_html( WBTM_Functions::get_name() ); ?> : <?php echo esc_html( get_the_title( $bus_id ) . '(' . $category . ')' ); ?></h6>
				<?php } ?>
				<?php if ( $show_bus_id == 'on' ) { ?>
                    <h6 class="text_left"><?php esc_html_e( 'Bus No ', 'addon-bus--ticket-booking-with-seat-pro' ); ?> : <?php echo esc_html( WBTM_Global_Function::get_post_info( $bus_id, 'wbtm_bus_no' ) ); ?></h6>
				<?php } ?>
                <h6 class="text_left"><?php echo WBTM_Translations::text_journey_date(); ?> : <?php echo $j_date ? WBTM_Global_Function::date_format( $j_date, 'full' ) : ''; ?></h6>
				<?php if ( $show_price == 'on' ) { ?>
                    <h6 class="text_left"><?php esc_html_e( 'Total Sales ', 'addon-bus--ticket-booking-with-seat-pro' ); ?> : <?php echo wc_price( $total_sale ); ?></h6>
				<?php } ?>
				<?php if ( $show_total_passenger == 'on' ) { ?>
                    <h6 class="text_left"><?php esc_html_e( 'Total Passengers ', 'addon-bus--ticket-booking-with-seat-pro' ); ?> : <?php echo esc_html( $total_guest ); ?></h6>
				<?php } ?>
				<?php if ( $show_total_order == 'on' ) { ?>
                    <h6 class="text_left"><?php esc_html_e( 'Total Order ', 'addon-bus--ticket-booking-with-seat-pro' ); ?> : <?php echo esc_html( sizeof( array_unique( $orders ) ) ); ?></h6>
				<?php } ?>
            </div>
        </div>
        <div class="mp_pdf_body table_list">
            <table>
                <thead>
                <tr>
                    <th><?php esc_html_e( 'SI.', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th>
					<?php if ( $show_pin == 'on' ) { ?>
                        <th><?php esc_html_e( 'PIN', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th><?php } ?>
					<?php if ( $show_order_id == 'on' ) { ?>
                        <th><?php esc_html_e( 'Order ID', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th> <?php } ?>
					<?php if ( $show_seat_name == 'on' ) { ?>
                        <th><?php echo WBTM_Translations::text_seat_name(); ?></th><?php } ?>
					<?php if ( $show_name == 'on' ) { ?>
                        <th><?php esc_html_e( 'Name', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th><?php } ?>
					<?php if ( $show_phone == 'on' ) { ?>
                        <th><?php esc_html_e( 'Phone', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th><?php } ?>
					<?php if ( $show_attendee_info == 'on' && $bus_id > 0 ) {
						do_action( 'wbtm_passenger_info_header', $bus_id );
					} ?>
					<?php if ( $show_extra_service == 'on' ) { ?>
                        <th><?php esc_html_e( 'Extra Service', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th><?php } ?>
					<?php if ( $show_from_to == 'on' ) { ?>
                        <th><?php esc_html_e( 'From=>To', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th> <?php } ?>
					<?php if ( $show_pick_drop == 'on' ) { ?>
                        <th><?php echo WBTM_Translations::text_pickup_point(); ?></th> <?php } ?>
					<?php if ( $show_pick_drop == 'on' ) { ?>
                        <th><?php echo WBTM_Translations::text_drop_off_point(); ?></th> <?php } ?>
					<?php if ( $show_price == 'on' ) { ?>
                        <th><?php esc_html_e( 'Paid Amount', 'addon-bus--ticket-booking-with-seat-pro' ); ?></th> <?php } ?>
                </tr>
                </thead>
                <tbody>
				<?php
					if ( $total_guest > 0 ) {
						$attendee_ids = [];
						$count        = 1;
						foreach ( $passenger_infos as $passenger ) {
							$attendee_id     = $passenger->ID;
							$post_id         = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_bus_id' );
							$order_id        = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_order_id' );
							$bp              = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_boarding_point' );
							$dp              = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_dropping_point' );
							$order_status    = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_order_status' );
							$passenger_infos = WBTM_Function_PRO::get_attendee_info( $attendee_id );
							if ( $order_status == 'partially-paid' ) {
								$paid_amount = WBTM_Global_Function::get_post_info( $order_id, '_order_total' );
							} else {
								$paid_amount = WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_bus_fare' );
							}
							?>
                            <tr>
                                <th><?php echo esc_html( $count ); ?></th>
								<?php if ( $show_pin == 'on' ) { ?>
                                    <td><?php echo esc_html( $attendee_id ); ?></td><?php } ?>
								<?php if ( $show_order_id == 'on' ) { ?>
                                    <td><?php echo esc_html( $order_id ); ?></td><?php } ?>
								<?php if ( $show_seat_name == 'on' ) { ?>
                                    <td><?php echo WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_seat' ); ?></td><?php } ?>
								<?php if ( $show_name == 'on' ) { ?>
                                    <td><?php echo WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_user_name' ); ?></td><?php } ?>
								<?php if ( $show_phone == 'on' ) { ?>
                                    <td><?php echo WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_user_phone' ); ?></td><?php } ?>
								<?php if ( $show_attendee_info == 'on' && $post_id > 0 ) {
									do_action( 'wbtm_passenger_info_column', $attendee_id, $post_id );
								} ?>
								<?php if ( $show_extra_service == 'on' ) { ?>
                                    <td><?php echo esc_html( WBTM_Passenger_List::extra_service( $attendee_id ) ); ?></td><?php } ?>
								<?php if ( $show_from_to == 'on' ) { ?>
                                    <td><?php echo esc_html( $bp . '=>' . $dp ); ?></td>                                <?php } ?>
								<?php if ( $show_pick_drop == 'on' ) { ?>
                                    <td><?php echo WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_pickup_point' ); ?></td><?php } ?>
								<?php if ( $show_pick_drop == 'on' ) { ?>
                                    <td><?php echo WBTM_Global_Function::get_post_info( $attendee_id, 'wbtm_drop_off_point' ); ?></td><?php } ?>
								<?php if ( $show_price == 'on' ) { ?>
                                    <td><?php echo wc_price( $paid_amount ); ?></td><?php } ?>
                            </tr>
							<?php
							$count ++;
						}
					}
				?>
                </tbody>
            </table>
        </div>
        <div class="mp_pdf_footer">
			<?php
				$term_title = WBTM_Global_Function::get_settings( 'wbtm_pdf_settings', 'pdf_tc_title' );
				$term_text  = WBTM_Global_Function::get_settings( 'wbtm_pdf_settings', 'pdf_tc_text' );
				if ( $term_title ) {
					?>
                    <h4><?php echo esc_html( $term_title ); ?></h4>
					<?php
				}
				if ( $term_text ) { ?>
                    <span><?php echo html_entity_decode( $term_text ); ?></span>
				<?php } ?>
        </div>
    </div>
<?php