function placeholderLoader(target) {
	target.addClass('loading').append('<div class="placeholder_area_loader"><div class="mp_spinner"></div></div>');
}

function placeholderLoaderRemove(target) {
	target.removeClass('loading').find('.placeholder_area_loader').remove();
}

function get_wbtm_filter_args(parent) {
	let filter_args = {};
	
	// Helper function to get and sanitize value
	function getFieldValue(name) {
		let field = parent.find('[name="' + name + '"]');
		let value = field.val();
		return value ? value.trim() : '';
	}

	// Get values for all possible fields
	let fields = [
		'wbtm_bus_id',
		'wbtm_booking_date',
		'wbtm_start_time',
		'wbtm_boarding_time',
		'wbtm_boarding_point',
		'wbtm_dropping_point',
		'wbtm_order_id',
		'wbtm_user_name',
		'wbtm_user_email',
		'wbtm_user_phone'
	];

	fields.forEach(field => {
		let value = getFieldValue(field);
		if (value && value !== ' ') {
			filter_args[field] = value;
		}
	});
	
	return filter_args;
}

//=======Passenger  filter=============//
(function ($) {
	"use strict";
	function get_wbtm_passenger_filter_result(parent) {
		let post_per_page = parseInt(parent.find("[name='post_per_page']").val()) || 20;
		let page = parseInt(parent.find('.active_pagination').attr('data-pagination')) || 1;
		let target = parent.find('#wbtm_passenger_list_result');
		
		// Get filter arguments
		let filter_args = get_wbtm_filter_args(parent);
		
		$.ajax({
			type: 'POST',
			url: wbtm_ajax_url,
			data: {
				action: "get_wbtm_passenger_filter_result",
				filter_args: filter_args,
				post_per_page: post_per_page,
				page: page
			},
			beforeSend: function () {
				placeholderLoader(target);
			},
			success: function (response) {
				target.html(response).slideDown('fast').promise().done(function () {
					let total_item = target.find("[name='mp_total_item']").val();
					$.when(wbtm_pagination_page_management(target, page - 1, total_item)).then(function () {
						placeholderLoaderRemove(target);
					});
				});
			},
			error: function(xhr, status, error) {
				placeholderLoaderRemove(target);
			}
		});
	}

	// Attach change event handlers
	$(document).on('change', '.wbtm_passenger_filter_area select, .wbtm_passenger_filter_area input', function() {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		get_wbtm_passenger_filter_result(parent);
	});

	// Filter button click handler
	$(document).on('click', '#get_wbtm_passenger_filter_result', function () {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		get_wbtm_passenger_filter_result(parent);
	});

	// Reset button handler
	$(document).on('click', '#wbtm_filter_reset', function () {
		window.location.reload();
	});

	$(document).on('click', '#wbtm_delete_attendee', function (e) {
		e.preventDefault();
		if (confirm('Are You Sure , Remove this Passenger ? \n\n 1. Ok : To Remove . \n 2. Cancel : To Cancel .')) {
			let attendee_id = $(this).data('attendee-id');
			let parent = $(this).closest('.wbtm_passenger_filter_area');
			if (attendee_id) {
				$.ajax({
					type: 'POST', url: wbtm_ajax_url, data: {
						"action": "wbtm_delete_attendee", "attendee_id": attendee_id
					}, beforeSend: function () {
						placeholderLoader(parent);
					}, success: function () {
						placeholderLoaderRemove(parent);
						parent.find('#get_wbtm_passenger_filter_result').trigger('click');
					}
				});
			}
			return true;
		} else {
			return false;
		}
	});

	$(document).on('click', '.wbtm_passenger_filter_area .pagination_area [data-pagination]', function (e) {
		e.preventDefault();
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		parent.find('[data-pagination]').removeClass('active_pagination');
		$(this).addClass('active_pagination').slideDown(250).promise().done(function () {
			get_wbtm_passenger_filter_result(parent);
		});
	});
}(jQuery));

//=======Report  filter=============//
(function ($) {
	"use strict";
	function get_wbtm_report_filter_result(parent) {
		let target = parent.find('#wbtm_sales_report_result');
		$.ajax({
			type: 'POST', url: wbtm_ajax_url, data: {
				"action": "get_wbtm_report_filter_result",
				"filter_args": get_wbtm_filter_args(parent),
			}, beforeSend: function () {
				placeholderLoader(target);
			}, success: function (data) {
				target.html(data).slideDown('fast').promise().done(function () {
					placeholderLoaderRemove(target);
				});
			}
		});
	}
	$(document).on('change', '' +
		'.wbtm_sales_report_area [name="wbtm_bus_id"],' +
		'.wbtm_sales_report_area [name="wbtm_booking_date"],' +
		'.wbtm_sales_report_area [name="wbtm_start_time"],' +
		'.wbtm_sales_report_area [name="wbtm_boarding_time"],' +
		'.wbtm_sales_report_area [name="wbtm_boarding_point"],' +
		'.wbtm_sales_report_area [name="wbtm_dropping_point"],' +
		'.wbtm_sales_report_area [name="wbtm_order_id"],' +
		'.wbtm_sales_report_area [name="wbtm_user_name"],' +
		'.wbtm_sales_report_area [name="wbtm_user_email"],' +
		'.wbtm_sales_report_area [name="wbtm_user_phone"]', function () {
		let parent = $(this).closest('.wbtm_sales_report_area');
		get_wbtm_report_filter_result(parent);
	});
	$(document).on('click', '#get_wbtm_sales_report_filter_result', function () {
		let parent = $(this).closest('.wbtm_sales_report_area');
		get_wbtm_report_filter_result(parent)
	});
}(jQuery));

(function ($) {
	"use strict";
	$(document).on('change', 'div.wbtm_custom_form_setting_area [name="wbtm_custom_type[]"]', function () {
		let parent = $(this).closest('tr');
		let target = parent.find('[name="wbtm_custom_value[]"]').closest('label');
		let target_date = parent.find('[name="wbtm_default_date[]"]').closest('label');
		let target_d_value = parent.find('[name="wbtm_default_value[]"]').closest('label');
		let val = $(this).val();
		if (val === 'select' || val === 'checkbox' || val === 'radio') {
			target.slideDown(250);
			target_date.slideUp(250);
			target_d_value.slideDown(250);
		} else if(val === 'date'){
			target.slideUp(250);
			target_date.slideDown(250);
			target_d_value.slideUp(250);
		}else {
			target.slideUp(250);
			target_date.slideUp(250);
			target_d_value.slideDown(250);
		}
	});
}(jQuery));

//=======Licence=============//
(function ($) {
	"use strict";
	$(document).on('click', '#wbtm_pro_license_key_inactive', function () {
		let parent= $(this).closest('.mp_basic_license_area');
		let key=parent.find('#wbtm_pro_license_key').val();
		if(key ) {
			if (confirm('Are you sure remove Licence? \n\n 1. Ok : To remove Licence . \n 2. Cancel : To Cancel .')) {
				$.ajax({
					type: 'POST', url: wbtm_ajax_url, data: {
						"action": "wbtm_pro_license_key_inactive"
					}, beforeSend: function () {
						wbtm_loader(parent);
					}, success: function (data) {
						parent.html(data);
					}
				});
			}
		}
	});
	$(document).on('click', '#wbtm_pro_license_key_active', function () {
		let parent= $(this).closest('.mp_basic_license_area');
		let key=parent.find('#wbtm_pro_license_key').val();
		if(key ) {
			$.ajax({
				type: 'POST', url: wbtm_ajax_url, data: {
					"action": "wbtm_pro_license_key_active",
					"key": key,
				}, beforeSend: function () {
					wbtm_loader(parent);
				}, success: function (data) {
					parent.html(data);
				}
			});
		}else{
			wbtm_alert($(this));
		}
	});
}(jQuery));
