<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_Backend_Order' ) ) {
		class WBTM_Backend_Order {
			public function __construct() {
				add_action( 'admin_menu', array( $this, 'backend_order_menu' ) );
				add_action( 'wbtm_registration_form_inside', [ $this, 'backend_order_hidden_input' ], 10, 1 );
			}
			public function backend_order_menu() {
				$menu_label = esc_html__( 'Purchase Ticket', 'addon-bus--ticket-booking-with-seat-pro' );
				add_submenu_page( 'edit.php?post_type=wbtm_bus', $menu_label, $menu_label, 'manage_options', 'wbtm_backend_order', array( $this, 'backend_order_page' ) );
			}
			public function backend_order_page() {
				$this->backend_order_place();
				//echo '<pre>';print_r(WC()->cart->get_cart());echo '</pre>';
				?>
                <div class="wrap"></div>
                <div class="wbtm_style">
                    <div class="_dLayout_margin">
						<?php require WBTM_Functions::template_path( 'layout/search_form.php' ); ?>
                    </div>
                </div>
				<?php
			}
			public function backend_order_place() {
				if ( isset( $_POST['wbtm_backend_order_hidden_input'] ) && $_POST['wbtm_backend_order_hidden_input'] > 0 ) {
					$order_date = date( 'M-d-Y-hi-a' );
					//$order_date_title = date('F d, Y @ h:i A');
					$user_id    = get_current_user_id();
					$order_data = array(
						'status'        => 'wc-completed',
						'customer_note' => 'Order Created From Dashboard.',
						'customer_id'   => $user_id,
					);
					$order      = wc_create_order( $order_data );
					$order_id   = $order->get_id();
					if ( ! is_wp_error( $order_id ) ) {
						$post_id          = WBTM_Global_Function::get_submit_info( 'wbtm_post_id', [] );
						$ticket_infos     = WBTM_Woocommerce::get_cart_ticket_info( $post_id );
						$base_price       = WBTM_Woocommerce::get_cart_seat_price( $ticket_infos );
						$extra_service    = WBTM_Woocommerce::get_cart_extra_service_info( $post_id );
						$ex_service_price = WBTM_Woocommerce::get_cart_ex_service_price( $extra_service );
						$total_price      = $base_price + $ex_service_price;
						$total_qty        = WBTM_Woocommerce::get_cart_ticket_qty( $ticket_infos );
						/*******************/
						add_post_meta( $order_id, '_payment_method_title', 'Import', true );
						add_post_meta( $order_id, '_order_total', $total_price, true );
						add_post_meta( $order_id, '_customer_user', $user_id, true );
						add_post_meta( $order_id, '_completed_date', $order_date, true );
						add_post_meta( $order_id, '_order_currency', get_woocommerce_currency_symbol(), true );
						add_post_meta( $order_id, '_paid_date', $order_date, true );
						$user_phone    = get_user_meta( $user_id, 'user_phone', true );
						$user_info     = get_userdata( $user_id );
						$customer_mail = WBTM_Global_Function::get_submit_info( 'wbtm_confirmation_email' );
						$customer_mail = $customer_mail ?: $user_info->user_email;
						add_post_meta( $order_id, '_billing_first_name', $user_info->first_name, true );
						add_post_meta( $order_id, '_billing_last_name', $user_info->last_name, true );
						add_post_meta( $order_id, '_billing_email', $customer_mail, true );
						add_post_meta( $order_id, '_billing_phone', $user_phone, true );
						add_post_meta( $order_id, '_billing_address_1', $user_info->user_email, true );
						add_post_meta( $order_id, '_billing_address_2', $user_phone, true );
						// get product by item_id
						$product_id = get_post_meta( $post_id, 'link_wc_product', true );
						$product    = WBTM_Global_Function::wc_product_sku( $product_id );
						if ( $product ) {
							// add item
							$item_id = wc_add_order_item( $order_id, array(
								'order_item_name' => $product->get_title(),
								'order_item_type' => 'line_item'
							) );
							if ( $item_id ) {
								wc_add_order_item_meta( $item_id, '_qty', 1 );
								wc_add_order_item_meta( $item_id, '_tax_class', 'no_tax' );
								wc_add_order_item_meta( $item_id, '_product_id', $product_id );
								wc_add_order_item_meta( $item_id, '_variation_id', '' );
								wc_add_order_item_meta( $item_id, '_line_subtotal', wc_format_decimal( $total_price ) );
								wc_add_order_item_meta( $item_id, '_line_total', wc_format_decimal( $total_price ) );
								wc_add_order_item_meta( $item_id, '_line_tax', wc_format_decimal( 0 ) );
								wc_add_order_item_meta( $item_id, '_line_subtotal_tax', wc_format_decimal( 0 ) );
								$bp      = WBTM_Global_Function::get_submit_info( 'wbtm_bp_place' );
								$bp_time = WBTM_Global_Function::get_submit_info( 'wbtm_bp_time' );
								wc_add_order_item_meta( $item_id, WBTM_Translations::text_bp(), $bp . '(' . WBTM_Global_Function::date_format( $bp_time, 'full' ) . ')' );
								$dp      = WBTM_Global_Function::get_submit_info( 'wbtm_dp_place' );
								$dp_time = WBTM_Global_Function::get_submit_info( 'wbtm_dp_time' );
								wc_add_order_item_meta( $item_id, WBTM_Translations::text_dp(), $dp . '(' . WBTM_Global_Function::date_format( $dp_time, 'full' ) . ')' );
								$start_point = WBTM_Global_Function::get_submit_info( 'wbtm_start_point' );
								$start_time  = WBTM_Global_Function::get_submit_info( 'wbtm_start_time' );
								if ( $bp != $start_point ) {
									wc_add_order_item_meta( $item_id, WBTM_Translations::text_start_point(), $start_point . '(' . WBTM_Global_Function::date_format( $start_time, 'full' ) . ')' );
								}
								$pickup_point = WBTM_Global_Function::get_submit_info( 'wbtm_pickup_point' );
								wc_add_order_item_meta( $item_id, WBTM_Translations::text_pickup_point(), $pickup_point );
								$drop_off_point = WBTM_Global_Function::get_submit_info( 'wbtm_drop_off_point' );
								wc_add_order_item_meta( $item_id, WBTM_Translations::text_drop_off_point(), $drop_off_point );
								$passenger_infos = apply_filters( 'add_wbtm_user_info_data', array(), $post_id, $ticket_infos );
								if ( sizeof( $ticket_infos ) > 0 ) {
									foreach ( $ticket_infos as $ticket_info ) {
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_ticket_type(), $ticket_info['ticket_name'] );
										if ( array_key_exists( 'seat_name', $ticket_info ) ) {
											$seat_name = $ticket_info['seat_name'];
											if ( array_key_exists( 'dd', $ticket_info ) && $ticket_info['dd'] ) {
												$seat_name = $seat_name . '(' . WBTM_Translations::text_upper_deck() . ')';
											}
											wc_add_order_item_meta( $item_id, WBTM_Translations::text_seat_name(), $seat_name );
										}
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_qty(), $ticket_info['ticket_qty'] );
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_price(), ' ( ' . $ticket_info["ticket_price"] . ' x ' . $ticket_info['ticket_qty'] . ' ) = ' . wc_price( $ticket_info['ticket_price'] * $ticket_info['ticket_qty'] ) );
									}
									wc_add_order_item_meta( $item_id, WBTM_Translations::text_total_qty(), $total_qty );
									wc_add_order_item_meta( $item_id, WBTM_Translations::text_ticket_sub_total(), wc_price( $base_price ) );
								}
								wc_add_order_item_meta( $item_id, '_bus_id', $post_id );
								wc_add_order_item_meta( $item_id, '_wbtm_bus_id', $post_id );
								wc_add_order_item_meta( $item_id, '_wbtm_ticket_info', $ticket_infos );
								wc_add_order_item_meta( $item_id, '_wbtm_bp', $bp );
								wc_add_order_item_meta( $item_id, '_wbtm_bp_time', $bp_time );
								wc_add_order_item_meta( $item_id, '_wbtm_dp', $dp );
								wc_add_order_item_meta( $item_id, '_wbtm_dp_time', $dp_time );
								wc_add_order_item_meta( $item_id, '_wbtm_start_point', $start_point );
								wc_add_order_item_meta( $item_id, '_wbtm_start_time', $start_time );
								wc_add_order_item_meta( $item_id, '_extra_services', $extra_service );
								wc_add_order_item_meta( $item_id, '_wbtm_pickup_point', $pickup_point );
								wc_add_order_item_meta( $item_id, '_wbtm_drop_off_point', $drop_off_point );
								wc_add_order_item_meta( $item_id, '_wbtm_base_price', $base_price );
								wc_add_order_item_meta( $item_id, '_wbtm_qty', $total_qty );
								wc_add_order_item_meta( $item_id, '_wbtm_passenger_info', $passenger_infos );
								wc_add_order_item_meta( $item_id, '_wbtm_tp', $total_price );
								/*******************/
								if ( sizeof( $extra_service ) > 0 ) {
									wc_add_order_item_meta( $item_id, WBTM_Translations::text_ex_service(), '' );
									foreach ( $extra_service as $service ) {
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_name(), $service['name'] );
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_total_qty(), $service['qty'] );
										wc_add_order_item_meta( $item_id, WBTM_Translations::text_price(), ' ( ' . wc_price( $service['price'] ) . ' x ' . $service['qty'] . ' ) = ' . wc_price( $service['price'] * $service['qty'] ) );
									}
									wc_add_order_item_meta( $item_id, WBTM_Translations::text_ex_service_sub_total(), $ex_service_price );
								}
								$order = new WC_Order( $order_id );
								$order->calculate_totals();
								$order->save();
								WBTM_Woocommerce::add_billing_data( $item_id, $order_id );
							}
						}
						wp_set_object_terms( $order_id, 'completed', 'shop_order_status' );
						do_action( 'wbtm_send_mail', $order_id );
						?>
                        <div class="updated notice notice-success is-dismissible">
                            <h3 class="textSuccess"><?php esc_html_e( 'Booked Successfully', 'addon-bus--ticket-booking-with-seat-pro' ); ?></h3>
							<?php do_action( 'wbtm_pdf_button', $order_id ); ?>
                            <button type="button" class="notice-dismiss">
                                <span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'addon-bus--ticket-booking-with-seat-pro' ); ?></span>
                            </button>
                        </div>
						<?php
					} else {
						esc_html_e( 'Product  not found', 'addon-bus--ticket-booking-with-seat-pro' );
					}
				}
			}
			public function backend_order_hidden_input( $post_id ) {
				if ( is_admin() && str_contains( wp_get_referer(), 'wbtm_backend_order' ) ) {
					?>
                    <div class="_dLayout_mB_padding_xs_dFlex_justifyBetween_alignCenter">
                        <label class="mp_zero">
							<?php esc_html_e( 'Customer Order Confirmation Email ', 'addon-bus--ticket-booking-with-seat-pro' ); ?>
                        </label>
                        <input type="hidden" name="wbtm_backend_order_hidden_input" value="<?php echo esc_attr( $post_id ); ?>"/>
                        <input type="email" class="formControl max_300" name="wbtm_confirmation_email" placeholder="<?php esc_html_e( 'Type Order Confirmation Email ', 'addon-bus--ticket-booking-with-seat-pro' ); ?>"/>
                    </div>
					<?php
				}
			}
		}
		new WBTM_Backend_Order();
	}