<?php
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_CSV' ) ) {
		class WBTM_CSV {
			public function __construct() {
				add_action( 'wp_ajax_wbtm_download_csv', array( $this, 'wbtm_download_csv' ) );
				add_action( 'wp_ajax_nopriv_wbtm_download_csv', array( $this, 'wbtm_download_csv' ) );
			}
			public function wbtm_download_csv() {
				if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'wbtm_download_csv' && $_REQUEST['document_type'] == 'csv' ) {
					if ( ! current_user_can( 'manage_options' ) || ! is_admin() ) {
						return false;
					}
					ob_start();
					$args       = isset( $_REQUEST['args'] ) ? WBTM_Global_Function::data_sanitize( $_REQUEST['args'] ) : [];
					
					//$page = isset( $_REQUEST['page'] ) ? WBTM_Global_Function::data_sanitize( $_REQUEST['page'] ) : 1;
					$filename   = 'Bus_passenger_Export_' . $_SERVER['SERVER_NAME'] . '_' . time() . '.csv';
					$header_row = $this->csv_header();
					
					$data_rows  = $this->csv_data( $args);
					
					$fh         = @fopen( 'php://output', 'w' );
					fprintf( $fh, chr( 0xEF ) . chr( 0xBB ) . chr( 0xBF ) );
					header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
					header( 'Content-Description: File Transfer' );
					header( 'Content-type: text/csv' );
					header( "Content-Disposition: attachment; filename={$filename}" );
					header( 'Expires: 0' );
					header( 'Pragma: public' );
					if ( sizeof( $data_rows ) > 0 ) {
						fputcsv( $fh, $header_row );
						foreach ( $data_rows as $data_row ) {
							fputcsv( $fh, $data_row );
						}
					} else {
						fputcsv( $fh, array( esc_html__( 'No Data Found !', 'addon-bus--ticket-booking-with-seat-pro' ) ) );
					}
					fclose( $fh );
					ob_end_flush();
				}
				die();
			}
			public function csv_header(): array {
				$header=[];
				$show_bus_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_name', 'on');
				$show_bus_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_id', 'on');
				$show_price = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_price', 'on');
				$show_pin = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pin', 'on');
				$show_order_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_order_id', 'on');
				$show_seat_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_seat_name', 'on');
				$show_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_name', 'on');
				$show_phone = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_phone', 'on');
				$show_email = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_email', 'on');
				$show_address = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_address', 'on');
				$show_extra_service = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_extra_service', 'on');
				$show_from_to = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_from_to', 'on');
				$show_pick_drop = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pickup_drop_off', 'on');
				$show_journey_date = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_journey_date', 'on');

				if($show_bus_name != 'off'){
					$header[]=WBTM_Functions::get_name();
				}
				if($show_bus_id != 'off' ){
					$header[]=esc_html__('Bus No ', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_order_id != 'off'){
					$header[]=esc_html__('Order ID', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_pin != 'off'){
					$header[]=esc_html__('PIN', 'addon-bus--ticket-booking-with-seat-pro');
				}

				if($show_journey_date != 'off'){
					$header[]=esc_html__('Journey Date ', 'addon-bus--ticket-booking-with-seat-pro');
				}

				if($show_seat_name != 'off'){
					$header[]=esc_html__('Seat Name', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_name != 'off'){
					$header[]=esc_html__('Name', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_phone != 'off'){
					$header[]=esc_html__('Phone', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_email != 'off'){
					$header[]=esc_html__('Email', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_address != 'off'){
					$header[]=esc_html__('Address', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_extra_service != 'off'){
					$header[]=esc_html__('Extra Service', 'addon-bus--ticket-booking-with-seat-pro');
				}

				if($show_from_to != 'off'){
					$header[]=esc_html__('From', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_from_to != 'off'){
					$header[]=esc_html__('To', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_pick_drop != 'off'){
					$header[]=esc_html__('Pickup', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_pick_drop != 'off') {
					$header[] = esc_html__('Drop-Off', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if($show_price != 'off'){
					$header[]=esc_html__('Price', 'addon-bus--ticket-booking-with-seat-pro');
				}
				
				return $header;
			}
			public function csv_data( $args ): array {
				$show_bus_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_name', 'on');
				$show_bus_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_id', 'on');
				$show_price = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_price', 'on');
				$show_pin = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pin', 'on');
				$show_order_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_order_id', 'on');
				$show_seat_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_seat_name', 'on');
				$show_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_name', 'on');
				$show_phone = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_phone', 'on');

				$show_email = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_email', 'on');
				$show_address = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_address', 'on');
				$show_extra_service = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_extra_service', 'on');
				$show_from_to = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_from_to', 'on');
				$show_pick_drop = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pickup_drop_off', 'on');
				$show_journey_date = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_journey_date', 'on');
				$passenger_info = WBTM_Function_PRO::get_attendee_info(53);
				
				$data = array();
				$all_passengers = WBTM_Function_PRO::attendee_query($args);
				if ( $all_passengers->found_posts > 0 ) {
					$attendee_query = $all_passengers->posts;
					$count=0;
					foreach ( $attendee_query as $_attendee ) {
						
						$attendee_id   = $_attendee->ID;
						$post_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
						$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
						$bp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_point');
						$dp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_point');
						$order_status = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_status');
						
						$passenger_infos = WBTM_Function_PRO::get_attendee_info($attendee_id);
						
						
						unset($journey_date);
						$journey_date = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_start_time');
						$journey_date = $journey_date?WBTM_Global_Function::date_format($journey_date, 'full'):'';

						if ($order_status == 'partially-paid') {
							$paid_amount = WBTM_Global_Function::get_post_info($order_id, '_order_total');
						} else {
							$paid_amount = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
						}
						if($show_bus_name != 'off'){
							$data[$count][]=get_the_title($post_id);
						}
						if($show_bus_id != 'off'){
							$data[$count][]=WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_no');
						}
						if($show_order_id != 'off'){
							$data[$count][]=$order_id;
						}
						
						if($show_pin != 'off'){
							$data[$count][]=$attendee_id;
						}

						if($show_journey_date != 'off'){
							$data[$count][]=$journey_date;
						}

						if($show_seat_name != 'off'){
							$data[$count][]=WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat');
						}
						if($show_name != 'off'){
							
							// unset($passenger_name);
							$data[$count][] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_name');
							//$data[$count][]= WBTM_Passenger_List::get_passenger_info($passenger_infos,'wbtm_full_name');							
						}
						if($show_phone != 'off'){
							// unset($passenger_phone);
							$data[$count][] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_phone');
							//$data[$count][]= WBTM_Passenger_List::get_passenger_info($passenger_infos,'wbtm_reg_phone');
						}
						if($show_email != 'off'){
							// unset($passenger_email);
							$data[$count][] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_email');
							//$data[$count][]= WBTM_Passenger_List::get_passenger_info($passenger_infos,'wbtm_reg_email');							
						}
						if($show_address != 'off'){
							// unset($passenger_address);
							$data[$count][] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_address');
							//$data[$count][]= WBTM_Passenger_List::get_passenger_info($passenger_infos,'wbtm_reg_address');
						}
						if($show_extra_service != 'off'){
							// unset($passenger_extra_service);
							// $passenger_extra_service = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_address');
							$data[$count][]= WBTM_Passenger_List::extra_service($attendee_id);

						}
						if($show_from_to != 'off'){
							$data[$count][]=$bp;
						}
						if($show_from_to != 'off'){
							$data[$count][]=$dp;
						}
						if($show_pick_drop != 'off'){
							$data[$count][]=WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pickup_point');
						}
						if($show_pick_drop != 'off') {
							$data[$count][] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_drop_off_point');
						}
						if($show_price != 'off'){
							$data[$count][]=$paid_amount;
						}
						$count++;
					}
				}
				return $data;
			}
		}
		new WBTM_CSV();
	}