<?php
/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
if (!defined('ABSPATH')) {
	die;
} // Cannot access pages directly.
if (!class_exists('WBTM_Layout_Pro')) {
	class WBTM_Layout_Pro
	{
		public function __construct() {}
		public static function seat_info($attendee_id)
		{
			if ($attendee_id > 0) {
				$price = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
				$passenger_infos = WBTM_Function_PRO::get_attendee_info($attendee_id);
				$seat_name = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat');
?>
				<div class="divider"></div>
				<ul class="mp_list">
					<li class="justifyBetween _wrap">
						<strong class="min_150">
							<?php echo WBTM_Translations::text_seat_name(); ?> :
						</strong>
						<strong>
							<?php echo esc_html($seat_name); ?>
						</strong>
						<span>x 1 &nbsp;|&nbsp;<?php echo wc_price($price); ?> = <?php echo wc_price($price); ?></span>
					</li>
					<?php if (is_array($passenger_infos) && sizeof($passenger_infos) > 0) { ?>
						<?php foreach ($passenger_infos as $passenger_info) { ?>
							<li>
								<strong><?php echo esc_html__($passenger_info['name'], 'your-text-domain'); ?>:</strong>
								<span><?php echo esc_html__($passenger_info['value'], 'your-text-domain'); ?></span>
							</li>
						<?php } ?>
					<?php } ?>
				</ul>
			<?php
				self::ex_service_info($attendee_id);
				//echo '<pre>';print_r(WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []));echo '</pre>';
			}
		}
		public static function service_info($attendee_id)
		{
			if ($attendee_id > 0) {
				//$pin = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pin');
				$post_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
				$category = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_category');
				$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
				$bp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_point');
				$bp_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_time');
				$dp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_point');
				$dp_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_time');
				$start_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_start_point');
				$start_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_start');
				$pickup_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pickup_point');
				$drop_off_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_drop_off_point');
				$attendee_info = get_post($attendee_id);
				$order_status = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_status');
				$order_status_text = $order_status === 'partially-paid' ? 'Partially Paid' : $order_status;
			?>
				<h4><?php esc_html_e('Booking Information', 'addon-bus--ticket-booking-with-seat-pro'); ?></h4>
				<div class="divider"></div>
				<ul class="mp_list">
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_pin(); ?> :</strong>
						<span>#<?php echo esc_html($attendee_id); ?></span>
					</li>
					<li>
						<strong class="min_150"><?php esc_html_e('Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?> :</strong>&nbsp;#<?php echo esc_html($order_id); ?>
					</li>
					<li>
						<strong class="min_150"><?php esc_html_e('Bus Name', 'addon-bus--ticket-booking-with-seat-pro'); ?> :</strong>&nbsp;<?php echo get_the_title($post_id); ?>
					</li>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_bus_type(); ?> :</strong>&nbsp;<?php echo esc_html($category); ?>
					</li>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_attendee_id(); ?> :</strong> <?php echo esc_html($attendee_id); ?>
					</li>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_bp(); ?> :</strong>
						<span><?php echo esc_html($bp) . ' ' . esc_html($bp_time ? ' (' . WBTM_Global_Function::date_format($bp_time, 'full') . ' )' : ''); ?></span>
					</li>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_dp(); ?> :</strong>
						<span><?php echo esc_html($dp) . ' ' . esc_html($dp_time ? ' (' . WBTM_Global_Function::date_format($dp_time, 'full') . ' )' : ''); ?></span>
					</li>
					<?php if ($start_point != $bp) { ?>
						<li>
							<strong class="min_150"><?php echo WBTM_Translations::text_start_point(); ?> :</strong>
							<span><?php echo esc_html($start_point) . ' ' . esc_html($start_time ? ' (' . WBTM_Global_Function::date_format($start_time, 'full') . ' )' : ''); ?></span>
						</li>
					<?php } ?>
					<?php if ($pickup_point) { ?>
						<li>
							<strong class="min_150"><?php echo WBTM_Translations::text_pickup_point(); ?> :</strong>
							<span><?php echo esc_html($pickup_point); ?></span>
						</li>
					<?php } ?>
					<?php if ($drop_off_point) { ?>
						<li>
							<strong class="min_150"><?php echo WBTM_Translations::text_drop_off_point(); ?> :</strong>
							<span><?php echo esc_html($drop_off_point); ?></span>
						</li>
					<?php } ?>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_order_date(); ?> :</strong>
						<?php echo WBTM_Global_Function::date_format($attendee_info->post_date, 'full'); ?>
					</li>
					<li>
						<strong class="min_150"><?php echo WBTM_Translations::text_order_status(); ?> :</strong><?php echo esc_html($order_status_text); ?>
					</li>
					<li>

						<strong class="min_150"><?php echo WBTM_Translations::text_payment_method(); ?> :</strong><?php echo WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_billing_type'); ?>
					</li>
				</ul>
			<?php
			}
		}
		public static function ex_service_info($attendee_id)
		{

			$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
			if (sizeof($ex_service_infos) > 0) {
			?>
				<h4><?php echo WBTM_Translations::text_ex_service(); ?></h4>
				<div class="divider"></div>
				<ul class="mp_list">
					<?php
					foreach ($ex_service_infos as $ex_service_info) {
						$name = $ex_service_info['name'];
						$price = $ex_service_info['price'];
						$qty = $ex_service_info['qty'];
					?>
						<li class="justifyBetween">
							<strong class="min_100"> <?php echo esc_html($name); ?> </strong>
							<span>x<?php echo esc_html($qty); ?>&nbsp;|&nbsp;<?php echo wc_price($price); ?> = <?php echo wc_price($price * $qty); ?></span>
						</li>
					<?php
					}
					?>
				</ul>
			<?php
			}
		}
		public static function billing_info($attendee_id)
		{
			$billing_name = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_name');
			$email = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_email');
			$phone = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_phone');
			$address = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_address');
			?>
			<h4><?php esc_html_e('Billing information', 'addon-bus--ticket-booking-with-seat-pro'); ?></h4>
			<div class="divider"></div>
			<ul class="mp_list">
				<?php if ($billing_name) { ?>
					<li>
						<strong class="min_100"><?php esc_html_e('Name', 'addon-bus--ticket-booking-with-seat-pro'); ?> : &nbsp;</strong>
						<?php echo esc_html($billing_name); ?>
					</li>
				<?php } ?>
				<?php if ($email) { ?>
					<li>
						<strong class="min_100"><?php esc_html_e('E-mail', 'addon-bus--ticket-booking-with-seat-pro'); ?> : &nbsp;</strong>
						<?php echo esc_html($email); ?>
					</li>
				<?php } ?>
				<?php if ($phone) { ?>
					<li>
						<strong class="min_100"><?php esc_html_e('Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?> : &nbsp;</strong>
						<?php echo esc_html($phone); ?>
					</li>
				<?php } ?>
				<?php if ($address) { ?>
					<li>
						<strong class="min_100"><?php esc_html_e('Address', 'addon-bus--ticket-booking-with-seat-pro'); ?> : &nbsp;</strong>
						<?php echo esc_html($address); ?>
					</li>
				<?php } ?>
			</ul>
		<?php
		}
		/**************************/
		public static function select_user()
		{
		?>
			<div class="inputList">
				<label class="fdColumn" id="wbtm_select_bus_user">
					<span class="fas fa-user-tie"><?php esc_html_e('Select User', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
					<select name="wbtm_bus_user" class="formControl wbtm_select2">
						<option value=" "><?php echo WBTM_Translations::text_please_select(); ?></option>
						<?php
						$users = get_users(array('role__not_in' => array('customer')));
						if (sizeof($users) > 0) {
							foreach ($users as $user) {
						?>
								<option value="<?php echo esc_attr($user->ID); ?>">
									<?php echo esc_html(ucfirst($user->data->display_name)); ?>
								</option>
						<?php
							}
						}
						?>
					</select>
				</label>
			</div>
		<?php
		}
		public static function select_bus()
		{
			$label = WBTM_Functions::get_name();
		?>
			<div class="inputList">
				<h5 class="padding_xs"><span class="fas fa-bus"></span> <?php echo esc_html__('Select', 'addon-bus--ticket-booking-with-seat-pro') . ' ' . esc_html($label); ?></h5>
				<label class="fdColumn" id="wbtm_select_bus_id">
					<select name="wbtm_bus_id" class="formControl wbtm_select2" required>
						<option value=" "><?php echo WBTM_Translations::text_please_select(); ?></option>
						<?php
						$loop = WBTM_Global_Function::query_post_type(WBTM_Functions::get_cpt());
						$posts = $loop->posts;
						foreach ($posts as $post) {
							$post_id = $post->ID;
							$bus_id = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_no');
							$category = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_category');
						?>
							<option value="<?php echo esc_attr($post_id); ?>">
								<?php echo get_the_title($post_id); ?>
								<?php echo esc_html($bus_id ? '=>' . $bus_id : ''); ?>
								<?php echo esc_html($category ? '(' . $category . ')' : ''); ?>
							</option>
						<?php
						}
						wp_reset_postdata();
						?>
					</select>
				</label>
			</div>
		<?php
		}
		public static function select_journey_date($post_id = 0)
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_bus_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_journey_date(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_start_time" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_journey_date_from()
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_bus_from_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_journey_date() . ' ' . WBTM_Translations::text_from(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_start_time_from" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_journey_date_to()
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_bus_to_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_journey_date() . ' ' . WBTM_Translations::text_to(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_start_time_to" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_order_date($post_id = 0)
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_booking_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_order_date(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_booking_date" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_order_date_from($post_id = 0)
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_booking_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_order_date() . ' ' . WBTM_Translations::text_from(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_booking_date_from" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_order_date_to($post_id = 0)
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_booking_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php echo WBTM_Translations::text_order_date() . ' ' . WBTM_Translations::text_to(); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_booking_date_to" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_bp_date($post_id = 0)
		{
			$date_format = WBTM_Global_Function::date_picker_format();
			$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
		?>
			<div id="wbtm_select_bp_date" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-calendar-alt"></span> <?php esc_attr_e('Boarding Point Date', 'addon-bus--ticket-booking-with-seat-pro'); ?></h5>
				<label class="fdColumn">
					<input type="hidden" name="wbtm_boarding_time" value="" />
					<input type="text" value="" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>" readonly />
				</label>
			</div>
		<?php
		}
		public static function select_bp_point($post_id = 0)
		{
		?>
			<div class='inputList'>
				<div class="wbtm_input_select">
					<h5 class="padding_xs"><span class="fas fa-map-marker"></span> <?php echo WBTM_Translations::text_bp(); ?></h5>
					<label class="fdColumn ">
						<input type="text" class="formControl wbtm_name_validation" name="wbtm_boarding_point" value="" placeholder="<?php esc_attr_e('Enter Boarding Point', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
					</label>
					<?php WBTM_Layout::route_list(); ?>
				</div>
			</div>
		<?php
		}
		public static function select_dp_point($post_id = 0)
		{
		?>
			<div class='inputList'>
				<div class="wbtm_input_select">
					<h5 class="padding_xs"><span class="fas fa-map-marker"></span> <?php echo WBTM_Translations::text_dp(); ?></h5>
					<label class="fdColumn ">
						<input type="text" class="formControl wbtm_name_validation" name="wbtm_dropping_point" value="" placeholder="<?php esc_attr_e('Enter Dropping Point', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
					</label>
					<?php WBTM_Layout::route_list(); ?>
				</div>
			</div>
		<?php
		}
		public static function select_order_id($post_id = 0)
		{
		?>
			<div id="wbtm_select_order_id" class='inputList'>
				<h5 class="padding_xs"><span class="fab fa-first-order-alt"></span> <?php esc_html_e('Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?></h5>
				<label class="fdColumn ">
					<input type="text" class="formControl wbtm_number_validation" name="wbtm_order_id" value="" placeholder="<?php esc_attr_e('Enter Order no..', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
				</label>
			</div>
		<?php
		}
		public static function select_passenger_name($post_id = 0)
		{
		?>
			<div id="wbtm_select_passenger_name" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-user-tie"></span> <?php esc_html_e('Billing Name', 'addon-bus--ticket-booking-with-seat-pro'); ?></h5>
				<label class="fdColumn ">
					<input type="text" class="formControl wbtm_name_validation" name="wbtm_user_name" value="" placeholder="<?php esc_attr_e('Enter Passenger Name', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
				</label>
			</div>
		<?php
		}
		public static function select_passenger_email($post_id = 0)
		{
		?>
			<div id="wbtm_select_passenger_email" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-envelope"></span> <?php esc_html_e('Billing Email', 'addon-bus--ticket-booking-with-seat-pro'); ?></h5>
				<label class="fdColumn ">
					<input type="email" class="formControl" name="wbtm_user_email" value="" placeholder="<?php esc_attr_e('Enter Passenger Email', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
				</label>
			</div>
		<?php
		}
		public static function select_passenger_phone($post_id = 0)
		{
		?>
			<div id="wbtm_select_passenger_phone" class='inputList'>
				<h5 class="padding_xs"><span class="fas fa-phone"></span> <?php esc_html_e('Billing Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?></h5>
				<label class="fdColumn ">
					<input type="text" class="formControl" name="wbtm_user_phone" value="" placeholder="<?php esc_attr_e('Enter Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?>" autocomplete="off" />
				</label>
			</div>
<?php
		}
		/**************************/
	}
	new  WBTM_Layout_Pro();
}
