<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_Pro_Mail' ) ) {
		class WBTM_Pro_Mail {
			public function __construct() {
				add_action( 'wbtm_send_mail', array( $this, 'send_mail' ) );
				add_filter( 'wp_mail_content_type', array( $this, 'email_content_type' ) );
			}

			public function send_mail($order_id = '') {
				$order = wc_get_order($order_id);
				if (empty($order_id) || !$order) {
					return new WP_Error('invalid_data', esc_html__('Invalid order id provided', 'addon-bus--ticket-booking-with-seat-pro'));
				}
			
				// Check if email has already been sent
				$email_sent = get_post_meta($order_id, '_wbtm_email_sent', true);
				if ($email_sent) {
					// return; // Email already sent, don't send again
				}
			
				$subject = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_email_subject', 'PDF Ticket Confirmation');
				$content = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_email_content', 'Here is PDF Ticket Confirmation Attachment');
				$form_name = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_email_form_name');
				$form_email = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_email_form_email');
				$form_name = $form_name ?: get_option('woocommerce_email_from_name');
				$form_email = $form_email ?: get_option('woocommerce_email_from_address');
				$admin_notify_email = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_admin_notification_email', '');
				$email_status = WBTM_Global_Function::get_settings('wbtm_email_settings', 'pdf_send_status', 'yes');
				$attachments = array();
				$headers = array(
					sprintf("From: %s <%s>", $form_name, $form_email),
				);
			
				if ($email_status == 'yes') {
					$guest_query = WBTM_Function_PRO::attendee_query(array('wbtm_order_id' => $order_id));
					if ($guest_query && $guest_query->post_count > 0) {
						$upload_dir = wp_upload_dir();
						$pdf_url = $upload_dir['basedir'] . '/' . esc_html__('Ticket', 'addon-bus--ticket-booking-with-seat-pro') . $order_id . '.pdf';
						
						// Generate PDF
						do_action('wbtm_generate_pdf', ['wbtm_order_id' => $order_id], $pdf_url, 'mail');
						
						// Wait for a short time to ensure PDF generation is complete
						sleep(2);
						
						// Check if PDF was generated successfully
						if (file_exists($pdf_url) && !is_wp_error($pdf_url)) {
							$attachments[] = $pdf_url;
							error_log("PDF attached: " . $pdf_url);
						} else {
							error_log("PDF file does not exist or there was an error: " . $pdf_url);
						}
					}
			
					$email_address_arr = array(
						$order->get_billing_email(),
						$admin_notify_email
					);
					$email_address = implode(",", $email_address_arr);
					
					// Mail content dynamic
					$content = $this->mail_content($content, $order);
					$pdf_email_content = apply_filters('wbtm_pdf_email_text', $content, $order_id);
					if(!empty($attachments)){
						$result = wp_mail($email_address, $subject, nl2br($pdf_email_content), $headers, $attachments);
					}
					error_log("Email sent result: " . ($result ? "Success" : "Failure"));
			
					// After sending email successfully
					if ($result) {
						update_post_meta($order_id, '_wbtm_email_sent', true);
					}
				}
			}

			public function mail_content( $content, $order ) {
				$get_content = $content;

				$get_content = str_replace( '{customer_name}', $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(), $get_content );
				$get_content = str_replace( '{order_id}', $order->get_order_number(), $get_content );
				$item_id     = current( array_keys( $order->get_items() ) );
				$post_id     = WBTM_Global_Function::get_order_item_meta( $item_id, '_wbtm_bus_id' );
				$post_title  = get_the_title( $post_id );
				$date        = WBTM_Global_Function::get_order_item_meta( $item_id, '_wbtm_bp_time' );
				$date        = WBTM_Global_Function::date_format( $date, 'full' );
				$get_content = str_replace( '{bus_name}', $post_title, $get_content );

				return str_replace( '{journey_date}', $date, $get_content );

			}

			//*************************//
			public function email_content_type() {
				return "text/html";
			}
		}
		new WBTM_Pro_Mail();
	}
