<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_View_Ticket')) {
		class WBTM_View_Ticket {
			public function __construct() {
				add_shortcode('view-ticket', [$this, 'view_ticket']);
			}
			public function view_ticket() {
				$pin = WBTM_Global_Function::get_submit_info_get_method('wbtm_pin');
                ob_start();
				?>
				<div class="wbtm_style">
					<div class="_max_600_fullAuto">
						<div class="dLayout dShadow_10">
							<h3><?php esc_html_e('Search Ticket', 'addon-bus--ticket-booking-with-seat-pro'); ?></h3>
							<div class="_divider"></div>
							<form action="<?php echo get_site_url(); ?>/view-ticket" method="get">
								<label class="allCenter">
									<span class="fas fa-ticket-alt _mR_xs"></span>
									<span class="_mR_xs"><?php esc_html_e('Ticket PIN', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
									<input type="text" class="formControl" value="<?php echo esc_attr($pin); ?>" name="wbtm_pin" placeholder="<?php esc_html_e('Enter Ticket PIN', 'addon-bus--ticket-booking-with-seat-pro'); ?>"/>
								</label>
								<div class="_divider"></div>
								<button type="submit" class="_successButton">
									<?php esc_html_e('Search Ticket', 'addon-bus--ticket-booking-with-seat-pro'); ?>
								</button>
							</form>
						</div>
						<?php
							if (is_user_logged_in()) {
								$attendee_ids = $pin ? explode('-', $pin) : '';
								if ($pin && sizeof($attendee_ids)>0) {
									$current_id = current($attendee_ids);
									$user_id = get_current_user_id();
									$current_user_id = WBTM_Global_Function::get_post_info($current_id, 'wbtm_user_id');
									$user_role=apply_filters('wbtm_user_role_check',false);
									if (is_admin() || $current_user_id == $user_id || $user_role) {
										if (sizeof($attendee_ids) > 1) {
											$order_id = WBTM_Global_Function::get_post_info($current_id, 'wbtm_order_id');
											$download_url = WBTM_Pro_Pdf::get_pdf_url(array('order_id' => $order_id));
										}
										else {
											$download_url = WBTM_Pro_Pdf::get_pdf_url(array('attendee_id' => $current_id));
										}
										?>
										<div class="dLayout dShadow_10">
											<?php WBTM_Layout_Pro::service_info($current_id); ?>
										</div>
										<div class="dLayout dShadow_10">
											<div class="justifyBetween _alignCenter">
												<h4><?php echo WBTM_Translations::text_passenger_info(); ?></h4>
												<?php WBTM_Pro_Pdf::pdf_download_button($download_url); ?>
											</div>
											<?php foreach ($attendee_ids as $attendee_id) { ?>
												<?php WBTM_Layout_Pro::seat_info($attendee_id); ?>
												<?php do_action('wbtm_add_after_seat_info',$attendee_id); ?>
											<?php } ?>
										</div>
										<div class="dLayout dShadow_10"><?php WBTM_Layout_Pro::billing_info($current_id); ?></div>
										<?php
									}else{
										WBTM_Layout::msg(esc_html__('You are not permitted to view this ticket !', 'addon-bus--ticket-booking-with-seat-pro'));
									}
								}
							}
							else {
								WBTM_Layout::msg(esc_html__('You need to login your account to view the ticket ! ', 'addon-bus--ticket-booking-with-seat-pro'));
							}
						?>
					</div>
				</div>
				<?php
				return ob_get_clean();
			}
		}
		new WBTM_View_Ticket();
	}