<?php
	if (!defined('ABSPATH')) {
		exit;
	}  // if direct access
	$args = $args ?? [];

	if (sizeof($args) > 0) {
		$css_url = WBTM_PLUGIN_URL_PRO . '/assets/admin/wbtm_pdf.css';
		?>
		<link rel="stylesheet" href="<?php echo esc_url($css_url); ?>">
		<html>
	<body>
		<?php
		$bg_color = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_bg_color', '#fbfbfb');
		$text_color = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_text_color', '#000');
		$bg_image = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'pdf_bg');
		$bg_image=$bg_image>0?wp_get_attachment_image_url($bg_image,'full'):$bg_image;
		?>
		<style type="text/css">
			.mp_pdf {
				color: <?php echo $text_color; ?>;
				background: <?php echo $bg_color; ?> url(<?php echo $bg_image; ?>) no-repeat center;
			}
		</style>
		<?php
		$merge_pdf = WBTM_Global_Function::get_settings('wbtm_pdf_settings', 'merge_pdf_ticket', 'no');
		$order_id = array_key_exists('wbtm_order_id', $args) && $args['wbtm_order_id'] ? $args['wbtm_order_id'] : '';
		$ticket_id = array_key_exists('attendee_id', $args) && $args['attendee_id'] ? $args['attendee_id'] : '';
		$bus_id = array_key_exists('wbtm_bus_id', $args) && $args['wbtm_bus_id'] ? $args['wbtm_bus_id'] : 0;
		if ($bus_id > 0) 
		{
			include WBTM_PLUGIN_DIR_PRO . '/template/pdf/passenger_list_pdf.php';
		}
		else 
		{
			if ($ticket_id && $ticket_id > 0) 
			{
				$total_guest = 1;
				if ($merge_pdf == 'yes') {
					$order_id = WBTM_Global_Function::get_post_info($ticket_id, 'wbtm_order_id');
					if ($order_id) {
						$filter_args['wbtm_order_id'] = $order_id;
						$guest_query = WBTM_Function_PRO::attendee_query($filter_args);
						$total_guest = $guest_query->post_count;
					}
				}
				include WBTM_PLUGIN_DIR_PRO . '/template/pdf/default.php';
				if ($total_guest > 1) {
					include WBTM_PLUGIN_DIR_PRO . '/template/pdf/ex_service_pdf.php';
				}
			}
			else 
			{
				$all_items = WBTM_Function_PRO::order_item_data($order_id);
				$total_guest = 0;
				if (sizeof($all_items) > 0) 
				{
					if ($merge_pdf == 'yes') 
					{
						foreach ($all_items as $all_item) 
						{
							if (is_array($all_item)) {
								$total_guest += sizeof($all_item);
							}
							else {
								$total_guest += 1;
							}
						}
						$i = 0;
						foreach ($all_items as $all_item) {
							if (is_array($all_item)) {
								$all_attendees = $all_item;
								include WBTM_PLUGIN_DIR_PRO . '/template/pdf/default.php';
								if ($i < $total_guest - 1) {
									$i++;
									?>
									<div class="page_break"></div>
									<?php
								}
							}
							else {
								$all_attendees = $all_items;
								include WBTM_PLUGIN_DIR_PRO . '/template/pdf/default.php';
								if ($i < $total_guest - 1) {
									$i++;
									?>
									<div class="page_break"></div>
									<?php
								}
								break;
							}
						}
					}
					else 
					{
						$i = 0;
						foreach ($all_items as $all_item) 
						{
							if (is_array($all_item)) 
							{
								foreach ($all_item as $item) {
									$ticket_id = $item;
									include WBTM_PLUGIN_DIR_PRO . '/template/pdf/default.php';
									if ($i < $total_guest - 1) {
										$i++;
										?>
										<div class="page_break"></div>
										<?php
									}
								}
							}
							else 
							{
								$ticket_id = $all_item;
								include WBTM_PLUGIN_DIR_PRO . '/template/pdf/default.php';
								if ($i < $total_guest - 1) {
									$i++;
									?>
									<div class="page_break"></div>
									<?php
								}
							}
						}
					}
				}
			}
		}
	}