jQuery(function ($) {

    // Login dependencies
    const facebookLogin = $(document).find('#yith_welrp_social_login_facebook');
    const googleLogin = $(document).find('#yith_welrp_social_login_google');
    const fbIconType = facebookLogin.find('#yith_welrp_social_login_facebook_icon_type input');
    const gIconType = googleLogin.find('#yith_welrp_social_login_google_icon_type input');
    const fbMedia = facebookLogin.find('.yith-toggle-content-row.media');
    const gMedia = googleLogin.find('.yith-toggle-content-row.media');

    // Lost password dependencies
    const recoverStep = $(document).find('#yith_welrp_panel_login-step-lost-password');
    const recoverType = recoverStep.find('#yith_welrp_popup_lost_password_recover_type input');
    const sendCodeCk = recoverStep.find('#yith_welrp_popup_lost_password_authentication_send_again');
    const setNewPwsSection = recoverStep.find('#yith_welrp_popup_lost_password_set_repeat_input_label').closest('.yith-plugin-fw__panel__section');

    function showField(value, media) {
        if (value) {
            media.show();
        } else {
            media.hide();
        }
    }

    fbIconType.on('change', function (e) {
        const value = e.target.value;

        showField( 'custom' ===value, fbMedia)

    })

    gIconType.on('change', function (e) {
        const value = e.target.value;

        showField('custom' === value, gMedia)

    })

    recoverType.on('change', function (e) {
        const value = e.target.value;

        if('with-code'!==value  && sendCodeCk.is(':checked')){
            sendCodeCk.click();
        }
        showField( 'with-code' === value, setNewPwsSection );
    });
    showField('custom' === fbIconType.filter(':checked').val(), fbMedia)
    showField('custom' === gIconType.filter(':checked').val(), gMedia)
    showField('with-code' === recoverType.filter(':checked').val(), setNewPwsSection)

    if('with-code'!==recoverType.filter(':checked').val()  && sendCodeCk.is(':checked')){
        sendCodeCk.click();
    }
})