<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase, WordPress.Files.FileName.InvalidClassFileName
/**
 * Admin class
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH Easy Login & Register Popup For WooCommerce
 * @version 1.0.0
 */

defined( 'YITH_WELRP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_Easy_Login_Register_Admin' ) ) {
	/**
	 * YITH Easy Login & Register Popup For WooCommerce
	 *
	 * @since 1.0.0
	 */
	class YITH_Easy_Login_Register_Admin {

		/**
		 * Panel Object
		 *
		 * @var YIT_Plugin_Panel_WooCommerce|null
		 */
		protected $panel = null;

		/**
		 * Plugin panel page
		 *
		 * @var string
		 */
		protected $panel_page = 'yith_welrp_panel';

		/**
		 * Constructor
		 *
		 * @return void
		 * @since 1.0.0
		 */
		public function __construct() {
			// Add panel options.
			add_action( 'admin_menu', array( $this, 'register_panel' ), 5 );
			// Add action links.
			add_filter( 'plugin_action_links_' . plugin_basename( YITH_WELRP_PATH . '/' . basename( YITH_WELRP_FILE ) ), array( $this, 'action_links' ) );
			add_filter( 'yith_show_plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 5 );
			// Enqueue custom CSS.
			add_action( 'admin_enqueue_scripts', array( $this, 'custom_css' ), 99 );
		}

		/**
		 * Add a panel under YITH Plugins tab
		 *
		 * @return   void
		 * @since    1.0.0
		 * @use      /Yit_Plugin_Panel class
		 * @see      plugin-fw/lib/yit-plugin-panel.php
		 */
		public function register_panel() {

			if ( ! empty( $this->panel ) ) {
				return;
			}

			$admin_tabs = array(
				'general'          => array(
					'title'       => __( 'General Settings', 'yith-easy-login-register-popup-for-woocommerce' ),
					'icon'        => 'settings',
					'description' => __( 'Set the general options for the plugin behavior.', 'yith-easy-login-register-popup-for-woocommerce' ),
				),
				'login-step'       => array(
					'title' => __( 'Steps Options', 'yith-easy-login-register-popup-for-woocommerce' ),
					'icon'  => '<svg dataSlot="icon" fill="none" strokeWidth={1.5} stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path strokeLinecap="round" strokeLinejoin="round" d="M2.25 7.125C2.25 6.504 2.754 6 3.375 6h6c.621 0 1.125.504 1.125 1.125v3.75c0 .621-.504 1.125-1.125 1.125h-6a1.125 1.125 0 0 1-1.125-1.125v-3.75ZM14.25 8.625c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v8.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 0 1-1.125-1.125v-8.25ZM3.75 16.125c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 0 1-1.125-1.125v-2.25Z" /></svg>',
				),
				'additional-popup' => array(
					'title'       => __( 'Additional Popup', 'yith-easy-login-register-popup-for-woocommerce' ),
					'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6"><path stroke-linecap="round" stroke-linejoin="round" d="M16.5 8.25V6a2.25 2.25 0 0 0-2.25-2.25H6A2.25 2.25 0 0 0 3.75 6v8.25A2.25 2.25 0 0 0 6 16.5h2.25m8.25-8.25H18a2.25 2.25 0 0 1 2.25 2.25V18A2.25 2.25 0 0 1 18 20.25h-7.5A2.25 2.25 0 0 1 8.25 18v-1.5m8.25-8.25h-6a2.25 2.25 0 0 0-2.25 2.25v6" /></svg>',
					'description' => __( 'Set the options to place the login/register popup anywhere.', 'yith-easy-login-register-popup-for-woocommerce' ),
				),
				'customization'    => array(
					'title'       => __( 'Customization', 'yith-easy-login-register-popup-for-woocommerce' ),
					'icon'        => '<svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M15 11.25l1.5 1.5.75-.75V8.758l2.276-.61a3 3 0 10-3.675-3.675l-.61 2.277H12l-.75.75 1.5 1.5M15 11.25l-8.47 8.47c-.34.34-.8.53-1.28.53s-.94.19-1.28.53l-.97.97-.75-.75.97-.97c.34-.34.53-.8.53-1.28s.19-.94.53-1.28L12.75 9M15 11.25L12.75 9"></path></svg>',
					'description' => __( 'Customize the colors of the popup and the button.', 'yith-easy-login-register-popup-for-woocommerce' ),
				),
			);

			$args = array(
				'ui_version'         => 2,
				'create_menu_page'   => true,
				'parent_slug'        => '',
				'page_title'         => 'YITH Easy Login & Register Popup for WooCommerce',
				'plugin_description' => _x( 'Makes the login, registration and password reset processes easier during the checkout and reduces the cart abandonment rate.', 'plugin description on options page', 'yith-easy-login-register-popup-for-woocommerce' ),
				'menu_title'         => 'Easy Login & Register Popup',
				'capability'         => 'manage_options',
				'parent'             => '',
				'parent_page'        => 'yith_plugin_panel',
				'page'               => $this->panel_page,
				'admin-tabs'         => $admin_tabs,
				'options-path'       => YITH_WELRP_PATH . '/plugin-options',
				'plugin_slug'        => YITH_WELRP_SLUG,
				'class'              => yith_set_wrapper_class(),
				'is_premium'         => true,
				'your_store_tools'   => array(
					'items' => array(
						'ajax-search'          => array(
							'name'           => 'Ajax Search',
							'icon_url'       => YITH_WELRP_ASSETS_URL . '/images/plugins/ajax-search.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-ajax-search/',
							// translators: Description of "YITH WooCommerce Ajax Search" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Add an intelligent search engine to your store so that your customers can quickly find the products they are looking for.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_WCAS_INIT' ),
							'is_recommended' => true,
						),
						'gift-cards'           => array(
							'name'           => 'Gift Cards',
							'icon_url'       => YITH_WELRP_ASSETS_URL . '/images/plugins/gift-card.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-gift-cards/',
							// translators: Description of "YITH WooCommerce Gift Cards" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Sell gift cards to increase your store\'s revenue and win new customers.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_YWGC_PREMIUM' ),
							'is_recommended' => true,
						),
						'ajax-product-filter'  => array(
							'name'           => 'Ajax Product Filter',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/ajax-product-filter.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/',
							// translators: Description of "YITH WooCommerce Ajax Product Filter" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Help your customers to easily find the products they are looking for and improve the user experience of your shop.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_WCAN_PREMIUM' ),
							'is_recommended' => false,
						),
						'wishlist'             => array(
							'name'           => 'Wishlist',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/wishlist.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-wishlist/',
							// translators: Description of "YITH WooCommerce Wishlist" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Allow your customers to create lists of products they want and share them with family and friends.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_WCWL_PREMIUM' ),
							'is_recommended' => false,
						),
						'product-addons'       => array(
							'name'           => 'Product Add-Ons & Extra Options',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/product-add-ons.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-product-add-ons/',
							// translators: Description of "YITH WooCommerce Product Add-Ons & Extra Options" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Add paid or free advanced options to your product pages using fields like radio buttons, checkboxes, drop-downs, custom text inputs, and more.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_WAPO_PREMIUM' ),
							'is_recommended' => false,
						),
						'request-a-quote'      => array(
							'name'           => 'Request a Quote',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/request-a-quote.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-request-a-quote/',
							// translators: Description of "YITH Request a Quote for WooCommerce" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Hide prices and/or the "Add to cart" button and let your customers request a custom quote for every product.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_YWRAQ_PREMIUM' ),
							'is_recommended' => false,
						),
						'dynamic-pricing'      => array(
							'name'           => 'Dynamic Pricing & Discounts',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/dynamic-pricing-and-discounts.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-dynamic-pricing-and-discounts/',
							// translators: Description of "YITH WooCommerce Dynamic Pricing & Discounts" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'The best-selling plugin for creating promotions and upsell strategies in your store: 3x2, 2x1, BOGO, free products in the cart, quantity discounts, last-minute offers, and more.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_YWDPD_PREMIUM' ),
							'is_recommended' => false,
						),
						'customize-my-account' => array(
							'name'           => 'Customize My Account Page',
							'icon_url'       => YITH_WELRP_ASSETS_URL . 'images/plugins/customize-myaccount-page.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-customize-my-account-page/',
							// translators: Description of "YITH WooCommerce Customize My Account Page" plugin in the "Your Store Tools" tab.
							'description'    => __(
								'Customize your customers\' My Account page by creating custom sections with promotions and ad-hoc content based on your needs.',
								'yith-easy-login-register-popup-for-woocommerce'
							),
							'is_active'      => defined( 'YITH_WCMAP_PREMIUM' ),
							'is_recommended' => false,
						),
					),
				),
				'help_tab'           => array(
					'main_video' => array(
						'desc' => _x( 'Check this video to learn how to <b>integrate Google and Facebook logins:</b>', '[HELP TAB] Video title', 'yith-easy-login-register-popup-for-woocommerce' ),
						'url'  => array(
							'en' => 'https://www.youtube.com/embed/cCPUjMeYpts',
							'it' => 'https://www.youtube.com/embed/egvOA54JpMM',
							'es' => 'https://www.youtube.com/embed/h-vk_eeqcXU',
						),
					),
					'playlists'  => array(
						'en' => 'https://www.youtube.com/watch?v=cCPUjMeYpts&list=PLDriKG-6905lLtK7X-xTqQIVThY69A2pz',
						'it' => 'https://www.youtube.com/watch?v=egvOA54JpMM&list=PL9c19edGMs0-3057GdT-1hDdne3P_SCQi',
						'es' => 'https://www.youtube.com/watch?v=h-vk_eeqcXU&list=PL9Ka3j92PYJMrufP9BP16W2cGGegpoC7z',
					),
					'hc_url'     => 'https://support.yithemes.com/hc/en-us/categories/4698314455185-YITH-EASY-LOGIN-REGISTER-POPUP-FOR-WOOCOMMERCE',
					'doc_url'    => 'https://docs.yithemes.com/yith-easy-login-register-popup-for-woocommerce/',
				),
				'welcome_modals'     => array(
					'on_close' => function () {
						update_option( 'yith-easy-login-welcome-modal', 'no' );
					},
					'modals'   => array(
						'welcome' => array(
							'type'        => 'welcome',
							'description' => __( 'The #1 plugin to make the login, registration and password reset processes easier and to reduce the cart abandonment rate. ', 'yith-easy-login-register-popup-for-woocommerce' ),
							'show'        => get_option( 'yith-easy-login-welcome-modal', 'welcome' ) === 'welcome',
							'items'       => array(
								'documentation' => array(
									'title'       => __( '<mark>Read the plugin documentation</mark>', 'yith-easy-login-register-popup-for-woocommerce' ),
									'description' => __( 'Learn what you can really do with this tool', 'yith-easy-login-register-popup-for-woocommerce' ),
									'url'         => '//docs.yithemes.com/yith-easy-login-register-popup-for-woocommerce/',
								),
								'watch-video'   => array(
									'title'       => __( '<mark>Watch our first steps video</mark>', 'yith-easy-login-register-popup-for-woocommerce' ),
									'description' => __( 'See how it works before you start using it ', 'yith-easy-login-register-popup-for-woocommerce' ),
									'url'         => add_query_arg(
										array(
											'page' => 'yith_welrp_panel',
											'tab'  => 'help',
										),
										admin_url( 'admin.php' )
									),
								),
								'customize'     => array(
									'title'       => __( '<mark>Personalize every step</mark> of the login/registration process of your shop', 'yith-easy-login-register-popup-for-woocommerce' ),
									'description' => __( 'and embark on this new adventure!', 'yith-easy-login-register-popup-for-woocommerce' ),
									'url'         => add_query_arg(
										array(
											'page' => 'yith_welrp_panel',
											'tab'  => 'login-step',
										),
										admin_url( 'admin.php' )
									),
								),
							),
						),
					),
				),
			);

			if ( ! class_exists( 'YIT_Plugin_Panel_WooCommerce' ) ) {
				require_once 'plugin-fw/lib/yit-plugin-panel-wc.php';
			}

			$this->panel = new YIT_Plugin_Panel_WooCommerce( $args );
		}

		/**
		 * Custom admin css plugin
		 *
		 * @since   1.0.0
		 */
		public function custom_css() {
			if ( isset( $_GET['page'] ) && sanitize_text_field( wp_unslash( $_GET['page'] ) ) === $this->panel_page ) { // phpcs:ignore WordPress.Security.NonceVerification
				$custom_css = '#yith_welrp_additional_popup_options-description p{background:none!important;font-weight:400!important;width:auto!important;padding:0 10px 0 0!important;}
                #yith_welrp_additional_popup_options-description p:before{display:none!important;}
                #yith_welrp_social_login_facebook, #yith_welrp_social_login_google {width: 100%;}
				#yith_welrp_social_login_facebook .description,  #yith_welrp_social_login_google .description {padding-top: 5px; display:inline-block}';
				wp_add_inline_style( 'yith-plugin-fw-fields', $custom_css );

				wp_enqueue_style( 'yith_welrp_admin', YITH_WELRP_ASSETS_URL . '/css/admin.css', false, YITH_WELRP_VERSION );
				wp_enqueue_script( 'yith_welrp_admin', YITH_WELRP_ASSETS_URL . '/js/' . yit_load_js_file( 'admin.js' ), array( 'jquery' ), YITH_WELRP_VERSION );
			}
		}

		/**
		 * Action Links: add the action links to plugin admin page
		 *
		 * @param array $links Links plugin array.
		 *
		 * @return   mixed
		 * @use      plugin_action_links_{$plugin_file_name}
		 * @since    1.0.0
		 */
		public function action_links( $links ) {
			$links = yith_add_action_links( $links, $this->panel_page, true, YITH_WELRP_SLUG );

			return $links;
		}

		/**
		 * Add the action links to plugin admin page
		 *
		 * @param array    $new_row_meta_args An array of plugin row meta.
		 * @param string[] $plugin_meta An array of the plugin's metadata,
		 *                                    including the version, author,
		 *                                    author URI, and plugin URI.
		 * @param string   $plugin_file Path to the plugin file relative to the plugins directory.
		 * @param array    $plugin_data An array of plugin data.
		 * @param string   $status Status of the plugin. Defaults are 'All', 'Active',
		 *                                    'Inactive', 'Recently Activated', 'Upgrade', 'Must-Use',
		 *                                    'Drop-ins', 'Search', 'Paused'.
		 *
		 * @return   array
		 * @since    1.0.0
		 * @use      plugin_row_meta
		 */
		public function plugin_row_meta( $new_row_meta_args, $plugin_meta, $plugin_file, $plugin_data, $status ) {
			if ( defined( 'YITH_WELRP_INIT' ) && YITH_WELRP_INIT === $plugin_file ) {
				$new_row_meta_args['slug']       = YITH_WELRP_SLUG;
				$new_row_meta_args['is_premium'] = true;
			}

			return $new_row_meta_args;
		}
	}
}
