<?php
/**
 *  Customization array
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH Easy Login & Register Popup For WooCommerce
 * @version 1.0.0
 */

defined( 'YITH_WELRP' ) || exit;

$settings = array(
	'customization' => array(
		array(
			'title' => _x( 'Popup colors', '[admin]Settings section title', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'  => 'title',
		),
		array(
			'id'        => 'yith_welrp_popup_colors',
			'type'      => 'yith-field',
			'yith-type' => 'multi-colorpicker',
			'colorpickers' => array(
				array(
					'name'    => _x( 'Background', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'background',
					'default' => '#fff'
				),
				array(
					'name'    => _x( 'Header Background', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'header',
					'default'   => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_colors[header]', '#ffffff' ),
				),
				array(
					'name'    => _x( 'Text', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'text',
					'default'   => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_colors[text]', '#1a1a1a' ),
				),
				array(
					'name'    => _x( 'Overlay', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'overlay',
					'default'   => 'rgba(0,0,0,0.5)'
				),
			)
		),
		array(
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => '',
			'id'           => 'yith_welrp_popup_link_color',
			'colorpickers' => array(
				array(
					'name'    => _x( 'Link', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'normal',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_link_color[normal]', '#007acc' ),
				),
				array(
					'name'    => _x( 'Link Hover', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'hover',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_link_color[hover]', '#686868' ),
				),
			),
		),
		array(
			'type' => 'sectionend'
		),
		array(
			'title' => _x( 'Button colors', '[admin]Settings section title', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'  => 'title',
		),
		array(
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => _x( 'Set the button colors (default and hover)', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'           => 'yith_welrp_button_bg_color',
			'colorpickers' => array(
				array(
					'name'    => _x( 'Background', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'normal',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_bg_color[normal]', '#a46497' ),
				),
				array(
					'name'    => _x( 'Background Hover', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'hover',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_bg_color[hover]', '#96588a' ),
				),
			),
		),
		array(
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => _x( 'Set the button border color (default and hover)', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'           => 'yith_welrp_button_br_color',
			'colorpickers' => array(
				array(
					'name'    => _x( 'Border', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'normal',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_br_color[normal]', '#a46497' ),
				),
				array(
					'name'    => _x( 'Border Hover', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'hover',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_br_color[hover]', '#96588a' ),
				),
			),
		),
		array(
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => '',
			'id'           => 'yith_welrp_button_lb_color',
			'colorpickers' => array(
				array(
					'name'    => _x( 'Text', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'normal',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_lb_color[normal]', '#ffffff' ),
				),
				array(
					'name'    => _x( 'Text hover', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'hover',
					'default' => YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_button_lb_color[hover]', '#ffffff' ),
				),
			),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_welrp_color_customization',
		),
	)
);

return $settings;