<?php
/**
 * General plugin settings array
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH Easy Login & Register Popup For WooCommerce
 * @version 1.0.0
 */

defined( 'YITH_WELRP' ) || exit;

$settings = array(
	'general' => array(
		array(
			'title' => _x( 'Popup general settings', '[admin]Settings section title', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith_welrp_general_settings',
		),
		array(
			'title'     => _x( 'Popup size', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'      => 'yith-field',
			'yith-type' => 'number',
			'desc'      => _x( 'Set the size of the popup window in pixel. In our demo we use a 590px width.', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'        => 'yith_welrp_popup_width',
			'default'   => '590',
		),
		array(
			'title'     => _x( 'Close popup by clicking on the background', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'desc'      => _x( 'If enabled, when the user clicks on the overlay background the popup will close.', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'        => 'yith_welrp_popup_close_overlay',
			'default'   => 'yes',
		),
		array(
			'title'     => _x( 'Blur background', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'desc'      => _x( 'If enabled, the page content will be blurred when the popup is opened.', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'        => 'yith_welrp_popup_blur_overlay',
			'default'   => 'yes',
		),
		array(
			'title'     => _x( 'Popup animations', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'      => 'yith-field',
			'yith-type' => 'multi-select',
			'class'     => 'wc-enhanced-select',
			'desc'      => _x( 'Choose the entrance and exit animation effects for the popup opening and closing. Default values are fade in and fade out.', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'        => 'yith_welrp_popup_animation',
			'selects'   => array(
				array(
					'title'   => _x( 'Entrance animation', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'entrance',
					'options' => array(
						'' => _x( 'No animation', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
						array(
							'label'   => _x( 'Fading entrances', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'fadeIn'         => _x( 'Fade in', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInUp'       => _x( 'Fade in up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInDown'     => _x( 'Fade in down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInRight'    => _x( 'Fade in right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInLeft'     => _x( 'Fade in left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInUpBig'    => _x( 'Fade in up big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInDownBig'  => _x( 'Fade in down big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInRightBig' => _x( 'Fade in right big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeInLeftBig'  => _x( 'Fade in left big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Bouncing entrances', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'bounceIn'      => _x( 'Bounce in', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceInUp'    => _x( 'Bounce in up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceInDown'  => _x( 'Bounce in down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceInRight' => _x( 'Bounce in right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceInLeft'  => _x( 'Bounce in left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Flippers', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'flipInX' => _x( 'Flip in X', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'flipInY' => _x( 'Flip in Y', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Sliding entrances', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'slideInUp'    => _x( 'Slide in up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideInDown'  => _x( 'Slide in down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideInRight' => _x( 'Slide in right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideInLeft'  => _x( 'Slide in left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Zoom entrances', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'zoomIn'      => _x( 'Zoom in', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomInUp'    => _x( 'Zoom in up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomInDown'  => _x( 'Zoom in down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomInRight' => _x( 'Zoom in right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomInLeft'  => _x( 'Zoom in left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
					),
					'default' => 'fadeIn',
				),
				array(
					'title'   => _x( 'Exit animation', 'Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
					'id'      => 'exit',
					'options' => array(
						'' => _x( 'No animation', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
						array(
							'label'   => _x( 'Fading exits', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'fadeOut'         => _x( 'Fade out', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutUp'       => _x( 'Fade out up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutDown'     => _x( 'Fade out down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutRight'    => _x( 'Fade out right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutLeft'     => _x( 'Fade out left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutUpBig'    => _x( 'Fade out up big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutDownBig'  => _x( 'Fade out down big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutRightBig' => _x( 'Fade out right big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'fadeOutLeftBig'  => _x( 'Fade out left big', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Bouncing exits', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'bounceOut'      => _x( 'Bounce out', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceOutUp'    => _x( 'Bounce out up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceOutDown'  => _x( 'Bounce out down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceOutRight' => _x( 'Bounce out right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'bounceOutLeft'  => _x( 'Bounce out left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Flippers', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'flipOutX' => _x( 'Flip out X', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'flipOutY' => _x( 'Flip out Y', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Sliding exits', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'slideOutUp'    => _x( 'Slide out up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideOutDown'  => _x( 'Slide out down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideOutRight' => _x( 'Slide out right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'slideOutLeft'  => _x( 'Slide out left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
						array(
							'label'   => _x( 'Zoom exits', '[admin]Plugin animation option group', 'yith-easy-login-register-popup-for-woocommerce' ),
							'options' => array(
								'zoomOut'      => _x( 'Zoom out', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomOutUp'    => _x( 'Zoom out up', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomOutDown'  => _x( 'Zoom out down', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomOutRight' => _x( 'Zoom out right', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
								'zoomOutLeft'  => _x( 'Zoom out left', '[admin]Plugin animation option label', 'yith-easy-login-register-popup-for-woocommerce' ),
							),
						),
					),
					'default' => 'fadeOut',
				),
			),
		),
		array(
			'title'     => _x( 'Close popup icon', '[admin]Plugin option label', 'yith-easy-login-register-popup-for-woocommerce' ),
			'type'      => 'yith-field',
			'yith-type' => 'media',
			'desc'      => _x( 'Upload a custom icon for the Close button in the popup (X icon by default).', '[admin]Plugin option description', 'yith-easy-login-register-popup-for-woocommerce' ),
			'id'        => 'yith_welrp_popup_close_icon',
			'default'   => '',
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_welrp_general_settings',
		),

	),
);

return apply_filters( 'yith_welrp_panel_general_settings_options', $settings );

