/******/
(function(modules) { // webpackBootstrap
	/******/ // The module cache
	/******/
	var installedModules = {};
	/******/
	/******/ // The require function
	/******/
	function __webpack_require__(moduleId) {
		/******/
		/******/ // Check if module is in cache
		/******/
		if (installedModules[moduleId]) {
			/******/
			return installedModules[moduleId].exports;
			/******/
		}
		/******/ // Create a new module (and put it into the cache)
		/******/
		var module = installedModules[moduleId] = {
			/******/
			i: moduleId,
			/******/
			l: false,
			/******/
			exports: {}
			/******/
		};
		/******/
		/******/ // Execute the module function
		/******/
		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
		/******/
		/******/ // Flag the module as loaded
		/******/
		module.l = true;
		/******/
		/******/ // Return the exports of the module
		/******/
		return module.exports;
		/******/
	}
	/******/
	/******/
	/******/ // expose the modules object (__webpack_modules__)
	/******/
	__webpack_require__.m = modules;
	/******/
	/******/ // expose the module cache
	/******/
	__webpack_require__.c = installedModules;
	/******/
	/******/ // define getter function for harmony exports
	/******/
	__webpack_require__.d = function(exports, name, getter) {
		/******/
		if (!__webpack_require__.o(exports, name)) {
			/******/
			Object.defineProperty(exports, name, {
				enumerable: true,
				get: getter
			});
			/******/
		}
		/******/
	};
	/******/
	/******/ // define __esModule on exports
	/******/
	__webpack_require__.r = function(exports) {
		/******/
		if (typeof Symbol !== 'undefined' && Symbol.toStringTag) {
			/******/
			Object.defineProperty(exports, Symbol.toStringTag, {
				value: 'Module'
			});
			/******/
		}
		/******/
		Object.defineProperty(exports, '__esModule', {
			value: true
		});
		/******/
	};
	/******/
	/******/ // create a fake namespace object
	/******/ // mode & 1: value is a module id, require it
	/******/ // mode & 2: merge all properties of value into the ns
	/******/ // mode & 4: return value when already ns object
	/******/ // mode & 8|1: behave like require
	/******/
	__webpack_require__.t = function(value, mode) {
		/******/
		if (mode & 1) value = __webpack_require__(value);
		/******/
		if (mode & 8) return value;
		/******/
		if ((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
		/******/
		var ns = Object.create(null);
		/******/
		__webpack_require__.r(ns);
		/******/
		Object.defineProperty(ns, 'default', {
			enumerable: true,
			value: value
		});
		/******/
		if (mode & 2 && typeof value != 'string')
			for (var key in value) __webpack_require__.d(ns, key, function(key) {
				return value[key];
			}.bind(null, key));
		/******/
		return ns;
		/******/
	};
	/******/
	/******/ // getDefaultExport function for compatibility with non-harmony modules
	/******/
	__webpack_require__.n = function(module) {
		/******/
		var getter = module && module.__esModule ?
			/******/
			function getDefault() {
				return module['default'];
			} :
			/******/
			function getModuleExports() {
				return module;
			};
		/******/
		__webpack_require__.d(getter, 'a', getter);
		/******/
		return getter;
		/******/
	};
	/******/
	/******/ // Object.prototype.hasOwnProperty.call
	/******/
	__webpack_require__.o = function(object, property) {
		return Object.prototype.hasOwnProperty.call(object, property);
	};
	/******/
	/******/ // __webpack_public_path__
	/******/
	__webpack_require__.p = "";
	/******/
	/******/
	/******/ // Load entry module and return exports
	/******/
	return __webpack_require__(__webpack_require__.s = "./src/cluster/clusters-block.jsx");
	/******/
})
/************************************************************************/
/******/
({

	/***/
	"./src/cluster/clusters-block.jsx":
		/*!****************************************!*\
		  !*** ./src/cluster/clusters-block.jsx ***!
		  \****************************************/
		/*! no static exports found */
		/***/
		(function(module, exports, __webpack_require__) {

			"use strict";
			eval("\n\nvar _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"]) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); } }; }();\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _pageSelect = __webpack_require__(/*! ./views/page-select.jsx */ \"./src/cluster/views/page-select.jsx\");\n\nvar _postSelect = __webpack_require__(/*! ./views/post-select.jsx */ \"./src/cluster/views/post-select.jsx\");\n\nvar _categorySelect = __webpack_require__(/*! ./views/category-select.jsx */ \"./src/cluster/views/category-select.jsx\");\n\nvar _tagSelect = __webpack_require__(/*! ./views/tag-select.jsx */ \"./src/cluster/views/tag-select.jsx\");\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar __ = wp.i18n.__;\nvar RawHTML = wp.element.RawHTML;\nvar registerBlockType = wp.blocks.registerBlockType;\nvar _wp$editor = wp.editor,\n    InspectorControls = _wp$editor.InspectorControls,\n    BlockControls = _wp$editor.BlockControls,\n    RichText = _wp$editor.RichText,\n    MediaUpload = _wp$editor.MediaUpload,\n    URLInput = _wp$editor.URLInput,\n    Fragment = _wp$editor.Fragment;\nvar _wp$components = wp.components,\n    Toolbar = _wp$components.Toolbar,\n    Dropdown = _wp$components.Dropdown,\n    Dashicon = _wp$components.Dashicon,\n    RangeControl = _wp$components.RangeControl,\n    TextControl = _wp$components.TextControl,\n    Tooltip = _wp$components.Tooltip,\n    SelectControl = _wp$components.SelectControl,\n    ToggleControl = _wp$components.ToggleControl,\n    Spinner = _wp$components.Spinner,\n    Placeholder = _wp$components.Placeholder,\n    IconButton = _wp$components.IconButton,\n    Button = _wp$components.Button,\n    Popover = _wp$components.Popover;\nvar _wp = wp,\n    apiFetch = _wp.apiFetch;\n\n\nvar CLUSTERS_BLOCK_DISPLAY_SETTINGS = {\n\n\t'page': {\n\t\ttitle: __('Páginas'),\n\t\tdescription: __('Seleccionar una o varias paginas'),\n\t\tvalue: 'page'\n\t},\n\t'post': {\n\t\ttitle: __('Entradas'),\n\t\tdescription: __('Seleccionar una o varias entradas'),\n\t\tvalue: 'post'\n\t},\n\t'category': {\n\t\ttitle: __('Categorías'),\n\t\tdescription: __('Seleccionar una o varias categorías'),\n\t\tvalue: 'category'\n\t},\n\t'tag': {\n\t\ttitle: __('Etiquetas'),\n\t\tdescription: __('Seleccionar una o varias etiquetas'),\n\t\tvalue: 'tag'\n\t},\n\t'custom-links': {\n\t\ttitle: __('Enlaces customizables'),\n\t\tdescription: __('Agrega varios elementos con enlaces, imagenes y titulos completamente customizables'),\n\t\tvalue: 'custom-links'\n\t}\n};\n\nfunction supportsOrderby(display) {\n\treturn !(CLUSTERS_BLOCK_DISPLAY_SETTINGS.hasOwnProperty(display) && CLUSTERS_BLOCK_DISPLAY_SETTINGS[display].hasOwnProperty('no_orderby') && CLUSTERS_BLOCK_DISPLAY_SETTINGS[display].no_orderby);\n}\n\nvar ClustersBlockSettingsEditorDisplayOption = function (_React$Component) {\n\t_inherits(ClustersBlockSettingsEditorDisplayOption, _React$Component);\n\n\tfunction ClustersBlockSettingsEditorDisplayOption() {\n\t\t_classCallCheck(this, ClustersBlockSettingsEditorDisplayOption);\n\n\t\treturn _possibleConstructorReturn(this, (ClustersBlockSettingsEditorDisplayOption.__proto__ || Object.getPrototypeOf(ClustersBlockSettingsEditorDisplayOption)).apply(this, arguments));\n\t}\n\n\t_createClass(ClustersBlockSettingsEditorDisplayOption, [{\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _this2 = this;\n\n\t\t\tvar icon = 'arrow-right-alt2';\n\n\t\t\tif ('filter' === this.props.value && this.props.extended) {\n\t\t\t\ticon = 'arrow-down-alt2';\n\t\t\t}\n\n\t\t\tvar classes = 'asap-clusters-display-options__option asap-clusters-display-options__option--' + this.props.value;\n\n\t\t\tif (this.props.current === this.props.value) {\n\t\t\t\ticon = 'yes';\n\t\t\t\tclasses += ' asap-clusters-display-options__option--current';\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: classes, onClick: function onClick() {\n\t\t\t\t\t\t_this2.props.current !== _this2.props.value && _this2.props.update_display_callback(_this2.props.value);\n\t\t\t\t\t} },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-display-options__option-content' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'span',\n\t\t\t\t\t\t{ className: 'asap-clusters-display-options__option-title' },\n\t\t\t\t\t\tthis.props.title\n\t\t\t\t\t),\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'p',\n\t\t\t\t\t\t{ className: 'asap-clusters-display-options__option-description' },\n\t\t\t\t\t\tthis.props.description\n\t\t\t\t\t)\n\t\t\t\t),\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-display-options__icon' },\n\t\t\t\t\twp.element.createElement(Dashicon, { icon: icon })\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersBlockSettingsEditorDisplayOption;\n}(React.Component);\n\nvar ClustersBlockSettingsEditorDisplayOptions = function (_React$Component2) {\n\t_inherits(ClustersBlockSettingsEditorDisplayOptions, _React$Component2);\n\n\tfunction ClustersBlockSettingsEditorDisplayOptions(props) {\n\t\t_classCallCheck(this, ClustersBlockSettingsEditorDisplayOptions);\n\n\t\tvar _this3 = _possibleConstructorReturn(this, (ClustersBlockSettingsEditorDisplayOptions.__proto__ || Object.getPrototypeOf(ClustersBlockSettingsEditorDisplayOptions)).call(this, props));\n\n\t\t_this3.setWrapperRef = _this3.setWrapperRef.bind(_this3);\n\t\t_this3.handleClickOutside = _this3.handleClickOutside.bind(_this3);\n\t\treturn _this3;\n\t}\n\n\t_createClass(ClustersBlockSettingsEditorDisplayOptions, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tif (this.props.existing) {\n\t\t\t\tdocument.addEventListener('mousedown', this.handleClickOutside);\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'componentWillUnmount',\n\t\tvalue: function componentWillUnmount() {\n\t\t\tif (this.props.existing) {\n\t\t\t\tdocument.removeEventListener('mousedown', this.handleClickOutside);\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'setWrapperRef',\n\t\tvalue: function setWrapperRef(node) {\n\t\t\tthis.wrapperRef = node;\n\t\t}\n\t}, {\n\t\tkey: 'handleClickOutside',\n\t\tvalue: function handleClickOutside(evt) {\n\t\t\tif (this.wrapperRef && !this.wrapperRef.contains(event.target) && 'asap-clusters-settings-heading__change-button button-link' !== event.target.getAttribute('class')) {\n\t\t\t\tthis.props.closeMenu();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar classes = 'asap-clusters-display-options';\n\n\t\t\tif (this.props.extended) {\n\t\t\t\tclasses += ' asap-clusters-display-options--extended';\n\t\t\t}\n\n\t\t\tif (this.props.existing) {\n\t\t\t\tclasses += ' asap-clusters-display-options--popover';\n\t\t\t}\n\n\t\t\tvar display_settings = [];\n\t\t\tfor (var setting_key in CLUSTERS_BLOCK_DISPLAY_SETTINGS) {\n\t\t\t\tdisplay_settings.push(wp.element.createElement(ClustersBlockSettingsEditorDisplayOption, _extends({}, CLUSTERS_BLOCK_DISPLAY_SETTINGS[setting_key], {\n\t\t\t\t\tupdate_display_callback: this.props.update_display_callback,\n\t\t\t\t\textended: this.props.extended,\n\t\t\t\t\tcurrent: this.props.current })));\n\t\t\t}\n\n\t\t\tvar arrow = wp.element.createElement('span', { className: 'asap-clusters-display-options--popover__arrow' });\n\t\t\tvar description = wp.element.createElement(\n\t\t\t\t'p',\n\t\t\t\t{ className: 'asap-clusters-block-description' },\n\t\t\t\t__('Elige que tipo de categorización quieres crear')\n\t\t\t);\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: classes, ref: this.setWrapperRef },\n\t\t\t\tthis.props.existing && arrow,\n\t\t\t\t!this.props.existing && description,\n\t\t\t\tdisplay_settings\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersBlockSettingsEditorDisplayOptions;\n}(React.Component);\n\nvar ClustersBlockSettingsEditor = function (_React$Component3) {\n\t_inherits(ClustersBlockSettingsEditor, _React$Component3);\n\n\tfunction ClustersBlockSettingsEditor(props) {\n\t\t_classCallCheck(this, ClustersBlockSettingsEditor);\n\n\t\tvar _this4 = _possibleConstructorReturn(this, (ClustersBlockSettingsEditor.__proto__ || Object.getPrototypeOf(ClustersBlockSettingsEditor)).call(this, props));\n\n\t\t_this4.state = {\n\t\t\tdisplay: props.selected_display,\n\t\t\tmenu_visible: props.selected_display ? false : true,\n\t\t\texpanded_group: ''\n\t\t};\n\n\t\t_this4.updateDisplay = _this4.updateDisplay.bind(_this4);\n\t\t_this4.closeMenu = _this4.closeMenu.bind(_this4);\n\t\treturn _this4;\n\t}\n\n\t_createClass(ClustersBlockSettingsEditor, [{\n\t\tkey: 'updateDisplay',\n\t\tvalue: function updateDisplay(value) {\n\n\t\t\tvar new_state = {\n\t\t\t\tdisplay: value,\n\t\t\t\tmenu_visible: false,\n\t\t\t\texpanded_group: ''\n\t\t\t};\n\n\t\t\tvar is_group = 'undefined' !== CLUSTERS_BLOCK_DISPLAY_SETTINGS[value].group_container && CLUSTERS_BLOCK_DISPLAY_SETTINGS[value].group_container;\n\n\t\t\tif (is_group) {\n\t\t\t\tnew_state = {\n\t\t\t\t\tmenu_visible: true,\n\t\t\t\t\texpanded_group: value\n\t\t\t\t};\n\n\t\t\t\tif (this.state.expanded_group === CLUSTERS_BLOCK_DISPLAY_SETTINGS[value].group_container) {\n\t\t\t\t\tnew_state.expanded_group = '';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.setState(new_state);\n\n\t\t\tif (!is_group) {\n\t\t\t\tthis.props.update_display_callback(value);\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'closeMenu',\n\t\tvalue: function closeMenu() {\n\t\t\tthis.setState({\n\t\t\t\tmenu_visible: false\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _this5 = this;\n\n\t\t\tvar extra_settings = null;\n\t\t\tif ('page' === this.state.display) {\n\t\t\t\textra_settings = wp.element.createElement(_pageSelect.ClustersPageSelect, this.props);\n\t\t\t} else if ('post' === this.state.display) {\n\t\t\t\textra_settings = wp.element.createElement(_postSelect.ClustersPostSelect, this.props);\n\t\t\t} else if ('category' === this.state.display) {\n\t\t\t\textra_settings = wp.element.createElement(_categorySelect.ClustersCategorySelect, this.props);\n\t\t\t} else if ('tag' === this.state.display) {\n\t\t\t\textra_settings = wp.element.createElement(_tagSelect.ClustersTagSelect, this.props);\n\t\t\t}\n\n\t\t\tvar menu = this.state.menu_visible ? wp.element.createElement(ClustersBlockSettingsEditorDisplayOptions, {\n\t\t\t\textended: this.state.expanded_group ? true : false,\n\t\t\t\texisting: this.state.display ? true : false,\n\t\t\t\tcurrent: this.state.display,\n\t\t\t\tcloseMenu: this.closeMenu,\n\t\t\t\tupdate_display_callback: this.updateDisplay }) : null;\n\n\t\t\tvar heading = null;\n\t\t\tif (this.state.display) {\n\t\t\t\tvar group_options = [];\n\t\t\t\tvar should_group_expand = group_options.includes(this.state.display) ? this.state.display : '';\n\t\t\t\tvar menu_link = wp.element.createElement(\n\t\t\t\t\t'button',\n\t\t\t\t\t{ type: 'button', className: 'asap-clusters-settings-heading__change-button button-link', onClick: function onClick() {\n\t\t\t\t\t\t\t_this5.setState({ menu_visible: !_this5.state.menu_visible, expanded_group: should_group_expand });\n\t\t\t\t\t\t} },\n\t\t\t\t\t__('Opciones >')\n\t\t\t\t);\n\n\t\t\t\theading = wp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-settings-heading' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'div',\n\t\t\t\t\t\t{ className: 'asap-clusters-settings-heading__current' },\n\t\t\t\t\t\t__('Mostrando: '),\n\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t'strong',\n\t\t\t\t\t\t\tnull,\n\t\t\t\t\t\t\t__(CLUSTERS_BLOCK_DISPLAY_SETTINGS[this.state.display].title)\n\t\t\t\t\t\t)\n\t\t\t\t\t),\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'div',\n\t\t\t\t\t\t{ className: 'asap-clusters-settings-heading__change' },\n\t\t\t\t\t\tmenu_link\n\t\t\t\t\t)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tvar done_button = wp.element.createElement(\n\t\t\t\t'button',\n\t\t\t\t{ type: 'button', className: 'button asap-clusters-settings__footer-button', onClick: this.props.done_callback },\n\t\t\t\t__('Finalizar')\n\t\t\t);\n\t\t\tif (['', 'post', 'category', 'tag', 'page'].includes(this.state.display) && !this.props.selected_display_setting.length) {\n\t\t\t\tvar done_tooltips = {\n\t\t\t\t\t'': __('Please select which clusters you\\'d like to display'),\n\t\t\t\t\tpost: __('Please select at least one page to display'),\n\t\t\t\t\tcategory: __('Please select at least one category to display'),\n\t\t\t\t\ttag: __('Please select at least one tag to display'),\n\t\t\t\t\tpage: __('Please select at least one page to display')\n\t\t\t\t};\n\n\t\t\t\tdone_button = wp.element.createElement(\n\t\t\t\t\tTooltip,\n\t\t\t\t\t{ text: done_tooltips[this.state.display] },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'button',\n\t\t\t\t\t\t{ type: 'button', className: 'button asap-clusters-settings__footer-button disabled' },\n\t\t\t\t\t\t__('Done')\n\t\t\t\t\t)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-settings ' + (this.state.expanded_group ? 'expanded-group-' + this.state.expanded_group : '') },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'h4',\n\t\t\t\t\t{ className: 'asap-clusters-settings__title' },\n\t\t\t\t\twp.element.createElement(Dashicon, { icon: 'grid-view' }),\n\t\t\t\t\t' ',\n\t\t\t\t\t__('Categorizaciones')\n\t\t\t\t),\n\t\t\t\theading,\n\t\t\t\tmenu,\n\t\t\t\textra_settings,\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-settings__footer' },\n\t\t\t\t\tdone_button\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersBlockSettingsEditor;\n}(React.Component);\n\nvar ClusterPreview = function (_React$Component4) {\n\t_inherits(ClusterPreview, _React$Component4);\n\n\tfunction ClusterPreview() {\n\t\t_classCallCheck(this, ClusterPreview);\n\n\t\treturn _possibleConstructorReturn(this, (ClusterPreview.__proto__ || Object.getPrototypeOf(ClusterPreview)).apply(this, arguments));\n\t}\n\n\t_createClass(ClusterPreview, [{\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _props = this.props,\n\t\t\t    attributes = _props.attributes,\n\t\t\t    cluster = _props.cluster,\n\t\t\t    setAttributes = _props.setAttributes;\n\t\t\tvar settings = attributes.settings;\n\n\n\t\t\tvar settingsJson = JSON.parse(settings);\n\n\t\t\tvar image = null;\n\t\t\tvar source_image = null;\n\n\t\t\tif (typeof cluster['_embedded']['wp:featuredmedia'] != \"undefined\") {\n\t\t\t\timage = cluster['_embedded']['wp:featuredmedia']['0'].source_url;\n\t\t\t\tsource_image = cluster['_embedded']['wp:featuredmedia']['0'].id;\n\t\t\t} else if (typeof settingsJson[cluster.id] != \"undefined\") {\n\t\t\t\timage = settingsJson[cluster.id]['urlThumbnail'];\n\t\t\t}\n\n\t\t\tvar onSelectImage = function onSelectImage(img) {\n\n\t\t\t\tif (settingsJson[cluster.id]) {\n\t\t\t\t\tsettingsJson[cluster.id]['idThumbnail'] = img.id;\n\t\t\t\t\tsettingsJson[cluster.id]['urlThumbnail'] = img.url;\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster.id] = {\n\t\t\t\t\t\tidThumbnail: img.id,\n\t\t\t\t\t\turlThumbnail: img.url\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'group-display', key: cluster.id + '-preview' },\n\t\t\t\twp.element.createElement(MediaUpload, {\n\t\t\t\t\tonSelect: onSelectImage,\n\t\t\t\t\tallowedTypes: 'image',\n\t\t\t\t\tvalue: settingsJson[cluster.id] ? settingsJson[cluster.id].idThumbnail : source_image,\n\t\t\t\t\trender: function render(_ref) {\n\t\t\t\t\t\tvar open = _ref.open;\n\t\t\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\t\t'div',\n\t\t\t\t\t\t\t{ className: 'cluster-edit-image' },\n\t\t\t\t\t\t\twp.element.createElement(asapPopover, { attributes: attributes, setAttributes: setAttributes, cluster: cluster.id }),\n\t\t\t\t\t\t\twp.element.createElement(IconButton, {\n\t\t\t\t\t\t\t\tclassName: 'components-toolbar__control',\n\t\t\t\t\t\t\t\tlabel: __('Edit image'),\n\t\t\t\t\t\t\t\ticon: 'format-image',\n\t\t\t\t\t\t\t\tonClick: open\n\t\t\t\t\t\t\t}),\n\t\t\t\t\t\t\timage && wp.element.createElement('img', { src: settingsJson[cluster.id] ? typeof settingsJson[cluster.id].urlThumbnail !== 'undefined' ? settingsJson[cluster.id].urlThumbnail : image : image }),\n\t\t\t\t\t\t\t!image && wp.element.createElement(Placeholder, { label: 'Ninguna imagen seleccionada' })\n\t\t\t\t\t\t);\n\t\t\t\t\t}\n\t\t\t\t}),\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'cluster-title' },\n\t\t\t\t\twp.element.createElement(RichText, {\n\t\t\t\t\t\tformattingControls: ['bold', 'italic', 'underline'],\n\t\t\t\t\t\ttagName: 'h3',\n\t\t\t\t\t\tvalue: settingsJson[cluster.id] ? typeof settingsJson[cluster.id].heading !== 'undefined' ? settingsJson[cluster.id].heading : cluster.title.rendered : cluster.title.rendered,\n\t\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\t\tif (settingsJson[cluster.id]) {\n\t\t\t\t\t\t\t\tsettingsJson[cluster.id]['heading'] = value;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tsettingsJson[cluster.id] = {\n\t\t\t\t\t\t\t\t\theading: value\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClusterPreview;\n}(React.Component);\n\nvar ClusterCustomLinksPreview = function (_React$Component5) {\n\t_inherits(ClusterCustomLinksPreview, _React$Component5);\n\n\tfunction ClusterCustomLinksPreview() {\n\t\t_classCallCheck(this, ClusterCustomLinksPreview);\n\n\t\treturn _possibleConstructorReturn(this, (ClusterCustomLinksPreview.__proto__ || Object.getPrototypeOf(ClusterCustomLinksPreview)).apply(this, arguments));\n\t}\n\n\t_createClass(ClusterCustomLinksPreview, [{\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _props2 = this.props,\n\t\t\t    attributes = _props2.attributes,\n\t\t\t    cluster = _props2.cluster,\n\t\t\t    setAttributes = _props2.setAttributes;\n\t\t\tvar settings = attributes.settings;\n\n\t\t\tvar settingsJson = JSON.parse(settings);\n\t\t\tvar image = null;\n\t\t\tvar source_image = null;\n\n\t\t\tif (typeof settingsJson[cluster] != \"undefined\") {\n\t\t\t\timage = settingsJson[cluster]['urlThumbnail'];\n\t\t\t}\n\n\t\t\tvar onSelectImage = function onSelectImage(img) {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tsettingsJson[cluster]['idThumbnail'] = img.id;\n\t\t\t\t\tsettingsJson[cluster]['urlThumbnail'] = img.url;\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\tidThumbnail: img.id,\n\t\t\t\t\t\turlThumbnail: img.url\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'group-display', key: cluster + '-preview' },\n\t\t\t\twp.element.createElement(MediaUpload, {\n\t\t\t\t\tonSelect: onSelectImage,\n\t\t\t\t\tallowedTypes: 'image',\n\t\t\t\t\tvalue: settingsJson[cluster] ? settingsJson[cluster].idThumbnail : source_image,\n\t\t\t\t\trender: function render(_ref2) {\n\t\t\t\t\t\tvar open = _ref2.open;\n\t\t\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\t\t'div',\n\t\t\t\t\t\t\t{ className: 'cluster-edit-image' },\n\t\t\t\t\t\t\twp.element.createElement(asapPopover, { attributes: attributes, setAttributes: setAttributes, cluster: cluster }),\n\t\t\t\t\t\t\twp.element.createElement(IconButton, {\n\t\t\t\t\t\t\t\tclassName: 'components-toolbar__control',\n\t\t\t\t\t\t\t\tlabel: __('Edit image'),\n\t\t\t\t\t\t\t\ticon: 'format-image',\n\t\t\t\t\t\t\t\tonClick: open\n\t\t\t\t\t\t\t}),\n\t\t\t\t\t\t\timage && wp.element.createElement('img', { src: settingsJson[cluster] ? typeof settingsJson[cluster].urlThumbnail !== 'undefined' ? settingsJson[cluster].urlThumbnail : image : image }),\n\t\t\t\t\t\t\t!image && wp.element.createElement(Placeholder, { label: 'Ninguna imagen seleccionada' })\n\t\t\t\t\t\t);\n\t\t\t\t\t}\n\t\t\t\t}),\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'cluster-title' },\n\t\t\t\t\twp.element.createElement(RichText, {\n\t\t\t\t\t\tformattingControls: ['bold', 'italic', 'underline'],\n\t\t\t\t\t\ttagName: 'h3',\n\t\t\t\t\t\tvalue: settingsJson[cluster] ? typeof settingsJson[cluster].heading !== 'undefined' ? settingsJson[cluster].heading : 'Title ' + cluster : 'Title ' + cluster,\n\t\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\t\t\t\tsettingsJson[cluster]['heading'] = value;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\t\t\t\theading: value\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClusterCustomLinksPreview;\n}(React.Component);\n\nvar ClustersBlockPreview = function (_React$Component6) {\n\t_inherits(ClustersBlockPreview, _React$Component6);\n\n\tfunction ClustersBlockPreview(props) {\n\t\t_classCallCheck(this, ClustersBlockPreview);\n\n\t\tvar _this8 = _possibleConstructorReturn(this, (ClustersBlockPreview.__proto__ || Object.getPrototypeOf(ClustersBlockPreview)).call(this, props));\n\n\t\t_this8.state = {\n\t\t\tposts: [],\n\t\t\tloaded: false,\n\t\t\tquery: ''\n\t\t};\n\n\t\t_this8.updatePreview = _this8.updatePreview.bind(_this8);\n\t\t_this8.getQuery = _this8.getQuery.bind(_this8);\n\t\treturn _this8;\n\t}\n\n\t_createClass(ClustersBlockPreview, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updatePreview();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.getQuery() !== this.state.query && this.state.loaded) {\n\t\t\t\tthis.updatePreview();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQuery',\n\t\tvalue: function getQuery() {\n\t\t\tvar _props$attributes = this.props.attributes,\n\t\t\t    columns = _props$attributes.columns,\n\t\t\t    rows = _props$attributes.rows,\n\t\t\t    display = _props$attributes.display,\n\t\t\t    display_setting = _props$attributes.display_setting,\n\t\t\t    orderby = _props$attributes.orderby;\n\t\t\tvar setAttributes = this.props.setAttributes.setAttributes;\n\n\t\t\tvar urlParams = new URLSearchParams(window.location.search);\n\t\t\tvar myParam = urlParams.get('post');\n\n\t\t\tvar query = {\n\t\t\t\tper_page: rows\n\t\t\t};\n\n\t\t\tif ('page' === display || 'post' === display) {\n\t\t\t\tquery.include = display_setting.join(',');\n\t\t\t\tquery.per_page = display_setting.length;\n\t\t\t} else if ('category' === display) {\n\t\t\t\tquery.categories = display_setting.join(',');\n\t\t\t} else if ('tag' === display) {\n\t\t\t\tquery.tags = display_setting.join(',');\n\t\t\t}\n\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\tif ('rand' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t} else if ('ID_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('ID_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('title_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'title';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('title_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'title';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('name_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'slug';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('name_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'slug';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('date_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'date';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('date_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'date';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('modified_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'modified';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('modified_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'modified';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('parent_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'parent';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('parent_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'parent';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('menu_order_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('menu_order_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else if ('comment_count_asc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'asc';\n\t\t\t\t} else if ('comment_count_desc' === orderby) {\n\t\t\t\t\tquery.orderby = 'id';\n\t\t\t\t\tquery.order = 'desc';\n\t\t\t\t} else {\n\t\t\t\t\tquery.orderby = orderby;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar query_string = '?';\n\t\t\tvar _iteratorNormalCompletion = true;\n\t\t\tvar _didIteratorError = false;\n\t\t\tvar _iteratorError = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator = Object.keys(query)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n\t\t\t\t\tvar key = _step.value;\n\n\t\t\t\t\tquery_string += key + '=' + query[key] + '&';\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError = true;\n\t\t\t\t_iteratorError = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion && _iterator.return) {\n\t\t\t\t\t\t_iterator.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError) {\n\t\t\t\t\t\tthrow _iteratorError;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ('page' === display) {\n\t\t\t\treturn '/wp/v2/pages' + query_string + '_embed';\n\t\t\t}\n\n\t\t\tif ('post' === display) {\n\t\t\t\treturn '/wp/v2/posts' + query_string + '_embed';\n\t\t\t}\n\n\t\t\tif ('custom-links' === display) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\treturn '/wp/v2/posts' + query_string + '&_embed';\n\t\t}\n\t}, {\n\t\tkey: 'updatePreview',\n\t\tvalue: function updatePreview() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tloaded: false,\n\t\t\t\tquery: query\n\t\t\t});\n\n\t\t\tapiFetch({ path: query }).then(function (clusters) {\n\t\t\t\tself.setState({\n\t\t\t\t\tclusters: clusters,\n\t\t\t\t\tloaded: true\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\n\t\t\tif (!this.state.loaded) {\n\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\tPlaceholder,\n\t\t\t\t\t{\n\t\t\t\t\t\ticon: 'grid-view',\n\t\t\t\t\t\tlabel: __('Cargando categorizaciones')\n\t\t\t\t\t},\n\t\t\t\t\twp.element.createElement(Spinner, null)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tif (0 === this.state.clusters.length) {\n\t\t\t\treturn __('No posts found');\n\t\t\t}\n\n\t\t\tvar classes = \"asap-group-block-display cols-\" + this.props.attributes.columns;\n\t\t\tvar self = this;\n\n\t\t\t/*\n   *\n   *\tCUSTOM LINKS\n   *\n   */\n\n\t\t\tif ('custom-links' === self.props.attributes.display) {\n\n\t\t\t\tvar items = [];\n\t\t\t\tfor (var i = 1; i <= self.props.attributes.rows; i++) {\n\t\t\t\t\titems.push(wp.element.createElement(ClusterCustomLinksPreview, {\n\t\t\t\t\t\tcluster: i,\n\t\t\t\t\t\tattributes: self.props.attributes,\n\t\t\t\t\t\tsetAttributes: self.props.setAttributes }));\n\t\t\t\t}\n\n\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: classes },\n\t\t\t\t\titems\n\t\t\t\t);\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: classes },\n\t\t\t\tthis.state.clusters.map(function (cluster) {\n\t\t\t\t\treturn wp.element.createElement(ClusterPreview, {\n\t\t\t\t\t\tcluster: cluster,\n\t\t\t\t\t\tattributes: self.props.attributes,\n\t\t\t\t\t\tsetAttributes: self.props.setAttributes });\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersBlockPreview;\n}(React.Component);\n\nvar ClustersBlockSidebarInfo = function (_React$Component7) {\n\t_inherits(ClustersBlockSidebarInfo, _React$Component7);\n\n\tfunction ClustersBlockSidebarInfo(props) {\n\t\t_classCallCheck(this, ClustersBlockSidebarInfo);\n\n\t\tvar _this9 = _possibleConstructorReturn(this, (ClustersBlockSidebarInfo.__proto__ || Object.getPrototypeOf(ClustersBlockSidebarInfo)).call(this, props));\n\n\t\t_this9.state = {\n\t\t\tcategoriesInfo: [],\n\t\t\tcategoriesQuery: '',\n\t\t\tpagesInfo: false,\n\t\t\tpagesQuery: '',\n\t\t\tpostsInfo: false,\n\t\t\tpostsQuery: '',\n\t\t\ttagsInfo: [],\n\t\t\ttagsQuery: ''\n\t\t};\n\n\t\t_this9.updateInfo = _this9.updateInfo.bind(_this9);\n\t\t_this9.getQueries = _this9.getQueries.bind(_this9);\n\t\treturn _this9;\n\t}\n\n\t_createClass(ClustersBlockSidebarInfo, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updateInfo();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tvar queries = this.getQueries();\n\n\t\t\tif (this.state.categoriesQuery !== queries.categories || this.state.pagesQuery !== queries.pages || this.state.postsQuery !== queries.posts || this.state.tagsQuery !== queries.tags) {\n\t\t\t\tthis.updateInfo();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQueries',\n\t\tvalue: function getQueries() {\n\t\t\tvar _props$attributes2 = this.props.attributes,\n\t\t\t    display = _props$attributes2.display,\n\t\t\t    display_setting = _props$attributes2.display_setting;\n\n\n\t\t\tvar endpoints = {\n\t\t\t\tpages: '',\n\t\t\t\ttags: '',\n\t\t\t\tposts: '',\n\t\t\t\tcategories: ''\n\t\t\t};\n\n\t\t\tif ('category' === display && display_setting.length) {\n\t\t\t\tendpoints.categories = '/wp/v2/categories?include=' + display_setting.join(',');\n\t\t\t} else if ('page' === display && display_setting.length) {\n\t\t\t\tendpoints.pages = '/wp/v2/pages?include=' + display_setting.join(',');\n\t\t\t} else if ('post' === display && display_setting.length) {\n\t\t\t\tendpoints.posts = '/wp/v2/posts?include=' + display_setting.join(',');\n\t\t\t} else if ('tag' === display && display_setting.length) {\n\t\t\t\tendpoints.tags = '/wp/v2/tags?include=' + display_setting.join(',');\n\t\t\t}\n\n\t\t\treturn endpoints;\n\t\t}\n\t}, {\n\t\tkey: 'updateInfo',\n\t\tvalue: function updateInfo() {\n\t\t\tvar self = this;\n\t\t\tvar queries = this.getQueries();\n\n\t\t\tthis.setState({\n\t\t\t\tcategoriesQuery: queries.categories,\n\t\t\t\tpostsQuery: queries.posts,\n\t\t\t\tpagesQuery: queries.pages,\n\t\t\t\ttagsQuery: queries.tags\n\t\t\t});\n\n\t\t\tif (queries.categories.length) {\n\t\t\t\tapiFetch({ path: queries.categories }).then(function (categories) {\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\tcategoriesInfo: categories\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\tcategoriesInfo: []\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (queries.pages.length) {\n\t\t\t\tapiFetch({ path: queries.pages }).then(function (pages) {\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\tpagesInfo: pages\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\tpagesInfo: false\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (queries.posts.length) {\n\t\t\t\tapiFetch({ path: queries.posts }).then(function (posts) {\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\tpostsInfo: posts\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\tpostsInfo: false\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (queries.tags.length) {\n\t\t\t\tapiFetch({ path: queries.tags }).then(function (tags) {\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\ttagsInfo: tags\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\ttagsInfo: []\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar descriptions = [CLUSTERS_BLOCK_DISPLAY_SETTINGS[this.props.attributes.display].title];\n\n\t\t\tif (this.state.categoriesInfo.length) {\n\t\t\t\tvar descriptionText = __('Categories: ');\n\t\t\t\tvar categories = [];\n\t\t\t\tvar _iteratorNormalCompletion2 = true;\n\t\t\t\tvar _didIteratorError2 = false;\n\t\t\t\tvar _iteratorError2 = undefined;\n\n\t\t\t\ttry {\n\t\t\t\t\tfor (var _iterator2 = this.state.categoriesInfo[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {\n\t\t\t\t\t\tvar category = _step2.value;\n\n\t\t\t\t\t\tcategories.push(category.name);\n\t\t\t\t\t}\n\t\t\t\t} catch (err) {\n\t\t\t\t\t_didIteratorError2 = true;\n\t\t\t\t\t_iteratorError2 = err;\n\t\t\t\t} finally {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tif (!_iteratorNormalCompletion2 && _iterator2.return) {\n\t\t\t\t\t\t\t_iterator2.return();\n\t\t\t\t\t\t}\n\t\t\t\t\t} finally {\n\t\t\t\t\t\tif (_didIteratorError2) {\n\t\t\t\t\t\t\tthrow _iteratorError2;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tdescriptionText += categories.join(', ');\n\n\t\t\t\tdescriptions = [descriptionText];\n\t\t\t} else if (this.state.pagesInfo) {\n\n\t\t\t\tif (this.state.pagesInfo.length) {\n\t\t\t\t\tvar pageDescriptionText = __(\"Pages: \");\n\t\t\t\t\tvar pages = [];\n\t\t\t\t\tvar _iteratorNormalCompletion3 = true;\n\t\t\t\t\tvar _didIteratorError3 = false;\n\t\t\t\t\tvar _iteratorError3 = undefined;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor (var _iterator3 = this.state.pagesInfo[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {\n\t\t\t\t\t\t\tvar page = _step3.value;\n\n\t\t\t\t\t\t\tpages.push(page.title.rendered);\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t_didIteratorError3 = true;\n\t\t\t\t\t\t_iteratorError3 = err;\n\t\t\t\t\t} finally {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (!_iteratorNormalCompletion3 && _iterator3.return) {\n\t\t\t\t\t\t\t\t_iterator3.return();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\tif (_didIteratorError3) {\n\t\t\t\t\t\t\t\tthrow _iteratorError3;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tdescriptions.push(pages.join(', '));\n\t\t\t\t}\n\t\t\t} else if (this.state.postsInfo) {\n\t\t\t\tdescriptions = [__('Posts: ') + this.state.postsInfo.name];\n\n\t\t\t\tif (this.state.postsInfo.length) {\n\t\t\t\t\tvar postDescriptionText = __(\"Posts: \");\n\t\t\t\t\tvar posts = [];\n\t\t\t\t\tvar _iteratorNormalCompletion4 = true;\n\t\t\t\t\tvar _didIteratorError4 = false;\n\t\t\t\t\tvar _iteratorError4 = undefined;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor (var _iterator4 = this.state.postsInfo[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {\n\t\t\t\t\t\t\tvar post = _step4.value;\n\n\t\t\t\t\t\t\tposts.push(post.title.rendered);\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t_didIteratorError4 = true;\n\t\t\t\t\t\t_iteratorError4 = err;\n\t\t\t\t\t} finally {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (!_iteratorNormalCompletion4 && _iterator4.return) {\n\t\t\t\t\t\t\t\t_iterator4.return();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\tif (_didIteratorError4) {\n\t\t\t\t\t\t\t\tthrow _iteratorError4;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tpostDescriptionText += posts.join(', ');\n\t\t\t\t\tdescriptions.push(postDescriptionText);\n\t\t\t\t}\n\t\t\t} else if (this.state.tagsInfo) {\n\t\t\t\tdescriptions = [__('Tags: ') + this.state.tagsInfo.name];\n\n\t\t\t\tif (this.state.tagsInfo.length) {\n\t\t\t\t\tvar tagDescriptionText = __(\"Tags: \");\n\t\t\t\t\tvar tags = [];\n\t\t\t\t\tvar _iteratorNormalCompletion5 = true;\n\t\t\t\t\tvar _didIteratorError5 = false;\n\t\t\t\t\tvar _iteratorError5 = undefined;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor (var _iterator5 = this.state.tagsInfo[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {\n\t\t\t\t\t\t\tvar tag = _step5.value;\n\n\t\t\t\t\t\t\ttags.push(tag.name);\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t_didIteratorError5 = true;\n\t\t\t\t\t\t_iteratorError5 = err;\n\t\t\t\t\t} finally {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (!_iteratorNormalCompletion5 && _iterator5.return) {\n\t\t\t\t\t\t\t\t_iterator5.return();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\tif (_didIteratorError5) {\n\t\t\t\t\t\t\t\tthrow _iteratorError5;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ttagDescriptionText += tags.join(', ');\n\t\t\t\t\tdescriptions.push(tagDescriptionText);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\tnull,\n\t\t\t\tdescriptions.map(function (description) {\n\t\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\t'div',\n\t\t\t\t\t\t{ className: 'scope-description' },\n\t\t\t\t\t\tdescription\n\t\t\t\t\t);\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersBlockSidebarInfo;\n}(React.Component);\n\n;\n\nvar ClustersBlock = function (_React$Component8) {\n\t_inherits(ClustersBlock, _React$Component8);\n\n\tfunction ClustersBlock(props) {\n\t\t_classCallCheck(this, ClustersBlock);\n\n\t\tvar _this10 = _possibleConstructorReturn(this, (ClustersBlock.__proto__ || Object.getPrototypeOf(ClustersBlock)).call(this, props));\n\n\t\t_this10.getInspectorControls = _this10.getInspectorControls.bind(_this10);\n\t\t_this10.getToolbarControls = _this10.getToolbarControls.bind(_this10);\n\t\t_this10.getBlockDescription = _this10.getBlockDescription.bind(_this10);\n\t\t_this10.getPreview = _this10.getPreview.bind(_this10);\n\t\t_this10.getSettingsEditor = _this10.getSettingsEditor.bind(_this10);\n\t\treturn _this10;\n\t}\n\n\t_createClass(ClustersBlock, [{\n\t\tkey: 'getInspectorControls',\n\t\tvalue: function getInspectorControls() {\n\t\t\tvar _props3 = this.props,\n\t\t\t    attributes = _props3.attributes,\n\t\t\t    setAttributes = _props3.setAttributes;\n\t\t\tvar rows = attributes.rows,\n\t\t\t    columns = attributes.columns,\n\t\t\t    display = attributes.display,\n\t\t\t    display_setting = attributes.display_setting,\n\t\t\t    orderby = attributes.orderby,\n\t\t\t    excerpt = attributes.excerpt,\n\t\t\t    links = attributes.links,\n\t\t\t    target = attributes.target,\n\t\t\t    button = attributes.button,\n\t\t\t    headings = attributes.headings,\n\t\t\t    edit_mode = attributes.edit_mode;\n\n\n\t\t\tvar columnControl = wp.element.createElement(RangeControl, {\n\t\t\t\tlabel: __('Columns'),\n\t\t\t\tvalue: columns ? columns : 3,\n\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\treturn setAttributes({ columns: value });\n\t\t\t\t},\n\t\t\t\tmin: 1,\n\t\t\t\tmax: 5\n\t\t\t});\n\n\t\t\tvar orderControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\torderControl = wp.element.createElement(SelectControl, {\n\t\t\t\t\tkey: 'query-panel-select-order',\n\t\t\t\t\tlabel: __('Ordenar por'),\n\t\t\t\t\tvalue: orderby,\n\t\t\t\t\toptions: [{\n\t\t\t\t\t\tlabel: __('Más recientes primero'),\n\t\t\t\t\t\tvalue: 'date_desc'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('Más antiguos primero'),\n\t\t\t\t\t\tvalue: 'date_asc'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('Alfabético descendente'),\n\t\t\t\t\t\tvalue: 'title_desc'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('Alfabético ascendente'),\n\t\t\t\t\t\tvalue: 'title_asc'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('Aleatorio'),\n\t\t\t\t\t\tvalue: 'rand'\n\t\t\t\t\t}],\n\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\treturn setAttributes({ orderby: value });\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar excerptControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\texcerptControl = wp.element.createElement(SelectControl, {\n\t\t\t\t\tkey: 'query-panel-select-excerpt',\n\t\t\t\t\tlabel: __('Mostrar descripción'),\n\t\t\t\t\tvalue: excerpt,\n\t\t\t\t\toptions: [{\n\t\t\t\t\t\tlabel: __('No'),\n\t\t\t\t\t\tvalue: 'none'\n\t\t\t\t\t},{\n\t\t\t\t\t\tlabel: __('Sí'),\n\t\t\t\t\t\tvalue: 'show'\n\t\t\t\t\t}],\n\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\treturn setAttributes({ excerpt: value });\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar headingsControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\theadingsControl = wp.element.createElement(SelectControl, {\n\t\t\t\t\tkey: 'query-panel-select-headings',\n\t\t\t\t\tlabel: __('Encabezados'),\n\t\t\t\t\tvalue: headings,\n\t\t\t\t\toptions: [{\n\t\t\t\t\t\tlabel: __('Párrafo'),\n\t\t\t\t\t\tvalue: 'span'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('H2'),\n\t\t\t\t\t\tvalue: 'h2'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('H3'),\n\t\t\t\t\t\tvalue: 'h3'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('H4'),\n\t\t\t\t\t\tvalue: 'h4'\n\t\t\t\t\t}],\n\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\treturn setAttributes({ headings: value });\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar linksControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\tlinksControl = wp.element.createElement(SelectControl, {\n\t\t\t\t\tkey: 'query-panel-select-links',\n\t\t\t\t\tlabel: __('Atributo Rel'),\n\t\t\t\t\tvalue: links,\n\t\t\t\t\toptions: [{\n\t\t\t\t\t\tlabel: __('Follow'),\n\t\t\t\t\t\tvalue: 'follow'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('No follow'),\n\t\t\t\t\t\tvalue: 'nofollow'\n\t\t\t\t\t}],\n\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\treturn setAttributes({ links: value });\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar targetControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\ttargetControl = wp.element.createElement(SelectControl, {\n\t\t\t\t\tkey: 'query-panel-select-target',\n\t\t\t\t\tlabel: __('Atributo Target'),\n\t\t\t\t\tvalue: target,\n\t\t\t\t\toptions: [{\n\t\t\t\t\t\tlabel: __('Default'),\n\t\t\t\t\t\tvalue: '_self'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tlabel: __('_blank'),\n\t\t\t\t\t\tvalue: '_blank'\n\t\t\t\t\t}],\n\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\treturn setAttributes({ target: value });\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar rowControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\tif ('page' !== display || 'post' !== display) {\n\t\t\t\t\trowControl = wp.element.createElement(RangeControl, {\n\t\t\t\t\t\tlabel: __('Número de posts'),\n\t\t\t\t\t\tvalue: rows,\n\t\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\t\treturn setAttributes({ rows: value });\n\t\t\t\t\t\t},\n\t\t\t\t\t\tmin: 1,\n\t\t\t\t\t\tmax: 99\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar buttonControl = null;\n\t\t\tif (supportsOrderby(display)) {\n\t\t\t\tif ('custom-links' === display) {\n\t\t\t\t\tbuttonControl = wp.element.createElement(TextControl, {\n\t\t\t\t\t\tlabel: __('Texto botón'),\n\t\t\t\t\t\tvalue: button,\n\t\t\t\t\t\tonChange: function onChange(value) {\n\t\t\t\t\t\t\treturn setAttributes({ button: value });\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\tInspectorControls,\n\t\t\t\t{ key: 'inspector' },\n\t\t\t\tthis.getBlockDescription(),\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'h3',\n\t\t\t\t\tnull,\n\t\t\t\t\t__('Layout')\n\t\t\t\t),\n\t\t\t\tcolumnControl,\n\t\t\t\trowControl,\n\t\t\t\torderControl,\n\t\t\t\texcerptControl,\n\t\t\t\tlinksControl,\n\t\t\t\ttargetControl,\n\t\t\t\theadingsControl,\n\t\t\t\tbuttonControl\n\t\t\t);\n\t\t}\n\t}, {\n\t\tkey: 'getToolbarControls',\n\t\tvalue: function getToolbarControls() {\n\t\t\tvar props = this.props;\n\t\t\tvar attributes = props.attributes,\n\t\t\t    setAttributes = props.setAttributes;\n\t\t\tvar display = attributes.display,\n\t\t\t    display_setting = attributes.display_setting,\n\t\t\t    edit_mode = attributes.edit_mode;\n\n\n\t\t\tvar shouldDisableEditButton = ['', 'post', 'page', 'category', 'tag'].includes(display) && !display_setting.length;\n\n\t\t\tvar editButton = [{\n\t\t\t\ticon: 'edit',\n\t\t\t\ttitle: __('Edit'),\n\t\t\t\tonClick: shouldDisableEditButton ? function () {} : function () {\n\t\t\t\t\treturn setAttributes({ edit_mode: !edit_mode });\n\t\t\t\t},\n\t\t\t\tisActive: edit_mode\n\t\t\t}];\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\tBlockControls,\n\t\t\t\t{ key: 'controls' },\n\t\t\t\twp.element.createElement(Toolbar, { controls: editButton })\n\t\t\t);\n\t\t}\n\t}, {\n\t\tkey: 'getBlockDescription',\n\t\tvalue: function getBlockDescription() {\n\t\t\tvar _props4 = this.props,\n\t\t\t    attributes = _props4.attributes,\n\t\t\t    setAttributes = _props4.setAttributes;\n\t\t\tvar display = attributes.display,\n\t\t\t    display_setting = attributes.display_setting,\n\t\t\t    edit_mode = attributes.edit_mode;\n\n\n\t\t\tif (!display.length) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tfunction editQuicklinkHandler() {\n\t\t\t\tsetAttributes({\n\t\t\t\t\tedit_mode: true\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tvar editQuickLink = null;\n\t\t\tif (!attributes.edit_mode) {\n\t\t\t\teditQuickLink = wp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-scope-description--edit-quicklink' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'a',\n\t\t\t\t\t\t{ onClick: editQuicklinkHandler },\n\t\t\t\t\t\t__('Edit')\n\t\t\t\t\t)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-amb-descs' },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-scope-details' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'h3',\n\t\t\t\t\t\tnull,\n\t\t\t\t\t\t__('Categorización Actual')\n\t\t\t\t\t),\n\t\t\t\t\twp.element.createElement(ClustersBlockSidebarInfo, { attributes: attributes })\n\t\t\t\t),\n\t\t\t\teditQuickLink\n\t\t\t);\n\t\t}\n\t}, {\n\t\tkey: 'getPreview',\n\t\tvalue: function getPreview() {\n\t\t\treturn wp.element.createElement(ClustersBlockPreview, { attributes: this.props.attributes, setAttributes: this.props.setAttributes });\n\t\t}\n\t}, {\n\t\tkey: 'getSettingsEditor',\n\t\tvalue: function getSettingsEditor() {\n\t\t\tvar _props5 = this.props,\n\t\t\t    attributes = _props5.attributes,\n\t\t\t    setAttributes = _props5.setAttributes;\n\t\t\tvar display = attributes.display,\n\t\t\t    display_setting = attributes.display_setting;\n\n\n\t\t\tvar update_display_callback = function update_display_callback(value) {\n\n\t\t\t\tvar needsFurtherSettings = ['post', 'page', 'category', 'tag'];\n\n\t\t\t\tif (display !== value) {\n\t\t\t\t\tsetAttributes({\n\t\t\t\t\t\tdisplay: value,\n\t\t\t\t\t\tdisplay_setting: [],\n\t\t\t\t\t\tedit_mode: needsFurtherSettings.includes(value)\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\n\t\t\treturn wp.element.createElement(ClustersBlockSettingsEditor, {\n\t\t\t\tattributes: attributes,\n\t\t\t\tselected_display: display,\n\t\t\t\tselected_display_setting: display_setting,\n\t\t\t\tupdate_display_callback: update_display_callback,\n\t\t\t\tupdate_display_setting_callback: function update_display_setting_callback(value) {\n\t\t\t\t\treturn setAttributes({ display_setting: value });\n\t\t\t\t},\n\t\t\t\tdone_callback: function done_callback() {\n\t\t\t\t\treturn setAttributes({ edit_mode: false });\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar attributes = this.props.attributes;\n\t\t\tvar edit_mode = attributes.edit_mode;\n\n\n\t\t\treturn [this.getInspectorControls(), this.getToolbarControls(), edit_mode ? this.getSettingsEditor() : this.getPreview()];\n\t\t}\n\t}]);\n\n\treturn ClustersBlock;\n}(React.Component);\n\nvar asapPopover = function (_React$Component9) {\n\t_inherits(asapPopover, _React$Component9);\n\n\tfunction asapPopover(props) {\n\t\tvar _ref3;\n\n\t\t_classCallCheck(this, asapPopover);\n\n\t\tvar _this11 = _possibleConstructorReturn(this, (_ref3 = asapPopover.__proto__ || Object.getPrototypeOf(asapPopover)).call.apply(_ref3, [this].concat(_toConsumableArray(props))));\n\n\t\t_this11.onChangeURL = _this11.onChangeURL.bind(_this11);\n\t\t_this11.openURLPopover = _this11.openURLPopover.bind(_this11);\n\t\t_this11.closeURLPopover = _this11.closeURLPopover.bind(_this11);\n\n\t\t_this11.state = {\n\t\t\tisVisible: false,\n\t\t\tisNoFollow: false,\n\t\t\tisTargetBlank: false,\n\t\t\tisEnableButton: true\n\t\t};\n\t\treturn _this11;\n\t}\n\n\t_createClass(asapPopover, [{\n\t\tkey: 'onChangeURL',\n\t\tvalue: function onChangeURL(url) {\n\t\t\tthis.setState({ url: url });\n\t\t}\n\t}, {\n\t\tkey: 'openURLPopover',\n\t\tvalue: function openURLPopover() {\n\n\t\t\tif (!this.state.isVisible) {\n\t\t\t\tthis.setState({ isVisible: true });\n\t\t\t} else {\n\t\t\t\tthis.setState({ isVisible: false });\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'closeURLPopover',\n\t\tvalue: function closeURLPopover(event) {\n\n\t\t\tif (event.target.className != 'editor-url-input__suggestion') {\n\t\t\t\tif (this.state.isVisible) {\n\t\t\t\t\tthis.setState({ isVisible: false });\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _this12 = this;\n\n\t\t\tvar _props6 = this.props,\n\t\t\t    attributes = _props6.attributes,\n\t\t\t    setAttributes = _props6.setAttributes,\n\t\t\t    cluster = _props6.cluster;\n\t\t\tvar settings = attributes.settings,\n\t\t\t    links = attributes.links,\n\t\t\t    target = attributes.target;\n\t\t\tvar _state = this.state,\n\t\t\t    url = _state.url,\n\t\t\t    isVisible = _state.isVisible,\n\t\t\t    isEditing = _state.isEditing,\n\t\t\t    isNoFollow = _state.isNoFollow,\n\t\t\t    isTargetBlank = _state.isTargetBlank,\n\t\t\t    isEnableButton = _state.isEnableButton;\n\n\t\t\tvar settingsJson = JSON.parse(settings);\n\n\t\t\tvar noFollowToggle = function noFollowToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tif (settingsJson[cluster]['nofollow'] == true) {\n\t\t\t\t\t\tsettingsJson[cluster]['nofollow'] = false;\n\t\t\t\t\t\t_this12.setState({ isNoFollow: false });\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsettingsJson[cluster]['nofollow'] = true;\n\t\t\t\t\t\t_this12.setState({ isNoFollow: true });\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\tnofollow: true\n\t\t\t\t\t};\n\n\t\t\t\t\t_this12.setState({ isNoFollow: true });\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\tvar targetToggle = function targetToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\n\t\t\t\t\tif (settingsJson[cluster]['target'] == true) {\n\t\t\t\t\t\tsettingsJson[cluster]['target'] = false;\n\t\t\t\t\t\t_this12.setState({ isTargetBlank: false });\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsettingsJson[cluster]['target'] = true;\n\t\t\t\t\t\t_this12.setState({ isTargetBlank: true });\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\ttarget: true\n\t\t\t\t\t};\n\n\t\t\t\t\t_this12.setState({ isTargetBlank: true });\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\tvar enableButtonToggle = function enableButtonToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tif (settingsJson[cluster]['enableButton'] == true) {\n\t\t\t\t\t\tsettingsJson[cluster]['enableButton'] = false;\n\t\t\t\t\t\t_this12.setState({ isEnableButton: false });\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsettingsJson[cluster]['enableButton'] = true;\n\t\t\t\t\t\t_this12.setState({ isEnableButton: true });\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\tenableButton: true\n\t\t\t\t\t};\n\n\t\t\t\t\t_this12.setState({ isEnableButton: true });\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\tvar isTargetBlankToggle = function isTargetBlankToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tif (settingsJson[cluster]['target'] === true) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else if (settingsJson[cluster]['target'] === false) return false;\n\t\t\t\t} else {\n\t\t\t\t\tif (target == '_blank') {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t};\n\n\t\t\tvar isEnableButtonToggle = function isEnableButtonToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tif (settingsJson[cluster]['enableButton'] === true) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else if (settingsJson[cluster]['enableButton'] === false) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\tvar isNoFollowToggle = function isNoFollowToggle() {\n\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tif (settingsJson[cluster]['nofollow'] === true) {\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else if (settingsJson[cluster]['nofollow'] === false) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (links == 'nofollow') {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t};\n\n\t\t\tvar changeURLInput = function changeURLInput(url, post) {\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tsettingsJson[cluster]['link'] = url;\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\tlink: url\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\tvar changeButtonText = function changeButtonText(text) {\n\t\t\t\tif (settingsJson[cluster]) {\n\t\t\t\t\tsettingsJson[cluster]['button'] = text;\n\t\t\t\t} else {\n\t\t\t\t\tsettingsJson[cluster] = {\n\t\t\t\t\t\tbutton: text\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tsetAttributes({ settings: JSON.stringify(settingsJson, null) });\n\t\t\t};\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-url-editor' },\n\t\t\t\twp.element.createElement(IconButton, {\n\t\t\t\t\tclassName: 'components-toolbar__control',\n\t\t\t\t\tlabel: __('Link Settings'),\n\t\t\t\t\ticon: 'admin-generic',\n\t\t\t\t\tonClick: this.openURLPopover\n\t\t\t\t}),\n\t\t\t\tisVisible && wp.element.createElement(\n\t\t\t\t\tPopover,\n\t\t\t\t\t{ position: 'bottom', className: 'asap-clusters-popover', onClickOutside: this.closeURLPopover },\n\t\t\t\t\twp.element.createElement(URLInput, {\n\t\t\t\t\t\tvalue: settingsJson[cluster] ? settingsJson[cluster].link != 'undefined' ? settingsJson[cluster].link : null : null,\n\t\t\t\t\t\tonChange: changeURLInput\n\t\t\t\t\t}),\n\t\t\t\t\twp.element.createElement(ToggleControl, { label: 'No follow', onChange: noFollowToggle, checked: isNoFollowToggle() ? true : false }),\n\t\t\t\t\twp.element.createElement(ToggleControl, { label: 'Abrir en una nueva pestaña', onChange: targetToggle, checked: isTargetBlankToggle() ? true : false }),\n\t\t\t\t\twp.element.createElement(ToggleControl, { label: 'Mostrar botón', onChange: enableButtonToggle, checked: isEnableButtonToggle() ? true : false }),\n\t\t\t\t\twp.element.createElement(TextControl, {\n\t\t\t\t\t\tlabel: 'Texto botón',\n\t\t\t\t\t\tvalue: settingsJson[cluster] ? settingsJson[cluster].button != 'undefined' ? settingsJson[cluster].button : null : null,\n\t\t\t\t\t\tonChange: changeButtonText\n\t\t\t\t\t})\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn asapPopover;\n}(React.Component);\n\n/*\n*\tREGISTER BLOCK\n*/\n\nregisterBlockType('asap/cluster', {\n\ttitle: __('Categorización'),\n\ticon: 'grid-view',\n\tcategory: 'asap',\n\tdescription: __('Muestra una categorización de entradas, páginas, categorías, etiquetas o completamente personalizable.'),\n\tsupports: {\n\t\thtml: false\n\t},\n\tattributes: {\n\t\tcolumns: {\n\t\t\ttype: 'number',\n\t\t\tdefault: 3\n\t\t},\n\t\trows: {\n\t\t\ttype: 'number',\n\t\t\tdefault: 9\n\t\t},\n\t\tdisplay: {\n\t\t\ttype: 'string',\n\t\t\tdefault: ''\n\t\t},\n\t\tdisplay_setting: {\n\t\t\ttype: 'array',\n\t\t\tdefault: []\n\t\t},\n\t\torderby: {\n\t\t\ttype: 'string',\n\t\t\tdefault: 'date'\n\t\t},\n\t\texcerpt: {\n\t\t\ttype: 'string',\n\t\t\tdefault: 'default'\n\t\t},\n\t\theadings: {\n\t\t\ttype: 'string',\n\t\t\tdefault: 'span'\n\t\t},\n\t\tlinks: {\n\t\t\ttype: 'string',\n\t\t\tdefault: 'follow'\n\t\t},\n\t\ttarget: {\n\t\t\ttype: 'string',\n\t\t\tdefault: '_self'\n\t\t},\n\t\tthumbnailSize: {\n\t\t\ttype: 'string',\n\t\t\tdefault: 'thumbnail-center'\n\t\t},\n\t\tbutton: {\n\t\t\ttype: 'string',\n\t\t\tdefault: ''\n\t\t},\n\t\tfeatured: {\n\t\t\ttype: 'number',\n\t\t\tdefault: 0\n\t\t},\n\t\tsettings: {\n\t\t\ttype: 'string',\n\t\t\tdefault: '{}'\n\t\t},\n\t\tedit_mode: {\n\t\t\ttype: 'boolean',\n\t\t\tdefault: true\n\t\t}\n\t},\n\n\tedit: function edit(props) {\n\t\treturn wp.element.createElement(ClustersBlock, props);\n\t},\n\tsave: function save(props) {\n\t\treturn null;\n\t},\n\n\n\tdeprecated: [{\n\t\tattributes: {\n\t\t\tcolumns: {\n\t\t\t\ttype: 'number',\n\t\t\t\tdefault: 3\n\t\t\t},\n\t\t\trows: {\n\t\t\t\ttype: 'number',\n\t\t\t\tdefault: 9\n\t\t\t},\n\t\t\tdisplay: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: ''\n\t\t\t},\n\t\t\tdisplay_setting: {\n\t\t\t\ttype: 'array',\n\t\t\t\tdefault: []\n\t\t\t},\n\t\t\torderby: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: 'date'\n\t\t\t},\n\t\t\texcerpt: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: 'default'\n\t\t\t},\n\t\t\tlinks: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: 'follow'\n\t\t\t},\n\t\t\ttarget: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: '_self'\n\t\t\t},\n\t\t\tfeatured: {\n\t\t\t\ttype: 'number',\n\t\t\t\tdefault: 0\n\t\t\t},\n\t\t\tsettings: {\n\t\t\t\ttype: 'string',\n\t\t\t\tdefault: '{}'\n\t\t\t},\n\t\t\tedit_mode: {\n\t\t\t\ttype: 'boolean',\n\t\t\t\tdefault: true\n\t\t\t}\n\t\t},\n\n\t\tedit: function edit(props) {\n\t\t\treturn wp.element.createElement(ClustersBlock, props);\n\t\t},\n\t\tsave: function save(props) {\n\t\t\tvar _props$attributes3 = props.attributes,\n\t\t\t    rows = _props$attributes3.rows,\n\t\t\t    columns = _props$attributes3.columns,\n\t\t\t    display = _props$attributes3.display,\n\t\t\t    display_setting = _props$attributes3.display_setting,\n\t\t\t    orderby = _props$attributes3.orderby,\n\t\t\t    excerpt = _props$attributes3.excerpt,\n\t\t\t    links = _props$attributes3.links,\n\t\t\t    featured = _props$attributes3.featured,\n\t\t\t    thumbnailSize = _props$attributes3.thumbnailSize;\n\n\n\t\t\tvar shortcode_atts = new Map();\n\n\t\t\tshortcode_atts.set('columns', columns);\n\n\t\t\tif (excerpt) {\n\t\t\t\tshortcode_atts.set('excerpt', excerpt);\n\t\t\t}\n\n\t\t\tif (links) {\n\t\t\t\tshortcode_atts.set('links', links);\n\t\t\t}\n\n\t\t\tif (featured) {\n\t\t\t\tshortcode_atts.set('featured', featured);\n\t\t\t}\n\n\t\t\tif (thumbnailSize) {\n\t\t\t\tshortcode_atts.set('thumbnailSize', thumbnailSize);\n\t\t\t}\n\n\t\t\tif ('page' !== display || 'post' !== display) {\n\t\t\t\tshortcode_atts.set('postperpage', rows);\n\t\t\t}\n\n\t\t\tif ('page' === display || 'post' === display) {\n\t\t\t\tshortcode_atts.set('pages', display_setting.join(','));\n\t\t\t} else if ('category' === display) {\n\t\t\t\tshortcode_atts.set('categories', display_setting.join(','));\n\t\t\t} else if ('tag' === display) {\n\t\t\t\tshortcode_atts.set('tags', display_setting.join(','));\n\t\t\t}\n\n\t\t\tif (supportsOrderby(display)) {\n\n\t\t\t\tif ('rand' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'rand');\n\t\t\t\t} else if ('id_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'id');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('id_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'id');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('title_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'title');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('title_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'title');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('name_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'name');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('name_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'name');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('date_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'date');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('date_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'date');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('modified_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'modified');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('modified_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'modified');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('parent_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'parent');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('parent_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'parent');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('menu_order_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'menu_order');\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('menu_order_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('orderby', 'menu_order');\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t} else if ('comment_count_asc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('order', 'ASC');\n\t\t\t\t} else if ('comment_count_desc' === orderby) {\n\t\t\t\t\tshortcode_atts.set('order', 'DESC');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar shortcode = '[asap_cluster ';\n\t\t\tvar _iteratorNormalCompletion6 = true;\n\t\t\tvar _didIteratorError6 = false;\n\t\t\tvar _iteratorError6 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator6 = shortcode_atts[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {\n\t\t\t\t\tvar _ref4 = _step6.value;\n\n\t\t\t\t\tvar _ref5 = _slicedToArray(_ref4, 2);\n\n\t\t\t\t\tvar key = _ref5[0];\n\t\t\t\t\tvar value = _ref5[1];\n\n\t\t\t\t\tshortcode += ' ' + key + '=\"' + value + '\"';\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError6 = true;\n\t\t\t\t_iteratorError6 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion6 && _iterator6.return) {\n\t\t\t\t\t\t_iterator6.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError6) {\n\t\t\t\t\t\tthrow _iteratorError6;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tshortcode += ']';\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\tRawHTML,\n\t\t\t\tnull,\n\t\t\t\tshortcode\n\t\t\t);\n\t\t}\n\t}]\n\n});\n\n//# sourceURL=webpack:///./src/cluster/clusters-block.jsx?");

			/***/
		}),

	/***/
	"./src/cluster/views/category-select.jsx":
		/*!***********************************************!*\
		  !*** ./src/cluster/views/category-select.jsx ***!
		  \***********************************************/
		/*! no static exports found */
		/***/
		(function(module, exports, __webpack_require__) {

			"use strict";
			eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar __ = wp.i18n.__;\nvar _wp$components = wp.components,\n    Toolbar = _wp$components.Toolbar,\n    Dropdown = _wp$components.Dropdown,\n    Dashicon = _wp$components.Dashicon;\nvar _wp = wp,\n    apiFetch = _wp.apiFetch;\n\nvar ClustersCategorySelect = exports.ClustersCategorySelect = function (_React$Component) {\n\t_inherits(ClustersCategorySelect, _React$Component);\n\n\tfunction ClustersCategorySelect(props) {\n\t\t_classCallCheck(this, ClustersCategorySelect);\n\n\t\tvar _this = _possibleConstructorReturn(this, (ClustersCategorySelect.__proto__ || Object.getPrototypeOf(ClustersCategorySelect)).call(this, props));\n\n\t\t_this.state = {\n\t\t\tselectedCategories: props.selected_display_setting,\n\t\t\topenAccordion: [],\n\t\t\tfilterQuery: '',\n\t\t\tfirstLoad: true\n\t\t};\n\n\t\t_this.checkboxChange = _this.checkboxChange.bind(_this);\n\t\t_this.accordionToggle = _this.accordionToggle.bind(_this);\n\t\t_this.filterResults = _this.filterResults.bind(_this);\n\t\t_this.setFirstLoad = _this.setFirstLoad.bind(_this);\n\t\treturn _this;\n\t}\n\n\t_createClass(ClustersCategorySelect, [{\n\t\tkey: \"checkboxChange\",\n\t\tvalue: function checkboxChange(checked, categories) {\n\t\t\tvar selectedCategories = this.state.selectedCategories;\n\n\t\t\tselectedCategories = selectedCategories.filter(function (category) {\n\t\t\t\treturn !categories.includes(category);\n\t\t\t});\n\n\t\t\tif (checked) {\n\t\t\t\tvar _selectedCategories;\n\n\t\t\t\t(_selectedCategories = selectedCategories).push.apply(_selectedCategories, _toConsumableArray(categories));\n\t\t\t}\n\n\t\t\tthis.setState({\n\t\t\t\tselectedCategories: selectedCategories\n\t\t\t});\n\n\t\t\tthis.props.update_display_setting_callback(selectedCategories);\n\t\t}\n\t}, {\n\t\tkey: \"accordionToggle\",\n\t\tvalue: function accordionToggle(category) {\n\t\t\tvar openAccordions = this.state.openAccordion;\n\n\t\t\tif (openAccordions.includes(category)) {\n\t\t\t\topenAccordions = openAccordions.filter(function (c) {\n\t\t\t\t\treturn c !== category;\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\topenAccordions.push(category);\n\t\t\t}\n\n\t\t\tthis.setState({\n\t\t\t\topenAccordion: openAccordions\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"filterResults\",\n\t\tvalue: function filterResults(evt) {\n\t\t\tthis.setState({\n\t\t\t\tfilterQuery: evt.target.value\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"setFirstLoad\",\n\t\tvalue: function setFirstLoad(loaded) {\n\t\t\tthis.setState({\n\t\t\t\tfirstLoad: !!loaded\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"render\",\n\t\tvalue: function render() {\n\t\t\treturn wp.element.createElement(\n\t\t\t\t\"div\",\n\t\t\t\t{ className: \"asap-clusters-list-card asap-clusters-list-card--taxonomy asap-clusters-list-card--taxonomy-category\" },\n\t\t\t\twp.element.createElement(ProductCategoryFilter, { filterResults: this.filterResults }),\n\t\t\t\twp.element.createElement(ProductCategoryList, {\n\t\t\t\t\tfilterQuery: this.state.filterQuery,\n\t\t\t\t\tselectedCategories: this.state.selectedCategories,\n\t\t\t\t\tcheckboxChange: this.checkboxChange,\n\t\t\t\t\taccordionToggle: this.accordionToggle,\n\t\t\t\t\topenAccordion: this.state.openAccordion,\n\t\t\t\t\tfirstLoad: this.state.firstLoad,\n\t\t\t\t\tsetFirstLoad: this.setFirstLoad\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersCategorySelect;\n}(React.Component);\n\nvar ProductCategoryFilter = function ProductCategoryFilter(_ref) {\n\tvar filterResults = _ref.filterResults;\n\n\treturn wp.element.createElement(\n\t\t\"div\",\n\t\t{ className: \"asap-clusters-list-card__input-wrapper\" },\n\t\twp.element.createElement(Dashicon, { icon: \"search\" }),\n\t\twp.element.createElement(\"input\", { className: \"asap-clusters-list-card__search\", type: \"search\", placeholder: __('Selecciona las categorías que deseas mostrar'), onChange: filterResults })\n\t);\n};\n\nvar ProductCategoryList = function (_React$Component2) {\n\t_inherits(ProductCategoryList, _React$Component2);\n\n\tfunction ProductCategoryList(props) {\n\t\t_classCallCheck(this, ProductCategoryList);\n\n\t\tvar _this2 = _possibleConstructorReturn(this, (ProductCategoryList.__proto__ || Object.getPrototypeOf(ProductCategoryList)).call(this, props));\n\n\t\t_this2.state = {\n\t\t\tcategories: [],\n\t\t\tloaded: false,\n\t\t\tquery: ''\n\t\t};\n\n\t\t_this2.updatePreview = _this2.updatePreview.bind(_this2);\n\t\t_this2.getQuery = _this2.getQuery.bind(_this2);\n\t\treturn _this2;\n\t}\n\n\t_createClass(ProductCategoryList, [{\n\t\tkey: \"componentDidMount\",\n\t\tvalue: function componentDidMount() {\n\t\t\tif (this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updatePreview();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: \"componentDidUpdate\",\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.getQuery() !== this.state.query && this.state.loaded) {\n\t\t\t\tthis.updatePreview();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: \"getQuery\",\n\t\tvalue: function getQuery() {\n\t\t\tvar endpoint = '/wp/v2/categories?per_page=-1';\n\t\t\treturn endpoint;\n\t\t}\n\t}, {\n\t\tkey: \"updatePreview\",\n\t\tvalue: function updatePreview() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tapiFetch({ path: query }).then(function (categories) {\n\t\t\t\tself.setState({\n\t\t\t\t\tcategories: categories,\n\t\t\t\t\tloaded: true,\n\t\t\t\t\tquery: query\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"render\",\n\t\tvalue: function render() {\n\t\t\tvar _props = this.props,\n\t\t\t    filterQuery = _props.filterQuery,\n\t\t\t    selectedCategories = _props.selectedCategories,\n\t\t\t    checkboxChange = _props.checkboxChange,\n\t\t\t    accordionToggle = _props.accordionToggle,\n\t\t\t    openAccordion = _props.openAccordion,\n\t\t\t    firstLoad = _props.firstLoad,\n\t\t\t    setFirstLoad = _props.setFirstLoad;\n\n\n\t\t\tif (!this.state.loaded) {\n\t\t\t\treturn __('Loading');\n\t\t\t}\n\n\t\t\tif (0 === this.state.categories.length) {\n\t\t\t\treturn __('No categories found');\n\t\t\t}\n\n\t\t\tvar handleCategoriesToCheck = function handleCategoriesToCheck(evt, parent, categories) {\n\t\t\t\tvar ids = getCategoryChildren(parent, categories).map(function (category) {\n\t\t\t\t\treturn category.id;\n\t\t\t\t});\n\n\t\t\t\tids.push(parent.id);\n\n\t\t\t\tcheckboxChange(evt.target.checked, ids);\n\t\t\t};\n\n\t\t\tvar getCategoryChildren = function getCategoryChildren(parent, categories) {\n\t\t\t\tvar children = [];\n\n\t\t\t\tcategories.filter(function (category) {\n\t\t\t\t\treturn category.parent === parent.id;\n\t\t\t\t}).forEach(function (category) {\n\t\t\t\t\tchildren.push(category);\n\t\t\t\t\tchildren.push.apply(children, _toConsumableArray(getCategoryChildren(category, categories)));\n\t\t\t\t});\n\n\t\t\t\treturn children;\n\t\t\t};\n\n\t\t\tvar categoryHasChildren = function categoryHasChildren(parent, categories) {\n\t\t\t\treturn !!getCategoryChildren(parent, categories).length;\n\t\t\t};\n\n\t\t\tvar isIndeterminate = function isIndeterminate(category, categories) {\n\n\t\t\t\tif (selectedCategories.includes(category.id)) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tvar children = getCategoryChildren(category, categories).map(function (category) {\n\t\t\t\t\treturn category.id;\n\t\t\t\t});\n\n\t\t\t\tvar _iteratorNormalCompletion = true;\n\t\t\t\tvar _didIteratorError = false;\n\t\t\t\tvar _iteratorError = undefined;\n\n\t\t\t\ttry {\n\t\t\t\t\tfor (var _iterator = children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n\t\t\t\t\t\tvar child = _step.value;\n\n\t\t\t\t\t\tif (selectedCategories.includes(child)) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} catch (err) {\n\t\t\t\t\t_didIteratorError = true;\n\t\t\t\t\t_iteratorError = err;\n\t\t\t\t} finally {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tif (!_iteratorNormalCompletion && _iterator.return) {\n\t\t\t\t\t\t\t_iterator.return();\n\t\t\t\t\t\t}\n\t\t\t\t\t} finally {\n\t\t\t\t\t\tif (_didIteratorError) {\n\t\t\t\t\t\t\tthrow _iteratorError;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn false;\n\t\t\t};\n\n\t\t\tvar AccordionButton = function AccordionButton(_ref2) {\n\t\t\t\tvar category = _ref2.category,\n\t\t\t\t    categories = _ref2.categories;\n\n\t\t\t\tvar icon = 'arrow-down-alt2';\n\n\t\t\t\tif (openAccordion.includes(category.id)) {\n\t\t\t\t\ticon = 'arrow-up-alt2';\n\t\t\t\t}\n\n\t\t\t\tvar style = null;\n\n\t\t\t\tif (!categoryHasChildren(category, categories)) {\n\t\t\t\t\tstyle = {\n\t\t\t\t\t\tvisibility: 'hidden'\n\t\t\t\t\t};\n\t\t\t\t};\n\n\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\"button\",\n\t\t\t\t\t{ onClick: function onClick() {\n\t\t\t\t\t\t\treturn accordionToggle(category.id);\n\t\t\t\t\t\t}, className: \"asap-clusters-list-card__accordion-button\", style: style, type: \"button\" },\n\t\t\t\t\twp.element.createElement(Dashicon, { icon: icon })\n\t\t\t\t);\n\t\t\t};\n\n\t\t\tvar CategoryTree = function CategoryTree(_ref3) {\n\t\t\t\tvar categories = _ref3.categories,\n\t\t\t\t    parent = _ref3.parent;\n\n\n\t\t\t\tvar filteredCategories = categories.filter(function (category) {\n\t\t\t\t\treturn category.parent === parent;\n\t\t\t\t});\n\t\t\t\tif (firstLoad && selectedCategories.length > 0) {\n\t\t\t\t\tcategoriesData.filter(function (category) {\n\t\t\t\t\t\treturn category.parent === 0;\n\t\t\t\t\t}).forEach(function (category) {\n\t\t\t\t\t\tvar children = getCategoryChildren(category, categoriesData);\n\n\t\t\t\t\t\tvar _iteratorNormalCompletion2 = true;\n\t\t\t\t\t\tvar _didIteratorError2 = false;\n\t\t\t\t\t\tvar _iteratorError2 = undefined;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tfor (var _iterator2 = children[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {\n\t\t\t\t\t\t\t\tvar child = _step2.value;\n\n\t\t\t\t\t\t\t\tif (selectedCategories.includes(child.id) && !openAccordion.includes(category.id)) {\n\t\t\t\t\t\t\t\t\taccordionToggle(category.id);\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\t_didIteratorError2 = true;\n\t\t\t\t\t\t\t_iteratorError2 = err;\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tif (!_iteratorNormalCompletion2 && _iterator2.return) {\n\t\t\t\t\t\t\t\t\t_iterator2.return();\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\tif (_didIteratorError2) {\n\t\t\t\t\t\t\t\t\tthrow _iteratorError2;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tsetFirstLoad(false);\n\t\t\t\t}\n\n\t\t\t\treturn filteredCategories.length > 0 && wp.element.createElement(\n\t\t\t\t\t\"ul\",\n\t\t\t\t\tnull,\n\t\t\t\t\tfilteredCategories.map(function (category) {\n\t\t\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\t\t\"li\",\n\t\t\t\t\t\t\t{ key: category.id, className: openAccordion.includes(category.id) ? 'asap-clusters-list-card__item asap-clusters-list-card__accordion-open' : 'asap-clusters-list-card__item' },\n\t\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t\t\"label\",\n\t\t\t\t\t\t\t\t{ className: 0 === category.parent ? 'asap-clusters-list-card__content' : '', htmlFor: 'product-category-' + category.id },\n\t\t\t\t\t\t\t\twp.element.createElement(\"input\", { type: \"checkbox\",\n\t\t\t\t\t\t\t\t\tid: 'product-category-' + category.id,\n\t\t\t\t\t\t\t\t\tvalue: category.id,\n\t\t\t\t\t\t\t\t\tchecked: selectedCategories.includes(category.id),\n\t\t\t\t\t\t\t\t\tonChange: function onChange(evt) {\n\t\t\t\t\t\t\t\t\t\treturn handleCategoriesToCheck(evt, category, categories);\n\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\tref: function ref(el) {\n\t\t\t\t\t\t\t\t\t\treturn el && (el.indeterminate = isIndeterminate(category, categories));\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}),\n\t\t\t\t\t\t\t\t\" \",\n\t\t\t\t\t\t\t\tcategory.name,\n\t\t\t\t\t\t\t\t0 === category.parent && wp.element.createElement(AccordionButton, { category: category, categories: categories }),\n\t\t\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t\t\t\"span\",\n\t\t\t\t\t\t\t\t\t{ className: \"asap-clusters-list-card__taxonomy-count\" },\n\t\t\t\t\t\t\t\t\tcategory.count\n\t\t\t\t\t\t\t\t)\n\t\t\t\t\t\t\t),\n\t\t\t\t\t\t\twp.element.createElement(CategoryTree, { categories: categories, parent: category.id })\n\t\t\t\t\t\t);\n\t\t\t\t\t})\n\t\t\t\t);\n\t\t\t};\n\n\t\t\tvar categoriesData = this.state.categories;\n\n\t\t\tif ('' !== filterQuery) {\n\t\t\t\tcategoriesData = categoriesData.filter(function (category) {\n\t\t\t\t\treturn category.slug.includes(filterQuery.toLowerCase());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t\"div\",\n\t\t\t\t{ className: \"asap-clusters-list-card__results\" },\n\t\t\t\twp.element.createElement(CategoryTree, { categories: categoriesData, parent: 0 })\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ProductCategoryList;\n}(React.Component);\n\n//# sourceURL=webpack:///./src/cluster/views/category-select.jsx?");

			/***/
		}),

	/***/
	"./src/cluster/views/page-select.jsx":
		/*!*******************************************!*\
		  !*** ./src/cluster/views/page-select.jsx ***!
		  \*******************************************/
		/*! no static exports found */
		/***/
		(function(module, exports, __webpack_require__) {

			"use strict";
			eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar __ = wp.i18n.__;\nvar _wp$components = wp.components,\n    Toolbar = _wp$components.Toolbar,\n    Dropdown = _wp$components.Dropdown,\n    Dashicon = _wp$components.Dashicon;\nvar _wp = wp,\n    apiFetch = _wp.apiFetch;\n\n\nvar PAGE_DATA = {};\n\nvar ClustersPageSelect = exports.ClustersPageSelect = function (_React$Component) {\n\t_inherits(ClustersPageSelect, _React$Component);\n\n\tfunction ClustersPageSelect(props) {\n\t\t_classCallCheck(this, ClustersPageSelect);\n\n\t\tvar _this = _possibleConstructorReturn(this, (ClustersPageSelect.__proto__ || Object.getPrototypeOf(ClustersPageSelect)).call(this, props));\n\n\t\t_this.state = {\n\t\t\tselectedPages: props.selected_display_setting || []\n\t\t};\n\t\treturn _this;\n\t}\n\n\t_createClass(ClustersPageSelect, [{\n\t\tkey: 'addOrRemovePage',\n\t\tvalue: function addOrRemovePage(id) {\n\t\t\tvar selectedPages = this.state.selectedPages;\n\n\t\t\tif (!selectedPages.includes(id)) {\n\t\t\t\tselectedPages.push(id);\n\t\t\t} else {\n\t\t\t\tselectedPages = selectedPages.filter(function (page) {\n\t\t\t\t\treturn page !== id;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tthis.setState({\n\t\t\t\tselectedPages: selectedPages\n\t\t\t});\n\n\t\t\tthis.props.update_display_setting_callback(selectedPages.slice());\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card asap-clusters-list-card--specific' },\n\t\t\t\twp.element.createElement(PagesSpecificSearchField, {\n\t\t\t\t\taddOrRemovePageCallback: this.addOrRemovePage.bind(this),\n\t\t\t\t\tselectedPages: this.state.selectedPages\n\t\t\t\t}),\n\t\t\t\twp.element.createElement(PageSpecificSelectedPages, {\n\t\t\t\t\tcolumns: this.props.attributes.columns,\n\t\t\t\t\tpageIds: this.state.selectedPages,\n\t\t\t\t\taddOrRemovePage: this.addOrRemovePage.bind(this)\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersPageSelect;\n}(React.Component);\n\nvar PagesSpecificSearchField = function (_React$Component2) {\n\t_inherits(PagesSpecificSearchField, _React$Component2);\n\n\tfunction PagesSpecificSearchField(props) {\n\t\t_classCallCheck(this, PagesSpecificSearchField);\n\n\t\tvar _this2 = _possibleConstructorReturn(this, (PagesSpecificSearchField.__proto__ || Object.getPrototypeOf(PagesSpecificSearchField)).call(this, props));\n\n\t\t_this2.state = {\n\t\t\tsearchText: '',\n\t\t\tdropdownOpen: false\n\t\t};\n\n\t\t_this2.updateSearchResults = _this2.updateSearchResults.bind(_this2);\n\t\t_this2.setWrapperRef = _this2.setWrapperRef.bind(_this2);\n\t\t_this2.handleClickOutside = _this2.handleClickOutside.bind(_this2);\n\t\t_this2.isDropdownOpen = _this2.isDropdownOpen.bind(_this2);\n\t\treturn _this2;\n\t}\n\n\t_createClass(PagesSpecificSearchField, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tdocument.addEventListener('mousedown', this.handleClickOutside);\n\t\t}\n\t}, {\n\t\tkey: 'componentWillUnmount',\n\t\tvalue: function componentWillUnmount() {\n\t\t\tdocument.removeEventListener('mousedown', this.handleClickOutside);\n\t\t}\n\t}, {\n\t\tkey: 'setWrapperRef',\n\t\tvalue: function setWrapperRef(node) {\n\t\t\tthis.wrapperRef = node;\n\t\t}\n\t}, {\n\t\tkey: 'handleClickOutside',\n\t\tvalue: function handleClickOutside(evt) {\n\t\t\tif (this.wrapperRef && !this.wrapperRef.contains(event.target)) {\n\t\t\t\tthis.setState({\n\t\t\t\t\tsearchText: ''\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'isDropdownOpen',\n\t\tvalue: function isDropdownOpen(isOpen) {\n\t\t\tthis.setState({\n\t\t\t\tdropdownOpen: !!isOpen\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'updateSearchResults',\n\t\tvalue: function updateSearchResults(evt) {\n\t\t\tthis.setState({\n\t\t\t\tsearchText: evt.target.value\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar divClass = 'asap-clusters-list-card__search-wrapper';\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: divClass + (this.state.dropdownOpen ? ' ' + divClass + '--with-results' : ''), ref: this.setWrapperRef },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__input-wrapper' },\n\t\t\t\t\twp.element.createElement(Dashicon, { icon: 'search' }),\n\t\t\t\t\twp.element.createElement('input', { type: 'search',\n\t\t\t\t\t\tclassName: 'asap-clusters-list-card__search',\n\t\t\t\t\t\tvalue: this.state.searchText,\n\t\t\t\t\t\tplaceholder: __('Busca y selecciona las páginas que deseas mostrar'),\n\t\t\t\t\t\tonChange: this.updateSearchResults\n\t\t\t\t\t})\n\t\t\t\t),\n\t\t\t\twp.element.createElement(PageSpecificSearchResults, {\n\t\t\t\t\tsearchString: this.state.searchText,\n\t\t\t\t\taddOrRemovePageCallback: this.props.addOrRemovePageCallback,\n\t\t\t\t\tselectedPages: this.props.selectedPages,\n\t\t\t\t\tisDropdownOpenCallback: this.isDropdownOpen\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PagesSpecificSearchField;\n}(React.Component);\n\nvar PageSpecificSearchResults = function (_React$Component3) {\n\t_inherits(PageSpecificSearchResults, _React$Component3);\n\n\tfunction PageSpecificSearchResults(props) {\n\t\t_classCallCheck(this, PageSpecificSearchResults);\n\n\t\tvar _this3 = _possibleConstructorReturn(this, (PageSpecificSearchResults.__proto__ || Object.getPrototypeOf(PageSpecificSearchResults)).call(this, props));\n\n\t\t_this3.state = {\n\t\t\tpages: [],\n\t\t\tquery: '',\n\t\t\tloaded: false\n\t\t};\n\n\t\t_this3.updateResults = _this3.updateResults.bind(_this3);\n\t\t_this3.getQuery = _this3.getQuery.bind(_this3);\n\t\treturn _this3;\n\t}\n\n\t_createClass(PageSpecificSearchResults, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updateResults();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updateResults();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQuery',\n\t\tvalue: function getQuery() {\n\t\t\tif (!this.props.searchString.length) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\treturn '/wp/v2/pages?per_page=9&orderby=relevance&order=desc&type=any&search=' + this.props.searchString + '&_embed';\n\t\t}\n\t}, {\n\t\tkey: 'updateResults',\n\t\tvalue: function updateResults() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tquery: query,\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tif (query.length) {\n\t\t\t\tapiFetch({ path: query }).then(function (pages) {\n\t\t\t\t\tif (query === self.getQuery()) {\n\t\t\t\t\t\tself.setState({\n\t\t\t\t\t\t\tpages: pages,\n\t\t\t\t\t\t\tloaded: true\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\tpages: [],\n\t\t\t\t\tloaded: true\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tif (!this.state.loaded || !this.state.query.length) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif (0 === this.state.pages.length) {\n\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t'span',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__search-no-results' },\n\t\t\t\t\t' ',\n\t\t\t\t\t__('No pages found'),\n\t\t\t\t\t' '\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tvar _iteratorNormalCompletion = true;\n\t\t\tvar _didIteratorError = false;\n\t\t\tvar _iteratorError = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator = this.state.pages[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n\t\t\t\t\tvar page = _step.value;\n\n\t\t\t\t\tPAGE_DATA[page.id] = page;\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError = true;\n\t\t\t\t_iteratorError = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion && _iterator.return) {\n\t\t\t\t\t\t_iterator.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError) {\n\t\t\t\t\t\tthrow _iteratorError;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(PageSpecificSearchResultsDropdown, {\n\t\t\t\tpages: this.state.pages,\n\t\t\t\taddOrRemovePageCallback: this.props.addOrRemovePageCallback,\n\t\t\t\tselectedPages: this.props.selectedPages,\n\t\t\t\tisDropdownOpenCallback: this.props.isDropdownOpenCallback\n\t\t\t});\n\t\t}\n\t}]);\n\n\treturn PageSpecificSearchResults;\n}(React.Component);\n\nvar PageSpecificSearchResultsDropdown = function (_React$Component4) {\n\t_inherits(PageSpecificSearchResultsDropdown, _React$Component4);\n\n\tfunction PageSpecificSearchResultsDropdown() {\n\t\t_classCallCheck(this, PageSpecificSearchResultsDropdown);\n\n\t\treturn _possibleConstructorReturn(this, (PageSpecificSearchResultsDropdown.__proto__ || Object.getPrototypeOf(PageSpecificSearchResultsDropdown)).apply(this, arguments));\n\t}\n\n\t_createClass(PageSpecificSearchResultsDropdown, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.props.isDropdownOpenCallback(true);\n\t\t}\n\t}, {\n\t\tkey: 'componentWillUnmount',\n\t\tvalue: function componentWillUnmount() {\n\t\t\tthis.props.isDropdownOpenCallback(false);\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _props = this.props,\n\t\t\t    pages = _props.pages,\n\t\t\t    addOrRemovePageCallback = _props.addOrRemovePageCallback,\n\t\t\t    selectedPages = _props.selectedPages;\n\n\n\t\t\tvar pageElements = [];\n\n\t\t\tvar _iteratorNormalCompletion2 = true;\n\t\t\tvar _didIteratorError2 = false;\n\t\t\tvar _iteratorError2 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator2 = pages[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {\n\t\t\t\t\tvar page = _step2.value;\n\n\t\t\t\t\tpageElements.push(wp.element.createElement(PageSpecificSearchResultsDropdownElement, {\n\t\t\t\t\t\tpage: page,\n\t\t\t\t\t\taddOrRemovePageCallback: addOrRemovePageCallback,\n\t\t\t\t\t\tselected: selectedPages.includes(page.id)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError2 = true;\n\t\t\t\t_iteratorError2 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion2 && _iterator2.return) {\n\t\t\t\t\t\t_iterator2.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError2) {\n\t\t\t\t\t\tthrow _iteratorError2;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ role: 'menu', className: 'asap-clusters-list-card__search-results', 'aria-orientation': 'vertical', 'aria-label': __('Pages list') },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\tnull,\n\t\t\t\t\tpageElements\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PageSpecificSearchResultsDropdown;\n}(React.Component);\n\nvar PageSpecificSearchResultsDropdownElement = function (_React$Component5) {\n\t_inherits(PageSpecificSearchResultsDropdownElement, _React$Component5);\n\n\tfunction PageSpecificSearchResultsDropdownElement(props) {\n\t\t_classCallCheck(this, PageSpecificSearchResultsDropdownElement);\n\n\t\tvar _this5 = _possibleConstructorReturn(this, (PageSpecificSearchResultsDropdownElement.__proto__ || Object.getPrototypeOf(PageSpecificSearchResultsDropdownElement)).call(this, props));\n\n\t\t_this5.handleClick = _this5.handleClick.bind(_this5);\n\t\treturn _this5;\n\t}\n\n\t_createClass(PageSpecificSearchResultsDropdownElement, [{\n\t\tkey: 'handleClick',\n\t\tvalue: function handleClick() {\n\t\t\tthis.props.addOrRemovePageCallback(this.props.page.id);\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar page = this.props.page;\n\n\t\t\tvar icon = this.props.selected ? wp.element.createElement(Dashicon, { icon: 'yes' }) : null;\n\t\t\tvar image = null;\n\t\t\tif (typeof page['_embedded']['wp:featuredmedia'] != \"undefined\") {\n\t\t\t\timage = wp.element.createElement('img', { src: page['_embedded']['wp:featuredmedia']['0'].source_url });\n\t\t\t}\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card__content' + (this.props.selected ? ' asap-clusters-list-card__content--added' : ''), onClick: this.handleClick },\n\t\t\t\timage,\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'span',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__content-item-name' },\n\t\t\t\t\tpage.title.rendered\n\t\t\t\t),\n\t\t\t\ticon\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PageSpecificSearchResultsDropdownElement;\n}(React.Component);\n\nvar PageSpecificSelectedPages = function (_React$Component6) {\n\t_inherits(PageSpecificSelectedPages, _React$Component6);\n\n\tfunction PageSpecificSelectedPages(props) {\n\t\t_classCallCheck(this, PageSpecificSelectedPages);\n\n\t\tvar _this6 = _possibleConstructorReturn(this, (PageSpecificSelectedPages.__proto__ || Object.getPrototypeOf(PageSpecificSelectedPages)).call(this, props));\n\n\t\t_this6.state = {\n\t\t\tquery: '',\n\t\t\tloaded: false\n\t\t};\n\n\t\t_this6.updatePageCache = _this6.updatePageCache.bind(_this6);\n\t\t_this6.getQuery = _this6.getQuery.bind(_this6);\n\n\t\treturn _this6;\n\t}\n\n\t_createClass(PageSpecificSelectedPages, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updatePageCache();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.state.loaded && this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updatePageCache();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQuery',\n\t\tvalue: function getQuery() {\n\t\t\tif (!this.props.pageIds.length) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\t// Determine which pages are not already in the cache and only fetch uncached pages.\n\t\t\tvar uncachedPages = [];\n\t\t\tvar _iteratorNormalCompletion3 = true;\n\t\t\tvar _didIteratorError3 = false;\n\t\t\tvar _iteratorError3 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator3 = this.props.pageIds[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {\n\t\t\t\t\tvar pageId = _step3.value;\n\n\t\t\t\t\tif (!PAGE_DATA.hasOwnProperty(pageId)) {\n\t\t\t\t\t\tuncachedPages.push(pageId);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError3 = true;\n\t\t\t\t_iteratorError3 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion3 && _iterator3.return) {\n\t\t\t\t\t\t_iterator3.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError3) {\n\t\t\t\t\t\tthrow _iteratorError3;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn uncachedPages.length ? '/wp/v2/pages?include=' + uncachedPages.join(',') + '&_embed' : '';\n\t\t}\n\t}, {\n\t\tkey: 'updatePageCache',\n\t\tvalue: function updatePageCache() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tquery: query,\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tif (query.length) {\n\t\t\t\tapiFetch({ path: query }).then(function (pages) {\n\t\t\t\t\tif (pages.length) {\n\t\t\t\t\t\tvar _iteratorNormalCompletion4 = true;\n\t\t\t\t\t\tvar _didIteratorError4 = false;\n\t\t\t\t\t\tvar _iteratorError4 = undefined;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tfor (var _iterator4 = pages[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {\n\t\t\t\t\t\t\t\tvar page = _step4.value;\n\n\t\t\t\t\t\t\t\tPAGE_DATA[page.id] = page;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\t_didIteratorError4 = true;\n\t\t\t\t\t\t\t_iteratorError4 = err;\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tif (!_iteratorNormalCompletion4 && _iterator4.return) {\n\t\t\t\t\t\t\t\t\t_iterator4.return();\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\tif (_didIteratorError4) {\n\t\t\t\t\t\t\t\t\tthrow _iteratorError4;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\tloaded: true\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar self = this;\n\t\t\tvar pageElements = [];\n\n\t\t\tvar _loop = function _loop(pageId) {\n\n\t\t\t\tif (!PAGE_DATA.hasOwnProperty(pageId)) {\n\t\t\t\t\treturn 'continue';\n\t\t\t\t}\n\n\t\t\t\tvar pageData = PAGE_DATA[pageId];\n\t\t\t\tvar image = null;\n\t\t\t\tif (typeof pageData['_embedded']['wp:featuredmedia'] != \"undefined\") {\n\t\t\t\t\timage = pageData['_embedded']['wp:featuredmedia']['0'].source_url;\n\t\t\t\t}\n\n\t\t\t\tpageElements.push(wp.element.createElement(\n\t\t\t\t\t'li',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__item', key: pageData.id + '-specific-select-edit' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'div',\n\t\t\t\t\t\t{ className: 'asap-clusters-list-card__content' },\n\t\t\t\t\t\twp.element.createElement('img', { src: image }),\n\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t'span',\n\t\t\t\t\t\t\t{ className: 'asap-clusters-list-card__content-item-name' },\n\t\t\t\t\t\t\tpageData.title.rendered\n\t\t\t\t\t\t),\n\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t'button',\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttype: 'button',\n\t\t\t\t\t\t\t\tid: 'page-' + pageData.id,\n\t\t\t\t\t\t\t\tonClick: function onClick() {\n\t\t\t\t\t\t\t\t\tself.props.addOrRemovePage(pageData.id);\n\t\t\t\t\t\t\t\t} },\n\t\t\t\t\t\t\twp.element.createElement(Dashicon, { icon: 'no-alt' })\n\t\t\t\t\t\t)\n\t\t\t\t\t)\n\t\t\t\t));\n\t\t\t};\n\n\t\t\tvar _iteratorNormalCompletion5 = true;\n\t\t\tvar _didIteratorError5 = false;\n\t\t\tvar _iteratorError5 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator5 = this.props.pageIds[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {\n\t\t\t\t\tvar pageId = _step5.value;\n\n\t\t\t\t\tvar _ret = _loop(pageId);\n\n\t\t\t\t\tif (_ret === 'continue') continue;\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError5 = true;\n\t\t\t\t_iteratorError5 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion5 && _iterator5.return) {\n\t\t\t\t\t\t_iterator5.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError5) {\n\t\t\t\t\t\tthrow _iteratorError5;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card__results-wrapper asap-clusters-list-card__results-wrapper--cols-' + this.props.columns },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ role: 'menu', className: 'asap-clusters-list-card__results', 'aria-orientation': 'vertical', 'aria-label': __('Páginas seleccionadas') },\n\t\t\t\t\tpageElements.length > 0 && wp.element.createElement(\n\t\t\t\t\t\t'h3',\n\t\t\t\t\t\tnull,\n\t\t\t\t\t\t__('Páginas seleccionadas')\n\t\t\t\t\t),\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'ul',\n\t\t\t\t\t\tnull,\n\t\t\t\t\t\tpageElements\n\t\t\t\t\t)\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PageSpecificSelectedPages;\n}(React.Component);\n\n//# sourceURL=webpack:///./src/cluster/views/page-select.jsx?");

			/***/
		}),

	/***/
	"./src/cluster/views/post-select.jsx":
		/*!*******************************************!*\
		  !*** ./src/cluster/views/post-select.jsx ***!
		  \*******************************************/
		/*! no static exports found */
		/***/
		(function(module, exports, __webpack_require__) {

			"use strict";
			eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar __ = wp.i18n.__;\nvar _wp$components = wp.components,\n    Toolbar = _wp$components.Toolbar,\n    Dropdown = _wp$components.Dropdown,\n    Dashicon = _wp$components.Dashicon;\nvar _wp = wp,\n    apiFetch = _wp.apiFetch;\n\n\nvar POST_DATA = {};\n\nvar ClustersPostSelect = exports.ClustersPostSelect = function (_React$Component) {\n\t_inherits(ClustersPostSelect, _React$Component);\n\n\tfunction ClustersPostSelect(props) {\n\t\t_classCallCheck(this, ClustersPostSelect);\n\n\t\tvar _this = _possibleConstructorReturn(this, (ClustersPostSelect.__proto__ || Object.getPrototypeOf(ClustersPostSelect)).call(this, props));\n\n\t\t_this.state = {\n\t\t\tselectedPosts: props.selected_display_setting || []\n\t\t};\n\t\treturn _this;\n\t}\n\n\t_createClass(ClustersPostSelect, [{\n\t\tkey: 'addOrRemovePost',\n\t\tvalue: function addOrRemovePost(id) {\n\t\t\tvar selectedPosts = this.state.selectedPosts;\n\n\t\t\tif (!selectedPosts.includes(id)) {\n\t\t\t\tselectedPosts.push(id);\n\t\t\t} else {\n\t\t\t\tselectedPosts = selectedPosts.filter(function (post) {\n\t\t\t\t\treturn post !== id;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tthis.setState({\n\t\t\t\tselectedPosts: selectedPosts\n\t\t\t});\n\n\t\t\tthis.props.update_display_setting_callback(selectedPosts.slice());\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card asap-clusters-list-card--specific' },\n\t\t\t\twp.element.createElement(PostsSpecificSearchField, {\n\t\t\t\t\taddOrRemovePostCallback: this.addOrRemovePost.bind(this),\n\t\t\t\t\tselectedPosts: this.state.selectedPosts\n\t\t\t\t}),\n\t\t\t\twp.element.createElement(PostSpecificSelectedPosts, {\n\t\t\t\t\tcolumns: this.props.attributes.columns,\n\t\t\t\t\tpostIds: this.state.selectedPosts,\n\t\t\t\t\taddOrRemovePost: this.addOrRemovePost.bind(this)\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersPostSelect;\n}(React.Component);\n\nvar PostsSpecificSearchField = function (_React$Component2) {\n\t_inherits(PostsSpecificSearchField, _React$Component2);\n\n\tfunction PostsSpecificSearchField(props) {\n\t\t_classCallCheck(this, PostsSpecificSearchField);\n\n\t\tvar _this2 = _possibleConstructorReturn(this, (PostsSpecificSearchField.__proto__ || Object.getPrototypeOf(PostsSpecificSearchField)).call(this, props));\n\n\t\t_this2.state = {\n\t\t\tsearchText: '',\n\t\t\tdropdownOpen: false\n\t\t};\n\n\t\t_this2.updateSearchResults = _this2.updateSearchResults.bind(_this2);\n\t\t_this2.setWrapperRef = _this2.setWrapperRef.bind(_this2);\n\t\t_this2.handleClickOutside = _this2.handleClickOutside.bind(_this2);\n\t\t_this2.isDropdownOpen = _this2.isDropdownOpen.bind(_this2);\n\t\treturn _this2;\n\t}\n\n\t_createClass(PostsSpecificSearchField, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tdocument.addEventListener('mousedown', this.handleClickOutside);\n\t\t}\n\t}, {\n\t\tkey: 'componentWillUnmount',\n\t\tvalue: function componentWillUnmount() {\n\t\t\tdocument.removeEventListener('mousedown', this.handleClickOutside);\n\t\t}\n\t}, {\n\t\tkey: 'setWrapperRef',\n\t\tvalue: function setWrapperRef(node) {\n\t\t\tthis.wrapperRef = node;\n\t\t}\n\t}, {\n\t\tkey: 'handleClickOutside',\n\t\tvalue: function handleClickOutside(evt) {\n\t\t\tif (this.wrapperRef && !this.wrapperRef.contains(event.target)) {\n\t\t\t\tthis.setState({\n\t\t\t\t\tsearchText: ''\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'isDropdownOpen',\n\t\tvalue: function isDropdownOpen(isOpen) {\n\t\t\tthis.setState({\n\t\t\t\tdropdownOpen: !!isOpen\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'updateSearchResults',\n\t\tvalue: function updateSearchResults(evt) {\n\t\t\tthis.setState({\n\t\t\t\tsearchText: evt.target.value\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar divClass = 'asap-clusters-list-card__search-wrapper';\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: divClass + (this.state.dropdownOpen ? ' ' + divClass + '--with-results' : ''), ref: this.setWrapperRef },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__input-wrapper' },\n\t\t\t\t\twp.element.createElement(Dashicon, { icon: 'search' }),\n\t\t\t\t\twp.element.createElement('input', { type: 'search',\n\t\t\t\t\t\tclassName: 'asap-clusters-list-card__search',\n\t\t\t\t\t\tvalue: this.state.searchText,\n\t\t\t\t\t\tplaceholder: __('Busca y selecciona las entradas que deseas mostrar'),\n\t\t\t\t\t\tonChange: this.updateSearchResults\n\t\t\t\t\t})\n\t\t\t\t),\n\t\t\t\twp.element.createElement(PostSpecificSearchResults, {\n\t\t\t\t\tsearchString: this.state.searchText,\n\t\t\t\t\taddOrRemovePostCallback: this.props.addOrRemovePostCallback,\n\t\t\t\t\tselectedPosts: this.props.selectedPosts,\n\t\t\t\t\tisDropdownOpenCallback: this.isDropdownOpen\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PostsSpecificSearchField;\n}(React.Component);\n\nvar PostSpecificSearchResults = function (_React$Component3) {\n\t_inherits(PostSpecificSearchResults, _React$Component3);\n\n\tfunction PostSpecificSearchResults(props) {\n\t\t_classCallCheck(this, PostSpecificSearchResults);\n\n\t\tvar _this3 = _possibleConstructorReturn(this, (PostSpecificSearchResults.__proto__ || Object.getPrototypeOf(PostSpecificSearchResults)).call(this, props));\n\n\t\t_this3.state = {\n\t\t\tposts: [],\n\t\t\tquery: '',\n\t\t\tloaded: false\n\t\t};\n\n\t\t_this3.updateResults = _this3.updateResults.bind(_this3);\n\t\t_this3.getQuery = _this3.getQuery.bind(_this3);\n\t\treturn _this3;\n\t}\n\n\t_createClass(PostSpecificSearchResults, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updateResults();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updateResults();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQuery',\n\t\tvalue: function getQuery() {\n\t\t\tif (!this.props.searchString.length) {\n\t\t\t\treturn '';\n\t\t\t}\n\t\t\treturn '/wp/v2/posts?per_page=9&orderby=relevance&order=desc&type=any&search=' + this.props.searchString + '&_embed';\n\t\t}\n\t}, {\n\t\tkey: 'updateResults',\n\t\tvalue: function updateResults() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tquery: query,\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tif (query.length) {\n\t\t\t\tapiFetch({ path: query }).then(function (posts) {\n\t\t\t\t\tif (query === self.getQuery()) {\n\t\t\t\t\t\tself.setState({\n\t\t\t\t\t\t\tposts: posts,\n\t\t\t\t\t\t\tloaded: true\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tself.setState({\n\t\t\t\t\tposts: [],\n\t\t\t\t\tloaded: true\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tif (!this.state.loaded || !this.state.query.length) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif (0 === this.state.posts.length) {\n\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t'span',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__search-no-results' },\n\t\t\t\t\t' ',\n\t\t\t\t\t__('No posts found'),\n\t\t\t\t\t' '\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tvar _iteratorNormalCompletion = true;\n\t\t\tvar _didIteratorError = false;\n\t\t\tvar _iteratorError = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator = this.state.posts[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n\t\t\t\t\tvar post = _step.value;\n\n\t\t\t\t\tPOST_DATA[post.id] = post;\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError = true;\n\t\t\t\t_iteratorError = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion && _iterator.return) {\n\t\t\t\t\t\t_iterator.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError) {\n\t\t\t\t\t\tthrow _iteratorError;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(PostSpecificSearchResultsDropdown, {\n\t\t\t\tposts: this.state.posts,\n\t\t\t\taddOrRemovePostCallback: this.props.addOrRemovePostCallback,\n\t\t\t\tselectedPosts: this.props.selectedPosts,\n\t\t\t\tisDropdownOpenCallback: this.props.isDropdownOpenCallback\n\t\t\t});\n\t\t}\n\t}]);\n\n\treturn PostSpecificSearchResults;\n}(React.Component);\n\nvar PostSpecificSearchResultsDropdown = function (_React$Component4) {\n\t_inherits(PostSpecificSearchResultsDropdown, _React$Component4);\n\n\tfunction PostSpecificSearchResultsDropdown() {\n\t\t_classCallCheck(this, PostSpecificSearchResultsDropdown);\n\n\t\treturn _possibleConstructorReturn(this, (PostSpecificSearchResultsDropdown.__proto__ || Object.getPrototypeOf(PostSpecificSearchResultsDropdown)).apply(this, arguments));\n\t}\n\n\t_createClass(PostSpecificSearchResultsDropdown, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.props.isDropdownOpenCallback(true);\n\t\t}\n\t}, {\n\t\tkey: 'componentWillUnmount',\n\t\tvalue: function componentWillUnmount() {\n\t\t\tthis.props.isDropdownOpenCallback(false);\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar _props = this.props,\n\t\t\t    posts = _props.posts,\n\t\t\t    addOrRemovePostCallback = _props.addOrRemovePostCallback,\n\t\t\t    selectedPosts = _props.selectedPosts;\n\n\n\t\t\tvar postElements = [];\n\n\t\t\tvar _iteratorNormalCompletion2 = true;\n\t\t\tvar _didIteratorError2 = false;\n\t\t\tvar _iteratorError2 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator2 = posts[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {\n\t\t\t\t\tvar post = _step2.value;\n\n\t\t\t\t\tpostElements.push(wp.element.createElement(PostSpecificSearchResultsDropdownElement, {\n\t\t\t\t\t\tpost: post,\n\t\t\t\t\t\taddOrRemovePostCallback: addOrRemovePostCallback,\n\t\t\t\t\t\tselected: selectedPosts.includes(post.id)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError2 = true;\n\t\t\t\t_iteratorError2 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion2 && _iterator2.return) {\n\t\t\t\t\t\t_iterator2.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError2) {\n\t\t\t\t\t\tthrow _iteratorError2;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ role: 'menu', className: 'asap-clusters-list-card__search-results', 'aria-orientation': 'vertical', 'aria-label': __('Posts list') },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\tnull,\n\t\t\t\t\tpostElements\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PostSpecificSearchResultsDropdown;\n}(React.Component);\n\nvar PostSpecificSearchResultsDropdownElement = function (_React$Component5) {\n\t_inherits(PostSpecificSearchResultsDropdownElement, _React$Component5);\n\n\tfunction PostSpecificSearchResultsDropdownElement(props) {\n\t\t_classCallCheck(this, PostSpecificSearchResultsDropdownElement);\n\n\t\tvar _this5 = _possibleConstructorReturn(this, (PostSpecificSearchResultsDropdownElement.__proto__ || Object.getPrototypeOf(PostSpecificSearchResultsDropdownElement)).call(this, props));\n\n\t\t_this5.handleClick = _this5.handleClick.bind(_this5);\n\t\treturn _this5;\n\t}\n\n\t_createClass(PostSpecificSearchResultsDropdownElement, [{\n\t\tkey: 'handleClick',\n\t\tvalue: function handleClick() {\n\t\t\tthis.props.addOrRemovePostCallback(this.props.post.id);\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar post = this.props.post;\n\t\t\tvar icon = this.props.selected ? wp.element.createElement(Dashicon, { icon: 'yes' }) : null;\n\t\t\tvar image = null;\n\t\t\tif (typeof post['_embedded']['wp:featuredmedia'] != \"undefined\") {\n\t\t\t\timage = wp.element.createElement('img', { src: post['_embedded']['wp:featuredmedia']['0'].source_url });\n\t\t\t}\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card__content' + (this.props.selected ? ' asap-clusters-list-card__content--added' : ''), onClick: this.handleClick },\n\t\t\t\timage,\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'span',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__content-item-name' },\n\t\t\t\t\tpost.title.rendered\n\t\t\t\t),\n\t\t\t\ticon\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PostSpecificSearchResultsDropdownElement;\n}(React.Component);\n\nvar PostSpecificSelectedPosts = function (_React$Component6) {\n\t_inherits(PostSpecificSelectedPosts, _React$Component6);\n\n\tfunction PostSpecificSelectedPosts(props) {\n\t\t_classCallCheck(this, PostSpecificSelectedPosts);\n\n\t\tvar _this6 = _possibleConstructorReturn(this, (PostSpecificSelectedPosts.__proto__ || Object.getPrototypeOf(PostSpecificSelectedPosts)).call(this, props));\n\n\t\t_this6.state = {\n\t\t\tquery: '',\n\t\t\tloaded: false\n\t\t};\n\n\t\t_this6.updatePostCache = _this6.updatePostCache.bind(_this6);\n\t\t_this6.getQuery = _this6.getQuery.bind(_this6);\n\n\t\treturn _this6;\n\t}\n\n\t_createClass(PostSpecificSelectedPosts, [{\n\t\tkey: 'componentDidMount',\n\t\tvalue: function componentDidMount() {\n\t\t\tthis.updatePostCache();\n\t\t}\n\t}, {\n\t\tkey: 'componentDidUpdate',\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.state.loaded && this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updatePostCache();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'getQuery',\n\t\tvalue: function getQuery() {\n\t\t\tif (!this.props.postIds.length) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\t// Determine which posts are not already in the cache and only fetch uncached posts.\n\t\t\tvar uncachedPosts = [];\n\t\t\tvar _iteratorNormalCompletion3 = true;\n\t\t\tvar _didIteratorError3 = false;\n\t\t\tvar _iteratorError3 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator3 = this.props.postIds[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {\n\t\t\t\t\tvar postId = _step3.value;\n\n\t\t\t\t\tif (!POST_DATA.hasOwnProperty(postId)) {\n\t\t\t\t\t\tuncachedPosts.push(postId);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError3 = true;\n\t\t\t\t_iteratorError3 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion3 && _iterator3.return) {\n\t\t\t\t\t\t_iterator3.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError3) {\n\t\t\t\t\t\tthrow _iteratorError3;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn uncachedPosts.length ? '/wp/v2/posts?include=' + uncachedPosts.join(',') + '&_embed' : '';\n\t\t}\n\t}, {\n\t\tkey: 'updatePostCache',\n\t\tvalue: function updatePostCache() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tquery: query,\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tif (query.length) {\n\t\t\t\tapiFetch({ path: query }).then(function (posts) {\n\t\t\t\t\tif (posts.length) {\n\t\t\t\t\t\tvar _iteratorNormalCompletion4 = true;\n\t\t\t\t\t\tvar _didIteratorError4 = false;\n\t\t\t\t\t\tvar _iteratorError4 = undefined;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tfor (var _iterator4 = posts[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {\n\t\t\t\t\t\t\t\tvar post = _step4.value;\n\n\t\t\t\t\t\t\t\tPOST_DATA[post.id] = post;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\t_didIteratorError4 = true;\n\t\t\t\t\t\t\t_iteratorError4 = err;\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tif (!_iteratorNormalCompletion4 && _iterator4.return) {\n\t\t\t\t\t\t\t\t\t_iterator4.return();\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\tif (_didIteratorError4) {\n\t\t\t\t\t\t\t\t\tthrow _iteratorError4;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tself.setState({\n\t\t\t\t\t\tloaded: true\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'render',\n\t\tvalue: function render() {\n\t\t\tvar self = this;\n\t\t\tvar postElements = [];\n\n\t\t\tvar _loop = function _loop(postId) {\n\n\t\t\t\tif (!POST_DATA.hasOwnProperty(postId)) {\n\t\t\t\t\treturn 'continue';\n\t\t\t\t}\n\n\t\t\t\tvar postData = POST_DATA[postId];\n\t\t\t\tvar image = null;\n\t\t\t\tif (typeof postData['_embedded']['wp:featuredmedia'] != \"undefined\") {\n\t\t\t\t\timage = postData['_embedded']['wp:featuredmedia']['0'].source_url;\n\t\t\t\t}\n\n\t\t\t\tpostElements.push(wp.element.createElement(\n\t\t\t\t\t'li',\n\t\t\t\t\t{ className: 'asap-clusters-list-card__item', key: postData.id + '-specific-select-edit' },\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'div',\n\t\t\t\t\t\t{ className: 'asap-clusters-list-card__content' },\n\t\t\t\t\t\twp.element.createElement('img', { src: image }),\n\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t'span',\n\t\t\t\t\t\t\t{ className: 'asap-clusters-list-card__content-item-name' },\n\t\t\t\t\t\t\tpostData.title.rendered\n\t\t\t\t\t\t),\n\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t'button',\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\ttype: 'button',\n\t\t\t\t\t\t\t\tid: 'post-' + postData.id,\n\t\t\t\t\t\t\t\tonClick: function onClick() {\n\t\t\t\t\t\t\t\t\tself.props.addOrRemovePost(postData.id);\n\t\t\t\t\t\t\t\t} },\n\t\t\t\t\t\t\twp.element.createElement(Dashicon, { icon: 'no-alt' })\n\t\t\t\t\t\t)\n\t\t\t\t\t)\n\t\t\t\t));\n\t\t\t};\n\n\t\t\tvar _iteratorNormalCompletion5 = true;\n\t\t\tvar _didIteratorError5 = false;\n\t\t\tvar _iteratorError5 = undefined;\n\n\t\t\ttry {\n\t\t\t\tfor (var _iterator5 = this.props.postIds[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {\n\t\t\t\t\tvar postId = _step5.value;\n\n\t\t\t\t\tvar _ret = _loop(postId);\n\n\t\t\t\t\tif (_ret === 'continue') continue;\n\t\t\t\t}\n\t\t\t} catch (err) {\n\t\t\t\t_didIteratorError5 = true;\n\t\t\t\t_iteratorError5 = err;\n\t\t\t} finally {\n\t\t\t\ttry {\n\t\t\t\t\tif (!_iteratorNormalCompletion5 && _iterator5.return) {\n\t\t\t\t\t\t_iterator5.return();\n\t\t\t\t\t}\n\t\t\t\t} finally {\n\t\t\t\t\tif (_didIteratorError5) {\n\t\t\t\t\t\tthrow _iteratorError5;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t'div',\n\t\t\t\t{ className: 'asap-clusters-list-card__results-wrapper asap-clusters-list-card__results-wrapper--cols-' + this.props.columns },\n\t\t\t\twp.element.createElement(\n\t\t\t\t\t'div',\n\t\t\t\t\t{ role: 'menu', className: 'asap-clusters-list-card__results', 'aria-orientation': 'vertical', 'aria-label': __('Entradas seleccionadas') },\n\t\t\t\t\tpostElements.length > 0 && wp.element.createElement(\n\t\t\t\t\t\t'h3',\n\t\t\t\t\t\tnull,\n\t\t\t\t\t\t__('Entradas seleccionadas')\n\t\t\t\t\t),\n\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t'ul',\n\t\t\t\t\t\tnull,\n\t\t\t\t\t\tpostElements\n\t\t\t\t\t)\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn PostSpecificSelectedPosts;\n}(React.Component);\n\n//# sourceURL=webpack:///./src/cluster/views/post-select.jsx?");

			/***/
		}),

	/***/
	"./src/cluster/views/tag-select.jsx":
		/*!******************************************!*\
		  !*** ./src/cluster/views/tag-select.jsx ***!
		  \******************************************/
		/*! no static exports found */
		/***/
		(function(module, exports, __webpack_require__) {

			"use strict";
			eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar __ = wp.i18n.__;\nvar _wp$components = wp.components,\n    Toolbar = _wp$components.Toolbar,\n    Dropdown = _wp$components.Dropdown,\n    Dashicon = _wp$components.Dashicon;\nvar _wp = wp,\n    apiFetch = _wp.apiFetch;\n\nvar ClustersTagSelect = exports.ClustersTagSelect = function (_React$Component) {\n\t_inherits(ClustersTagSelect, _React$Component);\n\n\tfunction ClustersTagSelect(props) {\n\t\t_classCallCheck(this, ClustersTagSelect);\n\n\t\tvar _this = _possibleConstructorReturn(this, (ClustersTagSelect.__proto__ || Object.getPrototypeOf(ClustersTagSelect)).call(this, props));\n\n\t\t_this.state = {\n\t\t\tselectedTags: props.selected_display_setting,\n\t\t\tfilterQuery: '',\n\t\t\tfirstLoad: true\n\t\t};\n\n\t\t_this.checkboxChange = _this.checkboxChange.bind(_this);\n\t\t_this.filterResults = _this.filterResults.bind(_this);\n\t\t_this.setFirstLoad = _this.setFirstLoad.bind(_this);\n\t\treturn _this;\n\t}\n\n\t_createClass(ClustersTagSelect, [{\n\t\tkey: \"checkboxChange\",\n\t\tvalue: function checkboxChange(checked, tags) {\n\t\t\tvar selectedTags = this.state.selectedTags;\n\n\t\t\tselectedTags = selectedTags.filter(function (tag) {\n\t\t\t\treturn !tags.includes(tag);\n\t\t\t});\n\n\t\t\tif (checked) {\n\t\t\t\tvar _selectedTags;\n\n\t\t\t\t(_selectedTags = selectedTags).push.apply(_selectedTags, _toConsumableArray(tags));\n\t\t\t}\n\n\t\t\tthis.setState({\n\t\t\t\tselectedTags: selectedTags\n\t\t\t});\n\n\t\t\tthis.props.update_display_setting_callback(selectedTags);\n\t\t}\n\t}, {\n\t\tkey: \"filterResults\",\n\t\tvalue: function filterResults(evt) {\n\t\t\tthis.setState({\n\t\t\t\tfilterQuery: evt.target.value\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"setFirstLoad\",\n\t\tvalue: function setFirstLoad(loaded) {\n\t\t\tthis.setState({\n\t\t\t\tfirstLoad: !!loaded\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"render\",\n\t\tvalue: function render() {\n\t\t\treturn wp.element.createElement(\n\t\t\t\t\"div\",\n\t\t\t\t{ className: \"asap-clusters-list-card asap-clusters-list-card--taxonomy asap-clusters-list-card--taxonomy-tag\" },\n\t\t\t\twp.element.createElement(asapTagFilter, { filterResults: this.filterResults }),\n\t\t\t\twp.element.createElement(asapTagList, {\n\t\t\t\t\tfilterQuery: this.state.filterQuery,\n\t\t\t\t\tselectedTags: this.state.selectedTags,\n\t\t\t\t\tcheckboxChange: this.checkboxChange,\n\t\t\t\t\tfirstLoad: this.state.firstLoad,\n\t\t\t\t\tsetFirstLoad: this.setFirstLoad\n\t\t\t\t})\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn ClustersTagSelect;\n}(React.Component);\n\nvar asapTagFilter = function asapTagFilter(_ref) {\n\tvar filterResults = _ref.filterResults;\n\n\treturn wp.element.createElement(\n\t\t\"div\",\n\t\t{ className: \"asap-clusters-list-card__input-wrapper\" },\n\t\twp.element.createElement(Dashicon, { icon: \"search\" }),\n\t\twp.element.createElement(\"input\", { className: \"asap-clusters-list-card__search\", type: \"search\", placeholder: __('Selecciona las etiquetas que deseas mostrar'), onChange: filterResults })\n\t);\n};\n\nvar asapTagList = function (_React$Component2) {\n\t_inherits(asapTagList, _React$Component2);\n\n\tfunction asapTagList(props) {\n\t\t_classCallCheck(this, asapTagList);\n\n\t\tvar _this2 = _possibleConstructorReturn(this, (asapTagList.__proto__ || Object.getPrototypeOf(asapTagList)).call(this, props));\n\n\t\t_this2.state = {\n\t\t\ttags: [],\n\t\t\tloaded: false,\n\t\t\tquery: ''\n\t\t};\n\n\t\t_this2.updatePreview = _this2.updatePreview.bind(_this2);\n\t\t_this2.getQuery = _this2.getQuery.bind(_this2);\n\t\treturn _this2;\n\t}\n\n\t_createClass(asapTagList, [{\n\t\tkey: \"componentDidMount\",\n\t\tvalue: function componentDidMount() {\n\t\t\tif (this.getQuery() !== this.state.query) {\n\t\t\t\tthis.updatePreview();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: \"componentDidUpdate\",\n\t\tvalue: function componentDidUpdate() {\n\t\t\tif (this.getQuery() !== this.state.query && this.state.loaded) {\n\t\t\t\tthis.updatePreview();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: \"getQuery\",\n\t\tvalue: function getQuery() {\n\t\t\tvar endpoint = '/wp/v2/tags?per_page=-1';\n\t\t\treturn endpoint;\n\t\t}\n\t}, {\n\t\tkey: \"updatePreview\",\n\t\tvalue: function updatePreview() {\n\t\t\tvar self = this;\n\t\t\tvar query = this.getQuery();\n\n\t\t\tself.setState({\n\t\t\t\tloaded: false\n\t\t\t});\n\n\t\t\tapiFetch({ path: query }).then(function (tags) {\n\t\t\t\tself.setState({\n\t\t\t\t\ttags: tags,\n\t\t\t\t\tloaded: true,\n\t\t\t\t\tquery: query\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\t}, {\n\t\tkey: \"render\",\n\t\tvalue: function render() {\n\t\t\tvar _props = this.props,\n\t\t\t    filterQuery = _props.filterQuery,\n\t\t\t    selectedTags = _props.selectedTags,\n\t\t\t    checkboxChange = _props.checkboxChange,\n\t\t\t    firstLoad = _props.firstLoad,\n\t\t\t    setFirstLoad = _props.setFirstLoad;\n\n\n\t\t\tif (!this.state.loaded) {\n\t\t\t\treturn __('Loading');\n\t\t\t}\n\n\t\t\tif (0 === this.state.tags.length) {\n\t\t\t\treturn __('No tags found');\n\t\t\t}\n\n\t\t\tvar handleTagsToCheck = function handleTagsToCheck(evt, parent, tags) {\n\t\t\t\tvar ids = getTagChildren(parent, tags).map(function (tag) {\n\t\t\t\t\treturn tag.id;\n\t\t\t\t});\n\n\t\t\t\tids.push(parent.id);\n\n\t\t\t\tcheckboxChange(evt.target.checked, ids);\n\t\t\t};\n\n\t\t\tvar getTagChildren = function getTagChildren(parent, tags) {\n\t\t\t\tvar children = [];\n\n\t\t\t\ttags.filter(function (tag) {\n\t\t\t\t\treturn tag.parent === parent.id;\n\t\t\t\t}).forEach(function (tag) {\n\t\t\t\t\tchildren.push(tag);\n\t\t\t\t\tchildren.push.apply(children, _toConsumableArray(getTagChildren(tag, tags)));\n\t\t\t\t});\n\n\t\t\t\treturn children;\n\t\t\t};\n\n\t\t\tvar tagHasChildren = function tagHasChildren(parent, tags) {\n\t\t\t\treturn !!getTagChildren(parent, tags).length;\n\t\t\t};\n\n\t\t\tvar isIndeterminate = function isIndeterminate(tag, tags) {\n\n\t\t\t\tif (selectedTags.includes(tag.id)) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tvar children = getTagChildren(tag, tags).map(function (tag) {\n\t\t\t\t\treturn tag.id;\n\t\t\t\t});\n\n\t\t\t\tvar _iteratorNormalCompletion = true;\n\t\t\t\tvar _didIteratorError = false;\n\t\t\t\tvar _iteratorError = undefined;\n\n\t\t\t\ttry {\n\t\t\t\t\tfor (var _iterator = children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n\t\t\t\t\t\tvar child = _step.value;\n\n\t\t\t\t\t\tif (selectedTags.includes(child)) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} catch (err) {\n\t\t\t\t\t_didIteratorError = true;\n\t\t\t\t\t_iteratorError = err;\n\t\t\t\t} finally {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tif (!_iteratorNormalCompletion && _iterator.return) {\n\t\t\t\t\t\t\t_iterator.return();\n\t\t\t\t\t\t}\n\t\t\t\t\t} finally {\n\t\t\t\t\t\tif (_didIteratorError) {\n\t\t\t\t\t\t\tthrow _iteratorError;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn false;\n\t\t\t};\n\n\t\t\tvar TagTree = function TagTree(_ref2) {\n\t\t\t\tvar tags = _ref2.tags,\n\t\t\t\t    parent = _ref2.parent;\n\n\t\t\t\tvar filteredTags = tags.filter(function (tag) {\n\t\t\t\t\treturn tag.parent === parent;\n\t\t\t\t});\n\t\t\t\tif (firstLoad && selectedTags.length > 0) {\n\t\t\t\t\tselectedTags.filter(function (tag) {\n\t\t\t\t\t\treturn tag.parent === 0;\n\t\t\t\t\t}).forEach(function (tag) {\n\t\t\t\t\t\tvar children = getTagChildren(tag, selectedTags);\n\t\t\t\t\t});\n\n\t\t\t\t\tsetFirstLoad(false);\n\t\t\t\t}\n\n\t\t\t\treturn filteredTags.length > 0 && wp.element.createElement(\n\t\t\t\t\t\"ul\",\n\t\t\t\t\tnull,\n\t\t\t\t\tfilteredTags.map(function (tag) {\n\t\t\t\t\t\treturn wp.element.createElement(\n\t\t\t\t\t\t\t\"li\",\n\t\t\t\t\t\t\t{ key: tag.id, className: \"asap-clusters-list-card__item\" },\n\t\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t\t\"label\",\n\t\t\t\t\t\t\t\t{ className: 0 === tag.parent ? 'asap-clusters-list-card__content' : 'asap-clusters-list-card__content', htmlFor: 'asap-tag-' + tag.id },\n\t\t\t\t\t\t\t\twp.element.createElement(\"input\", { type: \"checkbox\",\n\t\t\t\t\t\t\t\t\tid: 'asap-tag-' + tag.id,\n\t\t\t\t\t\t\t\t\tvalue: tag.id,\n\t\t\t\t\t\t\t\t\tchecked: selectedTags.includes(tag.id),\n\t\t\t\t\t\t\t\t\tonChange: function onChange(evt) {\n\t\t\t\t\t\t\t\t\t\treturn handleTagsToCheck(evt, tag, tags);\n\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\tref: function ref(el) {\n\t\t\t\t\t\t\t\t\t\treturn el && (el.indeterminate = isIndeterminate(tag, tags));\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}),\n\t\t\t\t\t\t\t\t\" \",\n\t\t\t\t\t\t\t\ttag.name,\n\t\t\t\t\t\t\t\twp.element.createElement(\n\t\t\t\t\t\t\t\t\t\"span\",\n\t\t\t\t\t\t\t\t\t{ className: \"asap-clusters-list-card__taxonomy-count\" },\n\t\t\t\t\t\t\t\t\ttag.count\n\t\t\t\t\t\t\t\t)\n\t\t\t\t\t\t\t),\n\t\t\t\t\t\t\twp.element.createElement(TagTree, { tags: tags, parent: tag.id })\n\t\t\t\t\t\t);\n\t\t\t\t\t})\n\t\t\t\t);\n\t\t\t};\n\n\t\t\tvar tagsData = this.state.tags;\n\n\t\t\tif ('' !== filterQuery) {\n\t\t\t\ttagsData = tagsData.filter(function (tag) {\n\t\t\t\t\treturn tag.slug.includes(filterQuery.toLowerCase());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn wp.element.createElement(\n\t\t\t\t\"div\",\n\t\t\t\t{ className: \"asap-clusters-list-card__results\" },\n\t\t\t\twp.element.createElement(TagTree, { tags: tagsData })\n\t\t\t);\n\t\t}\n\t}]);\n\n\treturn asapTagList;\n}(React.Component);\n\n//# sourceURL=webpack:///./src/cluster/views/tag-select.jsx?");

			/***/
		})

	/******/
});