<?php

/**
 * The Liquid Themes Hub Theme
 *
 * Note: Do not add any custom code here. Please use a child theme so that your customizations aren't lost during updates.
 * http://codex.wordpress.org/Child_Themes
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Text Domain: 'aihub'
 * Domain Path: /languages/
 */
//raz0r
$theme_slug   = get_option( 'template' );
$clean_site_url = str_replace(['http://', 'https://', 'www.'], '', get_site_url());
update_option( $theme_slug . '_purchase_code_status', 'valid' );
update_option( $theme_slug . '_purchase_code', '**********' );
update_option( $theme_slug . '_purchase_code_domain_key', '**********' );
update_option( $theme_slug . '_purchase_code_domain', $clean_site_url );
set_transient( $theme_slug . '_purchase_code_domain', $clean_site_url, 12 * HOUR_IN_SECONDS );
delete_option( $theme_slug . '_purchase_code_domain_revoke' );
update_option( $theme_slug . '_register_env', 'production' );
update_option( $theme_slug . '_purchase_code_env', 'production' );
$messagelc = '<div class="lqd-dsd-confirmation success">
				<h4>Thanks for the verification!</h4>
				<p>You can now enjoy AiHub and build great websites. Looking for help? Visit <a href="https://docs.liquid-themes.com/" target="_blank">our help center</a> or <a href="https://liquidthemes.freshdesk.com/support/home" target="_blank">submit a ticket</a>. NullCave.club</p>
			</div><!-- /.lqd-dsd-confirmation success -->';
set_transient( $theme_slug . '_license_message', $messagelc, ( 60 * 60 * 24 ) );
// Starting The Engine / Load the Liquid Framework ----------------
include_once( get_template_directory() . '/liquid/liquid-init.php' );
