/*
Author	:	AA-Team - http://themeforest.net/user/AA-Team
*/

if ( typeof WooZoneDirectImport == "undefined" || !WooZoneDirectImport ) { WooZoneDirectImport = { '_init' : [] }; }

// Initialization and events code for the app
WooZoneDirectImport.background = (function ($) {
	"use strict";

	var MODULE					= 'WooZoneDirectImport.background';
	var DISABLED				= false; // disable this module!
	var DEBUG					= false;

	// public
	var debug_level				= 0,
		maincontainer			= null,
		loader					= null;

	var u						= WooZoneDirectImport.utils,
		misc					= u.misc,
		cmisc					= u.cmisc;
	var whatstorage				= 'chrome'; // localStorage || chrome


	// init function, autoload
	(function init() {

		// module is already initialized?
		if ( $.inArray( 'background', WooZoneDirectImport._init ) > -1 ) {
			console.log( MODULE, 'WooZone ASIN Grabber background script already inited!' );
			return false;
		}
		WooZoneDirectImport._init.push( 'background' );

		// module is disabled?
		if ( DISABLED ) {
			console.log( MODULE, 'WooZone ASIN Grabber background script is DISABLED!' );
			return false;
		}
		if (DEBUG) console.log( MODULE, 'WooZone ASIN Grabber background script is loaded!' );

		// load the triggers
		$(document).ready(function(){
			maincontainer = null;
			//loader = null;

			triggers();
		});
		
		chrome_init();
	})();
	
	
	// :: CHROME TABS
	var tabs = (function tabs() {
		
		var items = []; // array of window tabs stats

		function set_status( tabId, property, status ) {
			var status = status || 0;

			if ( ! items[ tabId ] ) {
				items[ tabId ] = {};
			}
			items[ tabId ][ property ] = status;
		};
		
		function is_done( tabId, property ) {
			if ( ! items[ tabId ] ) {
				return false;
			}
			if ( ! misc.hasOwnProperty( items[ tabId ], property ) ) {
				return false;
			}
			return items[ tabId ][ property ] ? true : false;
		};
		
		return {
			items			: items, 
			set_status		: set_status,
			is_done			: is_done
		};
	})();


	// :: INIT & TRIGGERS
	// Triggers
	function triggers() {
	};
	
	// Init Chrome
	function chrome_init() {
		verify_extension_version();
		setup_listeners();
	};

	// setup chrome listeners
	function setup_listeners() {
		// current tab is (re)loaded
		// chrome.tabs.onUpdated will also fired for iframes, so if a page contains many iframes,
		// each completed iframe will trigger the event though you have checked changeInfo.status
		chrome.tabs.onUpdated.addListener(function(tabId, changeInfo, tab) {

			if (changeInfo.status == 'loading') { // tab is loading
				set_extension_status( tab ); // set extension status (icon & popup): allowed or not?
				inject_content_assets( tab ); // inject content scripts
			}
			//console.log(changeInfo.status );
			//if (changeInfo.status == 'complete') { // tab was loaded
			if (changeInfo.status == 'complete') { // tab was loaded
				
			}
		});
		
		// check all tabs
		//chrome.tabs.getAllInWindow(null, function(tabs) {
		chrome.tabs.query({}, function(tabs) {
			if ( ! tabs.length ) return false;

			for (var i = 0; i < tabs.length; i++) {
				set_extension_status( tabs[i] ); // set extension status (icon & popup): allowed or not?

				// !!! no need to always load content scripts in all tabs
				//inject_content_assets( tabs[i] ); // inject content scripts
			};
		});
		
		// message passing between background script & content script
		chrome.runtime.onMessage.addListener(function(req, sender, sendResponse) {
			if (DEBUG) console.log( MODULE, req, sender );

			switch ( req.action ) {
				case 'get_options':
					u.settings.read_all( function( ret ) {
						if (DEBUG) console.log( MODULE, 'read all options', ret );

						sendResponse( ret );
					});
					break;

				case 'notice':
					cmisc.createNotice( req.msg.title, req.msg.text, req.status, req.pms );

					//sendResponse(true);
					break;
			}
			return true; // sendResponse called asynchronously
		});
	};

	// set extension status (allowed on tab or not?)
	function set_extension_status( tab ) {

		var tabId = tab.id;
		//if ( tabs.is_done( tabId, 'extension_status' ) ) { // already done before!
		//	//return false;
		//}
		//tabs.set_status( tabId, 'extension_status', 1 );

		cmisc.set_extension_status( tab );
	}

	// verify what extension version you have?
	function verify_extension_version() {
		//misc.storage.reset(); return false; // reset storage

		var current = cmisc.get_version();
		if (DEBUG) console.log( MODULE, 'current version (in manifest): ', current );

		function _verify( ret ) {
			var prev = ret.value;
			if (DEBUG) console.log( MODULE, 'previous version (in storage): ', prev );
			if (DEBUG) console.log( MODULE, ret );

			// new		: previous extension version NOT retrieved (probably wasn't installed till now)
			// update	: already have an extension version
			var status = '';

			if ( 'valid' == ret.status ) {
				if ( ! prev ) {
					status = 'new';
				}
				else {
					if ( current != prev ) {
						status = 'update';
					}
				}
			}
			// error
			else {
				if (DEBUG) console.log( MODULE, ret.msg );
				status = 'new';
			}
			//console.log( MODULE, ret, status );

			if ( 'new' == status ) {
				if (DEBUG) console.log( MODULE, "Extension is now installed." );

				save_default_options(); // save default options
				save_version( current ); // save version to storage
			}
			else if ( 'update' == status ) {
				if (DEBUG) console.log( MODULE, "Extension was updated to new version." );

				save_version( current ); // save version to storage
			}
			else {
				if (DEBUG) console.log( MODULE, "Extension is already at latest version." );
			}

			// debug options
			if (DEBUG) {
				misc.storage.debug();
			}
		};
		
		if ( 'localStorage' == whatstorage ) {
			(function( ret ) {
				_verify( ret );
			})( cmisc.get_option_saved('WZAGdb_version') );
		}
		else if ( 'chrome' == whatstorage ) {
			cmisc.get_option_saved('WZAGdb_version', function( ret ) {
				_verify( ret );
			});
		}
	};
	
	// save version to storage
	function save_version( ver ) {
		if ( 'localStorage' == whatstorage ) {
			cmisc.save_option( 'WZAGdb_version', ver );
			return false;
		}
		else if ( 'chrome' == whatstorage ) {
			cmisc.save_option( 'WZAGdb_version', ver, function( ret ) {
				if (DEBUG) console.log( MODULE, 'update saved version', ret );
			});
		}
	};
	
	// save default options
	function save_default_options() {
		if ( 'localStorage' == whatstorage ) {
			u.settings.save_all( u.settings.build_defaults() );
			return false;
		}
		else if ( 'chrome' == whatstorage ) {
			u.settings.save_all( u.settings.build_defaults(), function( ret ) {
				if (DEBUG) console.log( MODULE, 'saved default options', ret );
			});
		}
	};

	// inject assets (javascript & css) into page content - the other method is inside manifest.json file
	function inject_content_assets( tab, scripts_cb, css_cb ) {
		var scripts_cb	= scripts_cb || null,
			css_cb 		= css_cb || null,
			tabId		= tab.id,
			url			= tab.url; 

		//if ( tabs.is_done( tabId, 'inject_asset' ) ) { // already done before!
		//	//return false;
		//}
		//tabs.set_status( tabId, 'inject_asset', 1 );

		// verify if allowed?
		if ( ! cmisc.is_extension_allowed( url ) ) {
			if (DEBUG) console.log( MODULE, ' inject content assets NOT ALLOWED here.', url ); 
			return false;
		}

		var css = [
			//'css/font-awesome.min.css',
			'css/styles.min.css'
		];
		var scripts = [
			'js/lib/jquery-3.1.1.js',
			'js/utils.js',
			'js/content.js'
		];
		
		//chrome notice here
		//cmisc.createNotice( 'load_box_init', 'load_box_init_desc', 'info' );
	
		function _inject_asset( items, what, callback ) {

			if (DEBUG) console.log( MODULE, ' inject content assets allowed here: ', what, url, items );
			var file = items.shift();
			if (file) {
				if ( 'script' == what ) {

					chrome.tabs.executeScript(tabId, { file: file }, function(result) {
						_inject_asset(items, what, callback);
					});

				}
				else if ( 'css' == what ) {
					chrome.tabs.insertCSS(tabId, { file: file }, function() {
						_inject_asset(items, what, callback);
					});
				}
			} else {
				if ( $.isFunction( callback ) ) { 
					callback();
				}
			}
		};


		_inject_asset(scripts, 'script', function(){
			if ( $.isFunction( scripts_cb ) ) { 
				scripts_cb();
			}
		});
		_inject_asset(css, 'css', function(){
			if ( $.isFunction( css_cb ) ) { 
				css_cb();
			}
		});
	};
	
	function createNotice() {
	}

	// external usage
	return {
	};
})(jQuery);

/**
 * Possible parameters for request:
 *  action: "xhttp" for a cross-origin HTTP request
 *  method: Default "GET"
 *  url   : required, but not validated
 *  data  : data to send in a POST request
 *
 * The callback function is called upon completion of the request */
chrome.runtime.onMessage.addListener(function(request, sender, callback) {
    if (request.action == "xhttp") {
        var xhttp = new XMLHttpRequest();
        var method = request.method ? request.method.toUpperCase() : 'GET';

        xhttp.onload = function() {
            callback(xhttp.responseText);
        };
        xhttp.onerror = function() {
            // Do whatever you want on error. Don't forget to invoke the
            // callback to clean up the communication port.
            callback();
        };
        xhttp.open(method, request.url, true);
        if (method == 'POST') {
            //xhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        	xhttp.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
        }

        xhttp.send( request.data );
        return true; // prevents the callback from being called too early on return
    }
});

chrome.runtime.onMessage.addListener( function(request, sender, sendResponse) {

    if( request.action == 'get-the-url' ){
      $.ajax({
        type: 'GET',
        url: request.url,
        dataType: 'text',
      }).done(function(results) {
          sendResponse({
            'status': 'valid',
            'action': request.action,
            'doc': results
          });
      });

      return true; // tell chrome about runnning async job
    }
  }
);