/*
Author	:	AA-Team - http://themeforest.net/user/AA-Team
*/

if ( typeof WooZoneDirectImport == "undefined" || !WooZoneDirectImport ) { WooZoneDirectImport = { '_init' : [] }; }

// Initialization and events code for the app
WooZoneDirectImport.options = (function ($) {
	"use strict";

	var MODULE					= 'WooZoneDirectImport.options';
	var DISABLED				= false; // disable this module!
	var DEBUG					= false;

	// public
	var debug_level				= 0,
		maincontainer			= null,
		loader					= null;

	var u						= WooZoneDirectImport.utils,
		misc					= u.misc,
		sites					= u.sites,
		cmisc					= u.cmisc;
	var whatstorage				= 'chrome'; // localStorage || chrome


	// init function, autoload
	(function init() {
		
		// module is already initialized?
		if ( $.inArray( 'options', WooZoneDirectImport._init ) > -1 ) {
			console.log( MODULE, 'WooZone ASIN Grabber options script already inited!' );
			return false;
		}
		WooZoneDirectImport._init.push( 'options' );

		// module is disabled?
		if ( DISABLED ) {
			console.log( MODULE, 'WooZone ASIN Grabber options script is DISABLED!' );
			return false;
		}
		if (DEBUG) console.log( MODULE, 'WooZone ASIN Grabber options script is loaded!' );

		// load the triggers
		$(document).ready(function(){
			maincontainer = $("#WooZoneDirectImport-wrapper");
			//loader = maincontainer.find(".WooZoneDirectImport-loader");
			triggers();
		});
	})();


	// Triggers
	function triggers() {
		translate_interface( function() {
			load_options( function() {
				if (DEBUG) console.log( MODULE, 'interface is loaded!' );
			});
		});
		
		// checkbox toggle switch
		$('body').on('click', 'form#WooZoneDirectImport-form-options .switch input', function(e) {
			var that 		= $(this),
				name		= that.prop('name'),
				value		= that.prop('checked'),
				value_		= value ? 1 : 0;

			save_option( name, value_ ); 
		});
		
		// select
		$('body').on('change', 'form#WooZoneDirectImport-form-options select', function(e) {
			var that 		= $(this),
				name		= that.prop('name'),
				value		= that.val();
			
			save_option( name, value ); 
		});

		// authorization step
		$('body').on('click', 'form#WooZoneDirectImport-form-options .WooZoneDirectImport-authorize-now-btn', function(e) {
			e.preventDefault();
			var that 		= $(this),
				form 		= that.parents('form').eq(0),
				api_url 	= form.find('[name="WzoneImport_settingsapi_url]"]').val(),
				api_secret 	= form.find('[name="WzoneImport_settingsapi_secret]"]').val();

			// gimi: aici trebuie sa faci tu ceva validari
			console.log( api_url, api_secret );

			chrome.runtime.sendMessage({
				method: 'POST',
				action: 'xhttp',
				url: api_url + "/wp-admin/admin-ajax.php?action=WooZoneDirectImport&sub_action=check_authorization",
				data: JSON.stringify({
					'api_secret': api_secret
				}),
				//data: product,
				}, function(responseText) {

				console.log( responseText );
			});

			console.log('ceaaa' );
		});


		$('body').on('click', 'form#WooZoneDirectImport-form-options a.remove_site', function(e) {
			e.preventDefault();
			var that 		= $(this),
				url 		= that.data('url');

			if( confirm("Want to delete the " + url + " authentification?")){
				sites.remove_site(  {
					'url': url,
					'site': {}
				}, function( ret ) {
					that.parents('li').eq(0).remove();
				});
			}

		});
	};

	// save single option
	function save_option( name, value ) {
		var __ = {};
		__[name] = value;
		
		function _verify( ret ) {
			//console.log( MODULE, ret );
			if ( 'valid' == ret.status ) {
				show_status_message( true );
			}
			// error
			else {
				if (DEBUG) console.log( MODULE, ret.msg );
				show_status_message( false );
			}
		};
		
		if ( 'localStorage' == whatstorage ) {
			(function( ret ) {
				_verify( ret );
			})( u.settings.save_single( __ ) );
		}
		else if ( 'chrome' == whatstorage ) {
			u.settings.save_single( __, function( ret ) {
				_verify( ret );
			});
		}
	};

	// load options
	function load_options( callback ) {
		var callback = callback || null;

		if ( ! maincontainer.find('form#WooZoneDirectImport-form-options').length ) {
			return false;
		}

		// debug options
		if (DEBUG) {
			misc.storage.debug();
		}

		// get extension settings from storage
		function _verify( ret ) {
			var items = ret.items;
			if (DEBUG) console.log( MODULE, ret );

			if ( 'valid' == ret.status ) {
				$.each(items, function(idx, val) {
					var elem = maincontainer.find('form#WooZoneDirectImport-form-options [name="' + idx + '"]'); // name ~ WzoneImport_settingsbox_status]

					if ( elem.length ) {
						var type		= elem.length ? elem.prop('tagName').toLowerCase() : '',
							is_chk		= elem.length ? elem.is(':checkbox') : false;
	
						//console.log( MODULE, elem, type, is_chk );
						if ( is_chk ) {
							elem.prop('checked', val);
						} else if ( 'select' == type ) { 
							elem.val( val );
						}
					}
				});

				_get_sites();

				if ( $.isFunction( callback ) ) callback();
			}
			// error
			else {
				if (DEBUG) console.log( MODULE, ret.msg );
				show_status_message( false, $('#WooZoneDirectImport-options-load-error') );
			}
		};
		
		if ( 'localStorage' == whatstorage ) {
			(function( ret ) {
				_verify( ret );
			})( u.settings.read_all() );
		}
		else if ( 'chrome' == whatstorage ) {
			u.settings.read_all( function( ret ) {
				_verify( ret );
			});
		}
	};

	function _get_sites()
	{
		sites.load_sites( {}, function( ret ) {
			
			var sites_elm = maincontainer.find(".WooZoneDirectImport-sites-lists");
			
			if( !Object.keys(ret.main_obj.sites).length ){
				sites_elm.html("<li class='no-sites-yet'>No sites added yet!</li>");
			}

			$.each( ret.main_obj.sites, function( key, site ){

				var li = $("<li />");
				li.append("<a href='" + ( key ) + "' target='_blank' class='site_name'>" + ( site.site_name ) + "</a>");

				li.append('<a href="#remove" title="Remove Site from List" class="remove_site" data-url="' + ( key ) + '"><i class="fa fa-times" aria-hidden="true"></i></a>')

				sites_elm.append( li );
			});
		});
	}

	// translate html interface
	function translate_interface( callback ) {
		var callback			= callback || null;
		var ver					= cmisc.get_version();

		$('.translate').each(function(i) {
			var $this 		= $(this),
				msg			= $this.data('message');

			if ( '__version_nb' == msg ) {
				msg = ver;
			} else {
				msg = cmisc.i18n_get( msg );
			}

			msg = $.trim(msg);
			if ( '' != msg ) {
				$this.html( msg );
			}
		});

		if ( $.isFunction( callback ) ) callback();
	};

	// show save status message
	function show_status_message( status, $el ) {
		var $el = $el || null;

		maincontainer.find('#WooZoneDirectImport-status .WooZone-message').hide();

		var __ = null;
		if ( status ) {
			__ = $el || maincontainer.find('#WooZoneDirectImport-status .WooZone-message.WooZone-success');
		} else {
			__ = $el || maincontainer.find('#WooZoneDirectImport-status .WooZone-message.WooZone-error');
		}

		if (__.length) __.show('600', function() {});
	};

	// external usage
	return {
	};
})(jQuery);