/*
Author  : AA-Team - http://themeforest.net/user/AA-Team
*/

if ( typeof WooZoneDirectImport == "undefined" || !WooZoneDirectImport ) { WooZoneDirectImport = { '_init' : [] }; }

// Initialization and events code for the app
WooZoneDirectImport.utils = (function () {
  "use strict";

  var MODULE          = 'WooZoneDirectImport.utils';
  var DISABLED        = false; // disable this module!
  var DEBUG         = false;
  
  var whatstorage       = 'chrome'; // localStorage || chrome


  // init function, autoload
  (function init() {

    // module is already initialized?
    if ( $.inArray( 'utils', WooZoneDirectImport._init ) > -1 ) {
      console.log( MODULE, 'WooZone ASIN Grabber utils script already inited!' );
      return false;
    }
    WooZoneDirectImport._init.push( 'utils' );

    // module is disabled?
    if ( DISABLED ) {
      console.log( MODULE, 'WooZone ASIN Grabber utils script is DISABLED!' );
      return false;
    }
    if (DEBUG) console.log( MODULE, 'WooZone ASIN Grabber utils script is loaded!' );
  })();
  
  
  // :: localStorage
  // localStorage: Feature detect + local reference
  var storage = (function() {
    var uid = new Date;
    var storage;
    var result;
    try {
      (storage = window.localStorage).setItem(uid, uid);
      result = storage.getItem(uid) == uid;
      storage.removeItem(uid);
      return result && storage;
    } catch (exception) {}
  }());
  if (storage) {
    if ( ! Storage.prototype.setObject ) {
      Storage.prototype.setObject = function(key, value) {
        this.setItem(key, JSON.stringify(value));
      };
    }
    if ( ! Storage.prototype.getObject ) {
      Storage.prototype.getObject = function(key) {
        var value = this.getItem(key);
        return value && JSON.parse(value);
      };
    }
  }


  // :: MISC
  var misc = {

    hasOwnProperty: function(obj, prop) {
      var proto = obj.__proto__ || obj.constructor.prototype;
      return (prop in obj) &&
      (!(prop in proto) || proto[prop] !== obj[prop]);
    },

    trim: function(str) {
      return str.replace(/^(\&nbsp\;|<br\s*\/?>*)/gi, "").replace(/(\&nbsp\;|<br\s*\/?>*)$/gi, "").trim();
    },

    isJson: function(str) {
      try {
        JSON && JSON.parse(str) || $.parseJSON(str);
      } catch (e) {
        return false;
      }
      return true;
    },
    
    get_current_date: function() {
      var UTCstring = (new Date()).toUTCString();
      return UTCstring;
    },
    
    array_unique: function( arr ) {
      var new_arr = arr.reduce(function (prev, cur) {
        //console.log(prev, cur);
        if (prev.indexOf(cur) < 0) prev.push(cur);
        return prev;
      }, []);
      return new_arr;
    },

    get_country_from_url: function( url ) {
      var regex   = /https?:\/\/(?:.+\.)amazon\.([^\/]*)/i,
        __      = null,
        country   = (__ = regex.exec( url )) !== null ? __[1] : null;
      return country;
    },
    
    get_asin_from_url: function( url ) {
      var regex   = /\/(?:dp|(?:gp\/product))\/([^\/|\?]+)(?:\/|\?)?/i,
        __      = null,
        asin    = (__ = regex.exec( url )) !== null ? __[1] : null;
      return asin;
    },
    
    get_url_from_sponsored: function( url ) {
      // The magic: create a new anchor element, and set the URL as its href attribute.
      // Notice that I am accessing the DOM element inside the jQuery object with [0]:
      var a     = $( '<a>', { href: url } )[0],
        q   = a.search,
        qs    = q.split('&');

      for (var i=0; i< qs.length; i++) {
        var x = qs[i].split('=');
        if ( x.length && 'url' == x[0] ) {
          var xx = decodeURIComponent( x[1] );
          //console.log( xx ); 
          return { found: true, url: xx };
        }
      }
      return { found: false, url: url };
    },

    build_product_url: function( asin, country ) {
      var asin    = asin || null,
        country   = country || null;

      var url = '';
      if ( asin && country ) {
        url = '//www.amazon.' + country + '/gp/product/' + asin + '/';
      }
      return url;
    },

    get_time: function( msg ) {
      if (0) {
        console.time( msg );
      } else {
        var time = new Date().getTime();
        return time;
      }
    },
    get_duration: function( msg, start ) {
      if (0) {
        console.timeEnd( msg );
      } else {
        var end = new Date().getTime();
        var duration = end - start;
        console.log( msg, duration + ' ms' );
        return duration;
      }
    },

    replaceAll: function(str, find, replace) {
      var regexp  = new RegExp( misc.escapeRegExp(find), 'g' );
      var str   = str.replace(regexp, replace);
      return str;
    },
    escapeRegExp: function(str) {
      return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
    },

    hashCode: function(str) {
      var hash = 0;
      if (str.length == 0) return hash;
      for (var i = 0; i < str.length; i++) {
        var char = str.charCodeAt(i);
        hash = ((hash<<5)-hash)+char;
        hash = hash & hash; // Convert to 32bit integer
      }
      return hash;
    },

    storage: (function() {
      var alls = [ 'chrome', 'localStorage', 'cs', 'ls' ];

      function reset( what ) {
        var what = what || alls;
        if ( $.inArray('chrome', what) > -1 || $.inArray('cs', what) > -1 ) {
          cstorage.clear();
        }
        if ( $.inArray('localStorage', what) > -1 || $.inArray('ls', what) > -1 ) {
          if (storage) {
            storage.clear();
          }
        }
      };

      function debug( what ) {
        var what = what || alls;
        if ( $.inArray('chrome', what) > -1 || $.inArray('cs', what) > -1 ) {
          // view ALL that is saved in storage    
          cstorage.read(null, function( ret, items ) {
            console.log( MODULE, '--chrome-storage' );
            console.log( MODULE, ret, ret.items );
          });
        }
        if ( $.inArray('localStorage', what) > -1 || $.inArray('ls', what) > -1 ) {
          if (storage) {
            console.log( MODULE, '--localStorage' );
            //for (var i = 0; i < localStorage.length; i++){
            //  // do something with localStorage.getItem(localStorage.key(i));
            //}
            console.log( MODULE, storage );
          } else {
            console.log( MODULE, 'Error: localStorage not available.' );
          }
        }
      };

      return {
        debug : debug,
        reset   : reset
      }
    })(),

    // always convert to string

    makeitstring: function( value, what ) {
      var ret = value;
      if ( 'url' == what ) {
        value = String(value).replace('as_', '');
        ret = 'as_' + value;
      }

      ret = String( ret );
      return ret;

    },

    makeitreadable: function( value, what ) {
      var ret = value;
      if ( 'url' == what ) {
        ret = String(value).replace('as_', '');
      }
      ret = String( ret );
      return ret;
    }
  };
  
  
  // :: CHROME MISC
  var cmisc = {

    i18n_replace: function(selector, name) {
      $( selector ).html( chrome.i18n.getMessage( name ) );
    },
    
    i18n_get: function(name, placeholder) {
      var placeholder = placeholder || null;
      if ( placeholder ) {
        return chrome.i18n.getMessage( name, placeholder );
      }
      else {
        return chrome.i18n.getMessage( name );
      }
    },
    
    get_manifest: function() {
      return chrome.runtime.getManifest();
    },
    
    open_new_tab: function(url) {
      chrome.tabs.create( { url:url } );
    },

    // get extension version from manifest    
    get_version: function() {
      //var x = chrome.app.getDetails();
      var x = chrome.runtime.getManifest();
      return x.version;
    },

    // get option from storage
    // callback params: callback( ret )
    get_option_saved: function( name, callback ) {
      var callback = callback || null;
      
      //var whatstorage = 'localStorage'; // localStorage || chrome

      if ( 'localStorage' == whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'value': null };
        if (storage) {
          ret.value = storage.getItem( name );
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == whatstorage ) {
        var __ = {};
        __[name] = null;
        cstorage.read( __, function( ret ) {
          if (DEBUG) console.log( MODULE, ret );

          var value = null;
          if ( 'valid' == ret.status ) {
            if ( misc.hasOwnProperty(ret.items, name) ) {
              value = ret.items[name];
            }
          }
          ret.value = value;
          delete ret['items'];
          if ( $.isFunction( callback ) ) callback( ret );
        });
      }
    },

    // save option to storage
    // callback params: callback( ret )
    save_option: function( name, value, callback ) {
      var callback = callback || null;

      //var whatstorage = 'localStorage'; // localStorage || chrome

      if ( 'localStorage' == whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'value': null };
        if (storage) {
          ret.value = value;
          storage.setItem( name, value );
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == whatstorage ) {
        var __ = {};
        __[name] = value;
        cstorage.save( __, function( ret ) {
          if (DEBUG) console.log( MODULE, ret );

          ret.value = value;
          if ( $.isFunction( callback ) ) callback( ret );
        });
      }
    },

    // is extension allowed on page?
    is_extension_allowed: function( url ) {
      //http://dev.aa-team.com/wp-plugins/WooZoneV9/wp-admin/admin.php?page=WooZone#!/direct_import false
      var ret = true;
      if ( ! url
        || url.match(/^chrome:|chrome-extension:/)
        || url.match(/^https:\/\/chrome.google.com\/webstore/)
        || url.match(/file:\//)
        || (
          ! url.match(/^(https?:\/\/)(.*)page=WooZone_direct_import/g)
          && ! url.match(/^(https?:\/\/.*\.amazon\.(com|co\.uk|de|cn|it|es|co\.jp|ca|fr|in|com\.mx|com\.br|com\.au|ae|nl|sg)\/)/g)
        )
      ) {
        ret = false;
      }
      return ret;
    },

    // verify & set extension status (icon & popup): available or disabled
    set_extension_status: function( tab ) {
      var url     = misc.hasOwnProperty( tab, 'url' ) ? tab.url : null,
        icon    = 'images/icons/icon_32.png',
        icon_d    = 'images/icons/icon_32_disabled.png';

      
      // extension is NOT allowed
      if ( ! this.is_extension_allowed( url ) ) {
        set_icon( icon_d);
        set_popup( 'html/extension_disabled.html' );
      }
      // extension is allowed here
      else {
        // !!! already setted by default in manifest.json
        //set_icon( icon);
        //set_popup( 'html/options.html' );
      }
    
      // shortcuts
      function set_icon(icon) {
        chrome.browserAction.setIcon( {path: chrome.extension.getURL(icon), tabId: tab.id} );
      };
      function set_popup(popup) {
        chrome.browserAction.setPopup( {tabId: tab.id, popup: popup} );
      };
    },

    // callback params: callback( ret )
    sendMessage: function( action, pms, callback ) {
      var pms = pms || {};

      chrome.runtime.sendMessage( { action: action, pms: pms }, function( response ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {} };
        if ( chrome.runtime.lastError ) {
          var msg = chrome.runtime.lastError.message;
          if ( DEBUG ) console.log( MODULE, msg );
          ret = { 'status' : 'invalid', 'msg' : msg, 'lastError' : chrome.runtime.lastError };
        }
        else {
          $.extend( ret, response );
        }

        if ( DEBUG ) console.log( MODULE, ret );
        if ( $.isFunction( callback ) ) callback( ret );
      });
    },
    
    sendNotice: function( msg_title, msg_text, status, pms ) {
      chrome.runtime.sendMessage( { action: 'notice', status: status, msg: { title: msg_title, text: msg_text }, pms: pms } );
    },
    
    createNotice: function( msg_title, msg_text, status, pms ) {
      var status      = status || 'info',
        pms       = pms || {},
        ph_title    = misc.hasOwnProperty( pms, 'title' ) ? pms.title : false,
        ph_text     = misc.hasOwnProperty( pms, 'text' ) ? pms.text : false,
        title       = ! ph_title ? this.i18n_get( msg_title ) : this.i18n_get( msg_title, ph_title ),
        text      = ! ph_text ? this.i18n_get( msg_text ) : this.i18n_get( msg_text, ph_text );

      var iconUrl  = ('error' == status ? 'icon_app_error.png' : 'icon_app_success.png');
      chrome.notifications.create(
        'Notifier', {
          type      : 'basic', 
          iconUrl     : '../images/' + iconUrl, 
          title     : title, 
          message     : text
        },
        function() {} 
      );
    }
  };
  
  
  // :: CHROME STORAGE
  var cstorage = {

    // callback params: callback( ret )
    read: function( keys, callback ) {
      var callback = callback || null;

      chrome.storage.sync.get(keys, function( items ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if ( chrome.runtime.lastError ) {
          var msg = chrome.runtime.lastError.message;
          if ( DEBUG ) console.log( MODULE, msg );
          ret = { 'status' : 'invalid', 'msg' : msg, 'lastError' : chrome.runtime.lastError };
        }
        else {
          ret.items = items;
        }

        if ( DEBUG ) console.log( MODULE, items );
        if ( $.isFunction( callback ) ) callback( ret );
      });
    },

    // callback params: callback( ret )
    save: function( keys, callback ) {
      var callback = callback || null;

      chrome.storage.sync.set(keys, function() {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if ( chrome.runtime.lastError ) {
          var msg = chrome.runtime.lastError.message;
          if ( DEBUG ) console.log( MODULE, msg );
          ret = { 'status' : 'invalid', 'msg' : msg, 'lastError' : chrome.runtime.lastError };
        }

        if ( $.isFunction( callback ) ) callback( ret );
      });
    },

    // callback params: callback( ret )
    remove: function( keys, callback ) {
      var callback = callback || null;

      chrome.storage.sync.remove(keys, function() {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if ( chrome.runtime.lastError ) {
          var msg = chrome.runtime.lastError.message;
          if ( DEBUG ) console.log( MODULE, msg );
          ret = { 'status' : 'invalid', 'msg' : msg, 'lastError' : chrome.runtime.lastError };
        }

        if ( $.isFunction( callback ) ) callback( ret );
      });
    },

    // callback params: callback( ret )
    clear: function( callback ) {
      var callback = callback || null;

      chrome.storage.sync.clear(function() {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if ( chrome.runtime.lastError ) {
          var msg = chrome.runtime.lastError.message;
          if ( DEBUG ) console.log( MODULE, msg );
          ret = { 'status' : 'invalid', 'msg' : msg, 'lastError' : chrome.runtime.lastError };
        }

        if ( $.isFunction( callback ) ) callback( ret );
      });
    }

  };


  // :: SETTINGS
  var settings = {

    //whatstorage: 'localStorage', // localStorage || chrome
    whatstorage: whatstorage,

    prefix: 'WZAGdb_settings',
    list: {
      // (key: default value) pairs
      'box_status'        : 1, // 0|1 <=> false|true
      'chrome_notices'      : 1, // 0|1 <=> false|true
      'current_site'        : '',
      'collapse'          : 'show',
      
      // non editable
      'box_opened'        : 1, // 0|1 <=> false|true
      'skip_intro'        : 1 // 0|1 <=> false|true
    },

    // <setting name>: WzoneImport_settingsbox_status]
    clean_prefix: function( keys ) {
      // settings & default values
      var _prefix = this.prefix;

      var __ = {};
      $.each(keys, function(i, v) {
        var x = i.replace(_prefix+'[', '').replace(']', '');
        __[x] = v;
      });
      return __;
    },

    build_defaults: function() {
      // settings & default values
      var _prefix     = this.prefix;
      var _settings   = this.list;

      // prepare to read from storage
      var __ = {};
      $.each(_settings, function(i, v) {
        var x = "prefix[key]".replace('prefix', _prefix).replace('key', i);
        __[x] = v;
      });
      return __;
    },

    // <setting name>: WzoneImport_settingsbox_status]
    build_default: function( name ) {
      // settings & default values
      var _prefix     = this.prefix;
      var _settings   = this.list;

      // prepare to read from storage
      var __    = {},
        clean = name.replace(_prefix+'[', '').replace(']', '');
      __[name] = _settings[clean];
      return __;
    },

    // <setting name>: WzoneImport_settingsbox_status]
    // callback params: callback( ret )
    read_all: function( callback ) {
      var callback = callback || null;

      // prepare to read from storage
      var __ = this.build_defaults();
      if ( 'localStorage' == this.whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if (storage) {
          var _new = {};
          $.each(__, function(i, v) {
            var _tmp = storage.getItem( i );
            _new[i] = _tmp !== null ? _tmp : v;
          });
          ret.items = _new;
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == this.whatstorage ) {
        cstorage.read( __, callback );
      }
    },

    // <setting name>: WzoneImport_settingsbox_status]
    // callback params: callback( ret )
    read_single: function( name, callback ) {
      var callback = callback || null;

      // prepare to read from storage
      var __ = this.build_default();
      if ( 'localStorage' == this.whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if (storage) {
          var _new = {};
          var _tmp = storage.getItem( name );
          _new[name] = _tmp !== null ? _tmp : __[name];
          ret.items = _new;
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == this.whatstorage ) {
        cstorage.read( __, callback );
      }
    },

    // !!! an alias of save_single
    save_all: function( keys, callback ) {
      var callback = callback || null;
      this.save_single( keys, callback );
    },

    // <setting name>: WzoneImport_settingsbox_status]
    // keys : { <setting name> : <setting value> }
    // callback params: callback( ret )
    save_single: function( keys, callback ) {
      var callback = callback || null;

      if ( 'localStorage' == this.whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if (storage) {
          var _new = {};
          $.each(keys, function(i, v) {
            _new[i] = v;
            storage.setItem( i, v );
          });
          //ret.items = _new;
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == this.whatstorage ) {
        cstorage.save( keys, callback );
      }
    },

    // <setting name>: WzoneImport_settingsbox_status]
    // callback params: callback( ret )
    remove_all: function( callback ) {
      var callback = callback || null;

      // settings & default values
      var _prefix     = this.prefix;
      var _settings   = this.list;

      // prepare to remove from storage
      var __ = this.build_default();
      if ( 'localStorage' == this.whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if (storage) {
          var _new = {};
          $.each(__, function(i, v) {
            storage.removeItem( i );
          });
          //ret.items = _new;
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == this.whatstorage ) {
        __ = Object.keys( __ );
        cstorage.remove( __, callback );
      }
    },

    // <setting name>: WzoneImport_settingsbox_status]
    // callback params: callback( ret )
    remove_single: function( name, callback ) {
      var callback = callback || null;

      if ( 'localStorage' == this.whatstorage ) {
        var ret = { 'status' : 'valid', 'msg' : '', 'lastError' : {}, 'items': {} };
        if (storage) {
          var _new = {};
          storage.removeItem( name );
          //ret.items = _new;
        } else {
          ret.status = 'invalid';
          ret.msg = 'Error: localStorage not available.';
        }
        return ret;
      }
      else if ( 'chrome' == this.whatstorage ) {
        cstorage.remove( name, callback );
      }
    }

  };


  // :: ASINS storage
  // !!! I've implemented this only for chrome.storage!
  var sites = {

    // //main storage container Structure
    // WZAGdb_asins : {
    //    //list of pages from where asins were saved
    //    pages : {
    //      //key = page code
    //      26227841 : {
    //        details     : {}, //page details: title, url...
    //        asins     : [], //asins added from this page
    //      }
    //    },
    //    //list of saved asins
    //    asins : {
    //      //key = asin
    //      B01K1IO3QW : {} //product properties: title, url, country, thumb, also page code...
    //      ...
    //    },
    //    //excluded pages & asins, when exporting...
    //    excluded : {
    //      pages : {} //key = pagecode
    //      asins : {} //key = asin
    //    }
    // }

    prefix: 'authorize_sites',

    error_codes: {
      0 : 'success', // successfull operation
      1 : 'chrome storage read', // error at chrome storage
      2 : 'chrome storage save', // error at chrome storage
      3 : 'chrome storage remove', // error at chrome storage
      4 : 'asin already added', // asin already exists in storage
      5 : 'asin not found', // asin not found in storage
      6 : 'pagecode not found', // pagecode not found in storage
      7 : 'invalid mandatory params for main object', // validation before saving main object in storage
      8 : 'asin already excluded', // asin already excluded
      9 : 'restore asin not found', // asin not found when restored
      10 : 'pagecode already excluded', // pagecode already excluded
      11 : 'restore pagecode not found', // pagecode not found when restored
    },

    init_main_obj: function( obj ) {
      var obj = typeof obj === 'object' && obj !== null ? obj : {};
      if ( ! misc.hasOwnProperty( obj, 'sites') ) {
        obj['sites'] = {};
      }
      return obj;
    },

    action_generic: function( pms ) {
      var that    = this,
        _prefix   = this.prefix;

      var pms     = pms || {},
        action    = misc.hasOwnProperty( pms, 'action' ) ? pms.action : '',
        callback  = misc.hasOwnProperty( pms, 'callback' ) ? pms.callback : null,
        s     = misc.hasOwnProperty( pms, 's' ) ? pms.s : {},
        url     = misc.hasOwnProperty( pms, 'url' ) ? pms.url : "",
        site    = misc.hasOwnProperty( pms, 'site' ) ? pms.site : {};

      // try to read current list of asins
      cstorage.read( _prefix, function( ret ) {

        if ( 'invalid' == ret.status ) {
          $.extend( ret, { error_code: 1 } );
          _status({
            ret     : ret,
            status    : 'invalid',
            error_code  : 1
          });
          return false;
        }

        var main_obj  = that.init_main_obj( ret.items[ _prefix ] ),
          _error_code = 0;

        //main_obj['excluded'] = { asins: [], pages: [] }; //debugging...

        // validation
        _error_code = 0;
        switch ( action ) {
          case 'load_sites':
            $.extend( ret, { error_code: 0, main_obj: main_obj } );
            _status({
              ret     : ret,
              status    : 'valid',
              error_code  : 0
            });
            return ret;
            //break;

          case 'add_site':
            //main_obj = that._tostring( main_obj ); //debugging...

            // asin exists? yes
            if ( misc.hasOwnProperty( main_obj['sites'], url ) ) {
              _error_code = 4;
            }
            break;

          case 'remove_site':
            // asin found? no
            if ( ! misc.hasOwnProperty( main_obj['sites'], url ) ) {
              _error_code = 5;
            }
            break;

          case 'remove_all':
            break;
        }

        if ( _error_code ) {
          $.extend( ret, { error_code: _error_code, status: 'invalid' } );
          _status({
            ret     : ret,
            status    : 'invalid',
            error_code  : _error_code
          });
          return false;
        }

        //------------------
        //:: main code

        _error_code = 0;
        switch ( action ) {
          case 'add_site':
            // asin don't exists so try to save asin to list
            if ( url !== null && site !== null && misc.hasOwnProperty( site, 'key' ) ) {
              main_obj['sites'][ url ] = site;
            }
            else {
              _error_code = 7;
            }
            break;

          case 'remove_site':
            // asin is found so try to remove asin from list
            if ( misc.hasOwnProperty( main_obj['sites'], url ) ) {
              
              delete main_obj['sites'][ url ];
            }
            else {
              _error_code = 7;
            }
            break;

          case 'remove_all':
            // remove all asins
            main_obj = that.init_main_obj( {} );
            break;

        }

        if ( _error_code ) {
          $.extend( ret, { error_code: _error_code, status: 'invalid' } );
          _status({
            ret     : ret,
            status    : 'invalid',
            error_code  : _error_code
          });
          return false;
        }

        //:: end main code
        //------------------

        var _save_obj = {};
        _save_obj[_prefix] = main_obj;

        // try to save
        cstorage.save( _save_obj, function( ret ) {

          if ( 'invalid' == ret.status ) {
            $.extend( ret, { error_code: 2 } );
            _status({
              ret     : ret,
              status    : 'invalid',
              error_code  : 2
            });
            return false;
          }

          // saved successfully
          $.extend( ret, { error_code: 0 } );
          _status({
            ret     : ret,
            status    : 'valid',
            error_code  : 0
          });
          return true;
        });
      });

      function _status( params ) {
        var params    = params || {},
          ret     = misc.hasOwnProperty( params, 'ret' ) ? params.ret : {},
          status    = misc.hasOwnProperty( params, 'status' ) ? params.status : 'invalid', // valid | invalid
          error_code  = misc.hasOwnProperty( params, 'error_code' ) ? params.error_code : 99999,
          optext    = '--missing text--',
          notice    = [];

        var _np     = '',
          _nvars    = [];

        switch ( action ) {
          case 'load_sites':
            _np = 'load';
            break;

          case 'add_site':
            _np = 'add';
            _nvars = [url];
            break;

          case 'remove_site':
            _np = 'remove';
            _nvars = [url];
            break;

          case 'remove_all':
            _np = 'remove_all';
            break;
        }

        if ( _nvars.length ) {
          if ( action.match(/page/gi) ) {
            _nvars[0] = misc.makeitreadable( _nvars[0], 'page' );
          }
          else {
            _nvars[0] = misc.makeitreadable( _nvars[0], 'url' );
          }
        }

        switch ( error_code ) {
          case 0:
            if ( $.inArray(action, ['load_sites', 'remove_all']) > -1 ) {
              if ( 'load_sites' == action ) {
                optext = action + '/ success/ sites loaded successfully';
              } else {
                optext = action + '/ success/ all sites removed successfully';
              }
              notice = [ 'sites_'+_np+'_success', 'sites_'+_np+'_success_desc', 'success' ];
            }
            else {
              optext = action + '/ success/ %s saved successfully'.replace('%s', _nvars[0]);
              notice = [ 'sites_'+_np+'_success', 'sites_'+_np+'_success_desc', 'success', { text: _nvars } ];
            }
            break;

          case 1:
            optext = action + '/ error/ get asins from chrome storage';
            notice = [ 'get_sites_storage_error', 'get_sites_storage_error_desc', 'error' ];
            break;

          case 2:
            if ( $.inArray(action, ['load_asins', 'remove_all']) > -1 ) {
              notice = [ 'sites_'+_np+'_error', 'sites_'+_np+'_error_desc', 'error' ];
            }
            else {
              notice = [ 'sites_'+_np+'_error', 'sites_'+_np+'_error_desc', 'error', { text: _nvars } ];
            }
            optext = action + '/ error/ save asins to chrome storage';
            break;

          case 4:
            optext = action + '/ error/ %s already exists'.replace('%s', _nvars[0]);
            notice = [ 'sites_'+_np+'_exists', 'sites_'+_np+'_exists_desc', 'error', { text: _nvars } ];
            break;

          case 5:
          case 6:
            optext = action + '/ error/ %s not found'.replace('%s', _nvars[0]);
            notice = [ 'sites_'+_np+'_notfound', 'sites_'+_np+'_notfound_desc', 'error', { text: _nvars } ];
            break;

          case 7:
            optext = action + '/ error/ save asins to chrome storage';
            notice = [ 'save_sites_storage_error', 'save_sites_storage_error_desc', 'error' ];
            break;

          case 8:
          case 10:
            optext = action + '/ error/ %s already excluded'.replace('%s', _nvars[0]);
            notice = [ 'sites_'+_np+'_notfound', 'sites_'+_np+'_notfound_desc', 'error', { text: _nvars } ];
            break;

          case 9:
          case 11:
            optext = action + '/ error/ %s not found'.replace('%s', _nvars[0]);
            notice = [ 'sites_'+_np+'_notfound', 'sites_'+_np+'_notfound_desc', 'error', { text: _nvars } ];
            break;
        }

        //chrome notice here
        if ( s.chrome_notices ) {
          if ( notice.length == 4 )
            cmisc.sendNotice( notice[0], notice[1], notice[2], notice[3] );
          else if ( notice.length == 3 )
            cmisc.sendNotice( notice[0], notice[1], notice[2] );
        }
        if (DEBUG) console.log( MODULE, optext, ret );

        if ( $.isFunction( callback ) ) callback( $.extend( ret, { error_code: error_code } ) );
        return status;
      };
    },

    add_site: function( pms, callback ) {
      var pms = $.extend( pms, {
        action    : 'add_site',
        callback  : callback
      });
      this.action_generic( pms );
    },

    remove_site: function( pms, callback ) {
      var pms = $.extend( pms, {
        action    : 'remove_site',
        callback  : callback
      });
      this.action_generic( pms );
    },

    remove_all: function( pms, callback ) {
      var pms = $.extend( pms, {
        action    : 'remove_all',
        callback  : callback
      });
      this.action_generic( pms );
    },

    load_sites: function( pms, callback ) {
      var pms = $.extend( pms, {
        action    : 'load_sites',
        callback  : callback
      });
      this.action_generic( pms );
    },

    // temporary function: used to convert from original data to new version
    _tostring: function( mo ) {
      var _mmo = this.init_main_obj(null);

      $.each( mo.sites, function (site, val) {
        var _site   = misc.makeitstring( site, 'url' );

        var newval = $.extend( {}, val );
        newval['site'] = _site;

        _mmo.sites[ _site ] = newval;
      });

      return _mmo;
    }

  };

  function isset(obj) 
  {
    var i, max_i;
    if(obj === undefined) return false;
    for (i = 1, max_i = arguments.length; i < max_i; i++) {
      if (obj[arguments[i]] === undefined) {
          return false;
      }
      obj = obj[arguments[i]];
    }
    return true;
  }

  function isAuthPage()
  {
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    
    if( typeof urlParams.get('page') != "" ){
      if( urlParams.get('page') == "WooZone_direct_import" ){
        return true;
      }
    }

    return false;
  }

  function isAmzDetailPage()
  {
    if( misc.get_asin_from_url( window.location.href ) ){
      return true;
    }

    return false;
  }

  function contentTrimmer( DOM='' ) {
    function clean_text( content ) {
      content = content.replace(/\s\s+/g, ' ');
      content = content.trim();
      return content;
    }
    
    // console.time('contentTrimmer');

    DOM = clean_text( DOM );

    let page = $('<div/>').html(DOM).contents().parent();

    // some unwanted HTML tags
    page.find("header").remove();
    page.find("style").remove();
    page.find("link").remove();
    page.find("input").remove();
    page.find("select").remove();

    // footer large menu
    page.find("#navFooter").remove();

    // reviews
    page.find("#reviewsMedley").remove();

    // Frequently bought together
    page.find("#sims-consolidated-1_feature_div").remove();

    // Sponsored products related to this item
    page.find("#sims-consolidated-2_feature_div").remove();

    // Customers who bought this item also bought
    page.find("#sims-consolidated-3_feature_div").remove();

    // Sponsored products related to this item
    page.find("#sponsoredProducts2_feature_div").remove();

    page.find("*").removeAttr('style');
    page.find("script").each( function(){
      var that = $(this);
      if( that.text().indexOf("twister-js-init-dpx-data") == -1 ){
        that.remove()
      }
    })

    // console.timeEnd('contentTrimmer');

    return page.html();
  }

  // external usage
  return {
    storage             : storage,
    cstorage            : cstorage,
    misc                : misc,
    isset               : isset,
    cmisc               : cmisc,
    settings            : settings,
    sites               : sites,
    isAuthPage          : isAuthPage,
    isAmzDetailPage     : isAmzDetailPage,
    contentTrimmer      : contentTrimmer,
  };
})();