<?php
// Prevent direct access to files
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'DSM_JSON_Handler' ) ) {
	class DSM_JSON_Handler {
		const MIME_TYPE = 'application/json';

		/**
		 * Add JSON to allowed file uploads.
		 *
		 * @since 2.7.2
		 */
		public function dsm_mime_types( $mimes ) {
			$mimes['json'] = self::MIME_TYPE;
			return $mimes;
		}

		/**
		 * Add JSON to wp_check_filetype_and_ext.
		 * Fixed: Use strict extension check to prevent bypass vulnerabilities.
		 *
		 * @since 2.7.2
		 */
		public function dsm_check_filetype_and_ext( $types, $file, $filename, $mimes ) {
			// If WordPress already detected a valid type, don't override it
			if ( ! empty( $types['ext'] ) && ! empty( $types['type'] ) ) {
				return $types;
			}

			// Only treat files that actually END with .json as JSON (case-insensitive)
			// This prevents bypass attacks like "malware.php.json" or "shell.json.php"
			if ( preg_match( '/\.json$/i', $filename ) ) {
				$types['ext']  = 'json';
				$types['type'] = self::MIME_TYPE;
			}

			return $types;
		}

		/**
		 * DSM_JSON_Handler constructor.
		 */
		public function __construct() {
			add_filter( 'upload_mimes', array( $this, 'dsm_mime_types' ) );
			add_filter( 'wp_check_filetype_and_ext', array( $this, 'dsm_check_filetype_and_ext' ), 10, 4 );
		}
	}
}