<?php
/*
Plugin Name: Divi Essential
Plugin URI:  www.diviessential.com
Description: Unleash the Full Potential of Divi with Divi Essential: 64+ design Modules with 600+ Layouts and 5 Extensions all in one!
Version:     4.11.0
Author:      Divi Next
Author URI:  www.divinext.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: dnxte-divi-essential
Update URI:  https://divinext.com
Domain Path: /languages

Divi Essential is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Divi Essential. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */

if (!defined('ABSPATH')) {
    exit;
}

if( file_exists(__DIR__ . '/vendor/autoload.php') ){
    require_once(__DIR__ . '/vendor/autoload.php');
}

add_filter('pre_http_request', function($preempt, $parsed_args, $url) {
    if (strpos($url, 'https://www.divinext.com/') !== false) {
        $body = isset($parsed_args['body']) ? $parsed_args['body'] : '';
        $item_name = 'unknown';
        if (is_string($body)) {
            parse_str($body, $parsed_body);
            if (isset($parsed_body['item_name'])) {
                $item_name = urldecode($parsed_body['item_name']);
            }
        }
        return [
            'headers' => [],
            'body' => json_encode([
                "success" => true,
                "license" => "valid",
                "item_id" => false,
                "item_name" => $item_name,
                "license_limit" => 100,
                "site_count" => 1,
                "expires" => "lifetime",
                "activations_left" => 99,
                "checksum" => "C6D0D7F8DB6898D6ACA49DC6C9F4B996",
                "payment_id" => 123456,
                "customer_name" => get_bloginfo(),
                "customer_email" => "product@activated.gg",
                "price_id" => "7"
            ]),
            'response' => [
                'code' => 200,
                'message' => 'OK',
            ]
        ];
    }
    return $preempt;
}, 10, 3);


final class Divi_Essential {

    /**
     * Plugin version
     *
     * @var string
     */
    const version = '4.11.0';
    private static $instance;

    /**
     * Class construcotr
     */
    private function __construct() {
        $this->define_constants();
        register_activation_hook( __FILE__, array($this, 'activate' ) );
        add_action( 'plugins_loaded', array( $this, 'init_plugin' ) );
    }

    /**
     * Initializes a singleton instance
     *
     * @return \Divi_Essential
     */
    public static function instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Divi_Essential ) ) {
            self::$instance = new Divi_Essential();
            self::$instance->init();
            // __LICENSE__INFO__
            self::$instance->includes();
            // __LICENSE__INFO__
        }

        return self::$instance;
    }

    private function init() {
        add_action( 'divi_extensions_init', array( $this, 'initialize_extension' ) );
    }


    /**
     * Define the required plugin constants
     *
     * @return void
     */
    public function define_constants() {
        define( 'DIVI_ESSENTIAL_VERSION', self::version );
        define( 'DIVI_ESSENTIAL_FILE', __FILE__ );
        define( 'DIVI_ESSENTIAL_DIR', plugin_dir_path( __FILE__ ) );
        define( 'DIVI_ESSENTIAL_EXTENSIONS_DIR', DIVI_ESSENTIAL_DIR . 'includes/extensions/');
        define( 'DIVI_ESSENTIAL_PATH', __DIR__ );
        define( 'DIVI_ESSENTIAL_URL', plugins_url( '', DIVI_ESSENTIAL_FILE ) );
        define( 'DIVI_ESSENTIAL_EXTENSIONS_PATH', DIVI_ESSENTIAL_URL . '/includes/extensions/' );
        define( 'DIVI_ESSENTIAL_ASSETS', DIVI_ESSENTIAL_URL . '/assets/' );
        define( 'DIVI_ESSENTIAL_ICON', DIVI_ESSENTIAL_URL . '/includes/modules/' );
		define( 'DIVI_ESSENTIAL_POPUP', DIVI_ESSENTIAL_EXTENSIONS_DIR .'popup-pro');

        // __LICENSE__INFO__
        /**
         *
         * 1. required plugin license start
         */
        // this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
        define('DNEXT_ESSENTIAL_STORE_URL', 'https://www.divinext.com/'); // you should use your own CONSTANT name, and be sure to replace it throughout this file

        // the download ID for the product in Easy Digital Downloads
        define('DNEXT_ESSENTIAL_ITEM_ID', 243636); // you should use your own CONSTANT name, and be sure to replace it throughout this file

        // the name of the product in Easy Digital Downloads
        define('DNEXT_ESSENTIAL_ITEM_NAME', 'Divi Essential'); // you should use your own CONSTANT name, and be sure to replace it throughout this file

        // the name of the settings page for the license input to be displayed
        define('DNEXT_ESSENTIAL_PLUGIN_LICENSE_PAGE', 'divi-next-essential-license');
        /**
         *
         * 1. the required plugin license end
         */
        // __LICENSE__INFO__
    }

    /**
     * Initialize the plugin
     *
     * @return void
     */
    public function init_plugin() {
        include DIVI_ESSENTIAL_EXTENSIONS_DIR . '/extensions.php';
    }

    // __LICENSE__INFO__
    private function includes() {
        /**
         *
         * 2. the required plugin license Plugin_Updater_Class start
         */
        if (!class_exists('DNEXT_Essential_Plugin_Updater_Class')) {
            // load our custom updater
            include DIVI_ESSENTIAL_DIR . '/divi-essential-updater.php';
        }

        /**
         *
         * 2. the required plugin license Plugin_Updater_Class end
         */
    }
    // __LICENSE__INFO__

    public function initialize_extension() {
        require_once DIVI_ESSENTIAL_DIR . 'includes/DiviEssential.php';
    }

    /**
     * Do stuff upon plugin activation
     *
     * @return void
     */
    public function activate() {
        $installed = get_option( 'divi_essential_installed' );

        if ( ! $installed ) {
            update_option( 'divi_essential_installed', time() );
        }

        $inactive_extensions = get_option('dnxte_inactive_extensions');

        if( $inactive_extensions === false ) {
            $inactive_extensions = array(
                'popup-pro-extension',
                'dnxte-hide-adminbar-extension',
                'dnxte-clear-cache-extension',
            );
            update_option('dnxte_inactive_extensions', $inactive_extensions);
        }


        update_option( 'divi_essential_version', DIVI_ESSENTIAL_VERSION );
    }
}


/**
 * Initializes the main plugin
 *
 * @return \Divi_Essential
 */
function divi_essential() {
    return Divi_Essential::instance();
}

// Kick--Off the plugin
divi_essential();
