jQuery(document).ready(function($) {
    // Handle click on the admin bar button
    $('#wp-admin-bar-divi-cache-clearer').on('click', function(e) {
        e.preventDefault();

        // Add spinning class
        $(this).addClass('clearing');

        // Make AJAX request to clear Divi cache
        $.ajax({
            url: DiviCacheClearer.ajax_url,
            type: 'POST',
            data: {
                action: 'clear_divi_css_cache',
                nonce: DiviCacheClearer.nonce
            },
            success: function(response) {
                // Remove spinning class
                $('#wp-admin-bar-divi-cache-clearer').removeClass('clearing');

                // Show success message
                if (response.success) {
                    // Create notification element
                    var notification = $('<div class="divi-cache-notification">' + response.data.message + '</div>');

                    // Add styles to the notification
                    notification.css({
                        'position': 'fixed',
                        'top': '32px',
                        'right': '20px',
                        'background-color': '#46b450',
                        'color': 'white',
                        'padding': '10px 15px',
                        'border-radius': '3px',
                        'box-shadow': '0 2px 5px rgba(0,0,0,0.2)',
                        'z-index': '999999',
                        'opacity': '0',
                        'transform': 'translateY(-20px)'
                    });

                    // Add to body and animate in
                    $('body').append(notification);
                    notification.animate({
                        opacity: 1,
                        transform: 'translateY(0)'
                    }, 300);

                    // Remove after 3 seconds
                    setTimeout(function() {
                        notification.animate({
                            opacity: 0,
                            transform: 'translateY(-20px)'
                        }, 300, function() {
                            notification.remove();
                        });
                    }, 3000);
                }
            },
            error: function() {
                // Remove spinning class
                $('#wp-admin-bar-divi-cache-clearer').removeClass('clearing');
            }
        });
    });
});