<?php

defined( 'ABSPATH' ) || die();

if ( file_exists( __DIR__ . '/traits/index.php' ) ) {
	require_once __DIR__ . '/traits/index.php';
}


/**
 * Custom Attributes class.
 *
 * @since             1.0.0
 * @package           Attributes
 */
class DnxteAttributes {
	use CAHelper;
	use CAToggles;
	use CARender;

	public function __construct() {
		$this->dnxte_custom_attributes();
		$this->add_filter();
	}

	public function add_filter() {
		add_filter( 'et_pb_all_fields_unprocessed_et_pb_section', array( $this, 'get_fields' ) );
		add_filter( 'et_pb_all_fields_unprocessed_et_pb_row', array( $this, 'get_fields' ) );
		add_filter( 'et_pb_all_fields_unprocessed_et_pb_column', array( $this, 'get_fields' ) );

		add_filter( 'et_builder_get_parent_modules', array( $this, 'parent_toggles' ), 10 );
		add_filter( 'et_builder_get_child_modules', array( $this, 'child_toggles' ), 10 );

		add_filter( 'et_module_shortcode_output', array( $this, 'section_output' ), 10, 3 );
		add_filter( 'et_module_shortcode_output', array( $this, 'column_output' ), 10, 3 );
		add_filter( 'et_module_shortcode_output', array( $this, 'row_output' ), 10, 3 );
		add_filter( 'et_module_shortcode_output', array( $this, 'module_output' ), 10, 3 );
	}

	public function dnxte_custom_attributes() {
		$modules = $this->get_modules();
		foreach ( $modules as $module ) {
			add_filter( "et_pb_all_fields_unprocessed_$module", array( $this, 'get_fields' ) );
		}
	}
}
if ( class_exists( 'DnxteAttributes' ) ) {
	new DnxteAttributes();
}
