<?php

defined( 'ABSPATH' ) || die();

trait CARender {
	public function section_output( $output, $render_slug, $module ) {
		if ( 'et_pb_section' === $render_slug ) {
			if ( is_array( $output ) ) {
				return $output;
			}

			$dnxte_custom_attribute_on_off = isset( $module->props['dnxte_custom_attribute_on_off'] ) ? $module->props['dnxte_custom_attribute_on_off'] : 'off';
			if ( isset( $module->props['dnxte_custom_attribute_on_off'] ) && 'on' === $module->props['dnxte_custom_attribute_on_off'] ) {
				$dnxte_attributes_options            = $module->props['dnxte_attributes_options'];
				$dnxte_custom_attribute_add          = isset( $module->props['dnxte_custom_attribute_add'] ) ? esc_attr( $module->props['dnxte_custom_attribute_add'] ) : 'module';
				$dnxte_custom_attribute_css_selector = isset( $module->props['dnxte_custom_attribute_css_selector'] ) ? esc_attr( $module->props['dnxte_custom_attribute_css_selector'] ) : '';
				$option_search                       = array( '&#91;', '&#93;' );
				$option_replace                      = array( '[', ']' );
				$dnxte_custom_attributes_options     = str_replace( $option_search, $option_replace, $dnxte_attributes_options );
				$dnxte_custom_attributes             = json_decode( $dnxte_custom_attributes_options );

				$dnxte_attributes_output = '';
				foreach ( $dnxte_custom_attributes as $index => $option ) {
					$data_attribute_name  = isset( $option->link_url ) ? esc_attr( $option->link_url ) : '';
					$data_attribute_value = isset( $option->link_text ) ? esc_attr( $option->link_text ) : '';

					if ( isset( $data_attribute_name ) ) {
						$dnxte_attributes_output .= esc_attr( $data_attribute_name );
					}

					if ( isset( $data_attribute_value ) ) {
						$dnxte_attributes_output .= ' ="' . esc_attr( $data_attribute_value ) . '"';
					}
				}

				switch ( $dnxte_custom_attribute_add ) {
					case 'wrapper':
						$output = str_replace( 'class="et_pb_section ', $dnxte_attributes_output . ' class="et_pb_section dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'button':
						$output = str_replace( 'class="et_pb_button ', $dnxte_attributes_output . ' class="et_pb_button dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'css':
						if ( $dnxte_custom_attribute_css_selector ) {
							$output = str_replace( 'class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . '', $dnxte_attributes_output . ' class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . ' dnxte_data_attributes ', $output );
						}
						break;

					default:
						// code...
						break;
				}
			}
		}
		return $output;
	}
	public function row_output( $output, $render_slug, $module ) {
		if ( 'et_pb_row' === $render_slug ) {
			if ( is_array( $output ) ) {
				return $output;
			}

			$dnxte_custom_attribute_on_off = isset( $module->props['dnxte_custom_attribute_on_off'] ) ? $module->props['dnxte_custom_attribute_on_off'] : 'off';
			if ( isset( $module->props['dnxte_custom_attribute_on_off'] ) && 'on' === $module->props['dnxte_custom_attribute_on_off'] ) {
				$dnxte_attributes_options            = $module->props['dnxte_attributes_options'];
				$dnxte_custom_attribute_add          = isset( $module->props['dnxte_custom_attribute_add'] ) ? esc_attr( $module->props['dnxte_custom_attribute_add'] ) : 'module';
				$dnxte_custom_attribute_css_selector = isset( $module->props['dnxte_custom_attribute_css_selector'] ) ? esc_attr( $module->props['dnxte_custom_attribute_css_selector'] ) : '';
				$option_search                       = array( '&#91;', '&#93;' );
				$option_replace                      = array( '[', ']' );
				$dnxte_custom_attributes_options     = str_replace( $option_search, $option_replace, $dnxte_attributes_options );
				$dnxte_custom_attributes             = json_decode( $dnxte_custom_attributes_options );

				$dnxte_attributes_output = '';
				foreach ( $dnxte_custom_attributes as $index => $option ) {
					$data_attribute_name  = isset( $option->link_url ) ? esc_attr( $option->link_url ) : '';
					$data_attribute_value = isset( $option->link_text ) ? esc_attr( $option->link_text ) : '';

					if ( isset( $data_attribute_name ) ) {
						$dnxte_attributes_output .= esc_attr( $data_attribute_name );
					}

					if ( isset( $data_attribute_value ) ) {
						$dnxte_attributes_output .= ' ="' . esc_attr( $data_attribute_value ) . '"';
					}
				}

				switch ( $dnxte_custom_attribute_add ) {
					case 'wrapper':
						$output = str_replace( 'class="et_pb_row ', $dnxte_attributes_output . ' class="et_pb_row dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'button':
						$output = str_replace( 'class="et_pb_button ', $dnxte_attributes_output . ' class="et_pb_button dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'css':
						if ( $dnxte_custom_attribute_css_selector ) {
							$output = str_replace( 'class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . '', $dnxte_attributes_output . ' class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . ' dnxte_data_attributes ', $output );
						}
						break;

					default:
						// code...
						break;
				}
			}
		}
		return $output;
	}

	public function column_output( $output, $render_slug, $module ) {
		if ( 'et_pb_column' === $render_slug ) {
			if ( is_array( $output ) ) {
				return $output;
			}
			$dnxte_custom_attribute_on_off = isset( $module->props['dnxte_custom_attribute_on_off'] ) ? $module->props['dnxte_custom_attribute_on_off'] : 'off';
			if ( isset( $module->props['dnxte_custom_attribute_on_off'] ) && 'on' === $module->props['dnxte_custom_attribute_on_off'] ) {
				$dnxte_attributes_options            = $module->props['dnxte_attributes_options'];
				$dnxte_custom_attribute_add          = isset( $module->props['dnxte_custom_attribute_add'] ) ? esc_attr( $module->props['dnxte_custom_attribute_add'] ) : 'module';
				$dnxte_custom_attribute_css_selector = isset( $module->props['dnxte_custom_attribute_css_selector'] ) ? esc_attr( $module->props['dnxte_custom_attribute_css_selector'] ) : '';
				$option_search                       = array( '&#91;', '&#93;' );
				$option_replace                      = array( '[', ']' );
				$dnxte_custom_attributes_options     = str_replace( $option_search, $option_replace, $dnxte_attributes_options );
				$dnxte_custom_attributes             = json_decode( $dnxte_custom_attributes_options );

				$dnxte_attributes_output = '';
				foreach ( $dnxte_custom_attributes as $index => $option ) {
					$data_attribute_name  = isset( $option->link_url ) ? esc_attr( $option->link_url ) : '';
					$data_attribute_value = isset( $option->link_text ) ? esc_attr( $option->link_text ) : '';

					if ( isset( $data_attribute_name ) ) {
						$dnxte_attributes_output .= esc_attr( $data_attribute_name );
					}

					if ( isset( $data_attribute_value ) ) {
						$dnxte_attributes_output .= ' ="' . esc_attr( $data_attribute_value ) . '"';
					}
				}

				switch ( $dnxte_custom_attribute_add ) {
					case 'wrapper':
						$output = str_replace( 'class="et_pb_column ', $dnxte_attributes_output . ' class="et_pb_column dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'button':
						$output = str_replace( 'class="et_pb_button ', $dnxte_attributes_output . ' class="et_pb_button dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'css':
						if ( $dnxte_custom_attribute_css_selector ) {
							$output = str_replace( 'class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . '', $dnxte_attributes_output . ' class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . ' dnxte_data_attributes ', $output );
						}
						break;

					default:
						// code...
						break;
				}
			}
		}
		return $output;
	}

	public function module_output( $output, $render_slug, $module ) {
		if ( $this->get_modules() !== $render_slug ) {
			if ( is_array( $output ) ) {
				return $output;
			}

			$dnxte_custom_attribute_on_off = isset( $module->props['dnxte_custom_attribute_on_off'] ) ? $module->props['dnxte_custom_attribute_on_off'] : 'off';
			if ( isset( $module->props['dnxte_custom_attribute_on_off'] ) && 'on' === $module->props['dnxte_custom_attribute_on_off'] ) {
				$dnxte_attributes_options            = $module->props['dnxte_attributes_options'];
				$dnxte_custom_attribute_add          = isset( $module->props['dnxte_custom_attribute_add'] ) ? esc_attr( $module->props['dnxte_custom_attribute_add'] ) : 'module';
				$dnxte_custom_attribute_css_selector = isset( $module->props['dnxte_custom_attribute_css_selector'] ) ? esc_attr( $module->props['dnxte_custom_attribute_css_selector'] ) : '';
				$option_search                       = array( '&#91;', '&#93;' );
				$option_replace                      = array( '[', ']' );
				$dnxte_custom_attributes_options     = str_replace( $option_search, $option_replace, $dnxte_attributes_options );
				$dnxte_custom_attributes             = json_decode( $dnxte_custom_attributes_options );

				$dnxte_attributes_output = '';
				foreach ( $dnxte_custom_attributes as $index => $option ) {
					$data_attribute_name  = isset( $option->link_url ) ? esc_attr( $option->link_url ) : '';
					$data_attribute_value = isset( $option->link_text ) ? esc_attr( $option->link_text ) : '';

					if ( isset( $data_attribute_name ) ) {
						$dnxte_attributes_output .= esc_attr( $data_attribute_name );
					}

					if ( isset( $data_attribute_value ) ) {
						$dnxte_attributes_output .= ' ="' . esc_attr( $data_attribute_value ) . '"';
					}
				}

				switch ( $dnxte_custom_attribute_add ) {
					case 'wrapper':
						$output = str_replace( 'class="et_pb_module ', $dnxte_attributes_output . ' class="et_pb_module dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_toggle ', $dnxte_attributes_output . ' class="et_pb_toggle dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_slide ', $dnxte_attributes_output . ' class="et_pb_slide dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_video_slider_item ', $dnxte_attributes_output . ' class="et_pb_video_slider_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_accordion_item ', $dnxte_attributes_output . ' class="et_pb_accordion_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_pricing_table ', $dnxte_attributes_output . ' class="et_pb_pricing_table dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_counter ', $dnxte_attributes_output . ' class="et_pb_counter dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_blurb ', $dnxte_attributes_output . ' class="et_pb_blurb dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_blog ', $dnxte_attributes_output . ' class="et_pb_blog dnxte_data_attributes ', $output );

						// Divi Essential Parent & Child Modules.
						$output = str_replace( 'class="dnxte_lottie ', $dnxte_attributes_output . ' class="dnxte_lottie dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_image_magnifier ', $dnxte_attributes_output . ' class="dnxte_image_magnifier dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_blurb ', $dnxte_attributes_output . ' class="dnxte_blurb dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_thumbs_gallery_parent ', $dnxte_attributes_output . ' class="dnxte_thumbs_gallery_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_thumbs_gallery_child ', $dnxte_attributes_output . ' class="dnxte_thumbs_gallery_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_tooltip ', $dnxte_attributes_output . ' class="dnxte_tooltip dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_tooltip_child ', $dnxte_attributes_output . ' class="dnxte_tooltip_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_3dcubeslider_parent ', $dnxte_attributes_output . ' class="dnxte_3dcubeslider_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_3dcubeslider_child ', $dnxte_attributes_output . ' class="dnxte_3dcubeslider_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_business_hour_parent ', $dnxte_attributes_output . ' class="dnxte_business_hour_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_business_hour_child ', $dnxte_attributes_output . ' class="dnxte_business_hour_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_coverflowslider_parent ', $dnxte_attributes_output . ' class="dnxte_coverflowslider_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_coverflowslider_child ', $dnxte_attributes_output . ' class="dnxte_coverflowslider_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_feature_list_parent ', $dnxte_attributes_output . ' class="dnxte_feature_list_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_feature_list_child ', $dnxte_attributes_output . ' class="dnxte_feature_list_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_floating_element ', $dnxte_attributes_output . ' class="dnxte_floating_element dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_floating_element_child ', $dnxte_attributes_output . ' class="dnxte_floating_element_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_price_list_parent ', $dnxte_attributes_output . ' class="dnxte_price_list_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_price_list_child ', $dnxte_attributes_output . ' class="dnxte_price_list_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_testimonial_parent ', $dnxte_attributes_output . ' class="dnxte_testimonial_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_testimonial_child ', $dnxte_attributes_output . ' class="dnxte_testimonial_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_logo_carousel_parent ', $dnxte_attributes_output . ' class="dnxte_logo_carousel_parent dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_logo_carousel_child ', $dnxte_attributes_output . ' class="dnxte_logo_carousel_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_person ', $dnxte_attributes_output . ' class="dnxte_person dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_person_item ', $dnxte_attributes_output . ' class="dnxte_person_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_advanced_tab ', $dnxte_attributes_output . ' class="dnxte_advanced_tab dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_advanced_tab_item ', $dnxte_attributes_output . ' class="dnxte_advanced_tab_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_image_accordion ', $dnxte_attributes_output . ' class="dnxte_image_accordion dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_image_accordion_item ', $dnxte_attributes_output . ' class="dnxte_image_accordion_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_creative ', $dnxte_attributes_output . ' class="dnxte_team_creative dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_creative_item ', $dnxte_attributes_output . ' class="dnxte_team_creative_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_overlay ', $dnxte_attributes_output . ' class="dnxte_team_overlay dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_overlay_item ', $dnxte_attributes_output . ' class="dnxte_team_overlay_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_overlay_card ', $dnxte_attributes_output . ' class="dnxte_team_overlay_card dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_overlay_card_item ', $dnxte_attributes_output . ' class="dnxte_team_overlay_card_item dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_social_reveal ', $dnxte_attributes_output . ' class="dnxte_team_social_reveal dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_team_social_reveal_child ', $dnxte_attributes_output . ' class="dnxte_team_social_reveal_child dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_timeline ', $dnxte_attributes_output . ' class="dnxte_timeline dnxte_data_attributes ', $output );
						$output = str_replace( 'class="dnxte_timeline_child ', $dnxte_attributes_output . ' class="dnxte_timeline_child dnxte_data_attributes ', $output );
						break;
					case 'button':
						$output = str_replace( 'class="et_pb_button ', $dnxte_attributes_output . ' class="et_pb_button dnxte_data_attributes ', $output );
						$output = str_replace( 'class="et_pb_with_border ', $dnxte_attributes_output . ' class="et_pb_with_border dnxte_data_attributes ', $output );
						break;
					case 'css':
						if ( $dnxte_custom_attribute_css_selector ) {
							$output = str_replace( 'class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . '', $dnxte_attributes_output . ' class="' . ltrim( $dnxte_custom_attribute_css_selector, '.' ) . ' dnxte_data_attributes ', $output );
						}
						break;

					default:
						// code...
						break;
				}
			}
		}
		return $output;
	}
}
