<?php

defined( 'ABSPATH' ) || die();

trait CAToggles {
	public function parent_toggles( $modules ) {
		// Ensure we run this code only once because it's expensive.
		static $is_applied = false;
		if ( $is_applied ) {
			return $modules;
		}
		// Bail early if the modules list empty.
		if ( empty( $modules ) ) {
			return $modules;
		}

		foreach ( $modules as $module_slug => $module ) {
			// Ensure toggles and fields list exist.
			if ( ! isset( $module->settings_modal_toggles ) || ! isset( $module->fields_unprocessed ) ) {
				continue;
			}

			$toggles_list = $module->settings_modal_toggles;

			if ( isset( $toggles_list['custom_css'] ) && ! empty( $toggles_list['custom_css']['toggles'] ) ) {
				$toggles_list['custom_css']['toggles']['dnxte_attributes'] = array(
					'title'    => esc_html__( 'Custom Attributes', 'dnxte-divi-essential' ),
					'priority' => 220,
				);
				$modules[ $module_slug ]->settings_modal_toggles           = $toggles_list;
			}
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_on_off']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_add']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_css_selector']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_attributes_options']['vb_support'] );
		}
		$is_applied = true;

		return $modules;
	}
	public function child_toggles( $modules ) {
		static $is_applied = false;
		if ( $is_applied ) {
			return $modules;
		}

		if ( empty( $modules ) ) {
			return $modules;
		}

		foreach ( $modules as $module_slug => $module ) {
			if ( ! isset( $module->settings_modal_toggles ) || ! isset( $module->fields_unprocessed ) ) {
				continue;
			}

			$toggles_list = $module->settings_modal_toggles;

			if ( isset( $toggles_list['custom_css'] ) && ! empty( $toggles_list['custom_css']['toggles'] ) ) {
				$toggles_list['custom_css']['toggles']['dnxte_attributes'] = array(
					'title'    => esc_html__( 'Custom Attributes', 'dnxte-divi-essential' ),
					'priority' => 220,
				);
				$modules[ $module_slug ]->settings_modal_toggles           = $toggles_list;
			}
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_on_off']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_add']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_custom_attribute_css_selector']['vb_support'] );
			unset( $modules[ $module_slug ]->fields_unprocessed['dnxte_attributes_options']['vb_support'] );
		}
		$is_applied = true;

		return $modules;
	}
}
