<?php

defined( 'ABSPATH' ) || die();

class Extensions {

	public function __construct() {
		require_once DIVI_ESSENTIAL_DIR . 'includes/admin.php';
		require_once DIVI_ESSENTIAL_DIR . 'includes/assets-manager.php';
		require_once DIVI_ESSENTIAL_DIR . 'includes/functions.php';
		require_once DIVI_ESSENTIAL_DIR . 'includes/Traits/button-render.php';
		new Divi_Essential\Includes\Admin();
		new Divi_Essential\Includes\AssetsManager();

		$visibility_feature = get_option( 'dnxte_inactive_extensions', array() );
		$modules            = array(
			'popup-pro'         => 'popup-pro-extension',
			'custom-attributes' => 'custom-attributes-extension',
			'read-more'         => 'read-more-extension',
			'widget-library'    => 'dnxte-widget-extension',
			'shortcode-library' => 'dnxte-shortcode-extension',
			'clear-cache'       => 'dnxte-clear-cache-extension',
		);

		// file_exists(__DIR__."/$key/$key.php")
		foreach ( $modules as $key => $value ) {
			if ( ! in_array( $value, $visibility_feature ) && file_exists(__DIR__."/$key/$key.php" )) {
				require_once __DIR__."/$key/$key.php";
			}
		}
	}
}

if ( class_exists( 'Extensions' ) ) {
	new Extensions();
}
