<?php

defined( 'ABSPATH' ) || die();

Class GeneratePopup{

	const popup_icon = "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHZpZXdCb3g9IjAgMCAyMCAyMCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGcgY2xpcC1wYXRoPSJ1cmwoI2NsaXAwXzY5OTVfMTQzMCkiPgo8cGF0aCBkPSJNMTYuNjM3NiAxNi42MjUyVjIwSDBWMy4zNjI0M0gzLjM3NDg0VjQuNjA3NzZIMS4yNDUzM1YxOC43NTQ3SDE1LjM5MjNWMTYuNjI1MkgxNi42Mzc2WiIgZmlsbD0iI0E3QUFBRCIvPgo8cGF0aCBkPSJNNC42MDc3MyAwVjE1LjM5MjNIMjBWMEg0LjYwNzczWk0xOC43NTQ3IDE0LjE0NjlINS44NTMwNlYxLjI0NTMzSDE4Ljc1NDdWMTQuMTQ2OVoiIGZpbGw9IiNBN0FBQUQiLz4KPHBhdGggZD0iTTEwLjk3MDUgNy43NzEyOUw3LjA4MTY1IDExLjc1NjNMNy45NzI5MiAxMi42MjYxTDExLjg2MTggOC42NDEwNEwxMC45NzA1IDcuNzcxMjlaIiBmaWxsPSIjQTdBQUFEIi8+CjxwYXRoIGQ9Ik0xMi4zNDgyIDcuMjk3NjdINy44NjUwMVY4LjU0M0gxMi4zNDgyVjcuMjk3NjdaIiBmaWxsPSIjQTdBQUFEIi8+CjxwYXRoIGQ9Ik0xMi4zNTM3IDguNTE4MDdIMTEuMTA4NFYxMS42NTYzSDEyLjM1MzdWOC41MTgwN1oiIGZpbGw9IiNBN0FBQUQiLz4KPC9nPgo8ZGVmcz4KPGNsaXBQYXRoIGlkPSJjbGlwMF82OTk1XzE0MzAiPgo8cmVjdCB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIGZpbGw9IndoaXRlIi8+CjwvY2xpcFBhdGg+CjwvZGVmcz4KPC9zdmc+Cg==";

    public function __construct(){
		add_action( 'init', array( $this, 'register_dnexte_popup' ) );

		add_filter( 'et_builder_post_types', array( $this, 'active_in_builder' ) );

		add_action( 'admin_init', array( $this, 'toggle_modal_status' ) );
    }

    /**
	 * Register the custom post type 'dnxte_popup'.
	 *
	 * @return void
	 */
	public function register_dnexte_popup() {
		$labels = array(
			"name"               => __( "Popup", "dnxte-divi-essential" ),
			"singular_name"      => __( "Popup", "dnxte-divi-essential" ),
			'add_new'            => __( 'Add New', 'dnxte-divi-essential' ),
			'add_new_item'       => __( 'Add New', 'dnxte-divi-essential' ),
			'edit_item'          => __( 'Edit Popup', 'dnxte-divi-essential' ),
			'new_item'           => __( 'New Popup', 'dnxte-divi-essential' ),
			'view_item'          => __( 'View Popup', 'dnxte-divi-essential' ),
			'search_items'       => __( 'Search Popup', 'dnxte-divi-essential' ),
			'not_found'          => __( 'No Popup Found', 'dnxte-divi-essential' ),
			'not_found_in_trash' => __( 'No Popup found in Trash', 'dnxte-divi-essential' ),
			'parent_item_colon'  => __( 'Parent Popup:', 'dnxte-divi-essential' ),
			'menu_name'          => __( 'Popup Pro', 'dnxte-divi-essential' ),
		);

		$args = array(
			"label"               => __( "Popup Pro", "dnxte-divi-essential" ),
			"labels"              => $labels,
			"description"         => "",
			"hierarchical"        => false,
			"supports"            => array( "title", 'editor', "author" ),
			"public"              => true,
			"show_ui"             => true,
			"show_in_menu"        => true,
			"menu_position"       => 200,
			"menu_icon"           => self::popup_icon,
			"show_in_nav_menus"   => true,
			"exclude_from_search" => true,
			"has_archive"         => false,
			"query_var"           => true,
			'can_export'          => true,
			//"rewrite"           => true,
			"capability_type"     => "post",
			'show_in_rest'        => false,
		);

		register_post_type( "dnxte_popup", $args );
		flush_rewrite_rules();
	}

	/**
	 * Handles activation/deactivation of popups via action links
	 *
	 * Validates the nonce and updates the popup's active status in post meta.
	 * Called when clicking the activate/deactivate links in the popup list.
	 *
	 * @param int $post_id The ID of the popup post
	 * @return void
	 * @since 1.0.0
	 * @access public
	 */

	public function toggle_modal_status($modal_id) {
		// Get and sanitize inputs
		$validation_token = isset($_GET['dnxte_popup_nonce']) ? sanitize_text_field($_GET['dnxte_popup_nonce']) : '';
		$modal_trigger = isset($_GET['dnxte_popup_action']) ? sanitize_text_field($_GET['dnxte_popup_action']) : '';
		$modal_id = isset($_GET['post_id']) || wp_verify_nonce(sanitize_key($validation_token), $modal_trigger)
			? sanitize_text_field($_GET['post_id'])
			: '';

		// Toggle active status
		$updated_state = ($modal_trigger === 'true') ? 'false' : 'true';
		update_post_meta(
			$modal_id,
			'dnxte_popup-active',
			sanitize_text_field($updated_state)
		);

		return;
	}

	/**
	 * active builder for Popup Pro post type
	 *
	 * @param array $post_types The post types
	 * @since 1.0.0
	 * @access public
	 */
	public function active_in_builder( $post_types ) {
		$post_types[] = 'dnxte_popup';

		return $post_types;
	}

}

if ( class_exists( 'GeneratePopup' ) ) {
	new GeneratePopup();
}