<?php

defined( 'ABSPATH' ) || die();

Class PostManager{
    const MODULES_NONCE = 'dnxte_nonce';

    private $default_values = [
        'dnxte_trigger_on_scroll_offset_units' => 'px'
    ];
    public function __construct() {
        add_action( 'manage_dnxte_popup_posts_custom_column', array( $this, 'manage_columns' ), 10, 2 );
        add_filter( 'manage_edit-dnxte_popup_columns', array( $this, 'edit_columns' ) );
		add_action( 'add_meta_boxes', array( $this, 'meta_box' ) );
        add_action( 'save_post', array( $this, 'settings_save' ), 10, 2 );
        add_action( 'do_meta_boxes', array( $this, 'remove_default_custom_fields' ), 1, 3 );
		add_filter( 'post_row_actions', array( $this, 'modify_popup_action_links' ), 10, 2 );
    }

    /**
	 * Manage the custom columns for the 'dnxte_popup' post type.
	 *
	 * @param [type] $columns
	 * @param [type] $post_id
	 * @return void
	 */
	public function manage_columns( $column, $post_id ) {
    global $post;

    $columns = array(
        'unique_identifier' => function() use ($post) {
            echo esc_html( "popup_{$post->ID}" );
        },
        'active_status' => function() use ($post) {
            $status = get_post_meta( $post->ID, 'dnxte_popup-active', true ) ?: 'true';
            printf( '<span class="%s">%s</span>', esc_attr( $status === 'true' ? 'active' : 'inactive' ),
                esc_html__( $status === 'true' ? 'Active' : 'Inactive', 'popup-pro' ) );
        },
        'triggering_setting' => function() use ($post) {
            $triggering_setting = get_post_meta( $post->ID, 'dnxteppro_sub_triggering_settings', true );
            $options = array(
                'trigger_on_none'       => esc_html__( 'Click', 'popup-pro' ),
                'trigger_on_load'       => esc_html__( 'On Load', 'popup-pro' ),
                'trigger_on_scroll'     => esc_html__( 'On Scroll', 'popup-pro' ),
                'trigger_on_exit'       => esc_html__( 'On Exit', 'popup-pro' ),
                'trigger_on_inactivity' => esc_html__( 'On Inactivity', 'popup-pro' ),
            );
            if ( isset( $options[$triggering_setting] ) ) {
                printf( '<span class="%s">%s</span>', esc_attr( $triggering_setting ), esc_html( $options[$triggering_setting] ) );
            }
        }
    );

    if ( isset( $columns[$column] ) ) {
        $columns[$column]();
    }
}

    /**
	 * Manage the custom columns for the 'dnxte_popup' post type.
	 *
	 * @param [type] $columns
	 * @return void
	 */
	public function edit_columns( $columns ) {
		$columns = array(
			'cb'                 => '<input type="checkbox" />',
			'title'              => __( 'Title' ),
			'unique_identifier' => __( 'CSS ID' ),
			'active_status'      => __( 'Status' ),
			'triggering_setting' => __( 'Trigger Mode' ),
			'author'             => __( 'Author' ),
			'date'               => __( 'Date' )
		);

		return $columns;
	}

	/**
	 * Renders the Meta Box and its fields.
	 *
	 * @param WP_Post $post The post object.
	 *
	 * @return void
	 * @since 1.0.0
	 * @access public
	 *
	 */

	 public function dnxte_popup_pro_metabox_fields( $post ) {
		$screen = get_current_screen();
		wp_nonce_field( 'dnxte-popup-pro', 'dnxte-popup-pro-meta-box-nonce' );
		$asset = DIVI_ESSENTIAL_DIR . 'assets/extension/popup-pro.core.min.asset.php';
		if( !file_exists( $asset ) ){
		  return;
		}
		$asset = include $asset;
		if( file_exists( DIVI_ESSENTIAL_POPUP . '/core/data-manager.php' ) ) {
			include_once DIVI_ESSENTIAL_POPUP . '/core/data-manager.php';
        }

        $data_manager = new DataManager();

        $meta_data = $data_manager->get_popup_data( $post->ID );
        $roles = $data_manager->determineUserRoleSelection($post->ID);
        $post_types = $data_manager->getSelectablePostTypes();


		wp_enqueue_style( 'dnxte-popup-pro-admin', DIVI_ESSENTIAL_ASSETS . 'extension/popup-pro.core.min.css', ['wp-components'], $asset['version'], 'all' );
		wp_enqueue_script( 'dnxte-popup-pro-admin', DIVI_ESSENTIAL_ASSETS . 'extension/popup-pro.core.min.js', $asset['dependencies'], $asset['version'], true );

		wp_localize_script( 'dnxte-popup-pro-admin', 'popupProAdmin', [
		  'meta_data' => $meta_data,
		  'roles' => $roles,
		  'post_types' => $post_types,
    		'ajaxurl'           => admin_url('admin-ajax.php'),
    		self::MODULES_NONCE => wp_create_nonce(self::MODULES_NONCE),
    		'action'            => 'get_popup_posts',
		] );


		echo '<div id="popup-pro-body">
		          <div class="dnxte-popup-loader">
						<svg class="circle-svg" height="100" width="100">
						  <circle cx="50" cy="50" r="25"></circle>
						</svg>
					</div>
				</div>';
	}

    /**
	 * Adds meta boxes to appropriate WordPress screens.
	 *
	 * @return void
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function meta_box() {

		$screen = get_current_screen();

		if ( $screen->post_type == 'dnxte_popup' ) {
			add_meta_box(
				'dnxte-popup-custom-meta_box',/* The id of our meta box. */
				esc_html__( 'Popup Pro Settings', 'dnxte-divi-essential' ),/* The title of our meta box. */
				array( $this, 'dnxte_popup_pro_metabox_fields' ),/* The callback function that renders the metabox. */
				'dnxte_popup' /* The screen on which to show the box. */
			);
		}
	}

    /**
	 * Handle post meta
	 *
	 * @param array $request The request
	 * @param int $post_id The post ID
	 * @param string $meta_key The meta key
	 * @since 1.0.0
	 * @access public
	 */
	public static function handle_post_meta( $request, $post_id, $meta_key ) {
		if ( isset( $request[ $meta_key ] ) ) {
		    $value = $request[ $meta_key ];

			// if( empty($value) && !empty($this->default_value[$meta_key])){
			//      $value = $this->default_value[$meta_key];
			// }

			update_post_meta(
				$post_id,
				$meta_key,
				sanitize_text_field( $value )
			);
		}
		// else {
		// 	delete_post_meta( $post_id, $meta_key );
		// }

	}

    /**
	 * Called when this metabox is saved.
	 *
	 * Saves the new meta values of our metabox.
	 *
	 * @param int $post_id The post ID.
	 *
	 * @return int The post ID.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function settings_save( $post_id, $post ) {
    	$nonce = isset( $_POST['dnxte-popup-pro-meta-box-nonce'] ) ? sanitize_text_field( $_POST['dnxte-popup-pro-meta-box-nonce'] ) : '';

    	if ( $nonce == '' || ! wp_verify_nonce( $nonce, 'dnxte-popup-pro' ) ) {
    		return $post_id;
    	}

       	global $pagenow;
       	if ( 'post.php' != $pagenow ) {
      		return $post_id;
       	}

       	if ( 'dnxte_popup' !== get_post_type() ) {
      		return $post_id;
       	}

       	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
      		return;
       	}

        // error_log("dom5");
        // error_log(print_r($_POST, true));

        // return;

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup-active' );
		// /* Triggering settings */
		self::handle_post_meta( $_POST, $post_id, 'dnxteppro_sub_triggering_settings' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_manual_custom_css_selector' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_closing_css_selector' );



		// self::handle_post_meta( $_POST, $post_id, 'dnxte_hide_popup_slug_url' );


		self::handle_post_meta( $_POST, $post_id, 'trigger_on_load-delay-start' );
		self::handle_post_meta( $_POST, $post_id, 'trigger_on_load-delay-end' );
		self::handle_post_meta( $_POST, $post_id, 'trigger_autotrigger-periodicity' );
		self::handle_post_meta( $_POST, $post_id, 'trigger_autotrigger-periodicity-hours' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_auto_trigger_activity' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_auto_trigger_activity_certain_perion_from' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_auto_trigger_activity_certain_perion_to' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_on_scroll_offset' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_on_scroll_offset_units' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_on_inactivity_delay' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_remove_link' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_close_overlay_click' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_clickable_under_overlay' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_prevent_page_scrolling' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_close_clicking_back_button' );

		// Customization Tab
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_overlay_bg_color' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_pp_enable_overlay_blur' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_overlay_zindex' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_layout' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_place_name' );
		self::handle_post_meta( $_POST, $post_id, 'open_animation_name' );
		self::handle_post_meta( $_POST, $post_id, 'closing_animation_name' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_pop_up_pro_close_btn_position' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_custom_hide_close_btn' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_custom_close_btn_outside' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_color' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_bg_color' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_icon_size' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_padding_sync' ); // this is for sync top and bottom padding value
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_padding' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_bottom_padding' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_left_padding_sync' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_left_padding' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_right_padding' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_margin_sync' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_margin' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_bottom_margin' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_left_margin_sync' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_left_margin' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_right_margin' );

		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_border_radius_sync' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_left_border_radius' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_bottom_left_border_radius' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_top_right_border_radius' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_popup_pro_close_btn_bottom_right_border_radius' );


		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_auto_resp_disable_phone' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_auto_resp_disable_tablet' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_trigger_auto_resp_disable_desktop' );





		// self::handle_post_meta( $_POST, $post_id, 'dnxte_sub_set_sitearea_settings' );

		// User roles
		self::handle_post_meta( $_POST, $post_id, 'dnxte_limitation_user_roles_all' );
		self::handle_post_meta( $_POST, $post_id, 'dnxte_limitation_user_roles_guest' );
		global $wp_roles;
		if ( ! isset( $roles ) ) {
			$roles = new \WP_Roles();
		}

		foreach ( $roles->role_names as $role_key => $role_value ) {
			self::handle_post_meta( $_POST, $post_id, "dnxte_limitation_user_roles_$role_key" );
		}

		// $dnxte_popup_obj = isset( $_POST['dnxte_sub_set_sitearea_settings'] ) ? sanitize_text_field( $_POST['dnxte_sub_set_sitearea_settings'] ) : '';
		// $dnxte_popup_taxonomies = get_object_taxonomies( $dnxte_popup_obj, 'object' );

		// foreach ( $dnxte_popup_taxonomies as $key => $taxonomy ) {
		// 	if ( ! $taxonomy->public || $key == 'post_format' ) {
		// 		continue;
		// 	}

		// 	$dnxte_popup_terms = get_terms( $key, array( 'hide_empty' => false ) );
		// 	$dnxte_popup_term_names = "display_site_area_all_{$key}";
		// 	$dnxte_popup_term_values = isset( $_POST[ $dnxte_popup_term_names ] ) ? sanitize_text_field( $_POST[ $dnxte_popup_term_names ] ) : '';

		// 	if ( $dnxte_popup_term_values ) {
		// 		update_post_meta( $post_id, $dnxte_popup_term_names, $dnxte_popup_term_values );
		// 	} else {
		// 		delete_post_meta( $post_id, $dnxte_popup_term_names );
		// 	}

		// 	foreach ( $dnxte_popup_terms as $term ) {
		// 		$term_name = "dnxte_display_site_area_{$key}-{$term->slug}";
		// 		$term_value = isset( $_POST[ $term_name ] ) ? sanitize_text_field( $_POST[ $term_name ] ) : '';

		// 		if ( $term_value ) {
		// 			update_post_meta( $post_id, $term_name, $term_value );
		// 		} else {
		// 			delete_post_meta( $post_id, $term_name );
		// 		}
		// 	}
		// }


		if ( isset( $_POST['dnxte_config_display'] ) ) {
     	      $config_display = stripslashes($_POST['dnxte_config_display']); // phpcs:ignore

            $config_display = json_decode($config_display, true);




            for($i=0; $i<count($config_display); $i++){
                $dnxte_display_page = $config_display[$i]['dnxte_display_page'] ?? [];


                $postIds = array_map(function($item) {
                    return $item['value'] ?? '';
                }, $dnxte_display_page);

                $config_display[$i]['dnxte_display_page'] = $postIds;
            }

            $config_display = wp_json_encode( rest_sanitize_array( $config_display ) );


            update_post_meta(
         			$post_id,
         			'dnxte_config_display',
         			$config_display
            );
		} else {
			update_post_meta( $post_id, 'dnxte_config_display', '' );
		}

	}

    /**
	 * Remove default custom fields meta box from Popup Pro post type screen
	 *
	 * @param string $post_type The post type
	 * @param string $context The context for the meta box (normal, advanced, side)
	 * @param WP_Post $post The post object
	 * @since 1.0.0
	 * @access public
	 */

	public function remove_default_custom_fields( $post_type, $context, $post ) {
		remove_meta_box( 'postcustom', 'dnxte_popup', $context );
	}


    /**
     * Column Management
     * Add custom action links to active/deactived Popup.
     * @since 1.0.0
     * @param [type] $actions
     * @param [type] $post
     * @return void
     */
    public function modify_popup_action_links( $action_links, $popup_post ) {
        if ( $popup_post->post_type !== 'dnxte_popup' ) {
            return $action_links;
        }

        $popup_status = get_post_meta( $popup_post->ID, 'dnxte_popup-active', true );

        if ( empty( $popup_status ) ) {
            $popup_status = 'true';
        }

        $admin_base = admin_url( 'edit.php' );

        $url_params = [
            'post_type'          => 'dnxte_popup',
            'post_id'            => $popup_post->ID,
            'dnxte_popup_action' => $popup_status,
            'dnxte_popup_nonce'  => wp_create_nonce( 'dnxte_popup_pro_nonce' ),
        ];

        $action_url = add_query_arg( $url_params, $admin_base );

        $action_text = ( $popup_status === 'true' ) ? 'Deactivate' : 'Activate';

        $action_links['active_status'] = sprintf(
            '<a href="%1$s" target="_self">%2$s</a>',
            esc_url( $action_url ),
            $action_text
        );

        return $action_links;
    }

}

if ( class_exists( 'PostManager' ) ) {
	new PostManager();
}
