<?php

defined( 'ABSPATH' ) || die();

class DataManager{
    public $meta_data = [];
    public $roles = null;


    public function __construct() {
        $this->set_default_meta_key();
    }

    public function get_popup_data($id) {
        if (empty($id)) {
            return $this->meta_data;
        }

        foreach ($this->meta_data as $key => $value) {
            if(!empty($result = get_post_meta($id, $key, true))){
                $this->meta_data[$key] = get_post_meta($id, $key, true);
            }
        }
        $this->meta_data['post_id'] = $id;


        $display_config = get_post_meta($id, 'dnxte_config_display', true);

        $this->meta_data['dnxte_config_display'] = json_decode($display_config);

        if(empty($this->meta_data['dnxte_config_display'])){
            $this->meta_data['dnxte_config_display'] = [
                [
                    'display_condition' => 'include',
                    'display_config_post_type' => 'sitewide',
                    'dnxte_display_page' => [[
                        'value' => '',
                        'label' => 'All'
                    ]]
                ]
            ];
        }else{
            foreach($this->meta_data['dnxte_config_display'] as $key => $value) {
                $posts = [];
                $postIds = isset($value->dnxte_display_page) ? $value->dnxte_display_page : [];

                $spaceIndex = array_search('', $postIds); // this is "all" post selected


                global $wpdb;

                if (!empty($postIds)) {
                    $placeholders = implode(',', array_fill(0, count($postIds), '%d'));
                    $query = "SELECT ID as value, post_title as label FROM {$wpdb->posts} WHERE ID IN ($placeholders)";
                    $query = $wpdb->prepare($query, $postIds); // phpcs:ignore

                    $posts = $wpdb->get_results($query, ARRAY_A); // phpcs:ignore
                } else {
                    $posts = [];
                }

                if($spaceIndex !==false){
                    array_splice($posts, $spaceIndex, 0, [['value' => '', 'label' => 'All']]);
                }

                $this->meta_data['dnxte_config_display'][$key]->dnxte_display_page = $posts;
            }
        }




        if(empty($this->roles)) {
            $this->roles = $this->getUserRoles();
        }

        foreach ( $this->roles->role_names as $role_key => $role_name ) {
            $field_key = "dnxte_limitation_user_roles_$role_key";
            $this->meta_data[$field_key] = get_post_meta( $id, $field_key, true );
        }

        return $this->meta_data;
    }

    public function set_default_meta_key() {
        $this->meta_data = array(
            'dnxte_popup-active'                    => 'true',
            'dnxteppro_sub_triggering_settings'     => 'trigger_on_load',
            'dnxte_manual_custom_css_selector'      => '',
            'dnxte_closing_css_selector'            => '',
            'dnxte_remove_link'                     => 'true',
            'dnxte_close_overlay_click'             => 'true',
            'dnxte_clickable_under_overlay'         => 'false',
            'dnxte_prevent_page_scrolling'          => 'true',
            'dnxte_close_clicking_back_button'      => 'true',
            'trigger_autotrigger-periodicity'       => 'every_time',
            'trigger_autotrigger-periodicity-hours' => '24',
            'dnxte_auto_trigger_activity'           => 'always',
            'dnxte_auto_trigger_activity_certain_perion_from' => '',
            'dnxte_auto_trigger_activity_certain_perion_to'   => '',
            'trigger_on_load-delay-start'        => '0',
            'trigger_on_load-delay-end'          => '0',
            'dnxte_trigger_on_scroll_offset'           => '0',
            'dnxte_trigger_on_scroll_offset_units'     => 'px',
            'dnxte_trigger_on_inactivity_delay'        => '0',
            'dnxte_popup_pro_title'             => '',
            'dnxte_popup_pro_overlay_bg_color'  => '',
            'dnxte_popup_pro_overlay_zindex'    => '',
            'dnxte_pp_enable_overlay_blur'      => true,
            'dnxte_custom_hide_close_btn'       => false,
            'dnxte_custom_close_btn_outside'    => false,
            'open_animation_name'               => '',
            'closing_animation_name'            => '',
            'dnxte_popup_pro_close_btn_color'   => '',
            'dnxte_popup_pro_close_btn_bg_color'   => '',
            'dnxte_popup_pro_close_btn_icon_size'   => '',
            'dnxte_popup_pro_close_btn_bottom_padding'   => '',
            'dnxte_popup_pro_close_btn_left_padding_sync'   => '',
            'dnxte_popup_pro_close_btn_left_padding'   => '',
            'dnxte_popup_pro_close_btn_top_padding_sync'   => '',
            'dnxte_popup_pro_close_btn_top_padding'   => '',
            'dnxte_popup_layout'   => 'box',
            'dnxte_popup_pro_close_btn_border_radius_sync'   => '',
            'dnxte_popup_pro_close_btn_bottom_left_border_radius'   => '',
            'dnxte_popup_pro_close_btn_bottom_right_border_radius'   => '',
            'dnxte_popup_pro_close_btn_top_right_border_radius'   => '',
            'dnxte_popup_pro_close_btn_top_left_border_radius'   => '',
            'dnxte_popup_pro_close_btn_border_radius'   => '',
            'dnxte_popup_pro_close_btn_right_padding'   => '',
            'dnxte_popup_pro_close_btn_top_margin_sync'   => '',
            'dnxte_popup_pro_close_btn_top_margin'   => '',
            'dnxte_popup_pro_close_btn_bottom_margin'   => '',
            'dnxte_popup_pro_close_btn_left_margin_sync'   => '',
            'dnxte_popup_pro_close_btn_left_margin'   => '',
            'dnxte_popup_pro_close_btn_right_margin'   => '',
            'dnxte_popup_pro_place_name'   => 'center_center',
            'dnxte_pop_up_pro_close_btn_position'   => 'top_right',

            // display condition
            'display_site_area' => '',
            'dnxte_sub_set_sitearea_settings' => '',
            'dnxte_limitation_user_roles_all' => 'on',
            'dnxte_limitation_user_roles_guest' => '',
            'dnxte_trigger_auto_resp_disable_phone' => '',
            'dnxte_trigger_auto_resp_disable_tablet' => '',
            'dnxte_trigger_auto_resp_disable_desktop' => '',
        );
    }
    public function determineUserRoleSelection($post_id) {
        $user_role_selected = false;
        if(empty($this->roles)) {
            $this->roles = $this->getUserRoles();
        }

        if ( $this->meta_data['dnxte_limitation_user_roles_guest'] === 'on' ) {
            $user_role_selected = true;
        } else {
            foreach ( $this->roles->role_names as $role_key => $role_name ) {
                if ( get_post_meta( $post_id, "dnxte_limitation_user_roles_$role_key", true ) === 'on' ) {
                    $user_role_selected = true;
                    break;
                }
            }
        }

        if ( empty( $this->meta_data['limitation_user_roles_all'] ) && ! $user_role_selected ) {
            $this->meta_data['dnxte_limitation_user_roles_all'] = 'on';
        }

        return $this->roles->role_names;
    }

    protected function getUserRoles() {
        global $wp_roles;
        if ( ! isset( $wp_roles ) ) {
            // phpcs:ignore
            $wp_roles = new \WP_Roles();

        }
        return $wp_roles;
    }
    public function getSelectablePostTypes() {
        $post_types = get_post_types(
            [
                'public'   => true,
                '_builtin' => false,
            ],
            'objects'
        );

        $selectable = [
            'sitewide' => 'Sitewide',
            'page'     => 'Pages',
            'post'     => 'Posts',
        ];

        foreach ($post_types as $post_type) {
            $selectable[$post_type->name] = $post_type->label;
        }
        unset($selectable['dnxte_popup']);
        return $selectable;
    }
}
if ( class_exists( 'DataManager' ) ) {
	new DataManager();
}
