<?php

defined( 'ABSPATH' ) || die();

class Enqueue
{


	const MODULES_NONCE = 'dnxte_nonce';

	public $style_files  = array();
	public $script_files = array();

	public $admin_style_files  = array();
	public $admin_script_files = array();
	protected $assets_url      = DIVI_ESSENTIAL_ASSETS . 'admin/';
	protected $assets_path     = DIVI_ESSENTIAL_PATH . '/assets/';
	protected $admin_assets_path     = DIVI_ESSENTIAL_PATH . '/assets/admin/';

	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'enqueue_assets'));
		add_action('wp_footer', array($this, 'print_markup'));
		add_filter(
			'et_builder_load_actions',
			function ($builder_load_requests) {
				$builder_load_requests[] = 'print_markup';
				return $builder_load_requests;
			}
		);

		$this->get_style_files();
		$this->get_script_files();
	}

	/**
	 * Enqueue frontend assets for Popup Pro
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function enqueue_assets()
	{
		if (is_admin()) {
			return;
		}
		foreach ($this->style_files as $file) {
			$path = DIVI_ESSENTIAL_ASSETS . "css/$file.css";
			$version = filemtime($this->assets_path . "css/$file.css");
			wp_enqueue_style("popup-pro-$file", $path, $version);
		}
		foreach ($this->script_files as $script) {
			wp_enqueue_script($script['handle'], $script['src'], $script['deps'], $script['ver'], $script['in_footer']);
		}
	}
	/**
	 * Renders the popup content in the frontend
	 *
	 * Takes a post data object and renders the popup content using the Divi builder shortcode.
	 * Processes the popup content and applies styles before displaying it on the frontend.
	 *
	 * @return string The rendered popup HTML markup
	 * @since 1.0.0
	 * @access public
	 */
	public function print_markup()
	{
		if ( function_exists( 'et_builder_is_frontend' ) && ! et_builder_is_frontend() ) {
			return;
		}

		global $post;

		$current_post_type = get_post_type( get_the_ID() ); // get the post type from the currently visited post
		$global_post_id    = get_the_ID();

		$args = array(
			'post_type'  => 'dnxte_popup',
			'posts_per_page'   => -1,
			'post_status' => 'publish',
			'meta_query' => array( // phpcs:ignore
				array(
					'key'     => 'dnxte_popup-active',
					'value'   => 'true',
					'compare' => '='
				)
			)
		);

		$popups = get_posts($args);

		$dnxtePopups = '';
		$popup_markups 		   = [];
		$trigger_event         = '';
		$dnxte_custom_selector = '';
		$popup_arr             = array(
			'popup_ids' => []
		);
		$trigger_values = [];
		foreach ( $popups as $popup ) {

			$post_id                             = $popup->ID;
			$dnxteppro_sub_setting_name_selected = get_post_meta(
				$post_id,
				'dnxteppro_sub_triggering_settings',
				true
			);
			//                echo $post_id.$dnxteppro_sub_setting_name_selected;
			$status                            = get_post_meta( $post_id, 'dnxte_popup-active' )[0];
			$opening_animation                 = $this->get_post_meta_content( $post_id, 'open_animation_name' );
			$closing_animation                 = $this->get_post_meta_content( $post_id, 'closing_animation_name' );
			$close_btn_position                = $this->get_post_meta_content( $post_id, 'dnxte_pop_up_pro_close_btn_position' );
			$popup_position                    = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_place_name' );
			$dnxte_limitation_user_roles_all   = $this->get_post_meta_content( $post_id, 'dnxte_limitation_user_roles_all' );
			$dnxte_limitation_user_roles_guest = $this->get_post_meta_content( $post_id, 'dnxte_limitation_user_roles_guest' );
			$dnxte_custom_hide_close_btn       = $this->get_post_meta_content( $post_id, 'dnxte_custom_hide_close_btn' );
			$dnxte_custom_close_btn_outside    = $this->get_post_meta_content( $post_id, 'dnxte_custom_close_btn_outside' );
			$dnxte_pp_enable_overlay_blur      = $this->get_post_meta_content( $post_id, 'dnxte_pp_enable_overlay_blur' );
			$dnxte_close_overlay_click         = $this->get_post_meta_content( $post_id, 'dnxte_close_overlay_click' );
			$dnxte_remove_link                 = $this->get_post_meta_content( $post_id, 'dnxte_remove_link' );
			$dnxte_closing_css_selector        = $this->get_post_meta_content( $post_id, 'dnxte_closing_css_selector' );
			$dnxte_close_clicking_back_button  = $this->get_post_meta_content( $post_id, 'dnxte_close_clicking_back_button' );
			$dnxte_clickable_under_overlay     = $this->get_post_meta_content( $post_id, 'dnxte_clickable_under_overlay' );
			$dnxte_prevent_page_scrolling      = $this->get_post_meta_content( $post_id, 'dnxte_prevent_page_scrolling' );
			$dnxte_disable_phone               = $this->get_post_meta_content( $post_id, 'dnxte_trigger_auto_resp_disable_phone' );
			$dnxte_disable_tablet              = $this->get_post_meta_content( $post_id, 'dnxte_trigger_auto_resp_disable_tablet' );
			$dnxte_disable_desktop             = $this->get_post_meta_content( $post_id, 'dnxte_trigger_auto_resp_disable_desktop' );


			// Trigger Event
			$trigger_event = $this->get_post_meta_content( $post_id, 'dnxteppro_sub_triggering_settings' );

			$trigger_delay_start = 'trigger_on_load' === $trigger_event ? $this->get_post_meta_content( $post_id, 'trigger_on_load-delay-start' ) : '';
			$trigger_delay_end   = 'trigger_on_load' === $trigger_event ? $this->get_post_meta_content( $post_id, 'trigger_on_load-delay-end' ) : '';

			$clickable_under_overlay = "true" === $dnxte_clickable_under_overlay ? "dnxte-clickable-under-overlay" : "";


			$defaults = array(
			     'hide_close_button' => 'false',
				'close_btn_outside' => 'false',
				'close_overlay_click' => 'false',
				'remove_link' => 'false',
				'close_clicking_back_button' => 'false',
				'prevent_page_scrolling' => 'false',
				'clickable_under_overlay' => 'false',
			);

			$popup_data = array(
				'opening_animation'          => esc_attr( $opening_animation ),
				'closing_animation'          => esc_attr( $closing_animation ),
				'close_btn_position'         => esc_attr( $close_btn_position ),
				'trigger_event'              => esc_attr( $trigger_event ),
				'trigger_delay_start'        => esc_attr( $trigger_delay_start ),
				'trigger_delay_end'          => esc_attr( $trigger_delay_end ),
				'hide_close_button'          => esc_attr( $dnxte_custom_hide_close_btn ),
				'close_btn_outside'          => esc_attr( $dnxte_custom_close_btn_outside ),
				'close_overlay_click'        => esc_attr( $dnxte_close_overlay_click ),
				'remove_link'                => esc_attr( $dnxte_remove_link ),
				'closing_css_selector'       => esc_attr( $dnxte_closing_css_selector ),
				'close_clicking_back_button' => esc_attr( $dnxte_close_clicking_back_button ),
				'prevent_page_scrolling'     => esc_attr( $dnxte_prevent_page_scrolling ),
				'clickable_under_overlay'    => esc_attr( $clickable_under_overlay ),
				'dnxte_disable_tablet'       => esc_attr( $dnxte_disable_tablet ),
				'dnxte_disable_desktop'      => esc_attr( $dnxte_disable_desktop ),
				'dnxte_disable_phone'        => esc_attr( $dnxte_disable_phone ),
			);


			$popup_data = $this->fillEmptyValues($defaults, $popup_data);

			$popup_data_json = wp_json_encode( $popup_data );

			$current_user_role = 'guest';
			$frontend_display  = false;

			if ( is_user_logged_in() ) {
				$current_user      = wp_get_current_user();
				$current_user_role = $current_user->roles[0];
			}
			$dnxte_limitation_user_roles_all = get_post_meta( $post_id, 'dnxte_limitation_user_roles_all', true );

			if ( $dnxte_limitation_user_roles_all === 'on' ) {
				$frontend_display = true;
			} else if (get_post_meta($post_id, "dnxte_limitation_user_roles_$current_user_role", true) === 'on') {
				$frontend_display = true;
			}


			// Site Area start -------------------------------
			if ( $frontend_display ) {

				$dnxte_config_display = get_post_meta($post_id, 'dnxte_config_display', true);
				$condition_data       = json_decode($dnxte_config_display);




				$includes = [];
				$excludes = [];
				if ( $condition_data ) {
					foreach ( $condition_data as $condition ) {
						if ( $condition->display_condition == 'include' ) {
							$includes[] = $condition->display_config_post_type;
							if ( isset( $condition->dnxte_display_page ) ) {
								$includes[$condition->display_config_post_type] = array_filter($condition->dnxte_display_page, function ($value) {
									return ! is_null($value) && $value !== '';
								});
							}
						} elseif ( $condition->display_condition == 'exclude' ) {
							$excludes[] = $condition->display_config_post_type;
							if ( isset( $condition->dnxte_display_page ) ) {
								$excludes[$condition->display_config_post_type] = array_filter($condition->dnxte_display_page, function ($value) {
									return ! is_null($value) && $value !== '';
								});
							}
						}
					}


					$sitewide = in_array( 'sitewide', $includes );

					if ( ! $sitewide ) { // include not sitewide
						$exits_post_type = array_key_exists( $current_post_type, $includes ); // current post type is include or not
						if ( $exits_post_type ) { // if post type exits in include then enter condition
							if (is_array($includes[$current_post_type]) && count($includes[$current_post_type])) {
								$post_id_exits = in_array( $global_post_id, $includes[ $current_post_type ] );
							} else {
								$post_id_exits = true; // Means all tag selected in dropdown
							}
							if ( $post_id_exits ) {  // if post id match with include
								$exits_post_type_exclude = array_key_exists( $current_post_type, $excludes ); // post type exclude
								if ($exits_post_type_exclude && count($excludes) > 1) { // if post type exclude then it will disclude
									$exclude_post_exits = in_array( $global_post_id, $excludes[ $current_post_type ] );
									if ($exclude_post_exits || (is_array($excludes[$current_post_type]) && !count($excludes[$current_post_type]))) {
										$frontend_display = false;
									} else {
										$frontend_display = true;
									}
								} else { // Other the will show
									$frontend_display = true;
								}
							} else {
								$frontend_display = false;
							}
						} else {
							$frontend_display = false;
						}
					} else {
						$exits_post_type_exclude = array_key_exists( $current_post_type, $excludes ); // post type exclude
						if ($exits_post_type_exclude && count($excludes) > 1) { // if post type exclude then it will disclude
							$exclude_post_exits = in_array( $global_post_id, $excludes[ $current_post_type ] );
							if ($exclude_post_exits || (is_array($excludes[$current_post_type]) && !count($excludes[$current_post_type]))) {
								$frontend_display = false;
							} else {
								$frontend_display = true;
							}
						} else { // Other the will show
							$frontend_display = true;
						}
					}
				}
			}
			// Site area end --------------------------------

			// Activity start -- Convert metabox to json to access from js files


			$dnxte_auto_trigger_activity = get_post_meta(
				$post_id,
				'dnxte_auto_trigger_activity',
				true
			);

			if('trigger_on_none' === $dnxteppro_sub_setting_name_selected){
			    $dnxte_auto_trigger_activity = 'always';
			}

			if( 'trigger_on_none' !== $dnxteppro_sub_setting_name_selected ){
    			if ( empty( $dnxte_auto_trigger_activity ) ) {
    				$dnxte_auto_trigger_activity = 'always';
    			}
    			$dnxte_activity_from = get_post_meta(
    				$post_id,
    				'dnxte_auto_trigger_activity_certain_perion_from',
    				true
    			);
    			$dnxte_activity_to   = get_post_meta(
    				$post_id,
    				'dnxte_auto_trigger_activity_certain_perion_to',
    				true
    			);
			}

			$today           = gmdate( 'Y-m-d', time() );
			$activity_status = false;
			if ( 'always' != $dnxte_auto_trigger_activity && ( $today >= gmdate( 'Y-m-d', strtotime( $dnxte_activity_from ) ) ) && ( $today <= gmdate( 'Y-m-d', strtotime( $dnxte_activity_to ) ) ) ) {
				$activity_status = true;
			} else if ('always' == $dnxte_auto_trigger_activity) {
				$activity_status = true;
			}
			// End of activity functionality . Output $activity_status = true means popup will be shown
			/* periodicity functionality working start */


			$popup_show = true;
			if ($activity_status) // If activity status is enabled
			{
				if (isset($_COOKIE["dxnteHours" . $post_id])):
					$popup_show = false;
				else:
					$popup_show = true;
				endif;
			} else {  // If activity status is disabled
				$popup_show = false;
			}



			/** @var  $trigger_autotrigger_periodicity */
			$trigger_autotrigger_periodicity = get_post_meta(
				$post_id,
				'trigger_autotrigger-periodicity',
				true
			);

			$trigger_autotrigger_periodicity_hours = get_post_meta(
				$post_id,
				'trigger_autotrigger-periodicity-hours',
				true
			);

			if ( empty( $trigger_autotrigger_periodicity ) ) {
				$trigger_autotrigger_periodicity = 'every_time';
			}

			if ( 'every_time' == $trigger_autotrigger_periodicity ) {
				$trigger_autotrigger_periodicity_hours = 0;
			}

			if ( $trigger_autotrigger_periodicity === 'once_only' ) {
				$trigger_autotrigger_periodicity_hours = 24 * 365;
			}

			if (isset($_COOKIE["dxnteHours" . $post_id]) && 'every_time' != $trigger_autotrigger_periodicity) {
				$popup_show = false;
			};

			$dnxte_custom_selector = get_post_meta(
				$post_id,
				'dnxte_manual_custom_css_selector',
				true
			);

			$dnxte_popup_layout = get_post_meta(
				$post_id,
				'dnxte_popup_layout',
				true
			);

			$css_class = $css_id = '';
			if ( strpos( $dnxte_custom_selector, '.' ) === 0 ) {
				$css_class = substr( $dnxte_custom_selector, 1 );
			} else if (strpos($dnxte_custom_selector, '#') === 0) {
				$css_id = substr( $dnxte_custom_selector, 1 );
			}

			// periodicity and activity functionality end here
			if ($status === 'true' && $frontend_display && $popup_show) { //&& $frontend_display
				if ('full_width' == $dnxte_popup_layout)
				$popup_position = '';

				$this_popup = sprintf(
					'<div id="dnxte_popup_%1$s" data-id="%1$s" class="clr-both dnxte_popups_counting active dnxte_popup_pro_%3$s dnxte_popup_content dnxte_popup_content_%1$s dnxte_popup_pro_position_%5$s dnxte_popup_pro_layout_%8$s" data-popup=%4$s><div id="page-container">%2$s</div></div>',
					esc_attr( $post_id ),
					$this->show_popup_layout($popup),
					esc_attr( $opening_animation ),
					$popup_data_json,
					esc_attr($popup_position), //5
					esc_attr( $css_id ),
					esc_attr( $css_class ),
					esc_attr( $dnxte_popup_layout )
				);
				$popup_markups[esc_attr($post_id)] = $this_popup;
				$dnxtePopups .= $this_popup;

				$popup_arr["json_data" . $post_id]          = $popup_data_json;
				$popup_arr["custom_selector" . $post_id]    = $dnxte_custom_selector;
				$popup_arr["popup_ids"][]                     = $post_id;
				$popup_arr["popup_show" . $post_id]         = $popup_show;
				$popup_arr["popup_perodicity" . $post_id]   = $trigger_autotrigger_periodicity;
				$popup_arr["periodicity_cookie" . $post_id] = (int) $trigger_autotrigger_periodicity_hours * 3600 * 1000; // in miliseconds
			}
			//        scroll offset Start
			$scroll_offset       = get_post_meta(
				$post_id,
				'dnxte_trigger_on_scroll_offset',
				true
			);
			$scroll_offset_units = get_post_meta(
				$post_id,
				'dnxte_trigger_on_scroll_offset_units',
				true
			);
//        Scroll offset End

//            inacvity start
			$inacvity_delays = get_post_meta(
				$post_id,
				'dnxte_trigger_on_inactivity_delay',
				true
			);
//            Inacvity end

			$trigger_values[ $post_id ] = array(
				'onload'                => [],
				'onscroll_offset'       => (int) $scroll_offset,
				'onscroll_offset_units' => !empty($scroll_offset_units) ? $scroll_offset_units : 'px',
				'onexit'                => '',
				'oninactivity_delays'   => $inacvity_delays,
			);

		}

		$dnxte_popup_show    = wp_json_encode( $popup_arr );
		$trigger_values_json = wp_json_encode( $trigger_values );

		wp_localize_script('popup-pro-frontend', 'popup_frontend', array(
			'custom_css_selector' => $dnxte_custom_selector,
			'dnxte_popup_show'    => $dnxte_popup_show,
			'trigger_event'       => $trigger_values_json,
			'popup_markups'		  => $popup_markups
		));

		print "<div id='dnxte_popup' style='display:none;'>$dnxtePopups</div>"; // phpcs:ignore
	}

	/**
	 * show pop layout
	 *
	 * @param object $post_data The post data
	 * @since 1.0.0
	 * @access public
	 */
	public function show_popup_layout( $post_data ) {
		$divi_library_shortcode = do_shortcode( $post_data->post_content );
		$this->popup_pro_styles( $post_data->ID );
		return $divi_library_shortcode;
	}

	protected function popup_pro_styles( $post_id ) {
		$overlay_bg_color                         = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_overlay_bg_color' );
		$close_btn_color                          = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_color' );
		$close_btn_bg_color                       = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_bg_color' );
		$close_btn_icon_size                      = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_icon_size' );
		$dnxte_popup_pro_close_btn_top_padding    = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_top_padding' );
		$dnxte_popup_pro_close_btn_bottom_padding = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_bottom_padding' );
		$dnxte_popup_pro_close_btn_left_padding   = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_left_padding' );
		$dnxte_popup_pro_close_btn_right_padding  = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_right_padding' );

		$dnxte_popup_pro_close_btn_top_margin    = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_top_margin' );
		$dnxte_popup_pro_close_btn_bottom_margin = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_bottom_margin' );
		$dnxte_popup_pro_close_btn_left_margin   = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_left_margin' );
		$dnxte_popup_pro_close_btn_right_margin  = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_right_margin' );

		$dnxte_popup_pro_close_btn_top_left_border_radius     = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_top_left_border_radius' );
		$dnxte_popup_pro_close_btn_top_right_border_radius    = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_top_right_border_radius' );
		$dnxte_popup_pro_close_btn_bottom_right_border_radius = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_bottom_right_border_radius' );
		$dnxte_popup_pro_close_btn_bottom_left_border_radius  = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_close_btn_bottom_left_border_radius' );
		$dnxte_pp_enable_overlay_blur                         = $this->get_post_meta_content( $post_id, 'dnxte_pp_enable_overlay_blur' );

		$dnxte_popup_pro_overlay_zindex = $this->get_post_meta_content( $post_id, 'dnxte_popup_pro_overlay_zindex' );

		print '<style type="text/css">';
		$style = print sprintf(
			'.mfp-bg.dnxte_popup_custom_%1$s {
            background-color: %2$s !important;
            z-index: %18$s !important;
            %19$s
        }
        .mfp-wrap.dnxte_popup_custom_%1$s button.mfp-close{
            color: %3$s !important;
            background: %4$s !important;
            font-size: %5$spx !important;
            padding-top: %6$spx !important;
            padding-bottom: %7$spx !important;
            padding-left: %8$spx !important;
            padding-right: %9$spx !important;
            margin-top: %10$spx !important;
            margin-bottom: %11$spx !important;
            margin-left: %12$spx !important;
            margin-right: %13$spx !important;
            border-top-left-radius: %14$s !important;
            border-top-right-radius: %15$s !important;
            border-bottom-right-radius: %16$s !important;
            border-bottom-left-radius: %17$s !important;
        }',
			esc_attr($post_id),
			esc_attr( $overlay_bg_color ),
			esc_attr( $close_btn_color ),
			esc_attr( $close_btn_bg_color ),
			esc_attr( $close_btn_icon_size ),
			esc_attr( $dnxte_popup_pro_close_btn_top_padding ),
			esc_attr( $dnxte_popup_pro_close_btn_bottom_padding ),
			esc_attr( $dnxte_popup_pro_close_btn_left_padding ),
			esc_attr( $dnxte_popup_pro_close_btn_right_padding ),
			esc_attr( $dnxte_popup_pro_close_btn_top_margin ), // 10
			esc_attr( $dnxte_popup_pro_close_btn_bottom_margin ),
			esc_attr( $dnxte_popup_pro_close_btn_left_margin ),
			esc_attr( $dnxte_popup_pro_close_btn_right_margin ),
			esc_attr( $dnxte_popup_pro_close_btn_top_left_border_radius ) . '%',
			esc_attr( $dnxte_popup_pro_close_btn_top_right_border_radius ) . '%',
			esc_attr( $dnxte_popup_pro_close_btn_bottom_right_border_radius ) . '%',
			esc_attr( $dnxte_popup_pro_close_btn_bottom_left_border_radius ) . '%',
			esc_attr( $dnxte_popup_pro_overlay_zindex ),
			esc_attr('true') === $dnxte_pp_enable_overlay_blur ? esc_attr('backdrop-filter: blur(2px);') : ''
		);

		print '</style>';
		return $style;
	}

	protected function get_post_meta_content( $post_id, $meta_key ) {
		$overlay_bg_color = get_post_meta( $post_id, $meta_key );
		if ( count( $overlay_bg_color ) > 0 ) {
			return $overlay_bg_color[0];
		}

		return '';
	}

	protected function get_style_files()
	{
		$this->style_files = array(
			'magnific-popup',
			'animate.min',
			'popupanimation',
			'hover-common',
			'popup-pro',
		);
	}

	protected function get_script_files()
	{
		$this->script_files = array(
			array(
				'handle'    => 'popup-pro-magnific-popup.min',

				'src'       => DIVI_ESSENTIAL_ASSETS . "js/magnific-popup.min.js",
				'deps'      => array(
					'jquery',
				),
				'ver'       => filemtime($this->assets_path . "js/magnific-popup.min.js"),
				'in_footer' => true,
			),
			array(
				'handle'    => 'popup-pro-frontend',
				'src'       => DIVI_ESSENTIAL_ASSETS . "js/popup-pro.js",
				'deps'      => array(
					'jquery',
					'popup-pro-magnific-popup.min',
				),
				'ver'       => filemtime($this->assets_path . "js/popup-pro.js"),
				'in_footer' => true,
			),
		);
	}

	private function fillEmptyValues($obj, $obj2) {
        foreach ($obj as $key => $value) {
            if (array_key_exists($key, $obj2) && $obj2[$key] === "") {
                $obj2[$key] = $value;
            }
        }

        return $obj2;
	}
}

if ( class_exists( 'Enqueue' ) ) {
	new Enqueue();
}
