<?php

namespace Divi_Essential\Includes;

defined( 'ABSPATH' ) || die();

/**
 * The Popup class.
 *
 * This class is responsible for rendering a custom post type and custom meta box in WordPress with user-defined fields/options.
 *
 * @since             1.0.0
 * @package           popup
 *
 */
class DnxtePopupPro {

	/**
	 * Popup constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		//  Don't Remove this line
        if ( defined( 'POPR_POPUP_PRO_VERSION' ) ) {
            return;
        }
		if( file_exists( DIVI_ESSENTIAL_POPUP . '/core/enqueue.php' ) ) {
			require_once DIVI_ESSENTIAL_POPUP . '/core/enqueue.php';
		}
		if( file_exists( DIVI_ESSENTIAL_POPUP . '/core/core.php' ) ) {
			require_once DIVI_ESSENTIAL_POPUP . '/core/core.php';
		}
	}

}

(new DnxtePopupPro());
