<?php
defined( 'ABSPATH' ) || die();

trait RMAssets {
	public function styles( $props, $render_slug ) {
		wp_enqueue_style( 'dnext_read_more_css' );
		$dnxte_rm_readmore_custom_css = isset( $props['dnxte_rm_custom_css'] ) ? $props['dnxte_rm_custom_css'] : '';

		if ( ! empty( $props['dnxte_rm_link_color'] ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%%~ .expand-bar',
					'declaration' => sprintf(
						'color: %1$s',
						esc_html( $props['dnxte_rm_link_color'] )
					),
				)
			);
		}

		if ( et_builder_is_hover_enabled( 'dnxte_rm_readmore_link_color', $props ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% ~.expand-bar:hover',
					'declaration' => sprintf(
						'color: %1$s;',
						esc_html( $props['dnxte_rm_readmore_link_color__hover'] )
					),
				)
			);
		}

		if ( ! empty( $props['dnxte_rm_font_size'] ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% ~.expand-bar,%%order_class%%~.expand-bar i::before,%%order_class%%~.expand-bar i::after',
					'declaration' => sprintf(
						'font-size: %1$s;',
						esc_html( $props['dnxte_rm_font_size'] )
					),
				)
			);
		}

		if ( ! empty( $props['dnxte_rm_font'] ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% ~.expand-bar',
					'declaration' => et_builder_set_element_font( $props['dnxte_rm_font'] ),
				)
			);
		}

		if ( ! empty( $props['dnxte_rm_text_align'] ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% ~.expand-bar',
					'declaration' => sprintf(
						'text-align: %1$s;',
						esc_attr( $props['dnxte_rm_text_align'] )
					),
				)
			);
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% ~.expand-bar',
					'declaration' => sprintf(
						'display: block;'
					),
				)
			);
		}

		if ( ! empty( $dnxte_rm_readmore_custom_css ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%%~.expand-bar',
					'declaration' => esc_html( $dnxte_rm_readmore_custom_css ),
				)
			);
		}
	}
	public function scripts() {
		wp_enqueue_script( 'jquery_expander_js' );
	}
}
