<?php
defined( 'ABSPATH' ) || die();

trait RMHelper {
	/**
	 * Load Read More Divi Modules Fields
	 *
	 * @param - $param - Field Array.
	 *
	 * @return - array
	 */
	public function get_fields( $param ) {
		$fields = array();

		$fields['dnxte_rm_readmore'] = array(
			'label'            => esc_html__( 'USE READ MORE', 'dnxte-divi-essential' ),
			'type'             => 'yes_no_button',
			'option_category'  => 'configuration',
			'options'          => array(
				'off' => esc_html__( 'No', 'dnxte-divi-essential' ),
				'on'  => esc_html__( 'Yes', 'dnxte-divi-essential' ),
			),
			'default'          => 'off',
			'default_on_front' => 'off',
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'description'      => esc_html__( 'Toggle whether you want to use the Read More feature on this module or not.', 'dnxte-divi-essential' ),
		);

		$fields['dnxte_rm_height'] = array(
			'label'            => esc_html__( 'Height', 'dnxte-divi-essential' ),
			'type'             => 'text',
			'option_category'  => 'basic_option',
			'default'          => '200',
			'default_on_front' => '200',
			'description'      => esc_html__( 'Adjust Read More block height from here.', 'dnxte-divi-essential' ),
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_disabled_on_device'] = array(
			'label'            => esc_html__( 'Disabled On Device', 'dnxte-divi-essential' ),
			'type'             => 'select',
			'option_category'  => 'configuration',
			'options'          => array(
				'none'    => esc_html__( 'None', 'dnxte-divi-essential' ),
				'phone'   => esc_html__( 'Phone', 'dnxte-divi-essential' ),
				'tablet'  => esc_html__( 'Tablet', 'dnxte-divi-essential' ),
				'desktop' => esc_html__( 'Desktop', 'dnxte-divi-essential' ),

			),
			'default'          => 'none',
			'default_on_front' => 'none',
			'description'      => esc_html__(
				'Phone - Disable Read More on phone (below 767 px), Tablet - Disables both on phone & tablet (below 980 px)
',
				'dnxte-divi-essential'
			),
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_text'] = array(
			'label'            => esc_html__( 'Read More Text', 'dnxte-divi-essential' ),
			'type'             => 'text',
			'option_category'  => 'basic_option',
			'default'          => 'Read more',
			'default_on_front' => 'Read more',
			'description'      => esc_html__(
				'Insert Read More placeholder text.
',
				'dnxte-divi-essential'
			),
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_less_text'] = array(
			'label'            => esc_html__( 'Read less Text', 'dnxte-divi-essential' ),
			'type'             => 'text',
			'option_category'  => 'basic_option',
			'default'          => 'Read less',
			'default_on_front' => 'Read less',
			'description'      => esc_html__( 'Insert Read Less placeholder text.', 'dnxte-divi-essential' ),
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_no_less'] = array(
			'label'            => esc_html__( 'Less Text Show', 'dnxte-divi-essential' ),
			'type'             => 'yes_no_button',
			'option_category'  => 'configuration',
			'options'          => array(
				'off' => esc_html__( 'No', 'dnxte-divi-essential' ),
				'on'  => esc_html__( 'Yes', 'dnxte-divi-essential' ),
			),
			'default'          => 'on',
			'default_on_front' => 'on',
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'description'      => esc_html__( 'Yes - Show less text. No - Not showing Less Text after expanding', 'dnxte-divi-essential' ),
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_font'] = array(
			'label'           => esc_html__( 'Font', 'dnxte-divi-essential' ),
			'type'            => 'font',
			'option_category' => 'font_option',
			'options'         => array(
				'bold'      => esc_html__( 'Bold', 'dnxte-divi-essential' ),
				'italic'    => esc_html__( 'Italic', 'dnxte-divi-essential' ),
				'uppercase' => esc_html__( 'Uppercase', 'dnxte-divi-essential' ),
				'underline' => esc_html__( 'Underline', 'dnxte-divi-essential' ),
			),
			'description'     => esc_html__( 'Choose the Read More Text Font.', 'dnxte-divi-essential' ),
			'tab_slug'        => 'custom_css',
			'toggle_slug'     => 'visibility',
			'show_if'         => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_font_size'] = array(
			'label'           => esc_html__( 'Text Size', 'dnxte-divi-essential' ),
			'description'     => esc_html__( 'Increase / decrease text size for Read More text. ', 'dnxte-divi-essential' ),
			'type'            => 'range',
			'option_category' => 'font_option',
			'tab_slug'        => 'custom_css',
			'toggle_slug'     => 'visibility',
			'allowed_units'   => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
			'default_unit'    => 'px',
			'range_settings'  => array(
				'min'  => '1',
				'max'  => '100',
				'step' => '1',
			),
			'default'         => '14px',
			'show_if'         => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_text_align'] = array(
			'label'            => esc_html__( 'Text Alignment', 'dnxte-divi-essential' ),
			'type'             => 'text_align',
			'option_category'  => 'layout',
			'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
			'default_on_front' => 'left',
			'description'      => esc_html__( 'Choose the Read More Text alignment.', 'dnxte-divi-essential' ),
			'tab_slug'         => 'custom_css',
			'toggle_slug'      => 'visibility',
			'show_if'          => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_link_color'] = array(
			'label'        => esc_html__( 'Link Text Color', 'dnxte-divi-essential' ),
			'description'  => esc_html__( 'Change Read More link color.', 'dnxte-divi-essential' ),
			'type'         => 'color-alpha',
			'custom_color' => true,
			'tab_slug'     => 'custom_css',
			'toggle_slug'  => 'visibility',
			'hover'        => 'tabs',
			'default'      => '#3D91DC',
			'show_if'      => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		$fields['dnxte_rm_custom_css'] = array(
			'label'       => esc_html__( 'Link Custom CSS', 'dnxte-divi-essential' ),
			'description' => esc_html__( 'Add / Customize Read More with Custom CSS ', 'dnxte-divi-essential' ),
			'type'        => 'codemirror',
			'tab_slug'    => 'custom_css',
			'toggle_slug' => 'visibility',
			'default'     => '',
			'show_if'     => array(
				'dnxte_rm_readmore' => 'on',
			),
		);

		return array_merge( $param, $fields );
	}
}
