<?php
defined( 'ABSPATH' ) || die();

trait RMRender {
	public function render_callback( $output, $render_slug, $module ) {
		if ( ! in_array( $render_slug, $this->allowed_modules, true ) ) {
			return $output;
		}

		if ( is_array( $output ) ) {
			return $output;
		}

		if ( isset( $module->props['dnxte_rm_readmore'] ) && 'on' === $module->props['dnxte_rm_readmore'] ) {
			$data   = 'data-readmore-text="' . $module->props['dnxte_rm_text'] . '"  data-readmore-disable-on-device="' . $module->props['dnxte_rm_disabled_on_device'] . '" data-readmore-less-text="' . $module->props['dnxte_rm_less_text'] . '" data-readmore-height="' . $module->props['dnxte_rm_height'] . '" data-readmore-no-less="' . $module->props['dnxte_rm_no_less'] . '" data-readmore-font-size="' . $module->props['dnxte_rm_font_size'] . '"';
			$output = str_replace( 'class="et_pb_module ', $data . ' class="et_pb_module dnxte-rm ', $output );
			$output = str_replace( 'class="et_pb_with_border ', $data . ' class="et_pb_with_border dnxte-rm ', $output );

			$this->styles( $module->props, $render_slug );
			$this->scripts();
		}
		return $output;
	}
}
