<?php

defined( 'ABSPATH' ) || die();

if ( file_exists( __DIR__ . '/read-more-traits/index.php' ) ) {
	require_once __DIR__ . '/read-more-traits/index.php';
}

class DNXTE_Readmore {
	use RMHelper;
	use RMRender;
	use RMAssets;

	public $allowed_modules = array( 'et_pb_text', 'et_pb_blog', 'et_pb_code', 'et_pb_cta', 'et_pb_blurb' );

	public function __construct() {
		$this->add_filters();
	}

	/**
	 * ...
	 *
	 * @return void
	 */
	public function add_filters() {
		$this->allowed_modules = apply_filters( 'dnxte_extend_readmore_supported_module', $this->allowed_modules );
		foreach ( $this->allowed_modules as $module ) {
			add_filter( "et_pb_all_fields_unprocessed_$module", array( $this, 'get_fields' ) );
		}
		add_filter( 'et_module_shortcode_output', array( $this, 'render_callback' ), 10, 3 );
	}
}

( new DNXTE_Readmore() );
