<?php 
class WCST_Email
{
	var $current_lang;
	public function __construct()
	{
	}
	public function send_active_notification_email_with_tracking_codes($recipients, $content, $subject = "", $email_heading = "", $order = null)
	{
		global $wcst_order_model, $wpml_helper;
		
		$mail = WC()->mailer();
		$this->current_lang = $order ?  $wcst_order_model->get_lang($order->get_id()): $wpml_helper->get_current_locale();
		$message = $mail->wrap_message($email_heading, stripcslashes($content));
		//
		
		do_action('wcst_before_active_notification_email', $recipients, $order);
		
		add_filter('wp_mail_from_name',array(&$this, 'wp_mail_from_name'), 99, 1);
		add_filter('wp_mail_from', array(&$this, 'wp_mail_from'));
		$attachments =  array();
		if(!$mail->send( $recipients, $subject, $message, "Content-Type: text/html\r\n", $attachments)) 
			wp_mail( $recipients, $subject, $message, "Content-Type: text/html\r\n", $attachments);
		remove_filter('wp_mail_from_name',array(&$this, 'wp_mail_from_name'));
		remove_filter('wp_mail_from',array(&$this, 'wp_mail_from'));
		
		
		do_action('wcst_after_active_notification_email', $recipients, $order);
	}
	public function wp_mail_from_name($name) 
	{
		$options_controller = new WCST_Option();
		$wpml_helper = new WCST_Wpml();
		$options = $options_controller->get_general_options();
		
		$active_notification_from_name = wcst_get_value_if_set($options, ['active_notification_from_name', $this->current_lang], "" );
		
		
		return $active_notification_from_name ? $active_notification_from_name : get_bloginfo('name');
	}
	public function wp_mail_from($content_type) 
	{
		$options_controller = new WCST_Option();
		$wpml_helper = new WCST_Wpml();
		$options = $options_controller->get_general_options();
		
		$active_notification_from_email_address = wcst_get_value_if_set($options, ['active_notification_from_email_address', $this->current_lang], "" );
		
		if($active_notification_from_email_address)
			return $active_notification_from_email_address;
			
		$server_headers = function_exists('apache_request_headers') ? apache_request_headers() : wcst_apache_request_headers();
		$domain = isset($server_headers['Host']) ? $server_headers['Host'] : null ;
		if(!isset($domain) && isset($_SERVER['HTTP_HOST']))
			$domain = str_replace("www.", "", $_SERVER['HTTP_HOST'] );
		
		return isset($domain) ? 'noprely@'.$domain : $content_type;
	}
	public function force_status_email_sending($action, $order)
	{
		// Ensure gateways are loaded in case they need to insert data into the emails
		WC()->payment_gateways();
		WC()->shipping();

		// Load mailer
		$mailer = WC()->mailer();

		$email_to_send = str_replace( 'send_email_', '', $action );

		$mails = $mailer->get_emails();

		if ( ! empty( $mails ) ) {
			foreach ( $mails as $mail ) {
				if ( $mail->id == $email_to_send ) {
					$mail->trigger( WCST_Order::get_id($order));
					
				}
			}
		}
	}
	function send_error_email_to_admin($text)
	{
		$mail = WC()->mailer();
		$email_heading = get_bloginfo('name');
		$subject = esc_html__('Something needs your attention...', 'woocommerce-shipping-tracking');
		
		ob_start();
		$mail->email_header($email_heading, $mail );
		wcst_html_escape_allowing_special_tags(__('<h2>The following error has been generated by your site:</h2>', 'woocommerce-shipping-tracking'));
		echo "<p>".$text."</p>";
		$mail->email_footer($mail);
		$message =  ob_get_contents();
		ob_end_clean(); 
		
		
		$mail->send( get_bloginfo('admin_email'), $subject, $message, "Content-Type: text/html\r\n");
	}
}