<?php 
class WCST_Product
{
	public function __construct()
	{
	}
	public function get_estimation_shippment_rule($id = null)
	{
		$wcst_options = new WCST_Option();
		$estimated_shipping_rules = $wcst_options->get_estimations_options();
		$id = !isset($id) ? get_the_ID() : $id;
		$not_translated_id = $not_translated_parend_id = -1;
		if(!isset($id))
			return null;
		
		$product = wc_get_product($id);
		if(!isset($product) || $product == false)
			return null;
		
		$parend_id = $product->get_parent_id(); // 0 for simple products
		
		$wpps_wpml_model = new WCST_Wpml();
		if($wpps_wpml_model->is_wpml_active())
		{
			$not_translated_id = $id;
			$id = $wpps_wpml_model->get_original_id($id);
			if($parend_id > 0)
				$not_translated_parend_id = $wpps_wpml_model->get_original_id($parend_id);
		}
		
		$result = null;
		foreach($estimated_shipping_rules['estimated_shipping'] as $rule)
		{
			if(empty($rule['products']) && empty($rule['categories']) && empty($rule['tags']))
			{
				$result = $rule;
			}
			else if(is_array($rule['products']) && (in_array($id , $rule['products']) || in_array($parend_id , $rule['products'])) )
			{
				$result = $rule;
				//break;
			}
			else if(is_array($rule['categories']))
			{
				$ids = $this->get_products_ids_using_categories($rule['categories'], $rule['children_categories']);
				
				if(is_array($ids) && (in_array($id , $ids) || in_array($not_translated_id , $ids) || in_array($parend_id , $ids) || in_array($not_translated_parend_id , $ids)) )
				{
					$result = $rule;
					//break;
				}
			}
			//due to the last elseif has not a proper check if the product belongs to categories, the following is not in "else if" but in a simple "if"
			$tags_id = $product->get_tag_ids();
			if(!$product->is_type('simple'))
			{
				$parent = wc_get_product($product->get_parent_id());
				$tags_id = $parent ? $parent->get_tag_ids() : $tags_id;
			}
			if(!empty($rule['tags']) && array_intersect($rule['tags'], $tags_id))
			{
				$result = $rule;
			}
		}
		return $result;
	}
	private function get_products_ids_using_categories($selected_categories, $get_post_belonging_to_children_categories = "selected_only" , $strategy = "all")
	{
		global $wpdb;
		$not_suffix = $strategy == "all" ? "  " : " NOT ";
		$results = $additional_categories_ids = array();
		
		//Retrieve children categories id
		if($get_post_belonging_to_children_categories == 'all_children')
		{
			foreach($selected_categories as $current_category)
			{
				$args = array(
						'type'                     => 'post',
						'child_of'                 => $current_category,
						'parent'                   => '',
						'orderby'                  => 'name',
						'order'                    => 'ASC',
						'hide_empty'               => 1,
						'hierarchical'             => 1,
						'exclude'                  => '',
						'include'                  => '',
						'number'                   => '',
						'taxonomy'                 => 'product_cat',
						'pad_counts'               => false

					); 

					$categories = get_categories( $args );
					
					foreach($categories as $result)
						$additional_categories_ids[] = $result->term_id;
			}
		}
		if(!empty($additional_categories_ids))
			$selected_categories = array_merge($selected_categories, $additional_categories_ids);
		
		//GROUP_CONCAT(posts.ID)
		$wpdb->query('SET group_concat_max_len=5000000'); 
		$wpdb->query('SET SQL_BIG_SELECTS=1');
		$query = "SELECT DISTINCT posts.ID
				 FROM {$wpdb->posts} AS posts 
				 INNER JOIN {$wpdb->term_relationships} AS term_rel ON term_rel.object_id = posts.ID
				 INNER JOIN {$wpdb->term_taxonomy} AS term_tax ON term_tax.term_taxonomy_id = term_rel.term_taxonomy_id 
				 INNER JOIN {$wpdb->terms} AS terms ON terms.term_id = term_tax.term_id
				 WHERE  terms.term_id {$not_suffix} IN ('" . implode( "','", $selected_categories). "')  
				 AND term_tax.taxonomy = 'product_cat' "; 
		$ids = $wpdb->get_results($query, ARRAY_A);
	
		foreach($ids as $id)
			$results[] = $id['ID'];
			
		return $results;
	}
	function get_order_variation_attribute_value_and_name($product)
	{
		if(!is_object($product))
			return "";
		
		if( $product->is_type( 'variation' ))
		{
			$variation_names = array();
			if( $product->get_variation_attributes() )
				foreach($product->get_variation_attributes( ) as $attribute_name => $value)
				{
					$meta_key = urldecode( str_replace( 'attribute_', '', $attribute_name ) ); 
					$variation_names[] = wc_attribute_label($meta_key).": ".$product->get_attribute($meta_key);
				}
			
			
			return $variation_names ? "(".implode( ', ', $variation_names ).")" : "";
		}
        return "";
	}
}
?>