<?php
class WCST_shipping_companies_url
{
	public static function get_company_url($trackurl, $trackno, $shipping_postcode = '', $order = null, $force_disable_tiny_url = false)
	{
		//		** INFO **
		//$trackurl: company id
		//$trackno:  tracking code
		
		
		global $wcst_order_model;
		
		$urltrack = null;
		
		//Custom companies	
		if($urltrack == null )
		{
			$urltrack = "";
			$custom_companies = get_option( 'wcst_user_defined_companies');
			$country_code = isset($order) ? $order->get_shipping_country() : "";
			if(isset($custom_companies) && is_array($custom_companies))
				foreach ($custom_companies as $index => $company_info) //['name'] and ['url']
					if (is_numeric($trackurl) && $index == intval($trackurl) ) //Custom company detected
					{
						
						$codes = explode(",", $trackno);
						$urltrack = $company_info['url'] ? $company_info['url'] : "#";
						foreach($codes as $code)
						{
							$code = trim($code);
							$urltrack =  preg_replace('/%s/', $code, $urltrack, 1);
							$urltrack =  preg_replace('/%S/', $code, $urltrack, 1);
							$urltrack =  preg_replace('/\s+/', '', $urltrack); //remove spaces
							$urltrack =  preg_replace('/%country_code/',  $country_code, $urltrack); 
							$urltrack =  preg_replace('/%post_code/',  $shipping_postcode, $urltrack); //remove spaces
						}
						
					}	
		}
		if($urltrack == null) //is still null, it means then that $trackurl refers to an AfterShip id 
		{
			$wcst_wpml_model = new WCST_Wpml();
			$lang = $order && $wcst_order_model->get_lang($order) ? $wcst_order_model->get_lang($order) : $wcst_wpml_model->get_current_language(); //"en"
			//$lang = $lang != "en" ? $lang : "";
			//aftership $urltrack = "https://www.aftership.com/{$lang}/track/{$trackurl}/{$trackno}";
			//17track: $urltrack = "https://t.17track.net/{$lang}/#nums={$trackno}&fc={$trackurl}";
			
			/* $trackno = trim($trackno);
			$tracking_url = base64_encode("https://www.trackingmore.com/track/{$lang}/{$trackno}?express={$trackurl}");
			$base_url = base64_encode(WCST_PLUGIN_PATH);
			$urltrack = WCST_PLUGIN_PATH."/tracker/tracker.php?tracking_url={$tracking_url}&base_url=".$base_url; */
			
			$lang = strlen($lang) != 2 ? "en" : $lang;
			$urltrack = WCST_PLUGIN_PATH."/tracker/tracker.php?lang={$lang}&code={$trackno}&company=".$trackurl;
			
		}
		
		$options_controller = new WCST_Option();
		$options = $options_controller->get_general_options();
		$disable_tiny_url = wcst_get_value_if_set($options,  'disable_tiny_url', false) == 'true' || $force_disable_tiny_url;
		
		
		$urltrack = apply_filters('wcst_getting_tracking_url', $urltrack, $trackurl, $trackno, $shipping_postcode, $order);
		$shortned = apply_filters('wcst_getting_tracking_url_shortened', WCST_shipping_companies_url::get_tiny_url($urltrack, $order, $trackurl, $trackno), $trackurl, $trackno, $shipping_postcode, $order);
		return array("urltrack"=>  $disable_tiny_url ? $urltrack : $shortned );
	}
	
	public static function get_tiny_url($url, $order, $company_code, $tracking_code) 
	{
		/* Doesn't work for free anymore
		$api_url = 'https://tinyurl.com/api-create.php?url=' . $url;

		$curl = curl_init();
		$timeout = 10;

		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_URL, $api_url);

		$new_url = curl_exec($curl);
		curl_close($curl);

		return $new_url; 
		*/
		
		if(!$order)
			return $url;
		
		$order_id = $order->get_id();
		$order->update_meta_data("_wcst_tiny_url_{$company_code}_{$tracking_code}", $url);
		$order->save();
		return get_site_url()."?wcst_shorturl={$order_id}&cmp={$company_code}&code={$tracking_code}";
	}
}
?>