<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

if(!class_exists('qcld_googleai_addons')){
   

    /**
     * Main Class.
     */
    final class qcld_googleai_addons
    {
        private $id = 'googleai';
        public $version = '1.0.6';
        public $helper;
        protected static $_instance = null;
     
        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }
        public $response_list;
        public function __construct()
        {
            add_action('wp_ajax_googleai_settings_option', [$this, 'googleai_settings_option_callback']);
            add_action('wp_ajax_qcld_plam_response',[$this,'qcld_plam_response_callback']);
            add_action('wp_ajax_nopriv_qcld_plam_response', [$this, 'qcld_plam_response_callback']);
        }
    
        public function googleai_settings_option_callback(){
            $nonce =  sanitize_text_field($_POST['nonce']);
            if (! wp_verify_nonce($nonce,'wp_chatbot')) {
                wp_send_json(array('success' => false, 'msg' => esc_html__('Failed in Security check', 'sm')));
                wp_die();
            }else{
                $api_key = sanitize_text_field($_POST['api_key']);
                $ai_engines = sanitize_text_field($_POST['ai_engines']);
                $temperature = sanitize_text_field($_POST['temperature']);
                $ai_enabled = sanitize_text_field($_POST['ai_enabled']);
                if($api_key  != ''){
                    update_option( 'qcld_googleai_api_key', $api_key );
                }
                if($ai_engines  != ''){
                    update_option( 'qcld_googleai_engines', $ai_engines );
                }
                update_option('qcld_googleai_enabled',$ai_enabled);
                update_option( 'qcld_googleai_temperature',$temperature);
            }
        }
        public function qcld_plam_response_callback(){

            $api_key = get_option( 'qcld_googleai_api_key');
            $ai_engines=  get_option( 'qcld_googleai_engines');
            $temperature = get_option( 'qcld_googleai_temperature');
          
        } 
    }
}
if(!function_exists('qcld_googleai_addons')){
    function qcld_googleais() {
        $qcld_wpopenai_addon = new qcld_googleai_addons();
        return $qcld_wpopenai_addon->instance();
    
    }
}

//fire off the plugin
qcld_googleais();