<?php
/**
 * Temporary class to handle some features.
 *
 * @link       Artbees.net
 * @since      1.0.0
 *
 * @package    Sellkit
 * @subpackage Sellkit/admin
 * @SuppressWarnings(PHPMD.NPathComplexity)
 */
class Sellkit_Extras {

	/**
	 * License.
	 *
	 * @since 1.1.0
	 * @var Sellkit_License
	 */
	public $license;

	/**
	 * Class construct.
	 */
	public function __construct() {
		$this->license = new Sellkit_License();

		// Register License page in appropriate admin context.
		if ( is_multisite() ) {
			add_action( 'network_admin_menu', [ $this, 'add_network_options_page' ], 999 );
		} else {
			add_action( 'admin_menu', [ $this, 'add_options_page' ], 999 );
		}
		add_action( 'admin_init', [ $this, 'license_action_callback' ] );
		add_action( 'wp_ajax_sellkit_dismiss_license_notice', [ $this, 'dismiss_license_notice' ] );
	}

	/**
	 * Adds license page.
	 *
	 * @return void
	 */
	public function add_options_page() {

		add_submenu_page(
			'sellkit-dashboard',
			esc_html__( 'Sellkit License', 'sellkit-pro' ),
			esc_html__( 'License', 'sellkit-pro' ),
			'manage_options',
			$this->license->sellkit_license_page,
			[ $this, 'render_option_page' ],
			9999
		);

	}

	/**
	 * Adds license page to Network Admin (multisite).
	 *
	 * @return void
	 */
	public function add_network_options_page() {
		$icon_data = '';
		// Try to reuse Sellkit's original SVG icon.
		$sellkit_main_file = WP_PLUGIN_DIR . '/sellkit/sellkit.php';
		if ( file_exists( $sellkit_main_file ) ) {
			$icon_url = plugins_url( 'assets/img/icons/sellkit-dashboard.svg', $sellkit_main_file );
			$response = wp_remote_get( $icon_url );
			if ( ! is_wp_error( $response ) ) {
				$icon_svg  = wp_remote_retrieve_body( $response );
				$icon_data = 'data:image/svg+xml;base64,' . base64_encode( $icon_svg );
			}
		}

		add_menu_page(
			esc_html__( 'Sellkit', 'sellkit-pro' ),
			esc_html__( 'Sellkit', 'sellkit-pro' ),
			'manage_network_options',
			$this->license->sellkit_license_page,
			[ $this, 'render_option_page' ],
			$icon_data,
			'58.1'
		);

	}

	/**
	 * Selectively renders license page based.
	 *
	 * @return void
	 */
	public function render_option_page() {
		if ( $this->license->get( 'site_key' ) ) {
			sellkit_pro()->load_files( [
				'admin/license/partials/license-connected',
			] );
		} else {
			sellkit_pro()->load_files( [
				'admin/license/partials/license-not-connected',
			] );
		}
	}

	/**
	 * Process remote license callback.
	 *
	 * @since 1.0.0
	 */
	public function license_action_callback() {

		$page   = sellkit_htmlspecialchars( INPUT_GET, 'page' );
		$action = sellkit_htmlspecialchars( INPUT_GET, 'action' );
		$nonce  = sellkit_htmlspecialchars( INPUT_GET, 'nonce' );

		if ( empty( $page ) || empty( $action ) || $this->license->sellkit_license_page !== $page ) {
			return;
		}

		$has_capability = is_multisite() ? current_user_can( 'manage_network_options' ) : current_user_can( 'manage_options' );
		if ( ! wp_verify_nonce( $nonce, $this->license->sellkit_license_page ) || ! $has_capability ) {
			return;
		}

		call_user_func( [ $this->license, $action ] );
	}

	/**
	 * Set option if notice is dismissed.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return void
	 */
	public function dismiss_license_notice() {
		check_ajax_referer( 'sellkit_dismiss_license_notice' );
		update_site_option( 'sellkit_dismiss_license_notice', 1 );
	}
}

new Sellkit_Extras();
