<?php
$license = new Sellkit_License();

?>
<div class="wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	<div class="sellkit-card">
		<h3 class="sellkit-card-section flex-space-between">
			<span><?php esc_html_e( 'Status', 'sellkit-pro' ); ?>:
				<?php if ( 'expired' === $license->get( 'status' ) ) : ?>
					<span style="color: #ff1919;">&nbsp;<?php esc_html_e( 'Expired', 'sellkit-pro' ); ?></span>
				<?php elseif ( 'invalid' === $license->get( 'status' ) ) : ?>
					<span style="color: #ff1919;">&nbsp;<?php esc_html_e( 'Invalid', 'sellkit-pro' ); ?></span>
				<?php else : ?>
					<span style="color: #00a600;">&nbsp;<?php esc_html_e( 'Active', 'sellkit-pro' ); ?></span>
				<?php endif; ?>
			</span>
			<a class="button" style="font-weight: 400;" href="https://my.getsellkit.com/">&nbsp;<?php esc_html_e( 'View Dashboard', 'sellkit-pro' ); ?></a>
		</h3>

		<?php
			$main_site_id = function_exists( 'get_main_site_id' ) ? get_main_site_id() : 1;
			$is_main_site = ! is_multisite() || get_current_blog_id() === (int) $main_site_id;
		?>

		<div class="sellkit-card-section flex-space-between">
			<p>
				<?php
					echo sprintf(
						/* Translators: %s: user email */
						__( 'You are connected as %s.', 'sellkit-pro' ), // phpcs:ignore
						'<strong>' . esc_html( $license->get( 'user_email' ) ) . '</strong>'
					);
				?>
				<br>
				<?php esc_html_e( 'Would you like to switch your license via another Sellkit Account?', 'sellkit-pro' ); ?>
				<?php if ( ! $is_main_site ) : ?>
					<br>
					<span class="description"><?php esc_html_e( 'Switching license is only available on the main site.', 'sellkit-pro' ); ?></span>
				<?php endif; ?>
			</p>
			<?php if ( $is_main_site ) : ?>
				<a href="<?php echo esc_url( $license->get_url( 'switch' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Switch Account', 'sellkit-pro' ); ?></a>
			<?php endif; ?>
		</div>
		<?php if ( $is_main_site ) : ?>
		<div class="sellkit-card-section flex-space-between">
			<p><?php esc_html_e( 'Do you want to remove your license from this website?', 'sellkit-pro' ); ?></p>
			<a href="<?php echo esc_url( $license->get_url( 'deactivate' ) ); ?>" class="button"><?php esc_html_e( 'Deactivate Licence', 'sellkit-pro' ); ?></a>
		</div>
		<?php else : ?>
		<div class="sellkit-card-section flex-space-between">
			<p><?php esc_html_e( 'License deactivation can only be done from the main site.', 'sellkit-pro' ); ?></p>
		</div>
		<?php endif; ?>
	</div>
</div>

