<?php

namespace SolidAffiliate\Views\Admin\Settings;

use SolidAffiliate\Lib\FormBuilder\FormBuilder;
use SolidAffiliate\Lib\VO\Schema;
use SolidAffiliate\Lib\Settings;
use SolidAffiliate\Models\Affiliate;

class SettingsTabView
{

  /**
   * Renders a Tab on Admin Settings page.
   *
   * @param Schema $settings_schema
   * @param Object $current_settings
   * 
   * @return string
   */
  public static function render($settings_schema, $current_settings)
  {
    // check if the sudo param is set in the url
    $sudo_mode = isset($_GET['sudo']);
    ob_start();
?>
    <?php
    // $setting_groups = [
    //   'Referral' => Settings::schema_for_settings_group('Referral'),
    //   'Integrations' => Settings::schema_for_settings_group('Integrations')
    // ];

    $setting_groups = Settings::schema_grouped_by_settings_groups($settings_schema);

    if ($sudo_mode) {
      // change every schema_entry->show_on_edit_form to true
      foreach ($setting_groups as $_group_name => $schema) {
        foreach ($schema->entries as $entry) {
          $entry->show_on_edit_form = true;
        }
      }
    }

    foreach ($setting_groups as $group_name => $schema) {
      /////////////////////////////////////////////////
      // Check if there are no entries to display
      $entries = $schema->entries;
      $entries_to_display = array_filter($entries, function ($entry) {
        return $entry->show_on_edit_form != FALSE;
      });
      if (count($entries_to_display) == 0) {
        continue;
      }
      /////////////////////////////////////////////////

      $group_name_formatted = str_replace(' ', '_', $group_name);
      # code...
    ?>

      <div class="sld-card setting setting-group-<?php echo $group_name_formatted ?>"
        style="<?php echo $group_name == 'HIDDEN' ? 'display: none;' : ''; ?>">
        <div class="sld_setting-heading">
          <?php do_action("solid_affiliate/settings/group_heading/before", $group_name); ?>
          <span class="group-icon">
            <?php
            switch ($group_name) {
              case 'Commissions calculations':
                echo '
                <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.7333 11.9999C19.4918 11.5809 19.1409 11.2355 18.7181 11.0006C18.2954 10.7658 17.8167 10.6503 17.3333 10.6665H14.6667C13.9594 10.6665 13.2811 10.9475 12.781 11.4476C12.281 11.9477 12 12.626 12 13.3332C12 14.0405 12.281 14.7187 12.781 15.2188C13.2811 15.7189 13.9594 15.9999 14.6667 15.9999H17.3333C18.0406 15.9999 18.7189 16.2808 19.219 16.7809C19.719 17.281 20 17.9593 20 18.6666C20 19.3738 19.719 20.0521 19.219 20.5522C18.7189 21.0523 18.0406 21.3332 17.3333 21.3332H14.6667C14.1833 21.3495 13.7047 21.234 13.2819 20.9991C12.8591 20.7643 12.5082 20.4189 12.2667 19.9999M16 9.33333V22.6667M4 16C4 17.5759 4.31039 19.1363 4.91345 20.5922C5.5165 22.0481 6.40042 23.371 7.51472 24.4853C8.62902 25.5996 9.95189 26.4835 11.4078 27.0866C12.8637 27.6896 14.4241 28 16 28C17.5759 28 19.1363 27.6896 20.5922 27.0866C22.0481 26.4835 23.371 25.5996 24.4853 24.4853C25.5996 23.371 26.4835 22.0481 27.0866 20.5922C27.6896 19.1363 28 17.5759 28 16C28 14.4241 27.6896 12.8637 27.0866 11.4078C26.4835 9.95189 25.5996 8.62902 24.4853 7.51472C23.371 6.40042 22.0481 5.5165 20.5922 4.91345C19.1363 4.31039 17.5759 4 16 4C14.4241 4 12.8637 4.31039 11.4078 4.91345C9.95189 5.5165 8.62902 6.40042 7.51472 7.51472C6.40042 8.62902 5.5165 9.95189 4.91345 11.4078C4.31039 12.8637 4 14.4241 4 16Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                ';
                break;
              case 'Affiliate links':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M11.9997 20L19.9997 12M14.6663 8.00008L15.2837 7.28542C16.5341 6.03519 18.2299 5.33288 19.9981 5.33301C21.7664 5.33313 23.4621 6.03567 24.7123 7.28608C25.9626 8.53649 26.6649 10.2323 26.6647 12.0006C26.6646 13.7688 25.9621 15.4645 24.7117 16.7147L23.9997 17.3334M17.3332 24L16.8039 24.712C15.5389 25.9629 13.8316 26.6645 12.0525 26.6645C10.2735 26.6645 8.5662 25.9629 7.3012 24.712C6.67767 24.0955 6.18266 23.3614 5.84481 22.5522C5.50697 21.743 5.33301 20.8749 5.33301 19.998C5.33301 19.1211 5.50697 18.253 5.84481 17.4438C6.18266 16.6346 6.67767 15.9005 7.3012 15.284L7.99986 14.6667" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>';
                break;
              case 'Lifetime commissions':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M16.0002 16.0001C15.2685 17.4203 14.2876 18.6975 13.1042 19.7708C12.3583 20.5168 11.408 21.0249 10.3734 21.2308C9.33882 21.4367 8.26638 21.3312 7.29175 20.9276C6.31712 20.524 5.48407 19.8404 4.89796 18.9633C4.31186 18.0862 3.99902 17.055 3.99902 16.0001C3.99902 14.9452 4.31186 13.914 4.89796 13.0369C5.48407 12.1598 6.31712 11.4762 7.29175 11.0726C8.26638 10.669 9.33882 10.5634 10.3734 10.7693C11.408 10.9753 12.3583 11.4834 13.1042 12.2294C14.2876 13.3027 15.2685 14.5798 16.0002 16.0001ZM16.0002 16.0001C16.7318 14.5798 17.7127 13.3027 18.8962 12.2294C19.642 11.4834 20.5923 10.9753 21.6269 10.7693C22.6615 10.5634 23.7339 10.669 24.7086 11.0726C25.6832 11.4762 26.5163 12.1598 27.1024 13.0369C27.6885 13.914 28.0013 14.9452 28.0013 16.0001C28.0013 17.055 27.6885 18.0862 27.1024 18.9633C26.5163 19.8404 25.6832 20.524 24.7086 20.9276C23.7339 21.3312 22.6615 21.4367 21.6269 21.2308C20.5923 21.0249 19.642 20.5168 18.8962 19.7708C17.7127 18.6975 16.7318 17.4203 16.0002 16.0001Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                ';
                break;
              case 'Affiliate groups':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M4 28V25.3333C4 23.9188 4.5619 22.5623 5.5621 21.5621C6.56229 20.5619 7.91885 20 9.33333 20H14.6667C16.0812 20 17.4377 20.5619 18.4379 21.5621C19.4381 22.5623 20 23.9188 20 25.3333V28M21.3333 4.17318C22.4806 4.46691 23.4974 5.13411 24.2235 6.06959C24.9497 7.00507 25.3438 8.15562 25.3438 9.33984C25.3438 10.5241 24.9497 11.6746 24.2235 12.6101C23.4974 13.5456 22.4806 14.2128 21.3333 14.5065M28 27.9999V25.3332C27.9932 24.1561 27.5972 23.0143 26.8737 22.0857C26.1502 21.1572 25.1398 20.4941 24 20.1999M6.66667 9.33333C6.66667 10.7478 7.22857 12.1044 8.22876 13.1046C9.22896 14.1048 10.5855 14.6667 12 14.6667C13.4145 14.6667 14.771 14.1048 15.7712 13.1046C16.7714 12.1044 17.3333 10.7478 17.3333 9.33333C17.3333 7.91885 16.7714 6.56229 15.7712 5.5621C14.771 4.5619 13.4145 4 12 4C10.5855 4 9.22896 4.5619 8.22876 5.5621C7.22857 6.56229 6.66667 7.91885 6.66667 9.33333Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>';
                break;

              case 'Advanced':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M16 28H6.66667C5.95942 28 5.28115 27.719 4.78105 27.219C4.28095 26.7189 4 26.0406 4 25.3333V6.66667C4 5.95942 4.28095 5.28115 4.78105 4.78105C5.28115 4.28095 5.95942 4 6.66667 4H25.3333C26.0406 4 26.7189 4.28095 27.219 4.78105C27.719 5.28115 28 5.95942 28 6.66667V16M4 13.3333H28M13.3333 4V28M25.3346 28C24.6274 28 23.9491 27.719 23.449 27.219C22.9489 26.7189 22.668 26.0406 22.668 25.3333C22.668 24.6261 22.9489 23.9478 23.449 23.4477C23.9491 22.9476 24.6274 22.6667 25.3346 22.6667M25.3346 28C26.0419 28 26.7202 27.719 27.2203 27.219C27.7204 26.7189 28.0013 26.0406 28.0013 25.3333C28.0013 24.6261 27.7204 23.9478 27.2203 23.4477C26.7202 22.9476 26.0419 22.6667 25.3346 22.6667M25.3346 28V30M25.3346 22.6667V20.6667M29.3765 23L27.6445 24M23.0263 26.6667L21.293 27.6667M21.293 23L23.0263 24M27.6445 26.6667L29.3779 27.6667" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                ';
                break;
              case 'Misc':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.6663 9.33333C10.6663 10.7478 11.2282 12.1044 12.2284 13.1046C13.2286 14.1048 14.5852 14.6667 15.9997 14.6667C17.4142 14.6667 18.7707 14.1048 19.7709 13.1046C20.7711 12.1044 21.333 10.7478 21.333 9.33333C21.333 7.91885 20.7711 6.56229 19.7709 5.5621C18.7707 4.5619 17.4142 4 15.9997 4C14.5852 4 13.2286 4.5619 12.2284 5.5621C11.2282 6.56229 10.6663 7.91885 10.6663 9.33333Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M3.33301 22.6667C3.33301 24.0812 3.89491 25.4377 4.89511 26.4379C5.8953 27.4381 7.25185 28 8.66634 28C10.0808 28 11.4374 27.4381 12.4376 26.4379C13.4378 25.4377 13.9997 24.0812 13.9997 22.6667C13.9997 21.2522 13.4378 19.8956 12.4376 18.8954C11.4374 17.8952 10.0808 17.3333 8.66634 17.3333C7.25185 17.3333 5.8953 17.8952 4.89511 18.8954C3.89491 19.8956 3.33301 21.2522 3.33301 22.6667Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M17.9997 22.6667C17.9997 24.0812 18.5616 25.4377 19.5618 26.4379C20.562 27.4381 21.9185 28 23.333 28C24.7475 28 26.104 27.4381 27.1042 26.4379C28.1044 25.4377 28.6663 24.0812 28.6663 22.6667C28.6663 21.2522 28.1044 19.8956 27.1042 18.8954C26.104 17.8952 24.7475 17.3333 23.333 17.3333C21.9185 17.3333 20.562 17.8952 19.5618 18.8954C18.5616 19.8956 17.9997 21.2522 17.9997 22.6667Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                ';
                break;
              case 'Affiliate management':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M8 28V25.3333C8 23.9188 8.5619 22.5623 9.5621 21.5621C10.5623 20.5619 11.9188 20 13.3333 20H16.6667M25.3346 28C24.6274 28 23.9491 27.719 23.449 27.219C22.9489 26.7189 22.668 26.0406 22.668 25.3333C22.668 24.6261 22.9489 23.9478 23.449 23.4477C23.9491 22.9476 24.6274 22.6667 25.3346 22.6667M25.3346 28C26.0419 28 26.7202 27.719 27.2203 27.219C27.7204 26.7189 28.0013 26.0406 28.0013 25.3333C28.0013 24.6261 27.7204 23.9478 27.2203 23.4477C26.7202 22.9476 26.0419 22.6667 25.3346 22.6667M25.3346 28V30M25.3346 22.6667V20.6667M29.3765 23L27.6445 24M23.0263 26.6667L21.293 27.6667M21.293 23L23.0263 24M27.6445 26.6667L29.3779 27.6667M10.6667 9.33333C10.6667 10.7478 11.2286 12.1044 12.2288 13.1046C13.229 14.1048 14.5855 14.6667 16 14.6667C17.4145 14.6667 18.771 14.1048 19.7712 13.1046C20.7714 12.1044 21.3333 10.7478 21.3333 9.33333C21.3333 7.91885 20.7714 6.56229 19.7712 5.5621C18.771 4.5619 17.4145 4 16 4C14.5855 4 13.229 4.5619 12.2288 5.5621C11.2286 6.56229 10.6667 7.91885 10.6667 9.33333Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>
                ';
                break;
              case 'Affiliate Portal':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8 26.7333V26.6667C8 25.2522 8.5619 23.8956 9.5621 22.8954C10.5623 21.8952 11.9188 21.3333 13.3333 21.3333H18.6667C20.0812 21.3333 21.4377 21.8952 22.4379 22.8954C23.4381 23.8956 24 25.2522 24 26.6667V26.7333M16 17.3333C17.0609 17.3333 18.0783 16.9119 18.8284 16.1618C19.5786 15.4116 20 14.3942 20 13.3333C20 12.2725 19.5786 11.2551 18.8284 10.5049C18.0783 9.75476 17.0609 9.33333 16 9.33333C14.9391 9.33333 13.9217 9.75476 13.1716 10.5049C12.4214 11.2551 12 12.2725 12 13.3333C12 14.3942 12.4214 15.4116 13.1716 16.1618C13.9217 16.9119 14.9391 17.3333 16 17.3333ZM16 4C25.6 4 28 6.4 28 16C28 25.6 25.6 28 16 28C6.4 28 4 25.6 4 16C4 6.4 6.4 4 16 4Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                  ';
                break;

              case 'Email notifications':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M11.9997 22.6667V24C11.9997 25.0609 12.4211 26.0783 13.1712 26.8284C13.9214 27.5786 14.9388 28 15.9997 28C17.0605 28 18.078 27.5786 18.8281 26.8284C19.5782 26.0783 19.9997 25.0609 19.9997 24V22.6667M13.333 6.66667C13.333 5.95942 13.614 5.28115 14.1141 4.78105C14.6142 4.28095 15.2924 4 15.9997 4C16.7069 4 17.3852 4.28095 17.8853 4.78105C18.3854 5.28115 18.6663 5.95942 18.6663 6.66667C20.1976 7.3907 21.5029 8.51777 22.4424 9.92707C23.3819 11.3364 23.9203 12.9748 23.9997 14.6667V18.6667C24.1 19.4956 24.3936 20.2894 24.8568 20.9842C25.3199 21.6789 25.9398 22.2552 26.6663 22.6667H5.33301C6.05959 22.2552 6.67942 21.6789 7.14259 20.9842C7.60576 20.2894 7.89933 19.4956 7.99967 18.6667V14.6667C8.07909 12.9748 8.61741 11.3364 9.55694 9.92707C10.4965 8.51777 11.8018 7.3907 13.333 6.66667Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    ';
                break;

              case 'New unpaid referral':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M18 25.3334H6.66667C5.95942 25.3334 5.28115 25.0525 4.78105 24.5524C4.28095 24.0523 4 23.374 4 22.6667V9.33341M4 9.33341C4 8.62617 4.28095 7.94789 4.78105 7.4478C5.28115 6.9477 5.95942 6.66675 6.66667 6.66675H25.3333C26.0406 6.66675 26.7189 6.9477 27.219 7.4478C27.719 7.94789 28 8.62617 28 9.33341M4 9.33341L16 17.3334L28 9.33341M28 9.33341V14.0001M28 20.0001H24.6667C24.1362 20.0001 23.6275 20.2108 23.2525 20.5859C22.8774 20.9609 22.6667 21.4696 22.6667 22.0001C22.6667 22.5305 22.8774 23.0392 23.2525 23.4143C23.6275 23.7894 24.1362 24.0001 24.6667 24.0001H26C26.5304 24.0001 27.0391 24.2108 27.4142 24.5859C27.7893 24.9609 28 25.4696 28 26.0001C28 26.5305 27.7893 27.0392 27.4142 27.4143C27.0391 27.7894 26.5304 28.0001 26 28.0001H22.6667M25.3333 28.0001V29.3334M25.3333 18.6667V20.0001" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                      ';
                break;

              case 'Application approval':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M14.6667 25.3334H6.66667C5.95942 25.3334 5.28115 25.0525 4.78105 24.5524C4.28095 24.0523 4 23.374 4 22.6667V9.33341M4 9.33341C4 8.62617 4.28095 7.94789 4.78105 7.4478C5.28115 6.9477 5.95942 6.66675 6.66667 6.66675H25.3333C26.0406 6.66675 26.7189 6.9477 27.219 7.4478C27.719 7.94789 28 8.62617 28 9.33341M4 9.33341L16 17.3334L28 9.33341M28 9.33341V17.3334M20 25.3334L22.6667 28.0001L28 22.6667" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        ';
                break;

              case 'New referral earned':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M13.3333 25.3334H6.66667C5.95942 25.3334 5.28115 25.0525 4.78105 24.5524C4.28095 24.0523 4 23.374 4 22.6667V9.33341M4 9.33341C4 8.62617 4.28095 7.94789 4.78105 7.4478C5.28115 6.9477 5.95942 6.66675 6.66667 6.66675H25.3333C26.0406 6.66675 26.7189 6.9477 27.2189 7.4478C27.719 7.94789 28 8.62617 28 9.33341M4 9.33341L16 17.3334L28 9.33341M28 9.33341V15.3334M23.7336 27.756L20.8377 29.2734C20.7517 29.3181 20.655 29.3381 20.5584 29.331C20.4618 29.324 20.369 29.2903 20.2904 29.2335C20.2119 29.1768 20.1506 29.0994 20.1135 29.0099C20.0764 28.9204 20.0649 28.8224 20.0803 28.7267L20.6337 25.512L18.291 23.236C18.2211 23.1685 18.1715 23.0826 18.1481 22.9882C18.1247 22.8938 18.1282 22.7947 18.1584 22.7022C18.1886 22.6098 18.2441 22.5277 18.3187 22.4653C18.3933 22.4029 18.484 22.3627 18.5803 22.3494L21.8177 21.88L23.2656 18.956C23.309 18.869 23.3757 18.7957 23.4584 18.7445C23.5411 18.6932 23.6364 18.6661 23.7336 18.6661C23.8309 18.6661 23.9262 18.6932 24.0089 18.7445C24.0916 18.7957 24.1583 18.869 24.2016 18.956L25.6496 21.88L28.887 22.3494C28.983 22.3632 29.0733 22.4036 29.1476 22.4661C29.2219 22.5285 29.2772 22.6105 29.3073 22.7028C29.3374 22.795 29.3411 22.8939 29.3179 22.9881C29.2948 23.0823 29.2457 23.1682 29.1763 23.236L26.8336 25.512L27.3856 28.7254C27.4022 28.8212 27.3916 28.9198 27.355 29.0098C27.3183 29.0999 27.2572 29.1779 27.1784 29.235C27.0997 29.2921 27.0065 29.3259 26.9095 29.3327C26.8125 29.3395 26.7156 29.3189 26.6297 29.2734L23.7336 27.756Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>';
                break;

              case 'Welcome email':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M13.333 18.6667H13.3463M18.6663 18.6667H18.6797M13.333 22.6667C14.1155 23.2115 15.0462 23.5036 15.9997 23.5036C16.9532 23.5036 17.8838 23.2115 18.6663 22.6667M5.33301 8C5.33301 10.2093 10.109 12 15.9997 12C21.8903 12 26.6663 10.2093 26.6663 8M5.33301 8C5.33301 5.79067 10.109 4 15.9997 4C21.8903 4 26.6663 5.79067 26.6663 8M5.33301 8V24C5.33301 26.2093 10.109 28 15.9997 28C21.8903 28 26.6663 26.2093 26.6663 24V8" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                          </svg>
                          ';
                break;

              case 'Fraud Prevention':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8 28V25.3333C8 23.9188 8.5619 22.5623 9.5621 21.5621C10.5623 20.5619 11.9188 20 13.3333 20H16M29.3333 21.3333C29.3333 26.6667 26 29.3333 24.6667 29.3333C23.3333 29.3333 20 26.6667 20 21.3333C21.3333 21.3333 23.3333 20.6667 24.6667 19.3333C26 20.6667 28 21.3333 29.3333 21.3333ZM10.6667 9.33333C10.6667 10.7478 11.2286 12.1044 12.2288 13.1046C13.229 14.1048 14.5855 14.6667 16 14.6667C17.4145 14.6667 18.771 14.1048 19.7712 13.1046C20.7714 12.1044 21.3333 10.7478 21.3333 9.33333C21.3333 7.91885 20.7714 6.56229 19.7712 5.5621C18.771 4.5619 17.4145 4 16 4C14.5855 4 13.229 4.5619 12.2288 5.5621C11.2286 6.56229 10.6667 7.91885 10.6667 9.33333Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        ';
                break;
              case 'Google reCAPTCHA':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M26.6663 14.6667C26.3403 12.3203 25.2518 10.1462 23.5685 8.47934C21.8853 6.81246 19.7007 5.74524 17.3512 5.44209C15.0018 5.13893 12.6178 5.61666 10.5666 6.80168C8.51538 7.98669 6.91067 9.81326 5.99967 12M5.33301 6.66668V12H10.6663M5.33301 17.3334C5.65909 19.6798 6.74758 21.8539 8.43082 23.5208C10.1141 25.1876 12.2987 26.2549 14.6481 26.558C16.9976 26.8612 19.3815 26.3834 21.4327 25.1984C23.484 24.0134 25.0887 22.1868 25.9997 20.0001M26.6663 25.3334V20.0001H21.333M14.6663 16.0001C14.6663 16.3537 14.8068 16.6928 15.0569 16.9429C15.3069 17.1929 15.6461 17.3334 15.9997 17.3334C16.3533 17.3334 16.6924 17.1929 16.9425 16.9429C17.1925 16.6928 17.333 16.3537 17.333 16.0001C17.333 15.6465 17.1925 15.3073 16.9425 15.0573C16.6924 14.8072 16.3533 14.6667 15.9997 14.6667C15.6461 14.6667 15.3069 14.8072 15.0569 15.0573C14.8068 15.3073 14.6663 15.6465 14.6663 16.0001Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>';
                break;

              case 'PayPal':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M23.333 9.6C25.5997 10.9333 26.6663 13.3333 26.6663 16C26.6663 19.3333 23.333 22 19.9997 22H16.533L15.733 26.8C15.6707 27.1057 15.5031 27.3799 15.2595 27.5748C15.0159 27.7697 14.7116 27.873 14.3997 27.8667H10.7997C10.6997 27.8687 10.6005 27.8482 10.5095 27.8067C10.4185 27.7652 10.3381 27.7038 10.274 27.6269C10.21 27.5501 10.1641 27.4598 10.1397 27.3629C10.1153 27.2659 10.113 27.1646 10.133 27.0667L10.3997 25.2M13.333 17.3333H16.6663C19.9997 17.3333 23.333 14 23.333 10.6667C23.333 6.66667 20.7997 4 16.6663 4H9.33301C8.66634 4 7.99967 4.66667 7.99967 5.33333L5.33301 24C5.33301 24.6667 5.99967 25.3333 6.66634 25.3333H10.3997L11.9997 18.6667C12.133 17.8667 12.533 17.3333 13.333 17.3333Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>';
                break;
              case 'MailChimp':
                echo '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M16 25.3334H6.66667C5.95942 25.3334 5.28115 25.0525 4.78105 24.5524C4.28095 24.0523 4 23.374 4 22.6667V9.33341M4 9.33341C4 8.62617 4.28095 7.94789 4.78105 7.4478C5.28115 6.9477 5.95942 6.66675 6.66667 6.66675H25.3333C26.0406 6.66675 26.7189 6.9477 27.219 7.4478C27.719 7.94789 28 8.62617 28 9.33341M4 9.33341L16 17.3334L28 9.33341M28 9.33341V16.0001M25.3346 28.0001C24.6274 28.0001 23.9491 27.7191 23.449 27.219C22.9489 26.7189 22.668 26.0407 22.668 25.3334C22.668 24.6262 22.9489 23.9479 23.449 23.4478C23.9491 22.9477 24.6274 22.6667 25.3346 22.6667M25.3346 28.0001C26.0419 28.0001 26.7202 27.7191 27.2203 27.219C27.7204 26.7189 28.0013 26.0407 28.0013 25.3334C28.0013 24.6262 27.7204 23.9479 27.2203 23.4478C26.7202 22.9477 26.0419 22.6667 25.3346 22.6667M25.3346 28.0001V30.0001M25.3346 22.6667V20.6667M29.3765 23.0001L27.6445 24.0001M23.0263 26.6667L21.293 27.6667M21.293 23.0001L23.0263 24.0001M27.6445 26.6667L29.3779 27.6667" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                      ';
              default:
                echo ''; // Default icon
            }
            ?>
          </span>

          <h2><?php echo (__($group_name, 'solid-affiliate')) ?></h2>

          <?php do_action("solid_affiliate/settings/group_heading/after", $group_name); ?>
        </div>
        <?php echo FormBuilder::build_form($schema, 'edit', $current_settings) ?>
      </div>


    <?php
    }
    ?>
    <!-- Settings Group -->

<?php

    $res = ob_get_clean();
    if ($res) {
      return $res;
    } else {
      return __("Error rendering settings.", 'solid-affiliate');
    }
  }
}
